/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.cdi;

import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Named;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.switchyard.common.cdi.OSGICDISupport;

public final class CDIUtil {
    private CDIUtil() {
    }

    public static BeanManager lookupBeanManager() {
        BeanManager beanManager = CDIUtil.getCDIBeanManager("java:comp");
        if (beanManager == null) {
            beanManager = CDIUtil.getCDIBeanManager("java:comp/env");
        }
        if (beanManager == null) {
            beanManager = CDIUtil.getOSGICDIBeanManager();
        }
        return beanManager;
    }

    public static Object lookupBean(String name) {
        BeanManager manager = CDIUtil.lookupBeanManager();
        Set beans = manager.getBeans(name);
        if (beans != null && !beans.isEmpty()) {
            Bean bean = (Bean)beans.iterator().next();
            CreationalContext context = manager.createCreationalContext((Contextual)bean);
            return manager.getReference(bean, Object.class, context);
        }
        return null;
    }

    public static String getNamedAnnotationValue(Class<?> clazz) {
        Named named = clazz.getAnnotation(Named.class);
        if (named == null) {
            return null;
        }
        return named.value();
    }

    private static BeanManager getCDIBeanManager(String jndiLocation) {
        Context javaComp = CDIUtil.getJavaComp(jndiLocation);
        if (javaComp != null) {
            try {
                return (BeanManager)javaComp.lookup("BeanManager");
            }
            catch (NamingException e) {
                return null;
            }
        }
        return null;
    }

    private static Context getJavaComp(String jndiName) {
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            Context context = (Context)initialContext.lookup(jndiName);
            return context;
        }
        catch (NamingException e) {
            Context context = null;
            return context;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected Exception retrieving '" + jndiName + "' from JNDI namespace.", e);
        }
        finally {
            if (initialContext != null) {
                try {
                    initialContext.close();
                }
                catch (NamingException e) {
                    throw new IllegalStateException("Unexpected error closing InitialContext.", e);
                }
            }
        }
    }

    private static BeanManager getOSGICDIBeanManager() {
        try {
            return OSGICDISupport.getBeanManager();
        }
        catch (Throwable t) {
            return null;
        }
    }
}

