/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.admin.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.switchyard.admin.Application;
import org.switchyard.admin.ComponentService;
import org.switchyard.admin.Reference;
import org.switchyard.admin.Service;
import org.switchyard.admin.Transformer;
import org.switchyard.admin.Validator;
import org.switchyard.admin.base.BaseJavaComponentService;
import org.switchyard.admin.base.BaseNoopComponentService;
import org.switchyard.admin.base.BaseReference;
import org.switchyard.admin.base.BaseService;
import org.switchyard.admin.base.BaseTransformer;
import org.switchyard.admin.base.BaseValidator;
import org.switchyard.admin.base.BaseWsdlComponentService;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.CompositeReferenceModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.config.model.property.PropertyModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.config.model.transform.TransformModel;
import org.switchyard.config.model.validate.ValidateModel;
import org.switchyard.deploy.internal.AbstractDeployment;

public class BaseApplication
implements Application {
    private final QName _name;
    private Map<QName, Service> _services;
    private Map<QName, Reference> _references;
    private Map<QName, ComponentService> _componentServices;
    private List<Transformer> _transformers;
    private List<Validator> _validators;
    private AbstractDeployment _deployment;
    private Map<String, String> _properties;

    public BaseApplication(AbstractDeployment deployment) {
        this._name = deployment.getName();
        this._deployment = deployment;
        this.addTransformers();
        this.addValidators();
        this.addComponents();
        this.addServices();
        this.addReferences();
        this.addProperties();
    }

    @Override
    public QName getName() {
        return this._name;
    }

    @Override
    public List<Service> getServices() {
        if (this._services == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Service>(this._services.values());
    }

    @Override
    public List<Reference> getReferences() {
        if (this._references == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Reference>(this._references.values());
    }

    @Override
    public Service getService(QName serviceName) {
        if (this._services == null) {
            return null;
        }
        return this._services.get(serviceName);
    }

    @Override
    public Reference getReference(QName referenceName) {
        if (this._references == null) {
            return null;
        }
        return this._references.get(referenceName);
    }

    @Override
    public SwitchYardModel getConfig() {
        return this._deployment.getConfig();
    }

    @Override
    public List<ComponentService> getComponentServices() {
        if (this._componentServices == null) {
            return Collections.emptyList();
        }
        return new ArrayList<ComponentService>(this._componentServices.values());
    }

    @Override
    public ComponentService getComponentService(QName componentServiceName) {
        if (this._componentServices == null) {
            return null;
        }
        return this._componentServices.get(componentServiceName);
    }

    @Override
    public List<Transformer> getTransformers() {
        return Collections.unmodifiableList(this._transformers);
    }

    @Override
    public List<Validator> getValidators() {
        return Collections.unmodifiableList(this._validators);
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this._properties);
    }

    public AbstractDeployment getDeployment() {
        return this._deployment;
    }

    private void addServices() {
        this._services = new LinkedHashMap<QName, Service>();
        if (this.getConfig().getComposite().getServices() == null) {
            return;
        }
        for (CompositeServiceModel service : this.getConfig().getComposite().getServices()) {
            this._services.put(service.getQName(), new BaseService(service, this));
        }
    }

    private void addReferences() {
        this._references = new LinkedHashMap<QName, Reference>();
        if (this.getConfig().getComposite().getReferences() == null) {
            return;
        }
        for (CompositeReferenceModel ref : this.getConfig().getComposite().getReferences()) {
            this._references.put(ref.getQName(), new BaseReference(ref, this));
        }
    }

    private void addTransformers() {
        this._transformers = new LinkedList<Transformer>();
        if (this.getConfig().getTransforms() == null) {
            return;
        }
        for (TransformModel transformModel : this.getConfig().getTransforms().getTransforms()) {
            this._transformers.add(new BaseTransformer(transformModel));
        }
    }

    private void addValidators() {
        this._validators = new LinkedList<Validator>();
        if (this.getConfig().getValidates() == null) {
            return;
        }
        for (ValidateModel validateModel : this.getConfig().getValidates().getValidates()) {
            this._validators.add(new BaseValidator(validateModel));
        }
    }

    private void addComponents() {
        this._componentServices = new LinkedHashMap<QName, ComponentService>();
        if (this.getConfig().getComposite().getComponents() == null) {
            return;
        }
        for (ComponentModel component : this.getConfig().getComposite().getComponents()) {
            if (component.getServices().size() <= 0) continue;
            ComponentServiceModel service = (ComponentServiceModel)component.getServices().get(0);
            if (service.getInterface() == null || "esb".equals(service.getInterface().getType())) {
                this._componentServices.put(service.getQName(), new BaseNoopComponentService(service, component, this));
                continue;
            }
            if ("java".equals(service.getInterface().getType())) {
                this._componentServices.put(service.getQName(), new BaseJavaComponentService(service, component, this));
                continue;
            }
            if (!"wsdl".equals(service.getInterface().getType())) continue;
            this._componentServices.put(service.getQName(), new BaseWsdlComponentService(service, component, this));
        }
    }

    private void addProperties() {
        this._properties = new LinkedHashMap<String, String>();
        if (this.getConfig().getComposite() == null) {
            return;
        }
        for (PropertyModel property : this.getConfig().getComposite().getProperties().values()) {
            this._properties.put(property.getName(), property.getValue());
        }
    }
}

