/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ELUtils;
import javax.el.ExpressionFactory;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanELResolver
extends ELResolver {
    private final boolean readOnly;
    private final ConcurrentCache<String, BeanProperties> cache = new ConcurrentCache(1000);

    public BeanELResolver() {
        this.readOnly = false;
    }

    public BeanELResolver(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return null;
        }
        context.setPropertyResolved(true);
        Method m = this.property(context, base, property).read(context);
        try {
            return m.invoke(base, (Object[])null);
        }
        catch (IllegalAccessException e) {
            throw new ELException(e);
        }
        catch (InvocationTargetException e) {
            throw new ELException(BeanELResolver.message(context, "propertyReadError", new Object[]{base.getClass().getName(), property.toString()}), e.getCause());
        }
        catch (Exception e) {
            throw new ELException(e);
        }
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return null;
        }
        context.setPropertyResolved(true);
        return this.property(context, base, property).getPropertyType();
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return;
        }
        context.setPropertyResolved(true);
        if (this.readOnly) {
            throw new PropertyNotWritableException(BeanELResolver.message(context, "resolverNotWriteable", new Object[]{base.getClass().getName()}));
        }
        Method m = this.property(context, base, property).write(context);
        try {
            m.invoke(base, value);
        }
        catch (IllegalAccessException e) {
            throw new ELException(e);
        }
        catch (InvocationTargetException e) {
            throw new ELException(BeanELResolver.message(context, "propertyWriteError", new Object[]{base.getClass().getName(), property.toString()}), e.getCause());
        }
        catch (Exception e) {
            throw new ELException(e);
        }
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return false;
        }
        context.setPropertyResolved(true);
        return this.readOnly || this.property(context, base, property).isReadOnly();
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null) {
            return null;
        }
        try {
            PropertyDescriptor[] pds;
            BeanInfo info = Introspector.getBeanInfo(base.getClass());
            for (PropertyDescriptor pd : pds = info.getPropertyDescriptors()) {
                pd.setValue("resolvableAtDesignTime", Boolean.TRUE);
                pd.setValue("type", pd.getPropertyType());
            }
            return Arrays.asList((FeatureDescriptor[])pds).iterator();
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base != null) {
            return Object.class;
        }
        return null;
    }

    private BeanProperty property(ELContext ctx, Object base, Object property) {
        Class<?> type = base.getClass();
        String prop = property.toString();
        BeanProperties props = this.cache.get(type.getName());
        if (props == null || type != props.getType()) {
            props = new BeanProperties(type);
            this.cache.put(type.getName(), props);
        }
        return props.get(ctx, prop);
    }

    private static Method getMethod(Class type, Method m) {
        Method mp;
        Class<?>[] inf;
        if (m == null || Modifier.isPublic(type.getModifiers())) {
            return m;
        }
        for (Class<?> anInf : inf = type.getInterfaces()) {
            try {
                mp = anInf.getMethod(m.getName(), m.getParameterTypes());
                mp = BeanELResolver.getMethod(mp.getDeclaringClass(), mp);
                if (mp == null) continue;
                return mp;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        Class sup = type.getSuperclass();
        if (sup != null) {
            try {
                mp = sup.getMethod(m.getName(), m.getParameterTypes());
                mp = BeanELResolver.getMethod(mp.getDeclaringClass(), mp);
                if (mp != null) {
                    return mp;
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Object invoke(ELContext context, Object base, Object method, Class<?>[] paramTypes, Object[] params) {
        String methodName;
        if (context == null) {
            throw new NullPointerException("ELContext could not be nulll");
        }
        if (base == null || method == null) {
            return null;
        }
        if (params == null) {
            params = new Object[]{};
        }
        ExpressionFactory expressionFactory = null;
        if (ELUtils.isCachedExpressionFactoryEnabled()) {
            expressionFactory = ELUtils.getCachedExpressionFactory();
        }
        if (expressionFactory == null) {
            expressionFactory = ExpressionFactory.newInstance();
        }
        if ((methodName = (String)expressionFactory.coerceToType(method, String.class)).length() == 0) {
            throw new MethodNotFoundException("The parameter method could not be zero-length");
        }
        Class<?> targetClass = base.getClass();
        if (methodName.equals("<init>") || methodName.equals("<cinit>")) {
            throw new MethodNotFoundException(method + " is not found in target class " + targetClass.getName());
        }
        Method targetMethod = null;
        if (paramTypes == null) {
            int paramsNumber = params.length;
            for (Method m : targetClass.getMethods()) {
                if (!m.getName().equals(methodName) || m.getParameterTypes().length != paramsNumber) continue;
                targetMethod = m;
                break;
            }
            if (targetMethod == null) {
                for (Method m : targetClass.getMethods()) {
                    if (!m.getName().equals(methodName) || !m.isVarArgs() || paramsNumber < m.getParameterTypes().length - 1) continue;
                    targetMethod = m;
                    break;
                }
            }
        } else {
            try {
                targetMethod = targetClass.getMethod(methodName, paramTypes);
            }
            catch (SecurityException e) {
                throw new ELException(e);
            }
            catch (NoSuchMethodException e) {
                throw new MethodNotFoundException(e);
            }
        }
        if (targetMethod == null) {
            throw new MethodNotFoundException(method + " is not found in target class " + targetClass.getName());
        }
        if (paramTypes == null) {
            paramTypes = targetMethod.getParameterTypes();
        }
        if (targetMethod.isVarArgs() ? paramTypes.length - 1 > params.length : paramTypes.length != params.length) {
            throw new IllegalArgumentException("Inconsistent number between argument types and values");
        }
        try {
            Object[] finalParamValues = new Object[paramTypes.length];
            if (paramTypes.length > 0) {
                int iCurrentIndex;
                int iLoopSize = paramTypes.length - 1;
                for (iCurrentIndex = 0; iCurrentIndex < iLoopSize; ++iCurrentIndex) {
                    finalParamValues[iCurrentIndex] = expressionFactory.coerceToType(params[iCurrentIndex], paramTypes[iCurrentIndex]);
                }
                if (targetMethod.isVarArgs()) {
                    Class<?> varArgsClassType = paramTypes[iCurrentIndex];
                    if (iCurrentIndex == params.length) {
                        finalParamValues[iCurrentIndex] = Array.newInstance(varArgsClassType.getComponentType(), 0);
                    } else if (iCurrentIndex == params.length - 1 && varArgsClassType == params[iCurrentIndex].getClass() && varArgsClassType.getClassLoader() == params[iCurrentIndex].getClass().getClassLoader()) {
                        finalParamValues[iCurrentIndex] = params[iCurrentIndex];
                    } else {
                        Object targetArray = Array.newInstance(varArgsClassType.getComponentType(), params.length - iCurrentIndex);
                        Class<?> componentClassType = varArgsClassType.getComponentType();
                        int iLoopSize2 = params.length - iCurrentIndex;
                        for (int i = 0; i < iLoopSize2; ++i) {
                            Array.set(targetArray, i, expressionFactory.coerceToType(iCurrentIndex + i, componentClassType));
                        }
                        finalParamValues[iCurrentIndex] = targetArray;
                    }
                } else {
                    finalParamValues[iCurrentIndex] = expressionFactory.coerceToType(params[iCurrentIndex], paramTypes[iCurrentIndex]);
                }
            }
            Object retValue = targetMethod.invoke(base, finalParamValues);
            context.setPropertyResolved(true);
            return retValue;
        }
        catch (IllegalAccessException e) {
            throw new ELException(e);
        }
        catch (InvocationTargetException e) {
            throw new ELException(e.getCause());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConcurrentCache<K, V> {
        private final int size;
        private final Map<K, V> eden;
        private final Map<K, V> longterm;

        public ConcurrentCache(int size) {
            this.size = size;
            this.eden = new ConcurrentHashMap(size);
            this.longterm = new WeakHashMap(size);
        }

        public V get(K key) {
            V value = this.eden.get(key);
            if (value == null && (value = this.longterm.get(key)) != null) {
                this.eden.put(key, value);
            }
            return value;
        }

        public void put(K key, V value) {
            if (this.eden.size() >= this.size) {
                this.longterm.putAll(this.eden);
                this.eden.clear();
            }
            this.eden.put(key, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class BeanProperty {
        private final Class<?> type;
        private final Class<?> owner;
        private final PropertyDescriptor descriptor;
        private Method read;
        private Method write;

        public BeanProperty(Class<?> owner, PropertyDescriptor descriptor) {
            this.owner = owner;
            this.descriptor = descriptor;
            this.type = descriptor.getPropertyType();
        }

        public Class getPropertyType() {
            return this.type;
        }

        public boolean isReadOnly() {
            return this.write == null && null == (this.write = BeanELResolver.getMethod(this.owner, this.descriptor.getWriteMethod()));
        }

        public Method getWriteMethod() {
            return this.write(null);
        }

        public Method getReadMethod() {
            return this.read(null);
        }

        private Method write(ELContext ctx) {
            if (this.write == null) {
                this.write = BeanELResolver.getMethod(this.owner, this.descriptor.getWriteMethod());
                if (this.write == null) {
                    throw new PropertyNotFoundException(ELResolver.message(ctx, "propertyNotWritable", new Object[]{this.type.getName(), this.descriptor.getName()}));
                }
            }
            return this.write;
        }

        private Method read(ELContext ctx) {
            if (this.read == null) {
                this.read = BeanELResolver.getMethod(this.owner, this.descriptor.getReadMethod());
                if (this.read == null) {
                    throw new PropertyNotFoundException(ELResolver.message(ctx, "propertyNotReadable", new Object[]{this.type.getName(), this.descriptor.getName()}));
                }
            }
            return this.read;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class BeanProperties {
        private final Map<String, BeanProperty> properties;
        private final Class<?> type;

        public BeanProperties(Class<?> type) throws ELException {
            this.type = type;
            this.properties = new HashMap<String, BeanProperty>();
            try {
                PropertyDescriptor[] pds;
                BeanInfo info = Introspector.getBeanInfo(this.type);
                for (PropertyDescriptor pd : pds = info.getPropertyDescriptors()) {
                    this.properties.put(pd.getName(), new BeanProperty(type, pd));
                }
            }
            catch (IntrospectionException ie) {
                throw new ELException(ie);
            }
        }

        private BeanProperty get(ELContext ctx, String name) {
            BeanProperty property = this.properties.get(name);
            if (property == null) {
                throw new PropertyNotFoundException(ELResolver.message(ctx, "propertyNotFound", new Object[]{this.type.getName(), name}));
            }
            return property;
        }

        public BeanProperty getBeanProperty(String name) {
            return this.get(null, name);
        }

        private Class<?> getType() {
            return this.type;
        }
    }
}

