/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import org.kie.internal.executor.api.Command;
import org.kie.internal.executor.api.CommandCallback;
import org.kie.internal.executor.api.CommandContext;
import org.kie.internal.runtime.Cacheable;
import org.kie.internal.runtime.Closeable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ClassCacheManager {
    private static final Logger logger = LoggerFactory.getLogger(ClassCacheManager.class);
    private final Map<String, Command> commandCache = new HashMap<String, Command>();
    private final Map<String, CommandCallback> callbackCache = new HashMap<String, CommandCallback>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command findCommand(String name, ClassLoader cl) {
        Map<String, Command> map = this.commandCache;
        synchronized (map) {
            if (!this.commandCache.containsKey(name)) {
                try {
                    Command commandInstance = (Command)Class.forName(name, true, cl).newInstance();
                    this.commandCache.put(name, commandInstance);
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Unknown Command implemenation with name '" + name + "'");
                }
            }
            Command cmd = this.commandCache.get(name);
            if (!cmd.getClass().getClassLoader().equals(cl)) {
                this.commandCache.remove(name);
                try {
                    Command commandInstance = (Command)Class.forName(name, true, cl).newInstance();
                    this.commandCache.put(name, commandInstance);
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Unknown Command implemenation with name '" + name + "'");
                }
            }
        }
        return this.commandCache.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandCallback findCommandCallback(String name, ClassLoader cl) {
        Map<String, CommandCallback> map = this.callbackCache;
        synchronized (map) {
            if (!this.callbackCache.containsKey(name)) {
                try {
                    CommandCallback commandCallbackInstance = (CommandCallback)Class.forName(name, true, cl).newInstance();
                    return commandCallbackInstance;
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Unknown Command implemenation with name '" + name + "'");
                }
            }
            CommandCallback cmdCallback = this.callbackCache.get(name);
            if (!cmdCallback.getClass().getClassLoader().equals(cl)) {
                this.callbackCache.remove(name);
                try {
                    CommandCallback commandCallbackInstance = (CommandCallback)Class.forName(name, true, cl).newInstance();
                    this.callbackCache.put(name, commandCallbackInstance);
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Unknown Command implemenation with name '" + name + "'");
                }
            }
        }
        return this.callbackCache.get(name);
    }

    public List<CommandCallback> buildCommandCallback(CommandContext ctx, ClassLoader cl) {
        ArrayList<CommandCallback> callbackList = new ArrayList<CommandCallback>();
        if (ctx != null && ctx.getData("callbacks") != null) {
            logger.debug("Callback: {}", ctx.getData("callbacks"));
            String[] callbacksArray = ((String)ctx.getData("callbacks")).split(",");
            List<String> callbacks = Arrays.asList(callbacksArray);
            for (String callbackName : callbacks) {
                CommandCallback handler = this.findCommandCallback(callbackName.trim(), cl);
                callbackList.add(handler);
            }
        }
        return callbackList;
    }

    protected void closeInstance(Object instance) {
        if (instance == null) {
            return;
        }
        if (instance instanceof Closeable) {
            ((Closeable)instance).close();
        } else if (instance instanceof Cacheable) {
            ((Cacheable)instance).close();
        }
    }

    @PreDestroy
    public void dispose() {
        if (this.commandCache != null) {
            for (Command command : this.commandCache.values()) {
                this.closeInstance(command);
            }
        }
        if (this.callbackCache != null) {
            for (Command command : this.callbackCache.values()) {
                this.closeInstance(command);
            }
        }
    }
}

