/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.serial.format;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.switchyard.common.io.CountingOutputStream;
import org.switchyard.serial.BaseSerializer;
import org.switchyard.serial.FormatType;

public final class SERObjectSerializer
extends BaseSerializer {
    public SERObjectSerializer() {
        super(FormatType.SER_OBJECT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> int serialize(T obj, Class<T> type, OutputStream out) throws IOException {
        out = new CountingOutputStream((OutputStream)new BufferedOutputStream(out, this.getBufferSize()));
        try {
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(obj);
            oos.flush();
        }
        finally {
            if (this.isCloseEnabled()) {
                out.close();
            }
        }
        return ((CountingOutputStream)out).getCount();
    }

    @Override
    public <T> T deserialize(InputStream in, Class<T> type) throws IOException {
        in = new BufferedInputStream(in, this.getBufferSize());
        try {
            ObjectInputStream ois = new ObjectInputStream(in);
            Object obj = ois.readObject();
            T t = type.cast(obj);
            return t;
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe);
        }
        finally {
            if (this.isCloseEnabled()) {
                in.close();
            }
        }
    }
}

