/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.drools.compiler.kie.builder.impl.InternalKieContainer;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieScanner;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.MemoryKieModule;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.compiler.kie.builder.impl.ZipKieModule;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.eclipse.aether.artifact.Artifact;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.KieScanner;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.runtime.KieContainer;
import org.kie.scanner.ArtifactResolver;
import org.kie.scanner.DependencyDescriptor;
import org.kie.scanner.KieScannersRegistry;
import org.kie.scanner.management.KieScannerMBean;
import org.kie.scanner.management.KieScannerMBeanImpl;
import org.kie.scanner.management.MBeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieRepositoryScannerImpl
implements InternalKieScanner {
    private Timer timer;
    private static final Logger log = LoggerFactory.getLogger(KieScanner.class);
    private InternalKieContainer kieContainer;
    private DependencyDescriptor kieProjectDescr;
    private Map<ReleaseId, DependencyDescriptor> usedDependencies;
    private ArtifactResolver artifactResolver;
    private InternalKieScanner.Status status = InternalKieScanner.Status.STARTING;
    private KieScannerMBean mbean;
    private long pollingInterval;

    public synchronized void setKieContainer(KieContainer kieContainer) {
        if (this.kieContainer != null) {
            throw new RuntimeException("Cannot change KieContainer on an already initialized KieScanner");
        }
        this.kieContainer = (InternalKieContainer)kieContainer;
        if (this.kieContainer.getContainerReleaseId() == null) {
            throw new RuntimeException("The KieContainer's ReleaseId cannot be null. Are you using a KieClasspathContainer?");
        }
        this.kieProjectDescr = new DependencyDescriptor(this.kieContainer.getReleaseId(), this.kieContainer.getCreationTimestamp());
        this.artifactResolver = ArtifactResolver.getResolverFor(kieContainer.getReleaseId(), true);
        this.usedDependencies = this.indexAtifacts(this.artifactResolver);
        KieScannersRegistry.register(this);
        this.status = InternalKieScanner.Status.STOPPED;
        if (MBeanUtils.isMBeanEnabled()) {
            this.mbean = new KieScannerMBeanImpl(this);
        }
    }

    private ArtifactResolver getArtifactResolver() {
        if (this.artifactResolver == null) {
            this.artifactResolver = new ArtifactResolver();
        }
        return this.artifactResolver;
    }

    public synchronized KieModule loadArtifact(ReleaseId releaseId) {
        return this.loadArtifact(releaseId, null);
    }

    public synchronized KieModule loadArtifact(ReleaseId releaseId, InputStream pomXml) {
        ArtifactResolver resolver = pomXml != null ? ArtifactResolver.getResolverFor(pomXml) : this.getArtifactResolver();
        Artifact artifact = resolver.resolveArtifact(releaseId);
        return artifact != null ? this.buildArtifact(artifact, resolver) : this.loadPomArtifact(releaseId);
    }

    public synchronized String getArtifactVersion(ReleaseId releaseId) {
        if (!releaseId.isSnapshot()) {
            return releaseId.getVersion();
        }
        Artifact artifact = this.getArtifactResolver().resolveArtifact(releaseId);
        return artifact != null ? artifact.getVersion() : null;
    }

    public synchronized ReleaseId getScannerReleaseId() {
        return this.kieContainer.getContainerReleaseId();
    }

    public synchronized ReleaseId getCurrentReleaseId() {
        return this.kieContainer.getReleaseId();
    }

    public synchronized InternalKieScanner.Status getStatus() {
        return this.status;
    }

    private KieModule loadPomArtifact(ReleaseId releaseId) {
        ArtifactResolver resolver = ArtifactResolver.getResolverFor(releaseId, false);
        if (resolver == null) {
            return null;
        }
        MemoryKieModule kieModule = new MemoryKieModule(releaseId);
        this.addDependencies((InternalKieModule)kieModule, resolver, resolver.getPomDirectDependencies());
        this.build((InternalKieModule)kieModule);
        return kieModule;
    }

    private InternalKieModule buildArtifact(Artifact artifact, ArtifactResolver resolver) {
        ZipKieModule kieModule;
        DependencyDescriptor dependencyDescriptor = new DependencyDescriptor(artifact);
        ReleaseId releaseId = dependencyDescriptor.getReleaseId();
        if (releaseId.isSnapshot()) {
            ((ReleaseIdImpl)releaseId).setSnapshotVersion(artifact.getVersion());
        }
        if ((kieModule = KieRepositoryScannerImpl.createZipKieModule(releaseId, artifact.getFile())) != null) {
            this.addDependencies((InternalKieModule)kieModule, resolver, resolver.getArtifactDependecies(dependencyDescriptor.toString()));
            this.build((InternalKieModule)kieModule);
        }
        return kieModule;
    }

    private void addDependencies(InternalKieModule kieModule, ArtifactResolver resolver, List<DependencyDescriptor> dependencies) {
        for (DependencyDescriptor dep : dependencies) {
            ReleaseId depReleaseId;
            ZipKieModule zipKieModule;
            InternalKieModule dependency = (InternalKieModule)KieServices.Factory.get().getRepository().getKieModule(dep.getReleaseId());
            if (dependency != null) {
                kieModule.addKieDependency(dependency);
                continue;
            }
            Artifact depArtifact = resolver.resolveArtifact(dep.getReleaseId());
            if (depArtifact == null || !this.isKJar(depArtifact.getFile()) || (zipKieModule = KieRepositoryScannerImpl.createZipKieModule(depReleaseId = new DependencyDescriptor(depArtifact).getReleaseId(), depArtifact.getFile())) == null) continue;
            kieModule.addKieDependency((InternalKieModule)zipKieModule);
        }
    }

    private static ZipKieModule createZipKieModule(ReleaseId releaseId, File jar) {
        KieModuleModel kieModuleModel = KieRepositoryScannerImpl.getKieModuleModelFromJar(jar);
        return kieModuleModel != null ? new ZipKieModule(releaseId, kieModuleModel, jar) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KieModuleModel getKieModuleModelFromJar(File jar) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(jar);
            ZipEntry zipEntry = zipFile.getEntry("META-INF/kmodule.xml");
            KieModuleModel kieModuleModel = KieModuleModelImpl.fromXML((InputStream)zipFile.getInputStream(zipEntry));
            KieBuilderImpl.setDefaultsforEmptyKieModule((KieModuleModel)kieModuleModel);
            KieModuleModel kieModuleModel2 = kieModuleModel;
            return kieModuleModel2;
        }
        catch (Exception exception) {
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private ResultsImpl build(InternalKieModule kieModule) {
        ResultsImpl messages = new ResultsImpl();
        KieBuilderImpl.buildKieModule((InternalKieModule)kieModule, (ResultsImpl)messages);
        return messages;
    }

    public synchronized void start(long pollingInterval) {
        if (this.getStatus() == InternalKieScanner.Status.SHUTDOWN) {
            throw new IllegalStateException("The scanner was shut down and can no longer be started.");
        }
        if (pollingInterval <= 0L) {
            throw new IllegalArgumentException("pollingInterval must be positive");
        }
        if (this.timer != null) {
            throw new IllegalStateException("The scanner is already running");
        }
        this.startScanTask(pollingInterval);
    }

    public synchronized void stop() {
        if (this.getStatus() == InternalKieScanner.Status.SHUTDOWN) {
            throw new IllegalStateException("The scanner was already shut down.");
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.pollingInterval = 0L;
        this.status = InternalKieScanner.Status.STOPPED;
    }

    public synchronized long getPollingInterval() {
        return this.pollingInterval;
    }

    public void shutdown() {
        if (this.getStatus() != InternalKieScanner.Status.SHUTDOWN) {
            this.stop();
            this.status = InternalKieScanner.Status.SHUTDOWN;
        }
    }

    private void startScanTask(long pollingInterval) {
        this.status = InternalKieScanner.Status.RUNNING;
        this.pollingInterval = pollingInterval;
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)new ScanTask(), pollingInterval, pollingInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void scanNow() {
        if (this.getStatus() == InternalKieScanner.Status.SHUTDOWN) {
            throw new IllegalStateException("The scanner was already shut down and can no longer be used.");
        }
        try {
            this.status = InternalKieScanner.Status.SCANNING;
            Map<DependencyDescriptor, Artifact> updatedArtifacts = this.scanForUpdates();
            if (updatedArtifacts.isEmpty()) {
                this.status = InternalKieScanner.Status.STOPPED;
                return;
            }
            this.status = InternalKieScanner.Status.UPDATING;
            Map.Entry<DependencyDescriptor, Artifact> containerEntry = null;
            for (Map.Entry<DependencyDescriptor, Artifact> entry : updatedArtifacts.entrySet()) {
                if (entry.getKey().isSameArtifact(this.kieContainer.getContainerReleaseId())) {
                    containerEntry = entry;
                    continue;
                }
                this.updateKieModule(entry.getKey(), entry.getValue());
            }
            if (containerEntry != null) {
                this.updateKieModule((DependencyDescriptor)containerEntry.getKey(), (Artifact)containerEntry.getValue());
            }
            log.info("The following artifacts have been updated: " + updatedArtifacts);
        }
        finally {
            this.status = InternalKieScanner.Status.STOPPED;
        }
    }

    private void updateKieModule(DependencyDescriptor oldDependency, Artifact artifact) {
        ReleaseId newReleaseId = new DependencyDescriptor(artifact).getReleaseId();
        ZipKieModule kieModule = KieRepositoryScannerImpl.createZipKieModule(newReleaseId, artifact.getFile());
        if (kieModule != null) {
            this.addDependencies((InternalKieModule)kieModule, this.artifactResolver, this.artifactResolver.getArtifactDependecies(newReleaseId.toString()));
            ResultsImpl messages = this.build((InternalKieModule)kieModule);
            if (messages.filterMessages(new Message.Level[]{Message.Level.ERROR}).isEmpty()) {
                this.kieContainer.updateDependencyToVersion(oldDependency.getArtifactReleaseId(), newReleaseId);
                oldDependency.setArtifactVersion(artifact.getVersion());
            }
        }
    }

    private Map<DependencyDescriptor, Artifact> scanForUpdates() {
        DependencyDescriptor resolvedDep;
        this.artifactResolver = ArtifactResolver.getResolverFor(this.kieContainer.getReleaseId(), true);
        HashMap<DependencyDescriptor, Artifact> newArtifacts = new HashMap<DependencyDescriptor, Artifact>();
        Artifact newArtifact = this.artifactResolver.resolveArtifact(this.kieContainer.getContainerReleaseId());
        if (newArtifact != null && (resolvedDep = new DependencyDescriptor(newArtifact)).isNewerThan(this.kieProjectDescr)) {
            newArtifacts.put(this.kieProjectDescr, newArtifact);
            this.kieProjectDescr = new DependencyDescriptor(newArtifact);
        }
        for (DependencyDescriptor dep : this.artifactResolver.getAllDependecies()) {
            DependencyDescriptor newDep;
            ReleaseId artifactId = dep.getReleaseIdWithoutVersion();
            DependencyDescriptor oldDep = this.usedDependencies.get(artifactId);
            if (oldDep == null || (newArtifact = this.artifactResolver.resolveArtifact(dep.getReleaseId())) == null || !(newDep = new DependencyDescriptor(newArtifact)).isNewerThan(oldDep)) continue;
            newArtifacts.put(oldDep, newArtifact);
            this.usedDependencies.put(artifactId, newDep);
        }
        return newArtifacts;
    }

    private Map<ReleaseId, DependencyDescriptor> indexAtifacts(ArtifactResolver artifactResolver) {
        HashMap<ReleaseId, DependencyDescriptor> depsMap = new HashMap<ReleaseId, DependencyDescriptor>();
        for (DependencyDescriptor dep : artifactResolver.getAllDependecies()) {
            Artifact artifact = artifactResolver.resolveArtifact(dep.getReleaseId());
            log.debug(artifact + " resolved to  " + artifact.getFile());
            if (!this.isKJar(artifact.getFile())) continue;
            depsMap.put(dep.getReleaseIdWithoutVersion(), new DependencyDescriptor(artifact));
        }
        return depsMap;
    }

    private boolean isKJar(File jar) {
        ZipFile zipFile;
        try {
            zipFile = new ZipFile(jar);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ZipEntry zipEntry = zipFile.getEntry("META-INF/kmodule.xml");
        return zipEntry != null;
    }

    public synchronized KieScannerMBean getMBean() {
        return this.mbean;
    }

    private class ScanTask
    extends TimerTask {
        private ScanTask() {
        }

        @Override
        public void run() {
            KieRepositoryScannerImpl.this.scanNow();
            KieRepositoryScannerImpl.this.status = InternalKieScanner.Status.RUNNING;
        }
    }
}

