/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.LeftTupleSets;
import org.drools.core.common.RightTupleSets;
import org.drools.core.phreak.PhreakJoinNode;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.ExistsNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleMemory;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleMemory;
import org.drools.core.rule.ContextEntry;
import org.drools.core.util.FastIterator;

public class PhreakExistsNode {
    public void doNode(ExistsNode existsNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        RightTupleSets srcRightTuples = bm.getStagedRightTuples().takeAll();
        if (srcLeftTuples.getDeleteFirst() != null) {
            this.doLeftDeletes(bm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            RuleNetworkEvaluator.doUpdatesExistentialReorderLeftMemory(bm, srcLeftTuples);
        }
        if (srcRightTuples.getUpdateFirst() != null) {
            RuleNetworkEvaluator.doUpdatesExistentialReorderRightMemory(bm, existsNode, srcRightTuples);
        }
        if (srcRightTuples.getInsertFirst() != null) {
            this.doRightInserts(existsNode, sink, bm, wm, srcRightTuples, trgLeftTuples);
        }
        if (srcRightTuples.getUpdateFirst() != null) {
            this.doRightUpdates(existsNode, sink, bm, wm, srcRightTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcRightTuples.getDeleteFirst() != null) {
            this.doRightDeletes(existsNode, bm, wm, srcRightTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            this.doLeftUpdates(existsNode, sink, bm, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcLeftTuples.getInsertFirst() != null) {
            this.doLeftInserts(existsNode, sink, bm, wm, srcLeftTuples, trgLeftTuples);
        }
        srcRightTuples.resetAll();
        srcLeftTuples.resetAll();
    }

    public void doLeftInserts(ExistsNode existsNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples) {
        LeftTupleMemory ltm = bm.getLeftTupleMemory();
        RightTupleMemory rtm = bm.getRightTupleMemory();
        ContextEntry[] contextEntry = bm.getContext();
        BetaConstraints constraints = existsNode.getRawConstraints();
        LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            FastIterator it = existsNode.getRightIterator(rtm);
            boolean useLeftMemory = RuleNetworkEvaluator.useLeftMemory(existsNode, leftTuple);
            constraints.updateFromTuple(contextEntry, wm, leftTuple);
            RuleNetworkEvaluator.findLeftTupleBlocker(existsNode, rtm, contextEntry, constraints, leftTuple, it, useLeftMemory);
            if (leftTuple.getBlocker() != null) {
                trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, leftTuple.getBlocker().getPropagationContext(), useLeftMemory));
            } else if (useLeftMemory) {
                ltm.add(leftTuple);
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
        constraints.resetTuple(contextEntry);
    }

    public void doRightInserts(ExistsNode existsNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples) {
        LeftTupleMemory ltm = bm.getLeftTupleMemory();
        RightTupleMemory rtm = bm.getRightTupleMemory();
        ContextEntry[] contextEntry = bm.getContext();
        BetaConstraints constraints = existsNode.getRawConstraints();
        RightTuple rightTuple = srcRightTuples.getInsertFirst();
        while (rightTuple != null) {
            RightTuple next = rightTuple.getStagedNext();
            rtm.add(rightTuple);
            if (ltm != null && ltm.size() > 0) {
                FastIterator it = existsNode.getLeftIterator(ltm);
                constraints.updateFromFactHandle(contextEntry, wm, rightTuple.getFactHandle());
                LeftTuple leftTuple = existsNode.getFirstLeftTuple(rightTuple, ltm, it);
                while (leftTuple != null) {
                    LeftTuple temp = (LeftTuple)it.next(leftTuple);
                    if (leftTuple.getStagedType() == 2) {
                        leftTuple = temp;
                        continue;
                    }
                    if (constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                        leftTuple.setBlocker(rightTuple);
                        rightTuple.addBlocked(leftTuple);
                        ltm.remove(leftTuple);
                        trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, rightTuple.getPropagationContext(), true));
                    }
                    leftTuple = temp;
                }
            }
            rightTuple.clearStaged();
            rightTuple = next;
        }
        constraints.resetFactHandle(contextEntry);
    }

    public void doLeftUpdates(ExistsNode existsNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        LeftTupleMemory ltm = bm.getLeftTupleMemory();
        RightTupleMemory rtm = bm.getRightTupleMemory();
        ContextEntry[] contextEntry = bm.getContext();
        BetaConstraints constraints = existsNode.getRawConstraints();
        boolean leftUpdateOptimizationAllowed = existsNode.isLeftUpdateOptimizationAllowed();
        LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            FastIterator rightIt = existsNode.getRightIterator(rtm);
            RightTuple firstRightTuple = existsNode.getFirstRightTuple(leftTuple, rtm, null, rightIt);
            RightTuple blocker = leftTuple.getBlocker();
            if (blocker == null) {
                if (leftTuple.getMemory() != null) {
                    ltm.remove(leftTuple);
                }
            } else if (rtm.isIndexed() && !rightIt.isFullIterator() && (firstRightTuple == null || firstRightTuple.getMemory() != blocker.getMemory())) {
                blocker.removeBlocked(leftTuple);
                blocker = null;
            }
            constraints.updateFromTuple(contextEntry, wm, leftTuple);
            if (!leftUpdateOptimizationAllowed && blocker != null) {
                blocker.removeBlocked(leftTuple);
                blocker = null;
            }
            if (blocker == null || !constraints.isAllowedCachedLeft(contextEntry, blocker.getFactHandle())) {
                if (blocker != null) {
                    blocker.removeBlocked(leftTuple);
                }
                RightTuple newBlocker = firstRightTuple;
                while (newBlocker != null) {
                    if (constraints.isAllowedCachedLeft(contextEntry, newBlocker.getFactHandle())) {
                        leftTuple.setBlocker(newBlocker);
                        newBlocker.addBlocked(leftTuple);
                        break;
                    }
                    newBlocker = (RightTuple)rightIt.next(newBlocker);
                }
            }
            if (leftTuple.getBlocker() == null) {
                ltm.add(leftTuple);
                if (leftTuple.getFirstChild() != null) {
                    RuleNetworkEvaluator.deleteLeftChild(leftTuple.getFirstChild(), trgLeftTuples, stagedLeftTuples);
                }
            } else if (leftTuple.getFirstChild() == null) {
                trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, leftTuple.getBlocker().getPropagationContext(), true));
            } else {
                for (LeftTuple childLeftTuple = leftTuple.getFirstChild(); childLeftTuple != null; childLeftTuple = childLeftTuple.getLeftParentNext()) {
                    childLeftTuple.setPropagationContext(leftTuple.getBlocker().getPropagationContext());
                    PhreakJoinNode.updateChildLeftTuple(childLeftTuple, stagedLeftTuples, trgLeftTuples);
                    childLeftTuple.reAddRight();
                }
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
        constraints.resetTuple(contextEntry);
    }

    public void doRightUpdates(ExistsNode existsNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        LeftTupleMemory ltm = bm.getLeftTupleMemory();
        RightTupleMemory rtm = bm.getRightTupleMemory();
        ContextEntry[] contextEntry = bm.getContext();
        BetaConstraints constraints = existsNode.getRawConstraints();
        boolean iterateFromStart = existsNode.isIndexedUnificationJoin() || rtm.getIndexType().isComparison();
        RightTuple rightTuple = srcRightTuples.getUpdateFirst();
        while (rightTuple != null) {
            LeftTuple firstBlocked;
            RightTuple next = rightTuple.getStagedNext();
            if (ltm != null && ltm.size() > 0) {
                FastIterator leftIt = existsNode.getLeftIterator(ltm);
                LeftTuple firstLeftTuple = existsNode.getFirstLeftTuple(rightTuple, ltm, leftIt);
                constraints.updateFromFactHandle(contextEntry, wm, rightTuple.getFactHandle());
                LeftTuple leftTuple = firstLeftTuple;
                while (leftTuple != null) {
                    LeftTuple temp = (LeftTuple)leftIt.next(leftTuple);
                    if (leftTuple.getStagedType() == 2) {
                        leftTuple = temp;
                        continue;
                    }
                    if (constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                        leftTuple.setBlocker(rightTuple);
                        rightTuple.addBlocked(leftTuple);
                        ltm.remove(leftTuple);
                        trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, rightTuple.getPropagationContext(), true));
                    }
                    leftTuple = temp;
                }
            }
            if ((firstBlocked = rightTuple.getTempBlocked()) != null) {
                RightTuple rootBlocker = rightTuple.getTempNextRightTuple();
                if (rootBlocker == null) {
                    iterateFromStart = true;
                }
                FastIterator rightIt = existsNode.getRightIterator(rtm);
                LeftTuple leftTuple = firstBlocked;
                while (leftTuple != null) {
                    LeftTuple temp = leftTuple.getBlockedNext();
                    leftTuple.clearBlocker();
                    if (leftTuple.getStagedType() == 2) {
                        leftTuple.setBlocker(rightTuple);
                        rightTuple.addBlocked(leftTuple);
                        leftTuple = temp;
                        continue;
                    }
                    constraints.updateFromTuple(contextEntry, wm, leftTuple);
                    if (iterateFromStart) {
                        rootBlocker = existsNode.getFirstRightTuple(leftTuple, rtm, null, rightIt);
                    }
                    RightTuple newBlocker = rootBlocker;
                    while (newBlocker != null) {
                        if (leftTuple.getStagedType() != 3 && newBlocker.getStagedType() != 3 && constraints.isAllowedCachedLeft(contextEntry, newBlocker.getFactHandle())) {
                            leftTuple.setBlocker(newBlocker);
                            newBlocker.addBlocked(leftTuple);
                            break;
                        }
                        newBlocker = (RightTuple)rightIt.next(newBlocker);
                    }
                    if (leftTuple.getBlocker() == null) {
                        LeftTuple childLeftTuple;
                        if (ltm != null) {
                            ltm.add(leftTuple);
                        }
                        if ((childLeftTuple = leftTuple.getFirstChild()) != null) {
                            childLeftTuple.setPropagationContext(rightTuple.getPropagationContext());
                            RuleNetworkEvaluator.deleteLeftChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                        }
                    }
                    leftTuple = temp;
                }
            }
            rightTuple.clearStaged();
            rightTuple = next;
        }
        constraints.resetFactHandle(contextEntry);
    }

    public void doLeftDeletes(BetaMemory bm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        LeftTupleMemory ltm = bm.getLeftTupleMemory();
        LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            RightTuple blocker = leftTuple.getBlocker();
            if (blocker == null) {
                if (leftTuple.getMemory() != null) {
                    ltm.remove(leftTuple);
                }
            } else {
                if (leftTuple.getFirstChild() != null) {
                    RuleNetworkEvaluator.deleteLeftChild(leftTuple.getFirstChild(), trgLeftTuples, stagedLeftTuples);
                }
                blocker.removeBlocked(leftTuple);
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public void doRightDeletes(ExistsNode existsNode, BetaMemory bm, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        RightTupleMemory rtm = bm.getRightTupleMemory();
        LeftTupleMemory ltm = bm.getLeftTupleMemory();
        ContextEntry[] contextEntry = bm.getContext();
        BetaConstraints constraints = existsNode.getRawConstraints();
        RightTuple rightTuple = srcRightTuples.getDeleteFirst();
        while (rightTuple != null) {
            RightTuple rootBlocker;
            RightTuple next = rightTuple.getStagedNext();
            FastIterator it = existsNode.getRightIterator(rtm);
            boolean useComparisonIndex = rtm.getIndexType().isComparison();
            RightTuple rightTuple2 = rootBlocker = useComparisonIndex ? null : (RightTuple)it.next(rightTuple);
            if (rightTuple.getMemory() != null) {
                rtm.remove(rightTuple);
            }
            if (rightTuple.getBlocked() != null) {
                LeftTuple leftTuple = rightTuple.getBlocked();
                while (leftTuple != null) {
                    LeftTuple temp = leftTuple.getBlockedNext();
                    leftTuple.clearBlocker();
                    if (leftTuple.getStagedType() == 2) {
                        leftTuple = temp;
                        continue;
                    }
                    constraints.updateFromTuple(contextEntry, wm, leftTuple);
                    if (useComparisonIndex) {
                        rootBlocker = rtm.getFirst(leftTuple, null, it);
                    }
                    RightTuple newBlocker = rootBlocker;
                    while (newBlocker != null) {
                        if (constraints.isAllowedCachedLeft(contextEntry, newBlocker.getFactHandle())) {
                            leftTuple.setBlocker(newBlocker);
                            newBlocker.addBlocked(leftTuple);
                            break;
                        }
                        newBlocker = (RightTuple)it.next(newBlocker);
                    }
                    if (leftTuple.getBlocker() == null) {
                        ltm.add(leftTuple);
                        LeftTuple childLeftTuple = leftTuple.getFirstChild();
                        if (childLeftTuple != null) {
                            childLeftTuple.setPropagationContext(rightTuple.getPropagationContext());
                            RuleNetworkEvaluator.deleteLeftChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                        }
                    }
                    leftTuple = temp;
                }
            }
            rightTuple.nullBlocked();
            rightTuple.clearStaged();
            rightTuple = next;
        }
    }
}

