/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.karaf;

import java.util.Arrays;
import java.util.List;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.ArgumentCompleter;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.apache.karaf.shell.console.jline.CommandSessionHolder;
import org.switchyard.admin.Application;
import org.switchyard.admin.Reference;
import org.switchyard.admin.Service;
import org.switchyard.admin.SwitchYard;
import org.switchyard.deploy.karaf.ResetMetricsCommand;

public class ResetMetricsPatternCompleter
implements Completer {
    private SwitchYard _switchYard;

    public int complete(String buffer, int cursor, List<String> candidates) {
        StringsCompleter delegate = new StringsCompleter();
        ResetMetricsCommand.SearchType type = this.getType();
        switch (type) {
            case application: {
                for (Application application : this._switchYard.getApplications()) {
                    delegate.getStrings().add(application.getName().toString());
                }
                break;
            }
            case service: {
                for (Service service : this._switchYard.getServices()) {
                    delegate.getStrings().add(service.getName().toString());
                }
                break;
            }
            case reference: {
                for (Reference reference : this._switchYard.getReferences()) {
                    delegate.getStrings().add(reference.getName().toString());
                }
                break;
            }
        }
        return delegate.complete(buffer, cursor, candidates);
    }

    public void setSwitchYard(SwitchYard switchYard) {
        this._switchYard = switchYard;
    }

    private ResetMetricsCommand.SearchType getType() {
        CommandSession session = CommandSessionHolder.getSession();
        if (session == null) {
            return null;
        }
        ArgumentCompleter.ArgumentList argList = (ArgumentCompleter.ArgumentList)session.get("ARGUMENTS_LIST");
        if (argList == null || argList.getArguments() == null || argList.getArguments().length == 0) {
            return null;
        }
        List<String> arguments = Arrays.asList(argList.getArguments());
        int argumentOffset = 1;
        int count = arguments.size();
        for (int index = 0; index < count; ++index) {
            if (!arguments.get(index).startsWith("-")) continue;
            argumentOffset = index;
        }
        if (argumentOffset < arguments.size()) {
            return ResetMetricsCommand.SearchType.valueOf(arguments.get(argumentOffset));
        }
        return null;
    }
}

