/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.builder.impl.TypeDeclarationUtils;
import org.drools.compiler.builder.impl.TypeDefinition;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.compiler.TypeDeclarationError;
import org.drools.compiler.lang.descr.AbstractClassTypeDeclarationDescr;
import org.drools.compiler.lang.descr.AnnotationDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.compiler.lang.descr.QualifiedName;
import org.drools.compiler.lang.descr.TypeDeclarationDescr;
import org.drools.compiler.lang.descr.TypeFieldDescr;
import org.drools.core.base.TypeResolver;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.FieldDefinition;
import org.drools.core.factmodel.traits.Alias;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.util.HierarchySorter;
import org.drools.core.util.asm.ClassFieldInspector;
import org.kie.api.definition.type.FactField;
import org.kie.api.definition.type.Key;

public class ClassHierarchyManager {
    protected KnowledgeBuilderImpl kbuilder;
    protected List<AbstractClassTypeDeclarationDescr> sortedDescriptors;
    protected Map<QualifiedName, Collection<QualifiedName>> taxonomy;

    public ClassHierarchyManager(Collection<AbstractClassTypeDeclarationDescr> unsortedDescrs, KnowledgeBuilderImpl kbuilder) {
        this.kbuilder = kbuilder;
        this.sortedDescriptors = this.sortByHierarchy(unsortedDescrs, kbuilder);
    }

    public List<AbstractClassTypeDeclarationDescr> getSortedDescriptors() {
        return this.sortedDescriptors;
    }

    protected List<AbstractClassTypeDeclarationDescr> sortByHierarchy(Collection<AbstractClassTypeDeclarationDescr> unsortedDescrs, KnowledgeBuilderImpl kbuilder) {
        this.taxonomy = new HashMap<QualifiedName, Collection<QualifiedName>>();
        HashMap<QualifiedName, AbstractClassTypeDeclarationDescr> cache = new HashMap<QualifiedName, AbstractClassTypeDeclarationDescr>();
        for (AbstractClassTypeDeclarationDescr tdescr : unsortedDescrs) {
            QualifiedName name = tdescr.getType();
            cache.put(name, tdescr);
            Collection<QualifiedName> supers = this.taxonomy.get(name);
            if (supers == null) {
                supers = new ArrayList<QualifiedName>();
                this.taxonomy.put(name, supers);
            } else {
                kbuilder.addBuilderResult(new TypeDeclarationError(tdescr, "Found duplicate declaration for type " + tdescr.getType()));
            }
            boolean circular = false;
            for (QualifiedName sup : tdescr.getSuperTypes()) {
                if (Object.class.getName().equals(name.getFullName())) continue;
                if (!ClassHierarchyManager.hasCircularDependency(tdescr.getType(), sup, this.taxonomy)) {
                    supers.add(sup);
                    continue;
                }
                circular = true;
                kbuilder.addBuilderResult(new TypeDeclarationError(tdescr, "Found circular dependency for type " + tdescr.getTypeName()));
                break;
            }
            if (!circular) continue;
            tdescr.getSuperTypes().clear();
        }
        for (AbstractClassTypeDeclarationDescr tdescr : unsortedDescrs) {
            for (TypeFieldDescr field : tdescr.getFields().values()) {
                QualifiedName typeName;
                QualifiedName name = tdescr.getType();
                if (!ClassHierarchyManager.hasCircularDependency(name, typeName = new QualifiedName(field.getPattern().getObjectType()), this.taxonomy)) {
                    this.taxonomy.get(name).add(typeName);
                    continue;
                }
                field.setRecursive(true);
            }
        }
        List sorted = new HierarchySorter().sort(this.taxonomy);
        ArrayList<AbstractClassTypeDeclarationDescr> list = new ArrayList<AbstractClassTypeDeclarationDescr>(sorted.size());
        for (QualifiedName name : sorted) {
            list.add((AbstractClassTypeDeclarationDescr)cache.get(name));
        }
        return list;
    }

    protected static boolean hasCircularDependency(QualifiedName name, QualifiedName typeName, Map<QualifiedName, Collection<QualifiedName>> taxonomy) {
        if (name.equals(typeName)) {
            return true;
        }
        Collection<QualifiedName> parents = taxonomy.get(typeName);
        if (parents != null) {
            if (parents.contains(name)) {
                return true;
            }
            for (QualifiedName ancestor : parents) {
                if (!ClassHierarchyManager.hasCircularDependency(name, ancestor, taxonomy)) continue;
                return true;
            }
        }
        return false;
    }

    public void inheritFields(PackageRegistry pkgRegistry, AbstractClassTypeDeclarationDescr typeDescr, Collection<AbstractClassTypeDeclarationDescr> sortedTypeDescriptors, List<TypeDefinition> unresolvedTypes, Map<String, AbstractClassTypeDeclarationDescr> unprocessableDescrs) {
        TypeDeclarationDescr tDescr = (TypeDeclarationDescr)typeDescr;
        boolean isNovel = TypeDeclarationUtils.isNovelClass(typeDescr, pkgRegistry);
        boolean inferFields = !isNovel && typeDescr.getFields().isEmpty();
        for (QualifiedName qname : tDescr.getSuperTypes()) {
            if (!this.mergeInheritedFields(tDescr, unresolvedTypes, unprocessableDescrs, pkgRegistry.getTypeResolver())) continue;
        }
        if (inferFields) {
            try {
                Class<?> existingClass = TypeDeclarationUtils.getExistingDeclarationClass(typeDescr, pkgRegistry);
                ClassFieldInspector inspector = new ClassFieldInspector(existingClass);
                for (String name : inspector.getGetterMethods().keySet()) {
                    if (!inspector.getSetterMethods().containsKey(name) || inspector.isNonGetter(name) || "class".equals(name)) continue;
                    TypeFieldDescr inheritedFlDescr = new TypeFieldDescr(name, new PatternDescr(((Class)inspector.getFieldTypes().get(name)).getName()));
                    inheritedFlDescr.setInherited(!Modifier.isAbstract(((Method)inspector.getGetterMethods().get(name)).getModifiers()));
                    if (tDescr.getFields().containsKey(inheritedFlDescr.getFieldName())) continue;
                    tDescr.getFields().put(inheritedFlDescr.getFieldName(), inheritedFlDescr);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected boolean mergeInheritedFields(TypeDeclarationDescr typeDescr, List<TypeDefinition> unresolvedTypes, Map<String, AbstractClassTypeDeclarationDescr> unprocessableDescrs, TypeResolver typeResolver) {
        if (typeDescr.getSuperTypes().isEmpty()) {
            return false;
        }
        boolean merge = false;
        for (int j = typeDescr.getSuperTypes().size() - 1; j >= 0; --j) {
            String fullSuper;
            String superTypePackageName;
            QualifiedName qname = typeDescr.getSuperTypes().get(j);
            String simpleSuperTypeName = qname.getName();
            merge = this.mergeFields(simpleSuperTypeName, superTypePackageName = qname.getNamespace(), fullSuper = qname.getFullName(), typeDescr, unresolvedTypes, unprocessableDescrs, typeResolver) || merge;
        }
        return merge;
    }

    protected boolean mergeFields(String simpleSuperTypeName, String superTypePackageName, String fullSuper, TypeDeclarationDescr typeDescr, List<TypeDefinition> unresolvedTypes, Map<String, AbstractClassTypeDeclarationDescr> unprocessableDescrs, TypeResolver resolver) {
        TypeFieldDescr inheritedFlDescr;
        LinkedHashMap<String, TypeFieldDescr> fieldMap = new LinkedHashMap<String, TypeFieldDescr>();
        boolean isNovel = TypeDeclarationUtils.isNovelClass(typeDescr, this.kbuilder.getPackageRegistry(typeDescr.getNamespace()));
        PackageRegistry registry = this.kbuilder.getPackageRegistry(superTypePackageName);
        InternalKnowledgePackage pack = null;
        if (registry != null) {
            pack = registry.getPackage();
        } else if (isNovel) {
            unprocessableDescrs.put(typeDescr.getType().getFullName(), typeDescr);
            return false;
        }
        if (unprocessableDescrs.containsKey(fullSuper)) {
            unprocessableDescrs.put(typeDescr.getType().getFullName(), typeDescr);
            return false;
        }
        boolean isSuperClassTagged = false;
        boolean isSuperClassDeclared = true;
        if (pack != null) {
            TypeDeclaration superTypeDeclaration = pack.getTypeDeclaration(simpleSuperTypeName);
            if (superTypeDeclaration != null && superTypeDeclaration.getTypeClassDef() != null) {
                ClassDefinition classDef = superTypeDeclaration.getTypeClassDef();
                for (FactField fld : classDef.getFields()) {
                    inheritedFlDescr = this.buildInheritedFieldDescrFromDefinition(fld, typeDescr);
                    fieldMap.put(inheritedFlDescr.getFieldName(), inheritedFlDescr);
                }
                isSuperClassTagged = !superTypeDeclaration.isNovel();
            }
        } else {
            isSuperClassDeclared = false;
        }
        if (!isSuperClassDeclared || isSuperClassTagged) {
            try {
                Class superKlass = registry != null ? registry.getTypeResolver().resolveType(fullSuper) : resolver.resolveType(fullSuper);
                ClassFieldInspector inspector = new ClassFieldInspector(superKlass);
                for (String name : inspector.getGetterMethods().keySet()) {
                    if (!inspector.getSetterMethods().containsKey(name) || inspector.isNonGetter(name) || "class".equals(name)) continue;
                    inheritedFlDescr = new TypeFieldDescr(name, new PatternDescr(((Class)inspector.getFieldTypes().get(name)).getName()));
                    inheritedFlDescr.setInherited(!Modifier.isAbstract(((Method)inspector.getGetterMethods().get(name)).getModifiers()));
                    if (fieldMap.containsKey(inheritedFlDescr.getFieldName())) continue;
                    fieldMap.put(inheritedFlDescr.getFieldName(), inheritedFlDescr);
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Unable to resolve Type Declaration superclass '" + fullSuper + "'");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (String fieldName : typeDescr.getFields().keySet()) {
            if (fieldMap.containsKey(fieldName)) {
                String type1 = ((TypeFieldDescr)fieldMap.get(fieldName)).getPattern().getObjectType();
                String type2 = typeDescr.getFields().get(fieldName).getPattern().getObjectType();
                if (type2.lastIndexOf(".") < 0) {
                    try {
                        TypeResolver typeResolver = this.kbuilder.getPackageRegistry(typeDescr.getNamespace()).getTypeResolver();
                        type1 = typeResolver.resolveType(type1).getName();
                        type2 = typeResolver.resolveType(type2).getName();
                        ((TypeFieldDescr)fieldMap.get(fieldName)).getPattern().setObjectType(type1);
                        typeDescr.getFields().get(fieldName).getPattern().setObjectType(type2);
                    }
                    catch (ClassNotFoundException typeResolver) {
                        // empty catch block
                    }
                }
                if (!type1.equals(type2)) {
                    this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Cannot redeclare field '" + fieldName + " from " + type1 + " to " + type2));
                    typeDescr.setType(null, null);
                    return false;
                }
                String initVal = ((TypeFieldDescr)fieldMap.get(fieldName)).getInitExpr();
                if (typeDescr.getFields().get(fieldName).getInitExpr() == null) {
                    typeDescr.getFields().get(fieldName).setInitExpr(initVal);
                }
                typeDescr.getFields().get(fieldName).setInherited(((TypeFieldDescr)fieldMap.get(fieldName)).isInherited());
                for (String key : ((TypeFieldDescr)fieldMap.get(fieldName)).getAnnotationNames()) {
                    if (typeDescr.getFields().get(fieldName).getAnnotation(key) != null) continue;
                    typeDescr.getFields().get(fieldName).addAnnotation(((TypeFieldDescr)fieldMap.get(fieldName)).getAnnotation(key));
                }
                if (typeDescr.getFields().get(fieldName).getIndex() < 0) {
                    typeDescr.getFields().get(fieldName).setIndex(((TypeFieldDescr)fieldMap.get(fieldName)).getIndex());
                }
            }
            fieldMap.put(fieldName, typeDescr.getFields().get(fieldName));
        }
        typeDescr.setFields(fieldMap);
        return true;
    }

    protected TypeFieldDescr buildInheritedFieldDescrFromDefinition(FactField fld, TypeDeclarationDescr typeDescr) {
        PatternDescr fldType = new PatternDescr();
        TypeFieldDescr inheritedFldDescr = new TypeFieldDescr();
        inheritedFldDescr.setFieldName(fld.getName());
        fldType.setObjectType(((FieldDefinition)fld).getTypeName());
        inheritedFldDescr.setPattern(fldType);
        if (fld.isKey()) {
            AnnotationDescr keyAnnotation = new AnnotationDescr(Key.class.getCanonicalName());
            keyAnnotation.setFullyQualifiedName(Key.class.getCanonicalName());
            inheritedFldDescr.addAnnotation(keyAnnotation);
        }
        inheritedFldDescr.setIndex(((FieldDefinition)fld).getDeclIndex());
        inheritedFldDescr.setInherited(true);
        String initExprOverride = ((FieldDefinition)fld).getInitExpr();
        int overrideCount = 0;
        for (TypeFieldDescr localField : typeDescr.getFields().values()) {
            Alias alias = localField.getTypedAnnotation(Alias.class);
            if (alias == null || !fld.getName().equals(alias.value().replaceAll("\"", "")) || localField.getInitExpr() == null) continue;
            ++overrideCount;
            initExprOverride = localField.getInitExpr();
        }
        if (overrideCount > 1) {
            initExprOverride = null;
        }
        inheritedFldDescr.setInitExpr(initExprOverride);
        return inheritedFldDescr;
    }

    public void addDeclarationToPackagePreservingOrder(TypeDeclaration type, AbstractClassTypeDeclarationDescr typeDescr, InternalKnowledgePackage tgtPackage, Map<String, PackageRegistry> pkgRegistryMap) {
        Collection<QualifiedName> parents = this.taxonomy.get(new QualifiedName(type.getFullName()));
        int index = this.getSortedDescriptors().indexOf(typeDescr);
        if (parents != null && !parents.isEmpty()) {
            for (QualifiedName parentName : parents) {
                TypeDeclaration parentDeclaration;
                String nameSpace = parentName.getNamespace();
                String name = parentName.getName();
                PackageRegistry parentPkgRegistry = pkgRegistryMap.get(nameSpace);
                if (parentPkgRegistry == null || (parentDeclaration = parentPkgRegistry.getPackage().getTypeDeclaration(name)) == null || parentDeclaration.getNature() != TypeDeclaration.Nature.DEFINITION) continue;
                index = Math.max(index, parentDeclaration.getOrder());
            }
        }
        type.setOrder(index + 1);
        tgtPackage.addTypeDeclaration(type);
    }
}

