/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.util;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.util.MVELSafeHelper;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.builder.model.ListenerModel;
import org.kie.api.builder.model.QualifierModel;
import org.kie.api.builder.model.WorkItemHandlerModel;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItemHandler;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;

public class CDIHelper {
    public static void wireListnersAndWIHs(KieSessionModel model, KieSession kSession) {
        CDIHelper.wireListnersAndWIHs(BeanCreatorHolder.beanCreator, model, kSession);
    }

    public static void wireListnersAndWIHs(BeanManager beanManager, KieSessionModel model, KieSession kSession) {
        CDIHelper.wireListnersAndWIHs(new CDIBeanCreator(beanManager), model, kSession);
    }

    public static void wireListnersAndWIHs(KieSessionModel model, KieSession kSession, Map<String, Object> parameters) {
        CDIHelper.wireListnersAndWIHs(new MVELBeanCreator(parameters), model, kSession);
    }

    private static void wireListnersAndWIHs(BeanCreator beanCreator, KieSessionModel model, KieSession kSession) {
        ReflectionBeanCreator fallbackBeanCreator = new ReflectionBeanCreator();
        ClassLoader cl = ((InternalKnowledgeBase)kSession.getKieBase()).getRootClassLoader();
        for (ListenerModel listenerModel : model.getListenerModels()) {
            Object listener;
            try {
                listener = beanCreator.createBean(cl, listenerModel.getType(), listenerModel.getQualifierModel());
            }
            catch (Exception e) {
                try {
                    listener = fallbackBeanCreator.createBean(cl, listenerModel.getType(), listenerModel.getQualifierModel());
                }
                catch (Exception ex) {
                    throw new RuntimeException("Cannot instance listener " + listenerModel.getType(), e);
                }
            }
            switch (listenerModel.getKind()) {
                case AGENDA_EVENT_LISTENER: {
                    kSession.addEventListener((AgendaEventListener)listener);
                    break;
                }
                case RULE_RUNTIME_EVENT_LISTENER: {
                    kSession.addEventListener((RuleRuntimeEventListener)listener);
                    break;
                }
                case PROCESS_EVENT_LISTENER: {
                    kSession.addEventListener((ProcessEventListener)listener);
                }
            }
        }
        for (WorkItemHandlerModel wihModel : model.getWorkItemHandlerModels()) {
            WorkItemHandler wih;
            try {
                wih = (WorkItemHandler)beanCreator.createBean(cl, wihModel.getType(), wihModel.getQualifierModel());
            }
            catch (Exception e) {
                try {
                    wih = (WorkItemHandler)fallbackBeanCreator.createBean(cl, wihModel.getType(), wihModel.getQualifierModel());
                }
                catch (Exception ex) {
                    throw new RuntimeException("Cannot instance WorkItemHandler " + wihModel.getType(), e);
                }
            }
            kSession.getWorkItemManager().registerWorkItemHandler(wihModel.getName(), wih);
        }
    }

    private static class MVELBeanCreator
    implements BeanCreator {
        private Map<String, Object> parameters;

        private MVELBeanCreator(Map<String, Object> parameters) {
            this.parameters = parameters;
        }

        @Override
        public <T> T createBean(ClassLoader cl, String type, QualifierModel qualifier) throws Exception {
            if (qualifier != null) {
                throw new IllegalArgumentException("Cannot use a qualifier without a CDI container");
            }
            ParserConfiguration config = new ParserConfiguration();
            config.setClassLoader(cl);
            ParserContext ctx = new ParserContext(config);
            if (this.parameters != null) {
                for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
                    ctx.addVariable(entry.getKey(), entry.getValue().getClass());
                }
            }
            Serializable compiledExpression = MVEL.compileExpression((String)type, (ParserContext)ctx);
            return (T)MVELSafeHelper.getEvaluator().executeExpression((Object)compiledExpression, this.parameters);
        }
    }

    private static class ReflectionBeanCreator
    implements BeanCreator {
        private ReflectionBeanCreator() {
        }

        @Override
        public <T> T createBean(ClassLoader cl, String type, QualifierModel qualifier) throws Exception {
            if (qualifier != null) {
                throw new IllegalArgumentException("Cannot use a qualifier without a CDI container");
            }
            return (T)Class.forName(type, true, cl).newInstance();
        }
    }

    private static class CDIBeanCreator
    implements BeanCreator {
        private final BeanManager beanManager;

        private CDIBeanCreator(BeanManager beanManager) {
            this.beanManager = beanManager;
        }

        @Override
        public <T> T createBean(ClassLoader cl, String type, QualifierModel qualifier) throws Exception {
            Set beans;
            Class<?> beanType = Class.forName(type, true, cl);
            if (qualifier == null) {
                beans = this.beanManager.getBeans(beanType, new Annotation[0]);
            } else {
                Annotation annotation = this.getQualifier(qualifier);
                beans = this.beanManager.getBeans(beanType, new Annotation[]{annotation});
            }
            Bean bean = (Bean)beans.iterator().next();
            return (T)bean.create(this.beanManager.createCreationalContext((Contextual)bean));
        }

        private Annotation getQualifier(QualifierModel model) throws Exception {
            return null;
        }
    }

    private static interface BeanCreator {
        public <T> T createBean(ClassLoader var1, String var2, QualifierModel var3) throws Exception;
    }

    private static class BeanCreatorHolder {
        private static final BeanCreator beanCreator = BeanCreatorHolder.loadBeanCreator();

        private BeanCreatorHolder() {
        }

        private static BeanCreator loadBeanCreator() {
            BeanManager beanManager = BeanCreatorHolder.lookupBeanManager();
            return beanManager != null ? new CDIBeanCreator(beanManager) : new ReflectionBeanCreator();
        }

        private static BeanManager lookupBeanManager() {
            try {
                return (BeanManager)InitialContext.doLookup("java:comp/BeanManager");
            }
            catch (NamingException namingException) {
                try {
                    return (BeanManager)InitialContext.doLookup("java:comp/env/BeanManager");
                }
                catch (NamingException namingException2) {
                    return null;
                }
            }
        }
    }
}

