/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder.dialect.mvel;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.commons.jci.readers.MemoryResourceReader;
import org.drools.compiler.compiler.AnalysisResult;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.ImportError;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.lang.descr.AccumulateDescr;
import org.drools.compiler.lang.descr.AndDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.CollectDescr;
import org.drools.compiler.lang.descr.ConditionalBranchDescr;
import org.drools.compiler.lang.descr.EntryPointDescr;
import org.drools.compiler.lang.descr.EvalDescr;
import org.drools.compiler.lang.descr.ExistsDescr;
import org.drools.compiler.lang.descr.ForallDescr;
import org.drools.compiler.lang.descr.FromDescr;
import org.drools.compiler.lang.descr.FunctionDescr;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.compiler.lang.descr.NamedConsequenceDescr;
import org.drools.compiler.lang.descr.NotDescr;
import org.drools.compiler.lang.descr.OrDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.compiler.lang.descr.ProcessDescr;
import org.drools.compiler.lang.descr.QueryDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.compiler.lang.descr.WindowReferenceDescr;
import org.drools.compiler.rule.builder.AccumulateBuilder;
import org.drools.compiler.rule.builder.CollectBuilder;
import org.drools.compiler.rule.builder.ConditionalBranchBuilder;
import org.drools.compiler.rule.builder.ConsequenceBuilder;
import org.drools.compiler.rule.builder.EnabledBuilder;
import org.drools.compiler.rule.builder.EngineElementBuilder;
import org.drools.compiler.rule.builder.EntryPointBuilder;
import org.drools.compiler.rule.builder.ForallBuilder;
import org.drools.compiler.rule.builder.FromBuilder;
import org.drools.compiler.rule.builder.GroupElementBuilder;
import org.drools.compiler.rule.builder.NamedConsequenceBuilder;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.compiler.rule.builder.PatternBuilder;
import org.drools.compiler.rule.builder.PredicateBuilder;
import org.drools.compiler.rule.builder.QueryBuilder;
import org.drools.compiler.rule.builder.ReturnValueBuilder;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.RuleClassBuilder;
import org.drools.compiler.rule.builder.RuleConditionBuilder;
import org.drools.compiler.rule.builder.SalienceBuilder;
import org.drools.compiler.rule.builder.WindowReferenceBuilder;
import org.drools.compiler.rule.builder.dialect.DialectUtil;
import org.drools.compiler.rule.builder.dialect.java.JavaFunctionBuilder;
import org.drools.compiler.rule.builder.dialect.mvel.MVELAccumulateBuilder;
import org.drools.compiler.rule.builder.dialect.mvel.MVELAnalysisResult;
import org.drools.compiler.rule.builder.dialect.mvel.MVELConsequenceBuilder;
import org.drools.compiler.rule.builder.dialect.mvel.MVELDialectConfiguration;
import org.drools.compiler.rule.builder.dialect.mvel.MVELEnabledBuilder;
import org.drools.compiler.rule.builder.dialect.mvel.MVELEvalBuilder;
import org.drools.compiler.rule.builder.dialect.mvel.MVELExprAnalyzer;
import org.drools.compiler.rule.builder.dialect.mvel.MVELFromBuilder;
import org.drools.compiler.rule.builder.dialect.mvel.MVELPredicateBuilder;
import org.drools.compiler.rule.builder.dialect.mvel.MVELReturnValueBuilder;
import org.drools.compiler.rule.builder.dialect.mvel.MVELSalienceBuilder;
import org.drools.core.base.EvaluatorWrapper;
import org.drools.core.base.TypeResolver;
import org.drools.core.base.mvel.MVELCompilationUnit;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.DialectRuntimeData;
import org.drools.core.rule.LineMappings;
import org.drools.core.rule.MVELDialectRuntimeData;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.util.StringUtils;
import org.kie.api.definition.rule.Rule;
import org.kie.api.io.Resource;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.mvel2.MVEL;
import org.mvel2.optimizers.OptimizerFactory;

public class MVELDialect
implements Dialect,
Externalizable {
    private String id = "mvel";
    private static final String EXPRESSION_DIALECT_NAME = "MVEL";
    protected static final PatternBuilder PATTERN_BUILDER = new PatternBuilder();
    protected static final QueryBuilder QUERY_BUILDER = new QueryBuilder();
    protected static final MVELAccumulateBuilder ACCUMULATE_BUILDER = new MVELAccumulateBuilder();
    protected static final SalienceBuilder SALIENCE_BUILDER = new MVELSalienceBuilder();
    protected static final EnabledBuilder ENABLED_BUILDER = new MVELEnabledBuilder();
    protected static final MVELEvalBuilder EVAL_BUILDER = new MVELEvalBuilder();
    protected static final MVELPredicateBuilder PREDICATE_BUILDER = new MVELPredicateBuilder();
    protected static final MVELReturnValueBuilder RETURN_VALUE_BUILDER = new MVELReturnValueBuilder();
    protected static final MVELConsequenceBuilder CONSEQUENCE_BUILDER = new MVELConsequenceBuilder();
    protected static final MVELFromBuilder FROM_BUILDER = new MVELFromBuilder();
    protected static final JavaFunctionBuilder FUNCTION_BUILDER = new JavaFunctionBuilder();
    protected static final CollectBuilder COLLECT_BUILDER = new CollectBuilder();
    protected static final ForallBuilder FORALL_BUILDER = new ForallBuilder();
    protected static final EntryPointBuilder ENTRY_POINT_BUILDER = new EntryPointBuilder();
    protected static final WindowReferenceBuilder WINDOW_REFERENCE_BUILDER = new WindowReferenceBuilder();
    protected static final GroupElementBuilder GE_BUILDER = new GroupElementBuilder();
    protected static final NamedConsequenceBuilder NAMED_CONSEQUENCE_BUILDER = new NamedConsequenceBuilder();
    protected static final ConditionalBranchBuilder CONDITIONAL_BRANCH_BUILDER = new ConditionalBranchBuilder();
    private static Map<Class<?>, EngineElementBuilder> builders;
    private static final MVELExprAnalyzer analyzer;
    private final Map interceptors = MVELCompilationUnit.INTERCEPTORS;
    protected List<KnowledgeBuilderResult> results;
    protected MemoryResourceReader src;
    protected InternalKnowledgePackage pkg;
    private MVELDialectConfiguration configuration;
    private PackageRegistry packageRegistry;
    private boolean strictMode;
    private int languageLevel;
    private MVELDialectRuntimeData data;
    private final ClassLoader rootClassLoader;

    public MVELDialect(ClassLoader rootClassLoader, KnowledgeBuilderConfigurationImpl pkgConf, PackageRegistry pkgRegistry, InternalKnowledgePackage pkg) {
        this(rootClassLoader, pkgConf, pkgRegistry, pkg, "mvel");
    }

    public MVELDialect(ClassLoader rootClassLoader, KnowledgeBuilderConfigurationImpl pkgConf, PackageRegistry pkgRegistry, InternalKnowledgePackage pkg, String id) {
        this.rootClassLoader = rootClassLoader;
        this.id = id;
        this.pkg = pkg;
        this.packageRegistry = pkgRegistry;
        this.configuration = (MVELDialectConfiguration)pkgConf.getDialectConfiguration("mvel");
        this.setLanguageLevel(this.configuration.getLangLevel());
        this.strictMode = this.configuration.isStrict();
        MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
        this.results = new ArrayList<KnowledgeBuilderResult>();
        if (pkg.getDialectRuntimeRegistry().getDialectData(this.getId()) == null) {
            this.data = new MVELDialectRuntimeData();
            this.pkg.getDialectRuntimeRegistry().setDialectData(this.getId(), (DialectRuntimeData)this.data);
            this.data.onAdd(this.pkg.getDialectRuntimeRegistry(), rootClassLoader);
        } else {
            this.data = (MVELDialectRuntimeData)this.pkg.getDialectRuntimeRegistry().getDialectData("mvel");
        }
        this.results = new ArrayList<KnowledgeBuilderResult>();
        this.src = new MemoryResourceReader();
        if (this.pkg != null) {
            this.addImport(new ImportDescr(this.pkg.getName() + ".*"));
        }
        this.addImport(new ImportDescr("java.lang.*"));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.results = (List)in.readObject();
        this.src = (MemoryResourceReader)in.readObject();
        this.pkg = (InternalKnowledgePackage)in.readObject();
        this.packageRegistry = (PackageRegistry)in.readObject();
        this.configuration = (MVELDialectConfiguration)in.readObject();
        this.strictMode = in.readBoolean();
        this.data = (MVELDialectRuntimeData)this.pkg.getDialectRuntimeRegistry().getDialectData("mvel");
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.results);
        out.writeObject(this.src);
        out.writeObject(this.pkg);
        out.writeObject(this.packageRegistry);
        out.writeObject(this.configuration);
        out.writeBoolean(this.strictMode);
        out.writeObject(this.data);
    }

    public void setLanguageLevel(int languageLevel) {
        this.languageLevel = languageLevel;
    }

    public static void initBuilder() {
        if (builders != null) {
            return;
        }
        MVELDialect.reinitBuilder();
    }

    public static void reinitBuilder() {
        builders = new HashMap();
        builders.put(AndDescr.class, GE_BUILDER);
        builders.put(OrDescr.class, GE_BUILDER);
        builders.put(NotDescr.class, GE_BUILDER);
        builders.put(ExistsDescr.class, GE_BUILDER);
        builders.put(PatternDescr.class, PATTERN_BUILDER);
        builders.put(FromDescr.class, FROM_BUILDER);
        builders.put(QueryDescr.class, QUERY_BUILDER);
        builders.put(AccumulateDescr.class, ACCUMULATE_BUILDER);
        builders.put(EvalDescr.class, EVAL_BUILDER);
        builders.put(CollectDescr.class, COLLECT_BUILDER);
        builders.put(ForallDescr.class, FORALL_BUILDER);
        builders.put(FunctionDescr.class, FUNCTION_BUILDER);
        builders.put(EntryPointDescr.class, ENTRY_POINT_BUILDER);
        builders.put(WindowReferenceDescr.class, WINDOW_REFERENCE_BUILDER);
        builders.put(NamedConsequenceDescr.class, NAMED_CONSEQUENCE_BUILDER);
        builders.put(ConditionalBranchDescr.class, CONDITIONAL_BRANCH_BUILDER);
    }

    @Override
    public void init(RuleDescr ruleDescr) {
        String pkgName = this.pkg == null ? "" : this.pkg.getName();
        String ruleClassName = DialectUtil.getUniqueLegalName(pkgName, ruleDescr.getName(), ruleDescr.getConsequence().hashCode(), "mvel", "Rule", this.src);
        ruleDescr.setClassName(StringUtils.ucFirst((String)ruleClassName));
    }

    @Override
    public void init(ProcessDescr processDescr) {
        String processDescrClassName = DialectUtil.getUniqueLegalName(this.pkg.getName(), processDescr.getName(), processDescr.getProcessId().hashCode(), "mvel", "Process", this.src);
        processDescr.setClassName(StringUtils.ucFirst((String)processDescrClassName));
    }

    @Override
    public String getExpressionDialectName() {
        return EXPRESSION_DIALECT_NAME;
    }

    @Override
    public void addRule(RuleBuildContext context) {
        RuleDescr ruleDescr = context.getRuleDescr();
        String name = this.pkg.getName() + "." + StringUtils.ucFirst((String)ruleDescr.getClassName());
        LineMappings mapping = new LineMappings(name);
        mapping.setStartLine(ruleDescr.getConsequenceLine());
        mapping.setOffset(ruleDescr.getConsequenceOffset());
        context.getPkg().getDialectRuntimeRegistry().getLineMappings().put(name, mapping);
    }

    @Override
    public void addFunction(FunctionDescr functionDescr, TypeResolver typeResolver, Resource resource) {
    }

    @Override
    public void preCompileAddFunction(FunctionDescr functionDescr, TypeResolver typeResolver) {
    }

    @Override
    public void postCompileAddFunction(FunctionDescr functionDescr, TypeResolver typeResolver) {
    }

    @Override
    public void addImport(ImportDescr importDescr) {
        String importEntry = importDescr.getTarget();
        if (importEntry.endsWith(".*")) {
            importEntry = importEntry.substring(0, importEntry.length() - 2);
            this.data.addPackageImport(importEntry);
        } else {
            try {
                Class cls = this.packageRegistry.getTypeResolver().resolveType(importEntry);
                this.data.addImport(cls.getSimpleName(), cls);
            }
            catch (ClassNotFoundException e) {
                this.results.add(new ImportError(importDescr, 1));
            }
        }
    }

    @Override
    public void addStaticImport(ImportDescr importDescr) {
        String staticImportEntry = importDescr.getTarget();
        if (staticImportEntry.endsWith("*")) {
            this.addStaticPackageImport(importDescr);
            return;
        }
        int index = staticImportEntry.lastIndexOf(46);
        String className = staticImportEntry.substring(0, index);
        String methodName = staticImportEntry.substring(index + 1);
        try {
            Class<?> cls = this.packageRegistry.getPackageClassLoader().loadClass(className);
            if (cls != null) {
                for (Method method : cls.getDeclaredMethods()) {
                    if (!method.getName().equals(methodName)) continue;
                    this.data.addImport(methodName, method);
                    return;
                }
                for (AccessibleObject accessibleObject : cls.getFields()) {
                    if (!accessibleObject.isAccessible() || !((Field)accessibleObject).getName().equals(methodName)) continue;
                    this.data.addImport(methodName, (Field)accessibleObject);
                    return;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.results.add(new ImportError(importDescr, -1));
    }

    public void addStaticPackageImport(ImportDescr importDescr) {
        String staticImportEntry = importDescr.getTarget();
        int index = staticImportEntry.lastIndexOf(46);
        String className = staticImportEntry.substring(0, index);
        Class<?> cls = null;
        try {
            cls = this.rootClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (cls == null) {
            this.results.add(new ImportError(importDescr, -1));
            return;
        }
        for (Method method : cls.getDeclaredMethods()) {
            if ((method.getModifiers() | 8) <= 0) continue;
            this.data.addImport(method.getName(), method);
        }
        for (AccessibleObject accessibleObject : cls.getFields()) {
            if (!accessibleObject.isAccessible() || (((Field)accessibleObject).getModifiers() | 8) <= 0) continue;
            this.data.addImport(((Field)accessibleObject).getName(), (Field)accessibleObject);
            return;
        }
    }

    public boolean isStrictMode() {
        return this.strictMode;
    }

    public void setStrictMode(boolean strictMode) {
        this.strictMode = strictMode;
    }

    @Override
    public void compileAll() {
    }

    @Override
    public AnalysisResult analyzeExpression(PackageBuildContext context, BaseDescr descr, Object content, BoundIdentifiers availableIdentifiers) {
        return this.analyzeExpression(context, descr, content, availableIdentifiers, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnalysisResult analyzeExpression(PackageBuildContext context, BaseDescr descr, Object content, BoundIdentifiers availableIdentifiers, Map<String, Class<?>> localTypes) {
        MVELAnalysisResult result = null;
        BaseDescr temp = context.getParentDescr();
        context.setParentDescr(descr);
        try {
            result = analyzer.analyzeExpression(context, (String)content, availableIdentifiers, localTypes, "drools", KnowledgeHelper.class);
        }
        catch (Exception e) {
            DialectUtil.copyErrorLocation(e, descr);
            context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to determine the used declarations.\n" + e.getMessage()));
        }
        finally {
            context.setParentDescr(temp);
        }
        return result;
    }

    @Override
    public AnalysisResult analyzeBlock(PackageBuildContext context, BaseDescr descr, String text, BoundIdentifiers availableIdentifiers) {
        return this.analyzeBlock(context, descr, null, text, availableIdentifiers, null, "drools", KnowledgeHelper.class);
    }

    public AnalysisResult analyzeBlock(PackageBuildContext context, BaseDescr descr, Map interceptors, String text, BoundIdentifiers availableIdentifiers, Map<String, Class<?>> localTypes, String contextIndeifier, Class kcontextClass) {
        return analyzer.analyzeExpression(context, text, availableIdentifiers, localTypes, contextIndeifier, kcontextClass);
    }

    public MVELCompilationUnit getMVELCompilationUnit(String expression, AnalysisResult analysis, Declaration[] previousDeclarations, Declaration[] localDeclarations, Map<String, Class<?>> otherInputVariables, PackageBuildContext context, String contextIndeifier, Class kcontextClass) {
        return this.getMVELCompilationUnit(expression, analysis, previousDeclarations, localDeclarations, otherInputVariables, context, contextIndeifier, kcontextClass, false);
    }

    public MVELCompilationUnit getMVELCompilationUnit(String expression, AnalysisResult analysis, Declaration[] previousDeclarations, Declaration[] localDeclarations, Map<String, Class<?>> otherInputVariables, PackageBuildContext context, String contextIndeifier, Class kcontextClass, boolean readLocalsFromTuple) {
        LinkedHashMap resolvedInputs = new LinkedHashMap();
        ArrayList<String> ids = new ArrayList<String>();
        if (analysis.getBoundIdentifiers().getThisClass() != null || localDeclarations != null && localDeclarations.length > 0) {
            Class<?> cls = analysis.getBoundIdentifiers().getThisClass();
            ids.add("this");
            resolvedInputs.put("this", cls != null ? cls : Object.class);
        }
        ids.add(contextIndeifier);
        resolvedInputs.put(contextIndeifier, kcontextClass);
        ids.add("kcontext");
        resolvedInputs.put("kcontext", kcontextClass);
        ids.add("rule");
        resolvedInputs.put("rule", Rule.class);
        ArrayList<String> strList = new ArrayList<String>();
        for (Map.Entry<String, Class<?>> e : analysis.getBoundIdentifiers().getGlobals().entrySet()) {
            strList.add(e.getKey());
            ids.add(e.getKey());
            resolvedInputs.put(e.getKey(), e.getValue());
        }
        String[] globalIdentifiers = strList.toArray(new String[strList.size()]);
        strList.clear();
        for (String op : analysis.getBoundIdentifiers().getOperators().keySet()) {
            strList.add(op);
            ids.add(op);
            resolvedInputs.put(op, context.getConfiguration().getComponentFactory().getExpressionProcessor().getEvaluatorWrapperClass());
        }
        EvaluatorWrapper[] operators = new EvaluatorWrapper[strList.size()];
        for (int i = 0; i < operators.length; ++i) {
            operators[i] = analysis.getBoundIdentifiers().getOperators().get(strList.get(i));
        }
        if (previousDeclarations != null) {
            for (Declaration decl : previousDeclarations) {
                if (!analysis.getBoundIdentifiers().getDeclrClasses().containsKey(decl.getIdentifier())) continue;
                ids.add(decl.getIdentifier());
                resolvedInputs.put(decl.getIdentifier(), decl.getExtractor().getExtractToClass());
            }
        }
        if (localDeclarations != null) {
            for (Declaration decl : localDeclarations) {
                if (!analysis.getBoundIdentifiers().getDeclrClasses().containsKey(decl.getIdentifier())) continue;
                ids.add(decl.getIdentifier());
                resolvedInputs.put(decl.getIdentifier(), decl.getExtractor().getExtractToClass());
            }
        }
        strList = new ArrayList();
        if (otherInputVariables != null) {
            MVELAnalysisResult mvelAnalysis = (MVELAnalysisResult)analysis;
            for (Map.Entry<String, Class<?>> stringClassEntry : otherInputVariables.entrySet()) {
                if (!analysis.getNotBoundedIdentifiers().contains(stringClassEntry.getKey()) && !mvelAnalysis.getMvelVariables().keySet().contains(stringClassEntry.getKey()) || "rule".equals(stringClassEntry.getKey())) continue;
                ids.add(stringClassEntry.getKey());
                strList.add(stringClassEntry.getKey());
                resolvedInputs.put(stringClassEntry.getKey(), stringClassEntry.getValue());
            }
        }
        String[] otherIdentifiers = strList.toArray(new String[strList.size()]);
        String[] inputIdentifiers = new String[resolvedInputs.size()];
        String[] inputTypes = new String[resolvedInputs.size()];
        int i = 0;
        Iterator i$ = ids.iterator();
        while (i$.hasNext()) {
            String id;
            inputIdentifiers[i] = id = (String)i$.next();
            inputTypes[i++] = ((Class)resolvedInputs.get(id)).getName();
        }
        String name = context != null && context.getPkg() != null && context.getPkg().getName() != null ? (context instanceof RuleBuildContext ? context.getPkg().getName() + "." + ((RuleBuildContext)context).getRuleDescr().getClassName() : context.getPkg().getName() + ".Unknown") : "Unknown";
        return new MVELCompilationUnit(name, expression, globalIdentifiers, operators, previousDeclarations, localDeclarations, otherIdentifiers, inputIdentifiers, inputTypes, this.languageLevel, ((MVELAnalysisResult)analysis).isTypesafe(), readLocalsFromTuple);
    }

    @Override
    public EngineElementBuilder getBuilder(Class clazz) {
        return builders.get(clazz);
    }

    @Override
    public Map<Class<?>, EngineElementBuilder> getBuilders() {
        return builders;
    }

    @Override
    public PatternBuilder getPatternBuilder() {
        return PATTERN_BUILDER;
    }

    @Override
    public QueryBuilder getQueryBuilder() {
        return QUERY_BUILDER;
    }

    @Override
    public AccumulateBuilder getAccumulateBuilder() {
        return ACCUMULATE_BUILDER;
    }

    @Override
    public ConsequenceBuilder getConsequenceBuilder() {
        return CONSEQUENCE_BUILDER;
    }

    @Override
    public RuleConditionBuilder getEvalBuilder() {
        return EVAL_BUILDER;
    }

    @Override
    public FromBuilder getFromBuilder() {
        return FROM_BUILDER;
    }

    @Override
    public EntryPointBuilder getEntryPointBuilder() {
        return ENTRY_POINT_BUILDER;
    }

    @Override
    public PredicateBuilder getPredicateBuilder() {
        return PREDICATE_BUILDER;
    }

    public PredicateBuilder getExpressionPredicateBuilder() {
        return PREDICATE_BUILDER;
    }

    @Override
    public SalienceBuilder getSalienceBuilder() {
        return SALIENCE_BUILDER;
    }

    @Override
    public EnabledBuilder getEnabledBuilder() {
        return ENABLED_BUILDER;
    }

    @Override
    public List<KnowledgeBuilderResult> getResults() {
        return this.results;
    }

    @Override
    public void clearResults() {
        this.results.clear();
    }

    @Override
    public ReturnValueBuilder getReturnValueBuilder() {
        return RETURN_VALUE_BUILDER;
    }

    @Override
    public RuleClassBuilder getRuleClassBuilder() {
        throw new UnsupportedOperationException("MVELDialect.getRuleClassBuilder is not supported");
    }

    @Override
    public TypeResolver getTypeResolver() {
        return this.packageRegistry.getTypeResolver();
    }

    public Map getInterceptors() {
        return this.interceptors;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public PackageRegistry getPackageRegistry() {
        return this.packageRegistry;
    }

    static {
        MVELDialect.initBuilder();
        analyzer = new MVELExprAnalyzer();
        OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.SAFE_REFLECTIVE);
    }
}

