/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import org.mvel2.ParserContext;
import org.mvel2.PropertyAccessor;
import org.mvel2.ast.ASTNode;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.AccessorOptimizer;
import org.mvel2.optimizers.OptimizerFactory;

public class LiteralDeepPropertyNode
extends ASTNode {
    private Object literal;

    public LiteralDeepPropertyNode(char[] expr, int start, int offset, int fields, Object literal, ParserContext pCtx) {
        super(pCtx);
        this.fields = fields;
        this.expr = expr;
        this.start = start;
        this.offset = offset;
        this.literal = literal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.accessor != null) {
            return this.accessor.getValue(this.literal, thisValue, factory);
        }
        try {
            AccessorOptimizer aO = OptimizerFactory.getThreadAccessorOptimizer();
            this.accessor = aO.optimizeAccessor(this.pCtx, this.expr, this.start, this.offset, this.literal, thisValue, factory, false, null);
            Object object = aO.getResultOptPass();
            return object;
        }
        finally {
            OptimizerFactory.clearThreadAccessorOptimizer();
        }
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return PropertyAccessor.get(this.expr, this.start, this.offset, this.literal, factory, thisValue, this.pCtx);
    }
}

