/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.admin.base;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.switchyard.Exchange;
import org.switchyard.admin.Application;
import org.switchyard.admin.Binding;
import org.switchyard.admin.ComponentService;
import org.switchyard.admin.MessageMetrics;
import org.switchyard.admin.Service;
import org.switchyard.admin.Throttling;
import org.switchyard.admin.base.BaseApplication;
import org.switchyard.admin.base.BaseBinding;
import org.switchyard.admin.base.ServiceThrottling;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.CompositeServiceModel;

public class BaseService
implements Service {
    private QName _name;
    private String _serviceInterface;
    private BaseApplication _application;
    private ComponentService _promotedService;
    private Map<String, Binding> _gateways = new LinkedHashMap<String, Binding>();
    private Throttling _throttling;

    public BaseService(QName name, String serviceInterface, BaseApplication application, ComponentService implementation, Map<String, Binding> gateways) {
        this._name = name;
        this._serviceInterface = serviceInterface;
        this._application = application;
        this._promotedService = implementation;
        this._gateways = gateways;
        this._throttling = new ServiceThrottling(this, null);
    }

    public BaseService(CompositeServiceModel serviceConfig, BaseApplication application) {
        this._name = serviceConfig.getQName();
        this._application = application;
        if (serviceConfig.getInterface() != null) {
            this._serviceInterface = serviceConfig.getInterface().getInterface();
        }
        this._promotedService = this.getPromotedService(application, serviceConfig);
        this._gateways = new LinkedHashMap<String, Binding>();
        int idx = 0;
        for (BindingModel bindingModel : serviceConfig.getBindings()) {
            String name = bindingModel.getName() == null ? "_" + this._name.getLocalPart() + "_" + bindingModel.getType() + "_" + ++idx : bindingModel.getName();
            this._gateways.put(name, new BaseBinding(this._application, this._name, bindingModel.getType(), name, bindingModel.toString()));
        }
        this._throttling = new ServiceThrottling(this, serviceConfig.getExtensions());
    }

    @Override
    public Application getApplication() {
        return this._application;
    }

    @Override
    public List<Binding> getGateways() {
        return new ArrayList<Binding>(this._gateways.values());
    }

    @Override
    public Binding getGateway(String gatewayName) {
        if (this._gateways.containsKey(gatewayName)) {
            return this._gateways.get(gatewayName);
        }
        return null;
    }

    @Override
    public ComponentService getPromotedService() {
        return this._promotedService;
    }

    @Override
    public String getInterface() {
        return this._serviceInterface;
    }

    @Override
    public QName getName() {
        return this._name;
    }

    @Override
    public Throttling getThrottling() {
        return this._throttling;
    }

    private ComponentService getPromotedService(Application application, CompositeServiceModel compositeService) {
        ComponentServiceModel componentServiceModel = compositeService.getComponentService();
        if (componentServiceModel == null) {
            return null;
        }
        return application.getComponentService(componentServiceModel.getQName());
    }

    @Override
    public MessageMetrics getMessageMetrics() {
        return this._promotedService.getMessageMetrics();
    }

    @Override
    public void resetMessageMetrics() {
        for (Binding binding : this._gateways.values()) {
            binding.resetMessageMetrics();
        }
        this._promotedService.resetMessageMetrics();
    }

    @Override
    public void recordMetrics(Exchange exchange) {
        String gatewayName = (String)exchange.getContext().getPropertyValue("org.switchyard.exchangeGatewayName");
        if (gatewayName != null && this._gateways.containsKey(gatewayName)) {
            this._gateways.get(gatewayName).recordMetrics(exchange);
        }
        this._promotedService.recordMetrics(exchange);
    }
}

