/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.type;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import org.switchyard.common.type.CompoundClassLoader;

public final class Classes {
    private Classes() {
    }

    public static Class<?> forName(String name) {
        return Classes.forName(name, new ClassLoader[]{null});
    }

    public static Class<?> forName(String name, Class<?> caller) {
        return Classes.forName(name, caller != null ? caller.getClassLoader() : null);
    }

    public static Class<?> forName(String name, ClassLoader ... loaders) {
        Class<?> c = null;
        for (ClassLoader cl : Classes.getClassLoaders(loaders)) {
            try {
                c = Class.forName(name, true, cl);
                break;
            }
            catch (Throwable t) {
                t.getMessage();
            }
        }
        return c;
    }

    public static URL getResource(String path) throws IOException {
        return Classes.getResource(path, new ClassLoader[]{null});
    }

    public static URL getResource(String path, Class<?> caller) throws IOException {
        String callerPath;
        ClassLoader loader = caller != null ? caller.getClassLoader() : null;
        URL url = Classes.getResource(path, loader);
        if (url == null && (callerPath = Classes.callerPath(path, caller)) != null) {
            url = Classes.getResource(callerPath, loader);
        }
        return url;
    }

    public static URL getResource(String path, ClassLoader ... loaders) throws IOException {
        List<URL> urls = Classes.getResources(path, loaders);
        return urls.size() > 0 ? urls.get(0) : null;
    }

    public static List<URL> getResources(String path) throws IOException {
        return Classes.getResources(path, new ClassLoader[]{null});
    }

    public static List<URL> getResources(String path, Class<?> caller) throws IOException {
        ClassLoader loader = caller != null ? caller.getClassLoader() : null;
        List<URL> urls = Classes.getResources(path, loader);
        String callerPath = Classes.callerPath(path, caller);
        if (callerPath != null) {
            urls.addAll(Classes.getResources(callerPath, loader));
        }
        return urls;
    }

    public static List<URL> getResources(String path, ClassLoader ... loaders) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (path != null) {
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            for (ClassLoader cl : Classes.getClassLoaders(loaders)) {
                Enumeration<URL> e = cl.getResources(path);
                while (e.hasMoreElements()) {
                    URL url = e.nextElement();
                    if (urls.contains(url)) continue;
                    urls.add(url);
                }
            }
        }
        return urls;
    }

    public static InputStream getResourceAsStream(String path) throws IOException {
        return Classes.getResourceAsStream(path, new ClassLoader[]{null});
    }

    public static InputStream getResourceAsStream(String path, Class<?> caller) throws IOException {
        String callerPath;
        ClassLoader loader = caller != null ? caller.getClassLoader() : null;
        InputStream in = Classes.getResourceAsStream(path, loader);
        if (in == null && (callerPath = Classes.callerPath(path, caller)) != null) {
            in = Classes.getResourceAsStream(callerPath, loader);
        }
        return in;
    }

    public static InputStream getResourceAsStream(String path, ClassLoader ... loaders) throws IOException {
        URL url = Classes.getResource(path, loaders);
        return url != null ? url.openStream() : null;
    }

    public static ClassLoader getClassLoader() {
        return new CompoundClassLoader(Classes.getClassLoaders());
    }

    public static ClassLoader getClassLoader(Class<?> caller) {
        return new CompoundClassLoader(Classes.getClassLoaders(caller));
    }

    public static ClassLoader getClassLoader(ClassLoader ... loaders) {
        return new CompoundClassLoader(Classes.getClassLoaders(loaders));
    }

    public static List<ClassLoader> getClassLoaders() {
        return Classes.getClassLoaders(new ClassLoader[]{null});
    }

    public static List<ClassLoader> getClassLoaders(Class<?> caller) {
        return Classes.getClassLoaders(caller != null ? caller.getClassLoader() : null);
    }

    public static List<ClassLoader> getClassLoaders(ClassLoader ... loaders) {
        LinkedHashSet<ClassLoader> set = new LinkedHashSet<ClassLoader>();
        ClassLoader cl = Classes.getTCCL();
        if (cl != null) {
            set.add(cl);
        }
        if (loaders != null) {
            for (ClassLoader loader : loaders) {
                if (loader == null) continue;
                set.add(loader);
            }
        }
        if ((cl = Classes.class.getClassLoader()) != null) {
            set.add(cl);
        }
        if ((cl = ClassLoader.getSystemClassLoader()) != null) {
            set.add(cl);
        }
        if ((cl = Class.class.getClassLoader()) != null) {
            set.add(cl);
        }
        return new ArrayList<ClassLoader>(set);
    }

    public static ClassLoader getTCCL() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader setTCCL(ClassLoader replacement) {
        Thread thread = Thread.currentThread();
        ClassLoader previous = thread.getContextClassLoader();
        thread.setContextClassLoader(replacement);
        return previous;
    }

    private static String callerPath(String path, Class<?> caller) {
        String pkg;
        String callerPath = null;
        if (path != null && caller != null && !path.contains(pkg = caller.getPackage().getName().replace('.', '/'))) {
            callerPath = pkg + "/" + path;
        }
        return callerPath;
    }
}

