/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.metadata.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Named;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.metadata.cache.AnnotationModel;
import org.jboss.weld.metadata.cache.InterceptorBindingModel;
import org.jboss.weld.metadata.cache.QualifierModel;
import org.jboss.weld.metadata.cache.ScopeModel;
import org.jboss.weld.metadata.cache.StereotypeModel;
import org.jboss.weld.resolution.QualifierInstance;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.util.cache.LoadingCacheUtils;

public class MetaAnnotationStore
implements Service {
    private final LoadingCache<Class<Annotation>, StereotypeModel<Annotation>> stereotypes;
    private final LoadingCache<Class<Annotation>, ScopeModel<Annotation>> scopes;
    private final LoadingCache<Class<Annotation>, QualifierModel<Annotation>> qualifiers;
    private final LoadingCache<Class<Annotation>, InterceptorBindingModel<Annotation>> interceptorBindings;
    private final LoadingCache<Annotation, QualifierInstance> qualifierInstanceCache;
    private final SharedObjectCache sharedObjectCache;

    public MetaAnnotationStore(ClassTransformer classTransformer) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        this.stereotypes = cacheBuilder.build((CacheLoader)new StereotypeFunction(classTransformer));
        this.scopes = cacheBuilder.build((CacheLoader)new ScopeFunction(classTransformer));
        this.qualifiers = cacheBuilder.build((CacheLoader)new QualifierFunction(classTransformer));
        this.interceptorBindings = cacheBuilder.build((CacheLoader)new InterceptorBindingFunction(classTransformer));
        this.qualifierInstanceCache = cacheBuilder.build((CacheLoader)new QualifierInstanceFunction(this));
        this.sharedObjectCache = classTransformer.getSharedObjectCache();
    }

    public void clearAnnotationData(Class<? extends Annotation> annotationClass) {
        this.stereotypes.invalidate(annotationClass);
        this.scopes.invalidate(annotationClass);
        this.qualifiers.invalidate(annotationClass);
        this.interceptorBindings.invalidate(annotationClass);
    }

    public <T extends Annotation> StereotypeModel<T> getStereotype(Class<T> stereotype) {
        return (StereotypeModel)LoadingCacheUtils.getCastCacheValue(this.stereotypes, stereotype);
    }

    public <T extends Annotation> ScopeModel<T> getScopeModel(Class<T> scope) {
        return (ScopeModel)LoadingCacheUtils.getCastCacheValue(this.scopes, scope);
    }

    public <T extends Annotation> QualifierModel<T> getBindingTypeModel(Class<T> bindingType) {
        return (QualifierModel)LoadingCacheUtils.getCastCacheValue(this.qualifiers, bindingType);
    }

    public <T extends Annotation> InterceptorBindingModel<T> getInterceptorBindingModel(Class<T> interceptorBinding) {
        return (InterceptorBindingModel)LoadingCacheUtils.getCastCacheValue(this.interceptorBindings, interceptorBinding);
    }

    public QualifierInstance getQualifierInstance(Annotation annotation) {
        return MetaAnnotationStore.isCacheAllowed(annotation) ? LoadingCacheUtils.getCacheValue(this.qualifierInstanceCache, annotation) : QualifierInstance.of(annotation, this);
    }

    public Set<QualifierInstance> getQualifierInstances(Bean<?> bean) {
        if (bean instanceof RIBean) {
            return ((RIBean)bean).getQualifierInstances();
        }
        return this.getQualifierInstances(bean.getQualifiers());
    }

    public Set<QualifierInstance> getQualifierInstances(Set<Annotation> annotations) {
        if (annotations == null || annotations.isEmpty()) {
            return Collections.emptySet();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        boolean useSharedCache = true;
        for (Annotation annotation : annotations) {
            if (MetaAnnotationStore.isCacheAllowed(annotation)) {
                builder.add((Object)LoadingCacheUtils.getCacheValue(this.qualifierInstanceCache, annotation));
                continue;
            }
            builder.add((Object)QualifierInstance.of(annotation, this));
            useSharedCache = false;
        }
        return useSharedCache ? this.sharedObjectCache.getSharedSet(builder.build()) : builder.build();
    }

    public String toString() {
        String newLine = "\n";
        StringBuilder buffer = new StringBuilder();
        buffer.append("Metadata cache").append("\n");
        buffer.append("Registered binding type models: ").append(this.qualifiers.size()).append("\n");
        buffer.append("Registered scope type models: ").append(this.scopes.size()).append("\n");
        buffer.append("Registered stereotype models: ").append(this.stereotypes.size()).append("\n");
        buffer.append("Registered interceptor binding models: ").append(this.interceptorBindings.size()).append("\n");
        buffer.append("Cached qualifier instances: ").append(this.qualifierInstanceCache.size()).append("\n");
        return buffer.toString();
    }

    @Override
    public void cleanup() {
        this.qualifiers.invalidateAll();
        this.scopes.invalidateAll();
        this.stereotypes.invalidateAll();
        this.interceptorBindings.invalidateAll();
        this.qualifierInstanceCache.invalidateAll();
    }

    private static boolean isCacheAllowed(Annotation annotation) {
        if (annotation.annotationType().equals(Named.class)) {
            Named named = (Named)annotation;
            return named.value().equals("");
        }
        return true;
    }

    private static class QualifierInstanceFunction
    extends CacheLoader<Annotation, QualifierInstance> {
        private final MetaAnnotationStore metaAnnotationStore;

        private QualifierInstanceFunction(MetaAnnotationStore metaAnnotationStore) {
            this.metaAnnotationStore = metaAnnotationStore;
        }

        public QualifierInstance load(Annotation key) throws Exception {
            return QualifierInstance.of(key, this.metaAnnotationStore);
        }
    }

    private static class InterceptorBindingFunction
    extends AbstractMetaAnnotationFunction<InterceptorBindingModel<Annotation>> {
        public InterceptorBindingFunction(ClassTransformer classTransformer) {
            super(classTransformer);
        }

        public InterceptorBindingModel<Annotation> load(Class<Annotation> from) {
            return new InterceptorBindingModel<Annotation>(this.getClassTransformer().getEnhancedAnnotation(from));
        }
    }

    private static class QualifierFunction
    extends AbstractMetaAnnotationFunction<QualifierModel<Annotation>> {
        public QualifierFunction(ClassTransformer classTransformer) {
            super(classTransformer);
        }

        public QualifierModel<Annotation> load(Class<Annotation> from) {
            return new QualifierModel<Annotation>(this.getClassTransformer().getEnhancedAnnotation(from));
        }
    }

    private static class ScopeFunction
    extends AbstractMetaAnnotationFunction<ScopeModel<Annotation>> {
        public ScopeFunction(ClassTransformer classTransformer) {
            super(classTransformer);
        }

        public ScopeModel<Annotation> load(Class<Annotation> from) {
            return new ScopeModel<Annotation>(this.getClassTransformer().getEnhancedAnnotation(from));
        }
    }

    private static class StereotypeFunction
    extends AbstractMetaAnnotationFunction<StereotypeModel<Annotation>> {
        public StereotypeFunction(ClassTransformer classTransformer) {
            super(classTransformer);
        }

        public StereotypeModel<Annotation> load(Class<Annotation> from) {
            return new StereotypeModel<Annotation>(this.getClassTransformer().getEnhancedAnnotation(from));
        }
    }

    private static abstract class AbstractMetaAnnotationFunction<M extends AnnotationModel<Annotation>>
    extends CacheLoader<Class<Annotation>, M> {
        private final ClassTransformer classTransformer;

        private AbstractMetaAnnotationFunction(ClassTransformer classTransformer) {
            this.classTransformer = classTransformer;
        }

        public ClassTransformer getClassTransformer() {
            return this.classTransformer;
        }
    }
}

