/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security;

import java.io.IOException;
import java.io.Serializable;
import java.security.cert.CertificateException;
import java.util.Arrays;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.auth.login.LoginException;
import org.switchyard.security.BaseSecurityMessages;

public class BaseSecurityMessages_$bundle
implements Serializable,
BaseSecurityMessages {
    private static final long serialVersionUID = 1L;
    public static final BaseSecurityMessages_$bundle INSTANCE = new BaseSecurityMessages_$bundle();
    private static final String unableToExtractCredentials = "SWITCHYARD014404: Unable to extract Credentials from SSLSession: %s";
    private static final String credentialsNotSet = "SWITCHYARD014403: Credentials are not set.";
    private static final String optionsNotSet = "SWITCHYARD014414: Options not set";
    private static final String propertyNotSet = "SWITCHYARD014402: Property [%s] is not set.";
    private static final String callbackHandlerNoSupport = "SWITCHYARD014410: CallbackHandler does not support: %s";
    private static final String userNameCannotBeNull = "SWITCHYARD014418: User name cannot be null";
    private static final String optionNotSet = "SWITCHYARD014415: Option [%s] not set";
    private static final String propertiesNotSet = "SWITCHYARD014401: Properties are not set";
    private static final String valueTypeNotImplemented = "SWITCHYARD014406: %s not implemented";
    private static final String couldNotCreateCert = "SWITCHYARD014407: Could not create certificate(s): %s";
    private static final String problemAccessingKeystore = "SWITCHYARD014411: Problem accessing KeyStore: %s";
    private static final String failedInvokeCallback = "SWITCHYARD014408: Failed to invoke callback: %s";
    private static final String noCallerCertificateProvided = "SWITCHYARD014413: No caller X509 Certificate provided";
    private static final String groupNameCannotBeNull = "SWITCHYARD014416: Group name cannot be null";
    private static final String problemVerifyingCallerCert = "SWITCHYARD014412: Problem verifying caller Certificate: %s";
    private static final String roleCannotBeNull = "SWITCHYARD014417: Role name cannot be null";
    private static final String valueTypeRecognizedNotImplemented = "SWITCHYARD014405: %s not implemented (although recognized)";

    protected BaseSecurityMessages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    @Override
    public final RuntimeException unableToExtractCredentials(String message, SSLPeerUnverifiedException pe) {
        RuntimeException result = new RuntimeException(String.format(this.unableToExtractCredentials$str(), message), pe);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToExtractCredentials$str() {
        return unableToExtractCredentials;
    }

    @Override
    public final IllegalStateException credentialsNotSet() {
        IllegalStateException result = new IllegalStateException(String.format(this.credentialsNotSet$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialsNotSet$str() {
        return credentialsNotSet;
    }

    @Override
    public final IllegalStateException optionsNotSet() {
        IllegalStateException result = new IllegalStateException(String.format(this.optionsNotSet$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String optionsNotSet$str() {
        return optionsNotSet;
    }

    @Override
    public final IllegalStateException propertyNotSet(String key) {
        IllegalStateException result = new IllegalStateException(String.format(this.propertyNotSet$str(), key));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String propertyNotSet$str() {
        return propertyNotSet;
    }

    @Override
    public final LoginException callbackHandlerNoSupport(String handler) {
        LoginException result = new LoginException(String.format(this.callbackHandlerNoSupport$str(), handler));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String callbackHandlerNoSupport$str() {
        return callbackHandlerNoSupport;
    }

    @Override
    public final IllegalArgumentException userNameCannotBeNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.userNameCannotBeNull$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String userNameCannotBeNull$str() {
        return userNameCannotBeNull;
    }

    @Override
    public final IllegalStateException optionNotSet(String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.optionNotSet$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String optionNotSet$str() {
        return optionNotSet;
    }

    @Override
    public final IllegalStateException propertiesNotSet() {
        IllegalStateException result = new IllegalStateException(String.format(this.propertiesNotSet$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String propertiesNotSet$str() {
        return propertiesNotSet;
    }

    @Override
    public final IllegalArgumentException valueTypeNotImplemented(String valueType) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.valueTypeNotImplemented$str(), valueType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String valueTypeNotImplemented$str() {
        return valueTypeNotImplemented;
    }

    @Override
    public final RuntimeException couldNotCreateCert(String message, CertificateException ce) {
        RuntimeException result = new RuntimeException(String.format(this.couldNotCreateCert$str(), message), ce);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotCreateCert$str() {
        return couldNotCreateCert;
    }

    @Override
    public final LoginException problemAccessingKeystore(String message) {
        LoginException result = new LoginException(String.format(this.problemAccessingKeystore$str(), message));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String problemAccessingKeystore$str() {
        return problemAccessingKeystore;
    }

    @Override
    public final LoginException failedInvokeCallback(String message, IOException ioe) {
        LoginException result = new LoginException(String.format(this.failedInvokeCallback$str(), message));
        result.initCause(ioe);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedInvokeCallback$str() {
        return failedInvokeCallback;
    }

    @Override
    public final LoginException noCallerCertificateProvided() {
        LoginException result = new LoginException(String.format(this.noCallerCertificateProvided$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noCallerCertificateProvided$str() {
        return noCallerCertificateProvided;
    }

    @Override
    public final IllegalArgumentException groupNameCannotBeNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.groupNameCannotBeNull$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String groupNameCannotBeNull$str() {
        return groupNameCannotBeNull;
    }

    @Override
    public final LoginException problemVerifyingCallerCert(String message) {
        LoginException result = new LoginException(String.format(this.problemVerifyingCallerCert$str(), message));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String problemVerifyingCallerCert$str() {
        return problemVerifyingCallerCert;
    }

    @Override
    public final IllegalArgumentException roleCannotBeNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.roleCannotBeNull$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String roleCannotBeNull$str() {
        return roleCannotBeNull;
    }

    @Override
    public final IllegalArgumentException valueTypeRecognizedNotImplemented(String valueType) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.valueTypeRecognizedNotImplemented$str(), valueType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String valueTypeRecognizedNotImplemented$str() {
        return valueTypeRecognizedNotImplemented;
    }
}

