/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.wire;

import com.google.inject.Binder;
import com.google.inject.ImplementedBy;
import com.google.inject.Key;
import com.google.inject.ProvidedBy;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import com.google.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Qualifier;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.inject.HiddenBinding;
import org.eclipse.sisu.inject.Legacy;
import org.eclipse.sisu.inject.TypeArguments;
import org.eclipse.sisu.wire.BeanEntryProvider;
import org.eclipse.sisu.wire.BeanListProvider;
import org.eclipse.sisu.wire.BeanMapProvider;
import org.eclipse.sisu.wire.BeanProvider;
import org.eclipse.sisu.wire.BeanSetProvider;
import org.eclipse.sisu.wire.NamedBeanMapProvider;
import org.eclipse.sisu.wire.PlaceholderBeanProvider;
import org.eclipse.sisu.wire.Wiring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocatorWiring
implements Wiring {
    private static final HiddenBinding HIDDEN_SOURCE = new HiddenBinding(){

        public String toString() {
            return LocatorWiring.class.getName();
        }
    };
    private final Binder binder;

    public LocatorWiring(Binder binder) {
        this.binder = binder.withSource(HIDDEN_SOURCE);
    }

    @Override
    public boolean wire(Key<?> key) {
        Class<?> clazz = key.getTypeLiteral().getRawType();
        if (Map.class == clazz) {
            this.bindMapImport(key);
        } else if (List.class == clazz || Collection.class == clazz || Iterable.class == clazz) {
            this.bindListImport(key);
        } else if (Set.class == clazz) {
            this.bindSetImport(key);
        } else {
            this.bindBeanImport(key);
        }
        return true;
    }

    private void bindMapImport(Key<?> key) {
        TypeLiteral<?>[] args = TypeArguments.get(key.getTypeLiteral());
        if (2 == args.length && key.getAnnotation() == null) {
            Class<?> qualifierType = args[0].getRawType();
            if (String.class == qualifierType) {
                this.binder.bind(key).toProvider(new NamedBeanMapProvider(args[1]));
            } else if (qualifierType.isAnnotationPresent(Qualifier.class)) {
                this.binder.bind(key).toProvider(new BeanMapProvider(Key.get(args[1], qualifierType)));
            }
        }
    }

    private void bindListImport(Key<?> key) {
        TypeLiteral<?>[] args = TypeArguments.get(key.getTypeLiteral());
        if (1 == args.length && key.getAnnotation() == null) {
            TypeLiteral<?> elementType = args[0];
            if (BeanEntry.class == elementType.getRawType() || org.sonatype.inject.BeanEntry.class == elementType.getRawType()) {
                Provider beanEntriesProvider = LocatorWiring.getBeanEntriesProvider(elementType);
                if (beanEntriesProvider != null) {
                    this.binder.bind(key).toProvider(beanEntriesProvider);
                }
            } else {
                this.binder.bind(key).toProvider(new BeanListProvider(Key.get(elementType)));
            }
        }
    }

    private static Provider getBeanEntriesProvider(TypeLiteral<?> entryType) {
        Class<?> qualifierType;
        TypeLiteral<?>[] args = TypeArguments.get(entryType);
        if (2 == args.length && (qualifierType = args[0].getRawType()).isAnnotationPresent(Qualifier.class)) {
            Key<?> beanKey = Key.get(args[1], qualifierType);
            if (BeanEntry.class == entryType.getRawType()) {
                return new BeanEntryProvider(beanKey);
            }
            return Legacy.beanEntriesProvider(beanKey);
        }
        return null;
    }

    private void bindSetImport(Key<?> key) {
        TypeLiteral<?>[] args = TypeArguments.get(key.getTypeLiteral());
        if (1 == args.length && key.getAnnotation() == null) {
            this.binder.bind(key).toProvider(new BeanSetProvider(Key.get(args[0])));
        }
    }

    private <T> void bindBeanImport(Key<T> key) {
        Annotation qualifier = key.getAnnotation();
        if (qualifier instanceof Named) {
            if (((Named)qualifier).value().length() == 0) {
                this.binder.bind(key).toProvider(new BeanProvider<T>(Key.get(key.getTypeLiteral(), Named.class)));
            } else {
                this.binder.bind(key).toProvider(new PlaceholderBeanProvider<T>(key));
            }
        } else {
            this.binder.bind(key).toProvider(new BeanProvider<T>(key));
            if (key.getAnnotationType() == null) {
                this.bindImplicitType(key.getTypeLiteral());
            }
        }
    }

    private void bindImplicitType(TypeLiteral type) {
        try {
            Class clazz = type.getRawType();
            if (TypeArguments.isConcrete(clazz)) {
                Member ctor = InjectionPoint.forConstructorOf(type).getMember();
                this.binder.bind(TypeArguments.implicitKey(clazz)).toConstructor((Constructor)ctor);
            } else {
                ImplementedBy implementedBy = clazz.getAnnotation(ImplementedBy.class);
                if (implementedBy != null) {
                    this.binder.bind(TypeArguments.implicitKey(clazz)).to(implementedBy.value());
                } else {
                    ProvidedBy providedBy = clazz.getAnnotation(ProvidedBy.class);
                    if (providedBy != null) {
                        this.binder.bind(TypeArguments.implicitKey(clazz)).toProvider(providedBy.value());
                    }
                }
            }
        }
        catch (RuntimeException runtimeException) {
        }
        catch (LinkageError linkageError) {}
    }
}

