/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.commands;

import java.io.PrintStream;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.camel.commands.AbstractContextCommand;
import org.apache.camel.commands.CamelController;
import org.apache.camel.util.JsonSchemaHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

public class EndpointListCommand
extends AbstractContextCommand {
    private static final String URI_COLUMN_LABEL = "Uri";
    private static final String STATUS_COLUMN_LABEL = "Status";
    private static final int DEFAULT_COLUMN_WIDTH_INCREMENT = 0;
    private static final String DEFAULT_FIELD_PREAMBLE = " ";
    private static final String DEFAULT_FIELD_POSTAMBLE = " ";
    private static final String DEFAULT_HEADER_PREAMBLE = " ";
    private static final String DEFAULT_HEADER_POSTAMBLE = " ";
    private static final int DEFAULT_FORMAT_BUFFER_LENGTH = 24;
    private static final int MAX_COLUMN_WIDTH = 120;
    private static final int MIN_COLUMN_WIDTH = 12;
    boolean decode = true;
    boolean verbose;
    boolean explain;

    public EndpointListCommand(String context, boolean decode, boolean verbose, boolean explain) {
        super(context);
        this.decode = decode;
        this.verbose = verbose;
        this.explain = explain;
    }

    @Override
    protected Object performContextCommand(CamelController camelController, String contextName, PrintStream out, PrintStream err) throws Exception {
        List<Map<String, String>> endpoints = camelController.getEndpoints(contextName);
        Map<String, Integer> columnWidths = this.computeColumnWidths(endpoints);
        String headerFormat = this.buildFormatString(columnWidths, true);
        String rowFormat = this.buildFormatString(columnWidths, false);
        if (endpoints.size() > 0) {
            out.println(String.format(headerFormat, URI_COLUMN_LABEL, STATUS_COLUMN_LABEL));
            out.println(String.format(headerFormat, "---", "------"));
            for (Map<String, String> row : endpoints) {
                String uri = row.get("uri");
                if (this.decode) {
                    uri = URLDecoder.decode(uri, "UTF-8");
                }
                uri = URISupport.sanitizeUri((String)uri);
                String state = row.get("state");
                out.println(String.format(rowFormat, uri, state));
                if (!this.explain) continue;
                boolean first = true;
                String json = camelController.explainEndpointAsJSon(this.context, row.get("uri"), this.verbose);
                List options = JsonSchemaHelper.parseJsonSchema((String)"properties", (String)json, (boolean)true);
                Collections.sort(options, new Comparator<Map<String, String>>(){

                    @Override
                    public int compare(Map<String, String> o1, Map<String, String> o2) {
                        int answer = -1 * o1.get("kind").compareTo(o2.get("kind"));
                        if (answer == 0) {
                            answer = o1.get("name").compareTo(o2.get("name"));
                        }
                        return answer;
                    }
                });
                for (Map option : options) {
                    String key = (String)option.get("name");
                    String kind = (String)option.get("kind");
                    String type = (String)option.get("type");
                    String javaType = (String)option.get("javaType");
                    String value = (String)option.get("value");
                    if (ObjectHelper.isEmpty((Object)value)) {
                        value = (String)option.get("defaultValue");
                    }
                    String desc = (String)option.get("description");
                    if (key == null || value == null) continue;
                    if (first) {
                        out.println();
                        first = false;
                    }
                    String line = "path".equals(kind) ? "\t" + key + " (endpoint path) = " + value : "\t" + key + " = " + value;
                    out.println(line);
                    if (type != null) {
                        String displayType = type;
                        if (javaType != null && !displayType.equals(javaType)) {
                            displayType = type + " (" + javaType + ")";
                        }
                        out.println("\t" + displayType);
                    }
                    if (desc != null) {
                        out.println("\t" + desc);
                    }
                    out.println();
                }
            }
        }
        return null;
    }

    private Map<String, Integer> computeColumnWidths(Iterable<Map<String, String>> endpoints) throws Exception {
        if (endpoints == null) {
            throw new IllegalArgumentException("Unable to determine column widths from null Iterable<Endpoint>");
        }
        int maxUriLen = 0;
        int maxStatusLen = 0;
        for (Map<String, String> row : endpoints) {
            String name = row.get("camelContextName");
            String uri = row.get("uri");
            if (this.decode) {
                uri = URLDecoder.decode(uri, "UTF-8");
            }
            maxUriLen = Math.max(maxUriLen, (uri = URISupport.sanitizeUri((String)uri)) == null ? 0 : uri.length());
            String status = row.get("state");
            maxStatusLen = Math.max(maxStatusLen, status == null ? 0 : status.length());
        }
        Hashtable<String, Integer> retval = new Hashtable<String, Integer>();
        retval.put(URI_COLUMN_LABEL, maxUriLen);
        retval.put(STATUS_COLUMN_LABEL, maxStatusLen);
        return retval;
    }

    private String buildFormatString(Map<String, Integer> columnWidths, boolean isHeader) {
        String fieldPostamble;
        String fieldPreamble;
        if (isHeader) {
            fieldPreamble = " ";
            fieldPostamble = " ";
        } else {
            fieldPreamble = " ";
            fieldPostamble = " ";
        }
        int columnWidthIncrement = 0;
        int uriLen = Math.min(columnWidths.get(URI_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
        uriLen = Math.max(12, uriLen);
        StringBuilder retval = new StringBuilder(24);
        retval.append(fieldPreamble).append("%-").append(uriLen).append('.').append(uriLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%s").append(fieldPostamble).append(' ');
        return retval.toString();
    }

    private int getMaxColumnWidth() {
        if (this.verbose) {
            return Integer.MAX_VALUE;
        }
        return 120;
    }
}

