/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.impl;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.persistence.spi.PersistenceProvider;
import org.apache.aries.jpa.container.ManagedPersistenceUnitInfoFactory;
import org.apache.aries.jpa.container.impl.CoundownCallback;
import org.apache.aries.jpa.container.impl.DestroyCallback;
import org.apache.aries.jpa.container.impl.EntityManagerFactoryManager;
import org.apache.aries.jpa.container.impl.InvalidPersistenceUnitException;
import org.apache.aries.jpa.container.impl.InvalidRangeCombination;
import org.apache.aries.jpa.container.impl.NLS;
import org.apache.aries.jpa.container.impl.PersistenceBundleHelper;
import org.apache.aries.jpa.container.impl.QuiesceParticipantImpl;
import org.apache.aries.jpa.container.parsing.ParsedPersistenceUnit;
import org.apache.aries.jpa.container.parsing.PersistenceDescriptor;
import org.apache.aries.jpa.container.parsing.PersistenceDescriptorParser;
import org.apache.aries.jpa.container.parsing.PersistenceDescriptorParserException;
import org.apache.aries.jpa.container.parsing.impl.PersistenceDescriptorParserImpl;
import org.apache.aries.jpa.container.tx.impl.OSGiTransactionManager;
import org.apache.aries.jpa.container.unit.impl.ManagedPersistenceUnitInfoFactoryImpl;
import org.apache.aries.util.AriesFrameworkUtil;
import org.apache.aries.util.VersionRange;
import org.apache.aries.util.tracker.RecursiveBundleTracker;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceBundleManager
implements BundleTrackerCustomizer,
ServiceTrackerCustomizer,
BundleActivator {
    private static final String QUIESCE_PARTICIPANT_CLASS = "org.apache.aries.quiesce.participant.QuiesceParticipant";
    private static final Logger _logger = LoggerFactory.getLogger((String)"org.apache.aries.jpa.container");
    private BundleContext ctx = null;
    private final Map<Bundle, EntityManagerFactoryManager> bundleToManagerMap = new HashMap<Bundle, EntityManagerFactoryManager>();
    private Set<ServiceReference> persistenceProviders = new HashSet<ServiceReference>();
    private Collection<EntityManagerFactoryManager> managersAwaitingProviders = new ArrayList<EntityManagerFactoryManager>();
    private ManagedPersistenceUnitInfoFactory persistenceUnitFactory;
    private PersistenceDescriptorParser parser;
    private ServiceRegistration parserReg;
    private Properties config;
    private RecursiveBundleTracker tracker;
    private ServiceTracker serviceTracker;
    private ServiceRegistration quiesceReg;
    private DestroyCallback quiesceParticipant;
    private AtomicBoolean quiesce = new AtomicBoolean(false);

    private void open() {
        String className = this.config.getProperty("org.apache.aries.jpa.container.ManagedPersistenceUnitInfoFactory");
        if (className != null) {
            try {
                Class clazz = this.ctx.getBundle().loadClass(className);
                this.persistenceUnitFactory = (ManagedPersistenceUnitInfoFactory)clazz.newInstance();
            }
            catch (Exception e) {
                _logger.error(NLS.MESSAGES.getMessage("unable.to.create.mpuif", new Object[]{className}), (Throwable)e);
            }
        }
        if (this.persistenceUnitFactory == null) {
            this.persistenceUnitFactory = new ManagedPersistenceUnitInfoFactoryImpl();
        }
        this.serviceTracker.open();
        this.tracker.open();
    }

    private void close() {
        OSGiTransactionManager otm;
        if (this.tracker != null) {
            this.tracker.close();
        }
        if (this.serviceTracker != null) {
            this.serviceTracker.close();
        }
        if ((otm = OSGiTransactionManager.get()) != null) {
            otm.destroy();
        }
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        if (!this.quiesce.get()) {
            return this.setupManager(bundle, null, true);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference ref) {
        ServiceReference reference;
        EntityManagerFactoryManager mgr;
        if (this.quiesce.get()) {
            return null;
        }
        HashMap<EntityManagerFactoryManager, ServiceReference> managersToManage = new HashMap<EntityManagerFactoryManager, ServiceReference>();
        PersistenceBundleManager persistenceBundleManager = this;
        synchronized (persistenceBundleManager) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Adding a provider: {}", new Object[]{ref});
            }
            this.persistenceProviders.add(ref);
            Iterator<EntityManagerFactoryManager> it = this.managersAwaitingProviders.iterator();
            while (it.hasNext()) {
                mgr = it.next();
                reference = this.getProviderServiceReference(mgr.getParsedPersistenceUnits());
                if (reference == null) continue;
                managersToManage.put(mgr, reference);
                it.remove();
            }
        }
        for (Map.Entry entry : managersToManage.entrySet()) {
            mgr = (EntityManagerFactoryManager)entry.getKey();
            reference = (ServiceReference)entry.getValue();
            Collection infos = null;
            try {
                infos = this.persistenceUnitFactory.createManagedPersistenceUnitMetadata(this.ctx, mgr.getBundle(), reference, mgr.getParsedPersistenceUnits());
                mgr.manage(reference, infos);
                mgr.bundleStateChange();
            }
            catch (Exception e) {
                if (e instanceof InvalidPersistenceUnitException) {
                    this.logInvalidPersistenceUnitException(mgr.getBundle(), (InvalidPersistenceUnitException)e);
                } else {
                    _logger.warn(NLS.MESSAGES.getMessage("unable.to.manage.pu", new Object[]{mgr.getBundle().getSymbolicName(), mgr.getBundle().getVersion()}), (Throwable)e);
                }
                mgr.destroy();
                if (infos != null) {
                    this.persistenceUnitFactory.destroyPersistenceBundle(this.ctx, mgr.getBundle());
                }
                this.setupManager(mgr.getBundle(), mgr, false);
            }
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference ref, Object o) {
        HashMap<Bundle, EntityManagerFactoryManager> mgrs;
        if (_logger.isDebugEnabled()) {
            _logger.debug("Removing a provider: {}", new Object[]{ref});
        }
        PersistenceBundleManager persistenceBundleManager = this;
        synchronized (persistenceBundleManager) {
            this.persistenceProviders.remove(ref);
            mgrs = new HashMap<Bundle, EntityManagerFactoryManager>(this.bundleToManagerMap);
        }
        for (Map.Entry entry : mgrs.entrySet()) {
            EntityManagerFactoryManager mgr = (EntityManagerFactoryManager)entry.getValue();
            if (!mgr.providerRemoved(ref)) continue;
            Bundle bundle = (Bundle)entry.getKey();
            this.persistenceUnitFactory.destroyPersistenceBundle(this.ctx, bundle);
            this.setupManager(bundle, mgr, false);
        }
    }

    private void initConfig() {
        this.config = new Properties();
        URL u = this.ctx.getBundle().getResource("org.apache.aries.jpa.container.properties");
        if (u != null) {
            if (_logger.isInfoEnabled()) {
                _logger.info(NLS.MESSAGES.getMessage("aries.jpa.config.file.found", new Object[]{"org.apache.aries.jpa.container.properties", this.ctx.getBundle().getSymbolicName(), this.ctx.getBundle().getVersion(), this.config}));
            }
            try {
                this.config.load(u.openStream());
            }
            catch (IOException e) {
                _logger.error(NLS.MESSAGES.getMessage("aries.jpa.config.file.read.error", new Object[]{"org.apache.aries.jpa.container.properties", this.ctx.getBundle().getSymbolicName(), this.ctx.getBundle().getVersion()}), (Throwable)e);
            }
        } else if (_logger.isInfoEnabled()) {
            _logger.info(NLS.MESSAGES.getMessage("aries.jpa.config.file.not.found", new Object[]{"org.apache.aries.jpa.container.properties", this.ctx.getBundle().getSymbolicName(), this.ctx.getBundle().getVersion(), this.config}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
        EntityManagerFactoryManager mgr = (EntityManagerFactoryManager)object;
        if (event != null && event.getType() == 8) {
            mgr.destroy();
            this.persistenceUnitFactory.destroyPersistenceBundle(this.ctx, bundle);
            this.setupManager(bundle, mgr, true);
        } else {
            try {
                boolean reassign;
                PersistenceBundleManager persistenceBundleManager = this;
                synchronized (persistenceBundleManager) {
                    reassign = this.managersAwaitingProviders.contains(mgr);
                }
                if (reassign) {
                    this.setupManager(bundle, mgr, false);
                } else {
                    mgr.bundleStateChange();
                }
            }
            catch (InvalidPersistenceUnitException e) {
                this.logInvalidPersistenceUnitException(bundle, e);
                mgr.destroy();
                this.persistenceUnitFactory.destroyPersistenceBundle(this.ctx, bundle);
                this.setupManager(bundle, mgr, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        EntityManagerFactoryManager mgr = (EntityManagerFactoryManager)object;
        mgr.destroy();
        if (!this.managersAwaitingProviders.contains(mgr)) {
            this.persistenceUnitFactory.destroyPersistenceBundle(this.ctx, bundle);
        }
        PersistenceBundleManager persistenceBundleManager = this;
        synchronized (persistenceBundleManager) {
            this.bundleToManagerMap.remove(bundle);
        }
    }

    private Collection<ParsedPersistenceUnit> parseBundle(Bundle b) {
        ArrayList<ParsedPersistenceUnit> pUnits = new ArrayList<ParsedPersistenceUnit>();
        Collection<PersistenceDescriptor> persistenceXmls = PersistenceBundleHelper.findPersistenceXmlFiles(b);
        if (!persistenceXmls.isEmpty()) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Located Persistence descriptors: {} in bundle {}", new Object[]{persistenceXmls, b.getSymbolicName() + "_" + b.getVersion()});
            }
            if (b.getState() == 32) {
                _logger.warn(NLS.MESSAGES.getMessage("jpa.bundle.active", new Object[]{b.getSymbolicName(), b.getVersion()}));
            }
            for (PersistenceDescriptor descriptor : persistenceXmls) {
                try {
                    pUnits.addAll(this.parser.parse(b, descriptor));
                }
                catch (PersistenceDescriptorParserException e) {
                    _logger.error(NLS.MESSAGES.getMessage("persistence.description.parse.error", new Object[]{descriptor.getLocation(), b.getSymbolicName(), b.getVersion()}), (Throwable)e);
                }
            }
        }
        return pUnits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityManagerFactoryManager setupManager(Bundle bundle, EntityManagerFactoryManager mgr, boolean reParse) {
        Collection<ParsedPersistenceUnit> pUnits;
        Collection<ParsedPersistenceUnit> collection = pUnits = mgr == null || reParse ? this.parseBundle(bundle) : mgr.getParsedPersistenceUnits();
        if (!pUnits.isEmpty()) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Located Persistence units: {}", new Object[]{pUnits});
            }
            ServiceReference ref = this.getProviderServiceReference(pUnits);
            Collection infos = null;
            if (ref != null) {
                infos = this.persistenceUnitFactory.createManagedPersistenceUnitMetadata(this.ctx, bundle, ref, pUnits);
            }
            if (mgr != null) {
                mgr.manage(pUnits, ref, infos);
            } else {
                mgr = new EntityManagerFactoryManager(this.ctx, bundle, pUnits, ref, infos);
            }
            PersistenceBundleManager persistenceBundleManager = this;
            synchronized (persistenceBundleManager) {
                this.bundleToManagerMap.put(bundle, mgr);
                if (ref == null) {
                    this.managersAwaitingProviders.add(mgr);
                }
            }
            try {
                mgr.bundleStateChange();
            }
            catch (InvalidPersistenceUnitException e) {
                this.logInvalidPersistenceUnitException(bundle, e);
                mgr.destroy();
                if (infos != null) {
                    this.persistenceUnitFactory.destroyPersistenceBundle(this.ctx, bundle);
                }
                PersistenceBundleManager persistenceBundleManager2 = this;
                synchronized (persistenceBundleManager2) {
                    this.managersAwaitingProviders.add(mgr);
                }
            }
        }
        return mgr;
    }

    private synchronized ServiceReference getProviderServiceReference(Collection<ParsedPersistenceUnit> parsedPersistenceUnits) {
        Bundle bundle;
        HashSet<String> ppClassNames = new HashSet<String>();
        ArrayList<VersionRange> versionRanges = new ArrayList<VersionRange>();
        for (ParsedPersistenceUnit unit : parsedPersistenceUnits) {
            Map metadata = unit.getPersistenceXmlMetadata();
            String provider = (String)metadata.get("org.apache.aries.jpa.provider");
            if (provider == null || provider.equals("")) continue;
            ppClassNames.add(provider);
            Properties props = (Properties)metadata.get("org.apache.aries.jpa.properties");
            if (props == null || !props.containsKey("org.apache.aries.jpa.provider.version")) continue;
            String versionRangeString = props.getProperty("org.apache.aries.jpa.provider.version", "0.0.0");
            try {
                versionRanges.add(VersionRange.parseVersionRange((String)versionRangeString));
            }
            catch (IllegalArgumentException e) {
                _logger.warn(NLS.MESSAGES.getMessage("version.range.parse.failure", new Object[]{versionRangeString, metadata.get("org.apache.aries.jpa.unit.name")}));
            }
        }
        VersionRange range = null;
        if (!versionRanges.isEmpty()) {
            try {
                range = this.combineVersionRanges(versionRanges);
            }
            catch (InvalidRangeCombination e) {
                Bundle bundle2 = parsedPersistenceUnits.iterator().next().getDefiningBundle();
                _logger.error(NLS.MESSAGES.getMessage("invalid.provider.version.ranges", new Object[]{bundle2.getSymbolicName(), bundle2.getVersion()}), (Throwable)e);
                return null;
            }
        }
        if (ppClassNames.size() > 1) {
            bundle = parsedPersistenceUnits.iterator().next().getDefiningBundle();
            _logger.error(NLS.MESSAGES.getMessage("multiple.persistence.providers.specified", new Object[]{bundle.getSymbolicName(), bundle.getVersion(), ppClassNames}));
            return null;
        }
        bundle = parsedPersistenceUnits.iterator().next().getDefiningBundle();
        String provider = ppClassNames.isEmpty() ? this.persistenceUnitFactory.getDefaultProviderClassName() : (String)ppClassNames.iterator().next();
        return this.getBestProvider(provider, range, bundle);
    }

    private VersionRange combineVersionRanges(List<VersionRange> versionRanges) throws InvalidRangeCombination {
        int check;
        Version minVersion = new Version(0, 0, 0);
        Version maxVersion = null;
        boolean minExclusive = false;
        boolean maxExclusive = false;
        for (VersionRange range : versionRanges) {
            int minComparison = 0;
            try {
                minComparison = minVersion.compareTo(range.getMinimumVersion());
            }
            catch (Exception t) {
                try {
                    Method m = minVersion.getClass().getMethod("compareTo", Object.class);
                    Object ret = m.invoke((Object)minVersion, range.getMinimumVersion());
                    minComparison = (Integer)ret;
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("PersistenceBundleManager.combineVersionRanges reflection compareTo failed", e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("PersistenceBundleManager.combineVersionRanges reflection compareTo failed", e);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("PersistenceBundleManager.combineVersionRanges reflection compareTo failed", e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("PersistenceBundleManager.combineVersionRanges reflection compareTo failed", e);
                }
            }
            if (minComparison < 0) {
                minVersion = range.getMinimumVersion();
                minExclusive = range.isMinimumExclusive();
            } else if (minComparison == 0 && range.isMaximumExclusive()) {
                minExclusive = true;
            }
            if (range.isMaximumUnbounded()) continue;
            if (maxVersion == null) {
                maxVersion = range.getMaximumVersion();
                maxExclusive = range.isMaximumExclusive();
                continue;
            }
            int maxComparison = maxVersion.compareTo(range.getMaximumVersion());
            if (maxComparison > 0) {
                maxVersion = range.getMaximumVersion();
                maxExclusive = range.isMaximumExclusive();
                continue;
            }
            if (maxComparison != 0 || !range.isMaximumExclusive()) continue;
            maxExclusive = true;
        }
        int n = check = maxVersion == null ? -1 : minVersion.compareTo(maxVersion);
        if (check > 0 || check == 0 && (minExclusive || maxExclusive)) {
            throw new InvalidRangeCombination(minVersion, minExclusive, maxVersion, maxExclusive);
        }
        StringBuilder rangeString = new StringBuilder();
        rangeString.append(minVersion);
        if (maxVersion != null) {
            rangeString.insert(0, minExclusive ? "(" : "[");
            rangeString.append(",");
            rangeString.append(maxVersion);
            rangeString.append(maxExclusive ? ")" : "]");
        }
        return VersionRange.parseVersionRange((String)rangeString.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized ServiceReference getBestProvider(String providerClass, VersionRange matchingCriteria, Bundle bundle) {
        if (!this.persistenceProviders.isEmpty()) {
            if ((providerClass == null || "".equals(providerClass)) && matchingCriteria == null) return Collections.max(this.persistenceProviders);
            ArrayList<ServiceReference> refs = new ArrayList<ServiceReference>();
            for (ServiceReference reference : this.persistenceProviders) {
                if (providerClass != null && !providerClass.equals(reference.getProperty("javax.persistence.provider")) || matchingCriteria != null && !matchingCriteria.matches(reference.getBundle().getVersion())) continue;
                refs.add(reference);
            }
            if (!refs.isEmpty()) {
                return Collections.max(refs, new ProviderServiceComparator());
            }
            _logger.warn(NLS.MESSAGES.getMessage("no.suitable.jpa.providers", new Object[]{providerClass, matchingCriteria, bundle.getSymbolicName(), bundle.getVersion()}));
            return null;
        } else {
            _logger.warn(NLS.MESSAGES.getMessage("no.jpa.providers", new Object[0]));
        }
        return null;
    }

    private void logInvalidPersistenceUnitException(Bundle bundle, InvalidPersistenceUnitException e) {
        _logger.warn(NLS.MESSAGES.getMessage("pu.has.becomd.invalid", new Object[]{bundle.getSymbolicName(), bundle.getVersion()}), (Throwable)e);
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.removedService(reference, service);
        this.addingService(reference);
    }

    public void start(BundleContext context) throws Exception {
        this.ctx = context;
        this.initConfig();
        this.initParser();
        this.serviceTracker = new ServiceTracker(this.ctx, PersistenceProvider.class.getName(), (ServiceTrackerCustomizer)this);
        this.tracker = new RecursiveBundleTracker(this.ctx, 62, (BundleTrackerCustomizer)this);
        this.open();
        try {
            context.getBundle().loadClass(QUIESCE_PARTICIPANT_CLASS);
            this.quiesceParticipant = new QuiesceParticipantImpl(this);
            this.quiesceReg = context.registerService(QUIESCE_PARTICIPANT_CLASS, (Object)this.quiesceParticipant, null);
        }
        catch (ClassNotFoundException e) {
            _logger.info(NLS.MESSAGES.getMessage("quiesce.manager.not.there", new Object[0]));
        }
    }

    private void initParser() {
        this.parser = new PersistenceDescriptorParserImpl();
        this.parserReg = this.ctx.registerService(PersistenceDescriptorParser.class.getName(), (Object)this.parser, null);
    }

    public void stop(BundleContext context) throws Exception {
        this.close();
        AriesFrameworkUtil.safeUnregisterService((ServiceRegistration)this.parserReg);
        AriesFrameworkUtil.safeUnregisterService((ServiceRegistration)this.quiesceReg);
        if (this.quiesceParticipant != null) {
            this.quiesceParticipant.callback();
        }
    }

    public BundleContext getCtx() {
        return this.ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiesceBundle(Bundle bundleToQuiesce, DestroyCallback callback) {
        boolean thisBundle = bundleToQuiesce.equals(this.ctx.getBundle());
        if (thisBundle) {
            this.quiesce.compareAndSet(false, true);
            AriesFrameworkUtil.safeUnregisterService((ServiceRegistration)this.quiesceReg);
        }
        ArrayList<EntityManagerFactoryManager> toDestroyNow = new ArrayList<EntityManagerFactoryManager>();
        ArrayList<EntityManagerFactoryManager> quiesceNow = new ArrayList<EntityManagerFactoryManager>();
        PersistenceBundleManager persistenceBundleManager = this;
        synchronized (persistenceBundleManager) {
            if (thisBundle) {
                toDestroyNow.addAll(this.managersAwaitingProviders);
                this.managersAwaitingProviders.clear();
                quiesceNow.addAll(this.bundleToManagerMap.values());
                this.bundleToManagerMap.clear();
                quiesceNow.removeAll(toDestroyNow);
            } else {
                EntityManagerFactoryManager emfm = this.bundleToManagerMap.get(bundleToQuiesce);
                if (emfm != null) {
                    if (this.managersAwaitingProviders.remove(emfm)) {
                        toDestroyNow.add(emfm);
                    } else {
                        quiesceNow.add(emfm);
                    }
                }
            }
        }
        for (EntityManagerFactoryManager emfm : toDestroyNow) {
            emfm.destroy();
        }
        if (quiesceNow.isEmpty()) {
            callback.callback();
        } else {
            CoundownCallback countdown = new CoundownCallback(quiesceNow.size(), callback);
            for (EntityManagerFactoryManager emfm : quiesceNow) {
                emfm.quiesce(countdown);
            }
        }
    }

    private static class ProviderServiceComparator
    implements Comparator<ServiceReference> {
        private ProviderServiceComparator() {
        }

        @Override
        public int compare(ServiceReference object1, ServiceReference object2) {
            Version v2;
            Version v1 = object1.getBundle().getVersion();
            int res = v1.compareTo(v2 = object2.getBundle().getVersion());
            if (res == 0) {
                Integer rank1 = (Integer)object1.getProperty("service.ranking");
                Integer rank2 = (Integer)object2.getProperty("service.ranking");
                if (rank1 != null && rank2 != null) {
                    res = rank1.compareTo(rank2);
                }
            }
            return res;
        }
    }
}

