/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.osgi.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.Marshaller;
import org.switchyard.deploy.osgi.NamespaceHandler;

public class SimpleNamespaceHandler
implements NamespaceHandler {
    private final Bundle _bundle;
    private final Properties _properties;

    public SimpleNamespaceHandler(Bundle bundle, Properties properties) {
        this._bundle = bundle;
        this._properties = properties;
    }

    @Override
    public URL getSchemaLocation(String namespace) {
        String prefix = this.getPrefix(namespace);
        if (prefix == null) {
            return null;
        }
        String location = this._properties.getProperty(prefix + ".location");
        String schema = this._properties.getProperty(prefix + ".schema");
        return this._bundle.getResource(location + schema);
    }

    @Override
    public Marshaller createMarshaller(String namespace, Descriptor desc) {
        try {
            Class<Marshaller> clazz = this.getMarshallerClass(namespace);
            if (clazz != null) {
                return (Marshaller)Construction.construct(clazz, (Class[])new Class[]{Descriptor.class}, (Object[])new Object[]{desc});
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create marshaller", e);
        }
    }

    @Override
    public Set<Class> getManagedClasses() {
        HashSet<Class> classes = new HashSet<Class>();
        for (String namespace : this.getNamespaces()) {
            Class<Marshaller> clazz = this.getMarshallerClass(namespace);
            if (clazz == null) continue;
            classes.add(clazz);
        }
        return classes;
    }

    Class<Marshaller> getMarshallerClass(String namespace) {
        String prefix = this.getPrefix(namespace);
        if (prefix == null) {
            return null;
        }
        String className = this._properties.getProperty(prefix + ".marshaller");
        if (className != null) {
            try {
                return this._bundle.loadClass(className);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to load marshaller", e);
            }
        }
        return null;
    }

    String getPrefix(String namespace) {
        for (String key : this._properties.stringPropertyNames()) {
            if (!key.endsWith(".namespace") || !namespace.equals(this._properties.getProperty(key))) continue;
            return key.substring(0, key.length() - ".namespace".length());
        }
        return null;
    }

    List<String> getNamespaces() {
        ArrayList<String> namespaces = new ArrayList<String>();
        for (String key : this._properties.stringPropertyNames()) {
            if (!key.endsWith(".namespace")) continue;
            namespaces.add(this._properties.getProperty(key));
        }
        return namespaces;
    }
}

