/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.codehaus.janino.CodeContext;
import org.codehaus.janino.CompileException;
import org.codehaus.janino.IClass;
import org.codehaus.janino.Location;
import org.codehaus.janino.Mod;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.Visitor;
import org.codehaus.janino.util.Traverser;
import org.codehaus.janino.util.iterator.ReverseListIterator;

public class Java {
    private Java() {
    }

    private static void setEnclosingBlockStatement(ArrayInitializerOrRvalue aiorv, BlockStatement enclosingBlockStatement) {
        if (aiorv instanceof Rvalue) {
            ((Rvalue)aiorv).setEnclosingBlockStatement(enclosingBlockStatement);
        } else if (aiorv instanceof ArrayInitializer) {
            ArrayInitializerOrRvalue[] values = ((ArrayInitializer)aiorv).values;
            for (int i = 0; i < values.length; ++i) {
                Java.setEnclosingBlockStatement(values[i], enclosingBlockStatement);
            }
        } else {
            throw new RuntimeException("Unexpected array or initializer class " + aiorv.getClass().getName());
        }
    }

    public static String join(Object[] a, String separator) {
        return Java.join(a, separator, 0, a.length);
    }

    public static String join(Object[] a, String separator, int off, int len) {
        if (a == null) {
            return "(null)";
        }
        if (off >= len) {
            return "";
        }
        StringBuffer sb = new StringBuffer(a[off].toString());
        ++off;
        while (off < len) {
            sb.append(separator);
            sb.append(a[off]);
            ++off;
        }
        return sb.toString();
    }

    public static class LocalVariable {
        public final boolean finaL;
        public final IClass type;
        public LocalVariableSlot slot;

        public LocalVariable(boolean finaL, IClass type) {
            this.finaL = finaL;
            this.type = type;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.finaL) {
                sb.append("final ");
            }
            sb.append(this.type).append(" ");
            return sb.toString();
        }

        public void setSlot(LocalVariableSlot slot) {
            this.slot = slot;
        }

        public short getSlotIndex() {
            if (this.slot == null) {
                return -1;
            }
            return this.slot.getSlotIndex();
        }
    }

    public static class LocalVariableSlot {
        private short slotIndex = (short)-1;
        private String name;
        private IClass type;
        private CodeContext.Offset start;
        private CodeContext.Offset end;

        public LocalVariableSlot(String name, short slotNumber, IClass type) {
            this.name = name;
            this.slotIndex = slotNumber;
            this.type = type;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("local var(");
            buf.append(this.name);
            buf.append(", ").append(this.slotIndex);
            if (this.name != null) {
                buf.append(", ").append(this.type);
                buf.append(", ").append(this.start.offset);
                buf.append(", ").append(this.end.offset);
            }
            buf.append(")");
            return buf.toString();
        }

        public short getSlotIndex() {
            return this.slotIndex;
        }

        public void setSlotIndex(short slotIndex) {
            this.slotIndex = slotIndex;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public CodeContext.Offset getStart() {
            return this.start;
        }

        public void setStart(CodeContext.Offset start) {
            this.start = start;
        }

        public CodeContext.Offset getEnd() {
            return this.end;
        }

        public void setEnd(CodeContext.Offset end) {
            this.end = end;
        }

        public IClass getType() {
            return this.type;
        }
    }

    public static final class Literal
    extends Rvalue {
        public final Object value;

        public Literal(Location location, Object value) {
            super(location);
            if (!(value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String || value instanceof Character || value instanceof Boolean || value instanceof Short || value instanceof Byte || value == null)) {
                throw new IllegalArgumentException(value.getClass().getName());
            }
            this.value = value;
        }

        public String toString() {
            return Scanner.literalValueToString(this.value);
        }

        public final void accept(Visitor.AtomVisitor visitor) {
            visitor.visitLiteral(this);
        }

        public final void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitLiteral(this);
        }
    }

    public static interface ArrayInitializerOrRvalue {
    }

    public static final class ArrayInitializer
    extends Located
    implements ArrayInitializerOrRvalue {
        public final ArrayInitializerOrRvalue[] values;

        public ArrayInitializer(Location location, ArrayInitializerOrRvalue[] values) {
            super(location);
            this.values = values;
        }

        public String toString() {
            return " { (" + this.values.length + " values) }";
        }
    }

    public static final class NewInitializedArray
    extends Rvalue {
        public final ArrayType arrayType;
        public final ArrayInitializer arrayInitializer;

        public NewInitializedArray(Location location, ArrayType arrayType, ArrayInitializer arrayInitializer) {
            super(location);
            this.arrayType = arrayType;
            this.arrayInitializer = arrayInitializer;
        }

        public String toString() {
            return "new " + this.arrayType.toString() + " { ... }";
        }

        public final void accept(Visitor.AtomVisitor visitor) {
            visitor.visitNewInitializedArray(this);
        }

        public final void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitNewInitializedArray(this);
        }
    }

    public static final class NewArray
    extends Rvalue {
        public final Type type;
        public final Rvalue[] dimExprs;
        public final int dims;

        public NewArray(Location location, Type type, Rvalue[] dimExprs, int dims) {
            super(location);
            this.type = type;
            this.dimExprs = dimExprs;
            this.dims = dims;
        }

        public String toString() {
            return "new " + this.type.toString() + "[]...";
        }

        public final void accept(Visitor.AtomVisitor visitor) {
            visitor.visitNewArray(this);
        }

        public final void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitNewArray(this);
        }
    }

    public static final class ParameterAccess
    extends Rvalue {
        public final FunctionDeclarator.FormalParameter formalParameter;

        public ParameterAccess(Location location, FunctionDeclarator.FormalParameter formalParameter) {
            super(location);
            this.formalParameter = formalParameter;
        }

        public String toString() {
            return this.formalParameter.name;
        }

        public final void accept(Visitor.AtomVisitor visitor) {
            visitor.visitParameterAccess(this);
        }

        public final void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitParameterAccess(this);
        }
    }

    public static final class NewAnonymousClassInstance
    extends Rvalue {
        public final Rvalue optionalQualification;
        public final AnonymousClassDeclaration anonymousClassDeclaration;
        public final Rvalue[] arguments;

        public NewAnonymousClassInstance(Location location, Rvalue optionalQualification, AnonymousClassDeclaration anonymousClassDeclaration, Rvalue[] arguments) {
            super(location);
            this.optionalQualification = optionalQualification;
            this.anonymousClassDeclaration = anonymousClassDeclaration;
            this.arguments = arguments;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.optionalQualification != null) {
                sb.append(this.optionalQualification.toString()).append('.');
            }
            sb.append("new ").append(this.anonymousClassDeclaration.baseType.toString()).append("() { ... }");
            return sb.toString();
        }

        public final void accept(Visitor.AtomVisitor visitor) {
            visitor.visitNewAnonymousClassInstance(this);
        }

        public final void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitNewAnonymousClassInstance(this);
        }
    }

    public static final class NewClassInstance
    extends Rvalue {
        public final Rvalue optionalQualification;
        public final Type type;
        public final Rvalue[] arguments;
        protected IClass iClass = null;

        public NewClassInstance(Location location, Rvalue optionalQualification, Type type, Rvalue[] arguments) {
            super(location);
            this.optionalQualification = optionalQualification;
            this.type = type;
            this.arguments = arguments;
        }

        public NewClassInstance(Location location, Rvalue optionalQualification, IClass iClass, Rvalue[] arguments) {
            super(location);
            this.optionalQualification = optionalQualification;
            this.type = null;
            this.arguments = arguments;
            this.iClass = iClass;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.optionalQualification != null) {
                sb.append(this.optionalQualification.toString()).append('.');
            }
            sb.append("new ");
            if (this.type != null) {
                sb.append(this.type.toString());
            } else if (this.iClass != null) {
                sb.append(this.iClass.toString());
            } else {
                sb.append("???");
            }
            sb.append('(');
            for (int i = 0; i < this.arguments.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.arguments[i].toString());
            }
            sb.append(')');
            return sb.toString();
        }

        public final void accept(Visitor.AtomVisitor visitor) {
            visitor.visitNewClassInstance(this);
        }

        public final void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitNewClassInstance(this);
        }
    }

    public static abstract class Invocation
    extends Rvalue {
        public final Rvalue[] arguments;
        public final String methodName;

        protected Invocation(Location location, String methodName, Rvalue[] arguments) {
            super(location);
            this.methodName = methodName;
            this.arguments = arguments;
        }
    }

    public static final class SuperclassMethodInvocation
    extends Invocation {
        public SuperclassMethodInvocation(Location location, String methodName, Rvalue[] arguments) {
            super(location, methodName, arguments);
        }

        public String toString() {
            return "super." + this.methodName + "()";
        }

        public final void accept(Visitor.AtomVisitor visitor) {
            visitor.visitSuperclassMethodInvocation(this);
        }

        public final void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitSuperclassMethodInvocation(this);
        }
    }

    public static final class MethodInvocation
    extends Invocation {
        public final Atom optionalTarget;
        IClass.IMethod iMethod;

        public MethodInvocation(Location location, Atom optionalTarget, String methodName, Rvalue[] arguments) {
            super(location, methodName, arguments);
            this.optionalTarget = optionalTarget;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.optionalTarget != null) {
                sb.append(this.optionalTarget.toString()).append('.');
            }
            sb.append(this.methodName).append('(');
            for (int i = 0; i < this.arguments.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.arguments[i].toString());
            }
            sb.append(')');
            return sb.toString();
        }

        public final void accept(Visitor.AtomVisitor visitor) {
            visitor.visitMethodInvocation(this);
        }

        public final void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitMethodInvocation(this);
        }
    }

    public static final class SuperConstructorInvocation
    extends ConstructorInvocation {
        public final Rvalue optionalQualification;

        public SuperConstructorInvocation(Location location, Rvalue optionalQualification, Rvalue[] arguments) {
            super(location, arguments);
            this.optionalQualification = optionalQualification;
            if (optionalQualification != null) {
                optionalQualification.setEnclosingBlockStatement(this);
            }
        }

        public String toString() {
            return "super()";
        }

        public void accept(Visitor.AtomVisitor visitor) {
            ((Visitor.BlockStatementVisitor)((Object)visitor)).visitSuperConstructorInvocation(this);
        }

        public void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitSuperConstructorInvocation(this);
        }
    }

    public static final class AlternateConstructorInvocation
    extends ConstructorInvocation {
        public AlternateConstructorInvocation(Location location, Rvalue[] arguments) {
            super(location, arguments);
        }

        public String toString() {
            return "this()";
        }

        public void accept(Visitor.AtomVisitor visitor) {
            ((Visitor.BlockStatementVisitor)((Object)visitor)).visitAlternateConstructorInvocation(this);
        }

        public void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitAlternateConstructorInvocation(this);
        }
    }

    public static abstract class ConstructorInvocation
    extends Atom
    implements BlockStatement {
        public final Rvalue[] arguments;
        private Scope enclosingScope = null;
        public Map localVariables = null;

        protected ConstructorInvocation(Location location, Rvalue[] arguments) {
            super(location);
            this.arguments = arguments;
            for (int i = 0; i < arguments.length; ++i) {
                arguments[i].setEnclosingBlockStatement(this);
            }
        }

        public void setEnclosingScope(Scope enclosingScope) {
            if (this.enclosingScope != null && enclosingScope != null) {
                throw new RuntimeException("Enclosing scope is already set for statement \"" + this.toString() + "\" at " + this.getLocation());
            }
            this.enclosingScope = enclosingScope;
        }

        public Scope getEnclosingScope() {
            return this.enclosingScope;
        }

        public LocalVariable findLocalVariable(String name) {
            if (this.localVariables == null) {
                return null;
            }
            return (LocalVariable)this.localVariables.get(name);
        }

        public abstract /* synthetic */ void accept(Visitor.BlockStatementVisitor var1);
    }

    public static final class ParenthesizedExpression
    extends Lvalue {
        public final Rvalue value;

        public ParenthesizedExpression(Location location, Rvalue value) {
            super(location);
            this.value = value;
        }

        public String toString() {
            return '(' + this.value.toString() + ')';
        }

        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitParenthesizedExpression(this);
        }

        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitParenthesizedExpression(this);
        }

        public void accept(Visitor.LvalueVisitor visitor) {
            visitor.visitParenthesizedExpression(this);
        }
    }

    public static final class Cast
    extends Rvalue {
        public final Type targetType;
        public final Rvalue value;

        public Cast(Location location, Type targetType, Rvalue value) {
            super(location);
            this.targetType = targetType;
            this.value = value;
        }

        public String toString() {
            return '(' + this.targetType.toString() + ") " + this.value.toString();
        }

        public final void accept(Visitor.AtomVisitor visitor) {
            visitor.visitCast(this);
        }

        public final void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitCast(this);
        }
    }

    public static final class BinaryOperation
    extends BooleanRvalue {
        public final Rvalue lhs;
        public final String op;
        public final Rvalue rhs;

        public BinaryOperation(Location location, Rvalue lhs, String op, Rvalue rhs) {
            super(location);
            this.lhs = lhs;
            this.op = op;
            this.rhs = rhs;
        }

        public String toString() {
            return this.lhs.toString() + ' ' + this.op + ' ' + this.rhs.toString();
        }

        public Iterator unrollLeftAssociation() {
            Rvalue lhs;
            ArrayList<Rvalue> operands = new ArrayList<Rvalue>();
            BinaryOperation x = this;
            while (true) {
                operands.add(x.rhs);
                lhs = x.lhs;
                if (!(lhs instanceof BinaryOperation) || ((BinaryOperation)lhs).op != this.op) break;
                x = (BinaryOperation)lhs;
            }
            operands.add(lhs);
            return new ReverseListIterator(operands.listIterator(operands.size()));
        }

        public final void accept(Visitor.AtomVisitor visitor) {
            visitor.visitBinaryOperation(this);
        }

        public final void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitBinaryOperation(this);
        }
    }

    public static final class Instanceof
    extends Rvalue {
        public final Rvalue lhs;
        public final Type rhs;

        public Instanceof(Location location, Rvalue lhs, Type rhs) {
            super(location);
            this.lhs = lhs;
            this.rhs = rhs;
        }

        public String toString() {
            return this.lhs.toString() + " instanceof " + this.rhs.toString();
        }

        public final void accept(Visitor.AtomVisitor visitor) {
            visitor.visitInstanceof(this);
        }

        public final void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitInstanceof(this);
        }
    }

    public static final class UnaryOperation
    extends BooleanRvalue {
        public final String operator;
        public final Rvalue operand;

        public UnaryOperation(Location location, String operator, Rvalue operand) {
            super(location);
            this.operator = operator;
            this.operand = operand;
        }

        public String toString() {
            return this.operator + this.operand.toString();
        }

        public final void accept(Visitor.AtomVisitor visitor) {
            visitor.visitUnaryOperation(this);
        }

        public final void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitUnaryOperation(this);
        }
    }

    public static final class SuperclassFieldAccessExpression
    extends Lvalue {
        public final Type optionalQualification;
        public final String fieldName;
        Rvalue value = null;

        public SuperclassFieldAccessExpression(Location location, Type optionalQualification, String fieldName) {
            super(location);
            this.optionalQualification = optionalQualification;
            this.fieldName = fieldName;
        }

        public String toString() {
            return (this.optionalQualification == null ? "super." : this.optionalQualification.toString() + ".super.") + this.fieldName;
        }

        public final void accept(Visitor.AtomVisitor visitor) {
            visitor.visitSuperclassFieldAccessExpression(this);
        }

        public final void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitSuperclassFieldAccessExpression(this);
        }

        public final void accept(Visitor.LvalueVisitor visitor) {
            visitor.visitSuperclassFieldAccessExpression(this);
        }
    }

    public static final class FieldAccessExpression
    extends Lvalue {
        public final Atom lhs;
        public final String fieldName;
        Rvalue value = null;

        public FieldAccessExpression(Location location, Atom lhs, String fieldName) {
            super(location);
            this.lhs = lhs;
            this.fieldName = fieldName;
        }

        public String toString() {
            return this.lhs.toString() + '.' + this.fieldName;
        }

        public final void accept(Visitor.AtomVisitor visitor) {
            visitor.visitFieldAccessExpression(this);
        }

        public final void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitFieldAccessExpression(this);
        }

        public final void accept(Visitor.LvalueVisitor visitor) {
            visitor.visitFieldAccessExpression(this);
        }
    }

    public static final class ArrayAccessExpression
    extends Lvalue {
        public final Rvalue lhs;
        public final Rvalue index;

        public ArrayAccessExpression(Location location, Rvalue lhs, Rvalue index) {
            super(location);
            this.lhs = lhs;
            this.index = index;
        }

        public String toString() {
            return this.lhs.toString() + '[' + this.index + ']';
        }

        public final void accept(Visitor.AtomVisitor visitor) {
            visitor.visitArrayAccessExpression(this);
        }

        public final void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitArrayAccessExpression(this);
        }

        public final void accept(Visitor.LvalueVisitor visitor) {
            visitor.visitArrayAccessExpression(this);
        }
    }

    public static final class Crement
    extends Rvalue {
        public final boolean pre;
        public final String operator;
        public final Lvalue operand;

        public Crement(Location location, String operator, Lvalue operand) {
            super(location);
            this.pre = true;
            this.operator = operator;
            this.operand = operand;
        }

        public Crement(Location location, Lvalue operand, String operator) {
            super(location);
            this.pre = false;
            this.operator = operator;
            this.operand = operand;
        }

        public String toString() {
            return this.pre ? this.operator + this.operand : this.operand + this.operator;
        }

        public final void accept(Visitor.AtomVisitor visitor) {
            visitor.visitCrement(this);
        }

        public final void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitCrement(this);
        }
    }

    public static final class ConditionalExpression
    extends Rvalue {
        public final Rvalue lhs;
        public final Rvalue mhs;
        public final Rvalue rhs;

        public ConditionalExpression(Location location, Rvalue lhs, Rvalue mhs, Rvalue rhs) {
            super(location);
            this.lhs = lhs;
            this.mhs = mhs;
            this.rhs = rhs;
        }

        public String toString() {
            return this.lhs.toString() + " ? " + this.mhs.toString() + " : " + this.rhs.toString();
        }

        public final void accept(Visitor.AtomVisitor visitor) {
            visitor.visitConditionalExpression(this);
        }

        public final void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitConditionalExpression(this);
        }
    }

    public static final class Assignment
    extends Rvalue {
        public final Lvalue lhs;
        public final String operator;
        public final Rvalue rhs;

        public Assignment(Location location, Lvalue lhs, String operator, Rvalue rhs) {
            super(location);
            this.lhs = lhs;
            this.operator = operator;
            this.rhs = rhs;
        }

        public String toString() {
            return this.lhs.toString() + ' ' + this.operator + ' ' + this.rhs.toString();
        }

        public final void accept(Visitor.AtomVisitor visitor) {
            visitor.visitAssignment(this);
        }

        public final void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitAssignment(this);
        }
    }

    public static final class ClassLiteral
    extends Rvalue {
        public final Type type;

        public ClassLiteral(Location location, Type type) {
            super(location);
            this.type = type;
        }

        public String toString() {
            return this.type.toString() + ".class";
        }

        public final void accept(Visitor.AtomVisitor visitor) {
            visitor.visitClassLiteral(this);
        }

        public final void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitClassLiteral(this);
        }
    }

    public static final class QualifiedThisReference
    extends Rvalue {
        public final Type qualification;
        ClassDeclaration declaringClass = null;
        TypeBodyDeclaration declaringTypeBodyDeclaration = null;
        IClass targetIClass = null;

        public QualifiedThisReference(Location location, Type qualification) {
            super(location);
            if (qualification == null) {
                throw new NullPointerException();
            }
            this.qualification = qualification;
        }

        public String toString() {
            return this.qualification.toString() + ".this";
        }

        public final void accept(Visitor.AtomVisitor visitor) {
            visitor.visitQualifiedThisReference(this);
        }

        public final void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitQualifiedThisReference(this);
        }
    }

    public static final class ThisReference
    extends Rvalue {
        IClass iClass = null;

        public ThisReference(Location location) {
            super(location);
        }

        public String toString() {
            return "this";
        }

        public final void accept(Visitor.AtomVisitor visitor) {
            visitor.visitThisReference(this);
        }

        public final void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitThisReference(this);
        }
    }

    public static final class ArrayLength
    extends Rvalue {
        public final Rvalue lhs;

        public ArrayLength(Location location, Rvalue lhs) {
            super(location);
            this.lhs = lhs;
        }

        public String toString() {
            return this.lhs.toString() + ".length";
        }

        public final void accept(Visitor.AtomVisitor visitor) {
            visitor.visitArrayLength(this);
        }

        public final void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitArrayLength(this);
        }
    }

    public static final class FieldAccess
    extends Lvalue {
        public final Atom lhs;
        public final IClass.IField field;

        public FieldAccess(Location location, Atom lhs, IClass.IField field) {
            super(location);
            this.lhs = lhs;
            this.field = field;
        }

        public String toString() {
            return this.lhs.toString() + '.' + this.field.getName();
        }

        public final void accept(Visitor.AtomVisitor visitor) {
            visitor.visitFieldAccess(this);
        }

        public final void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitFieldAccess(this);
        }

        public final void accept(Visitor.LvalueVisitor visitor) {
            visitor.visitFieldAccess(this);
        }
    }

    public static final class LocalVariableAccess
    extends Lvalue {
        public LocalVariable localVariable;

        public LocalVariableAccess(Location location, LocalVariable localVariable) {
            super(location);
            this.localVariable = localVariable;
        }

        public String toString() {
            return this.localVariable.toString();
        }

        public final void accept(Visitor.LvalueVisitor visitor) {
            visitor.visitLocalVariableAccess(this);
        }

        public final void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitLocalVariableAccess(this);
        }

        public final void accept(Visitor.AtomVisitor visitor) {
            visitor.visitLocalVariableAccess(this);
        }
    }

    public static final class Package
    extends Atom {
        public final String name;

        public Package(Location location, String name) {
            super(location);
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public final void accept(Visitor.AtomVisitor visitor) {
            visitor.visitPackage(this);
        }
    }

    public static final class AmbiguousName
    extends Lvalue {
        public final String[] identifiers;
        public final int n;
        private Type type = null;
        Atom reclassified = null;

        public AmbiguousName(Location location, String[] identifiers) {
            this(location, identifiers, identifiers.length);
        }

        public AmbiguousName(Location location, String[] identifiers, int n) {
            super(location);
            this.identifiers = identifiers;
            this.n = n;
        }

        public Type toType() {
            if (this.type == null) {
                String[] is = new String[this.n];
                System.arraycopy(this.identifiers, 0, is, 0, this.n);
                this.type = new ReferenceType(this.getLocation(), is);
                this.type.setEnclosingScope(this.getEnclosingBlockStatement());
            }
            return this.type;
        }

        public String toString() {
            return Java.join(this.identifiers, ".", 0, this.n);
        }

        public Lvalue toLvalue() {
            if (this.reclassified != null) {
                return this.reclassified.toLvalue();
            }
            return this;
        }

        public Rvalue toRvalue() {
            if (this.reclassified != null) {
                return this.reclassified.toRvalue();
            }
            return this;
        }

        public final void accept(Visitor.AtomVisitor visitor) {
            visitor.visitAmbiguousName(this);
        }

        public final void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitAmbiguousName(this);
        }

        public final void accept(Visitor.LvalueVisitor visitor) {
            visitor.visitAmbiguousName(this);
        }
    }

    public static abstract class Lvalue
    extends Rvalue {
        protected Lvalue(Location location) {
            super(location);
        }

        public Lvalue toLvalue() {
            return this;
        }

        public abstract void accept(Visitor.LvalueVisitor var1);
    }

    public static abstract class BooleanRvalue
    extends Rvalue {
        protected BooleanRvalue(Location location) {
            super(location);
        }
    }

    public static abstract class Rvalue
    extends Atom
    implements ArrayInitializerOrRvalue {
        private BlockStatement enclosingBlockStatement = null;
        static final Object CONSTANT_VALUE_UNKNOWN = new Object();
        Object constantValue = CONSTANT_VALUE_UNKNOWN;
        public static final Object CONSTANT_VALUE_NULL = new Throwable();
        public static final boolean JUMP_IF_TRUE = true;
        public static final boolean JUMP_IF_FALSE = false;

        protected Rvalue(Location location) {
            super(location);
        }

        public final void setEnclosingBlockStatement(final BlockStatement enclosingBlockStatement) {
            this.accept((Visitor.RvalueVisitor)new Traverser(){

                public void traverseRvalue(Rvalue rv) {
                    if (rv.enclosingBlockStatement != null && enclosingBlockStatement != rv.enclosingBlockStatement) {
                        throw new RuntimeException("Enclosing block statement for rvalue \"" + rv + "\" at " + rv.getLocation() + " is already set");
                    }
                    rv.enclosingBlockStatement = enclosingBlockStatement;
                    super.traverseRvalue(rv);
                }

                public void traverseAnonymousClassDeclaration(AnonymousClassDeclaration acd) {
                    acd.setEnclosingScope(enclosingBlockStatement);
                }

                public void traverseType(Type t) {
                    if (t.enclosingScope != null && enclosingBlockStatement != t.enclosingScope) {
                        throw new RuntimeException("Enclosing scope already set for type \"" + this.toString() + "\" at " + t.getLocation());
                    }
                    t.enclosingScope = enclosingBlockStatement;
                    super.traverseType(t);
                }
            }.comprehensiveVisitor());
        }

        public BlockStatement getEnclosingBlockStatement() {
            return this.enclosingBlockStatement;
        }

        public Rvalue toRvalue() {
            return this;
        }

        public abstract void accept(Visitor.RvalueVisitor var1);
    }

    public static final class ArrayType
    extends Type {
        public final Type componentType;

        public ArrayType(Type componentType) {
            super(componentType.getLocation());
            this.componentType = componentType;
        }

        public void setEnclosingScope(Scope enclosingScope) {
            super.setEnclosingScope(enclosingScope);
            this.componentType.setEnclosingScope(enclosingScope);
        }

        public String toString() {
            return this.componentType.toString() + "[]";
        }

        public final void accept(Visitor.AtomVisitor visitor) {
            visitor.visitArrayType(this);
        }

        public final void accept(Visitor.TypeVisitor visitor) {
            visitor.visitArrayType(this);
        }
    }

    public static final class RvalueMemberType
    extends Type {
        public final Rvalue rvalue;
        public final String identifier;

        public RvalueMemberType(Location location, Rvalue rvalue, String identifier) {
            super(location);
            this.rvalue = rvalue;
            this.identifier = identifier;
        }

        public String toString() {
            return this.identifier;
        }

        public final void accept(Visitor.AtomVisitor visitor) {
            visitor.visitRvalueMemberType(this);
        }

        public final void accept(Visitor.TypeVisitor visitor) {
            visitor.visitRvalueMemberType(this);
        }
    }

    public static final class ReferenceType
    extends Type {
        public final String[] identifiers;

        public ReferenceType(Location location, String[] identifiers) {
            super(location);
            this.identifiers = identifiers;
        }

        public String toString() {
            return Java.join(this.identifiers, ".");
        }

        public final void accept(Visitor.AtomVisitor visitor) {
            visitor.visitReferenceType(this);
        }

        public final void accept(Visitor.TypeVisitor visitor) {
            visitor.visitReferenceType(this);
        }
    }

    public static final class BasicType
    extends Type {
        public int index;
        public static final int VOID = 0;
        public static final int BYTE = 1;
        public static final int SHORT = 2;
        public static final int CHAR = 3;
        public static final int INT = 4;
        public static final int LONG = 5;
        public static final int FLOAT = 6;
        public static final int DOUBLE = 7;
        public static final int BOOLEAN = 8;

        public BasicType(Location location, int index) {
            super(location);
            this.index = index;
        }

        public String toString() {
            switch (this.index) {
                case 0: {
                    return "void";
                }
                case 1: {
                    return "byte";
                }
                case 2: {
                    return "short";
                }
                case 3: {
                    return "char";
                }
                case 4: {
                    return "int";
                }
                case 5: {
                    return "long";
                }
                case 6: {
                    return "float";
                }
                case 7: {
                    return "double";
                }
                case 8: {
                    return "boolean";
                }
            }
            throw new RuntimeException("Invalid index " + this.index);
        }

        public final void accept(Visitor.TypeVisitor visitor) {
            visitor.visitBasicType(this);
        }

        public final void accept(Visitor.AtomVisitor visitor) {
            visitor.visitBasicType(this);
        }
    }

    public static final class SimpleType
    extends Type {
        public final IClass iClass;

        public SimpleType(Location location, IClass iClass) {
            super(location);
            this.iClass = iClass;
        }

        public String toString() {
            return this.iClass.toString();
        }

        public final void accept(Visitor.AtomVisitor visitor) {
            visitor.visitSimpleType(this);
        }

        public final void accept(Visitor.TypeVisitor visitor) {
            visitor.visitSimpleType(this);
        }
    }

    public static abstract class Type
    extends Atom {
        private Scope enclosingScope = null;

        protected Type(Location location) {
            super(location);
        }

        public void setEnclosingScope(Scope enclosingScope) {
            if (this.enclosingScope != null && enclosingScope != this.enclosingScope) {
                throw new RuntimeException("Enclosing scope already set for type \"" + this.toString() + "\" at " + this.getLocation());
            }
            this.enclosingScope = enclosingScope;
        }

        public Scope getEnclosingScope() {
            return this.enclosingScope;
        }

        public Type toType() {
            return this;
        }

        public abstract void accept(Visitor.TypeVisitor var1);
    }

    public static abstract class Atom
    extends Located {
        public Atom(Location location) {
            super(location);
        }

        public Type toType() {
            return null;
        }

        public Rvalue toRvalue() {
            return null;
        }

        public Lvalue toLvalue() {
            return null;
        }

        public abstract String toString();

        public final Type toTypeOrPE() throws Parser.ParseException {
            Type result = this.toType();
            if (result == null) {
                this.throwParseException("Expression \"" + this.toString() + "\" is not a type");
            }
            return result;
        }

        public final Rvalue toRvalueOrPE() throws Parser.ParseException {
            Rvalue result = this.toRvalue();
            if (result == null) {
                this.throwParseException("Expression \"" + this.toString() + "\" is not an rvalue");
            }
            return result;
        }

        public final Lvalue toLvalueOrPE() throws Parser.ParseException {
            Lvalue result = this.toLvalue();
            if (result == null) {
                this.throwParseException("Expression \"" + this.toString() + "\" is not an lvalue");
            }
            return result;
        }

        public abstract void accept(Visitor.AtomVisitor var1);
    }

    public static final class EmptyStatement
    extends Statement {
        public EmptyStatement(Location location) {
            super(location);
        }

        public String toString() {
            return ";";
        }

        public final void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitEmptyStatement(this);
        }
    }

    public static final class ContinueStatement
    extends Statement {
        public final String optionalLabel;

        public ContinueStatement(Location location, String optionalLabel) {
            super(location);
            this.optionalLabel = optionalLabel;
        }

        public String toString() {
            return this.optionalLabel == null ? "continue;" : "continue " + this.optionalLabel + ';';
        }

        public final void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitContinueStatement(this);
        }
    }

    public static final class BreakStatement
    extends Statement {
        public final String optionalLabel;

        public BreakStatement(Location location, String optionalLabel) {
            super(location);
            this.optionalLabel = optionalLabel;
        }

        public String toString() {
            return this.optionalLabel == null ? "break;" : "break " + this.optionalLabel + ';';
        }

        public final void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitBreakStatement(this);
        }
    }

    public static final class ThrowStatement
    extends Statement {
        public final Rvalue expression;

        public ThrowStatement(Location location, Rvalue expression) {
            super(location);
            this.expression = expression;
            this.expression.setEnclosingBlockStatement(this);
        }

        public String toString() {
            return "throw " + this.expression + ';';
        }

        public final void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitThrowStatement(this);
        }
    }

    public static final class ReturnStatement
    extends Statement {
        public final Rvalue optionalReturnValue;

        public ReturnStatement(Location location, Rvalue optionalReturnValue) {
            super(location);
            this.optionalReturnValue = optionalReturnValue;
            if (optionalReturnValue != null) {
                optionalReturnValue.setEnclosingBlockStatement(this);
            }
        }

        public String toString() {
            return this.optionalReturnValue == null ? "return;" : "return " + this.optionalReturnValue + ';';
        }

        public final void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitReturnStatement(this);
        }
    }

    public static final class LocalVariableDeclarationStatement
    extends Statement {
        public final short modifiers;
        public final Type type;
        public final VariableDeclarator[] variableDeclarators;

        public LocalVariableDeclarationStatement(Location location, short modifiers, Type type, VariableDeclarator[] variableDeclarators) {
            super(location);
            this.modifiers = modifiers;
            this.type = type;
            this.type.setEnclosingScope(this);
            this.variableDeclarators = variableDeclarators;
            for (int i = 0; i < variableDeclarators.length; ++i) {
                VariableDeclarator vd = variableDeclarators[i];
                if (vd.optionalInitializer == null) continue;
                Java.setEnclosingBlockStatement(vd.optionalInitializer, this);
            }
        }

        public final void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitLocalVariableDeclarationStatement(this);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.modifiers != 0) {
                sb.append(Mod.shortToString(this.modifiers)).append(' ');
            }
            sb.append(this.type).append(' ').append(this.variableDeclarators[0].toString());
            for (int i = 1; i < this.variableDeclarators.length; ++i) {
                sb.append(", ").append(this.variableDeclarators[i].toString());
            }
            return sb.append(';').toString();
        }
    }

    public static final class DoStatement
    extends ContinuableStatement {
        public final BlockStatement body;
        public final Rvalue condition;

        public DoStatement(Location location, BlockStatement body, Rvalue condition) {
            super(location);
            this.body = body;
            this.body.setEnclosingScope(this);
            this.condition = condition;
            this.condition.setEnclosingBlockStatement(this);
        }

        public String toString() {
            return "do " + this.body + " while(" + this.condition + ");";
        }

        public final void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitDoStatement(this);
        }
    }

    public static final class SynchronizedStatement
    extends Statement {
        public final Rvalue expression;
        public final BlockStatement body;
        short monitorLvIndex = (short)-1;

        public SynchronizedStatement(Location location, Rvalue expression, BlockStatement body) {
            super(location);
            this.expression = expression;
            this.expression.setEnclosingBlockStatement(this);
            this.body = body;
            this.body.setEnclosingScope(this);
        }

        public String toString() {
            return "synchronized(" + this.expression + ") " + this.body;
        }

        public final void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitSynchronizedStatement(this);
        }
    }

    static class Padder
    extends CodeContext.Inserter
    implements CodeContext.FixUp {
        public Padder(CodeContext codeContext) {
        }

        public void fixUp() {
            int x = this.offset % 4;
            if (x != 0) {
                CodeContext ca = this.getCodeContext();
                ca.pushInserter(this);
                ca.makeSpace((short)-1, 4 - x);
                ca.popInserter();
            }
        }
    }

    public static final class SwitchStatement
    extends BreakableStatement {
        public final Rvalue condition;
        public final List sbsgs;

        public SwitchStatement(Location location, Rvalue condition, List sbsgs) {
            super(location);
            this.condition = condition;
            this.condition.setEnclosingBlockStatement(this);
            this.sbsgs = sbsgs;
            Iterator it = sbsgs.iterator();
            while (it.hasNext()) {
                SwitchBlockStatementGroup sbsg = (SwitchBlockStatementGroup)it.next();
                Iterator it2 = sbsg.caseLabels.iterator();
                while (it2.hasNext()) {
                    ((Rvalue)it2.next()).setEnclosingBlockStatement(this);
                }
                it2 = sbsg.blockStatements.iterator();
                while (it2.hasNext()) {
                    ((BlockStatement)it2.next()).setEnclosingScope(this);
                }
            }
        }

        public String toString() {
            return "switch (" + this.condition + ") { (" + this.sbsgs.size() + " statement groups) }";
        }

        public final void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitSwitchStatement(this);
        }

        public static class SwitchBlockStatementGroup
        extends Located {
            public final List caseLabels;
            public final boolean hasDefaultLabel;
            public final List blockStatements;

            public SwitchBlockStatementGroup(Location location, List caseLabels, boolean hasDefaultLabel, List blockStatements) {
                super(location);
                this.caseLabels = caseLabels;
                this.hasDefaultLabel = hasDefaultLabel;
                this.blockStatements = blockStatements;
            }

            public String toString() {
                return this.caseLabels.size() + (this.hasDefaultLabel ? " case label(s) plus DEFAULT" : " case label(s)");
            }
        }
    }

    public static class CatchClause
    extends Located
    implements Scope {
        public final FunctionDeclarator.FormalParameter caughtException;
        public final Block body;
        private TryStatement enclosingTryStatement = null;

        public CatchClause(Location location, FunctionDeclarator.FormalParameter caughtException, Block body) {
            super(location);
            this.caughtException = caughtException;
            this.caughtException.type.setEnclosingScope(this);
            this.body = body;
            this.body.setEnclosingScope(this);
        }

        public void setEnclosingTryStatement(TryStatement enclosingTryStatement) {
            if (this.enclosingTryStatement != null && enclosingTryStatement != this.enclosingTryStatement) {
                throw new RuntimeException("Enclosing TYR statement already set for catch clause " + this.toString() + " at " + this.getLocation());
            }
            this.enclosingTryStatement = enclosingTryStatement;
        }

        public Scope getEnclosingScope() {
            return this.enclosingTryStatement;
        }
    }

    public static final class TryStatement
    extends Statement {
        public final BlockStatement body;
        public final List catchClauses;
        public final Block optionalFinally;
        CodeContext.Offset finallyOffset = null;

        public TryStatement(Location location, BlockStatement body, List catchClauses, Block optionalFinally) {
            super(location);
            this.body = body;
            this.body.setEnclosingScope(this);
            this.catchClauses = catchClauses;
            Iterator it = catchClauses.iterator();
            while (it.hasNext()) {
                ((CatchClause)it.next()).setEnclosingTryStatement(this);
            }
            this.optionalFinally = optionalFinally;
            if (optionalFinally != null) {
                optionalFinally.setEnclosingScope(this);
            }
        }

        public String toString() {
            return "try ... " + this.catchClauses.size() + (this.optionalFinally == null ? " catches" : " catches ... finally");
        }

        public final void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitTryStatement(this);
        }
    }

    public static final class WhileStatement
    extends ContinuableStatement {
        public final Rvalue condition;
        public final BlockStatement body;

        public WhileStatement(Location location, Rvalue condition, BlockStatement body) {
            super(location);
            this.condition = condition;
            this.condition.setEnclosingBlockStatement(this);
            this.body = body;
            this.body.setEnclosingScope(this);
        }

        public String toString() {
            return "while (" + this.condition + ") " + this.body + ';';
        }

        public final void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitWhileStatement(this);
        }
    }

    public static final class ForStatement
    extends ContinuableStatement {
        public final BlockStatement optionalInit;
        public final Rvalue optionalCondition;
        public final Rvalue[] optionalUpdate;
        public final BlockStatement body;

        public ForStatement(Location location, BlockStatement optionalInit, Rvalue optionalCondition, Rvalue[] optionalUpdate, BlockStatement body) {
            super(location);
            this.optionalInit = optionalInit;
            if (optionalInit != null) {
                optionalInit.setEnclosingScope(this);
            }
            this.optionalCondition = optionalCondition;
            if (optionalCondition != null) {
                optionalCondition.setEnclosingBlockStatement(this);
            }
            this.optionalUpdate = optionalUpdate;
            if (optionalUpdate != null) {
                for (int i = 0; i < optionalUpdate.length; ++i) {
                    optionalUpdate[i].setEnclosingBlockStatement(this);
                }
            }
            this.body = body;
            this.body.setEnclosingScope(this);
        }

        public String toString() {
            return "for (...; ...; ...) ...";
        }

        public final void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitForStatement(this);
        }
    }

    public static final class IfStatement
    extends Statement {
        public final Rvalue condition;
        public final BlockStatement thenStatement;
        public final BlockStatement optionalElseStatement;

        public IfStatement(Location location, Rvalue condition, BlockStatement thenStatement, BlockStatement optionalElseStatement) {
            super(location);
            this.condition = condition;
            this.condition.setEnclosingBlockStatement(this);
            this.thenStatement = thenStatement;
            this.thenStatement.setEnclosingScope(this);
            this.optionalElseStatement = optionalElseStatement;
            if (optionalElseStatement != null) {
                optionalElseStatement.setEnclosingScope(this);
            }
        }

        public String toString() {
            return this.optionalElseStatement == null ? "if" : "if ... else";
        }

        public final void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitIfStatement(this);
        }
    }

    public static final class LocalClassDeclarationStatement
    extends Statement {
        public final LocalClassDeclaration lcd;

        public LocalClassDeclarationStatement(LocalClassDeclaration lcd) {
            super(lcd.getLocation());
            this.lcd = lcd;
            this.lcd.setEnclosingScope(this);
        }

        public String toString() {
            return this.lcd.toString();
        }

        public final void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitLocalClassDeclarationStatement(this);
        }
    }

    public static final class ExpressionStatement
    extends Statement {
        public final Rvalue rvalue;

        public ExpressionStatement(Rvalue rvalue) throws Parser.ParseException {
            super(rvalue.getLocation());
            if (!(rvalue instanceof Assignment || rvalue instanceof Crement || rvalue instanceof MethodInvocation || rvalue instanceof SuperclassMethodInvocation || rvalue instanceof NewClassInstance || rvalue instanceof NewAnonymousClassInstance)) {
                String expressionType = rvalue.getClass().getName();
                expressionType = expressionType.substring(expressionType.lastIndexOf(46) + 1);
                this.throwParseException(expressionType + " is not allowed as an expression statement.  " + "Expressions statements must be one of assignments, method invocations, or object allocations.");
            }
            this.rvalue = rvalue;
            this.rvalue.setEnclosingBlockStatement(this);
        }

        public String toString() {
            return this.rvalue.toString() + ';';
        }

        public final void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitExpressionStatement(this);
        }
    }

    public static abstract class ContinuableStatement
    extends BreakableStatement {
        protected CodeContext.Offset whereToContinue = null;
        protected boolean bodyHasContinue = false;

        protected ContinuableStatement(Location location) {
            super(location);
        }
    }

    public static abstract class BreakableStatement
    extends Statement {
        CodeContext.Offset whereToBreak = null;

        protected BreakableStatement(Location location) {
            super(location);
        }
    }

    public static final class Block
    extends Statement {
        public final List statements = new ArrayList();

        public Block(Location location) {
            super(location);
        }

        public void addStatement(BlockStatement statement) {
            this.statements.add(statement);
            statement.setEnclosingScope(this);
        }

        void addButDontEncloseStatement(BlockStatement statement) {
            this.statements.add(statement);
        }

        public void addStatements(List statements) {
            this.statements.addAll(statements);
            Iterator it = statements.iterator();
            while (it.hasNext()) {
                ((BlockStatement)it.next()).setEnclosingScope(this);
            }
        }

        public void addButDontEncloseStatements(List statements) {
            this.statements.addAll(statements);
        }

        public BlockStatement[] getStatements() {
            return this.statements.toArray(new BlockStatement[this.statements.size()]);
        }

        public final void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitBlock(this);
        }

        public String toString() {
            return "{ ... }";
        }
    }

    public static final class LabeledStatement
    extends BreakableStatement {
        public final String label;
        public final Statement body;

        public LabeledStatement(Location location, String label, Statement body) {
            super(location);
            this.label = label;
            this.body = body;
            this.body.setEnclosingScope(this);
        }

        public String toString() {
            return this.label + ": " + this.body;
        }

        public final void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitLabeledStatement(this);
        }
    }

    public static abstract class Statement
    extends Located
    implements BlockStatement {
        private Scope enclosingScope = null;
        public Map localVariables = null;

        protected Statement(Location location) {
            super(location);
        }

        public void setEnclosingScope(Scope enclosingScope) {
            if (this.enclosingScope != null && enclosingScope != this.enclosingScope) {
                throw new RuntimeException("Enclosing scope is already set for statement \"" + this.toString() + "\" at " + this.getLocation());
            }
            this.enclosingScope = enclosingScope;
        }

        public Scope getEnclosingScope() {
            return this.enclosingScope;
        }

        public LocalVariable findLocalVariable(String name) {
            if (this.localVariables == null) {
                return null;
            }
            return (LocalVariable)this.localVariables.get(name);
        }

        public abstract /* synthetic */ void accept(Visitor.BlockStatementVisitor var1);
    }

    public static interface BlockStatement
    extends Locatable,
    Scope {
        public void setEnclosingScope(Scope var1);

        public Scope getEnclosingScope();

        public void accept(Visitor.BlockStatementVisitor var1);

        public LocalVariable findLocalVariable(String var1);
    }

    public static final class VariableDeclarator
    extends Located {
        public final String name;
        public final int brackets;
        public final ArrayInitializerOrRvalue optionalInitializer;
        public LocalVariable localVariable = null;

        public VariableDeclarator(Location location, String name, int brackets, ArrayInitializerOrRvalue optionalInitializer) {
            super(location);
            this.name = name;
            this.brackets = brackets;
            this.optionalInitializer = optionalInitializer;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.name);
            for (int i = 0; i < this.brackets; ++i) {
                sb.append("[]");
            }
            if (this.optionalInitializer != null) {
                sb.append(" = ").append(this.optionalInitializer);
            }
            return sb.toString();
        }
    }

    public static final class FieldDeclaration
    extends Statement
    implements TypeBodyDeclaration,
    DocCommentable {
        private final String optionalDocComment;
        public final short modifiers;
        public final Type type;
        public final VariableDeclarator[] variableDeclarators;

        public FieldDeclaration(Location location, String optionalDocComment, short modifiers, Type type, VariableDeclarator[] variableDeclarators) {
            super(location);
            this.optionalDocComment = optionalDocComment;
            this.modifiers = modifiers;
            this.type = type;
            this.type.setEnclosingScope(this);
            this.variableDeclarators = variableDeclarators;
            for (int i = 0; i < variableDeclarators.length; ++i) {
                VariableDeclarator vd = variableDeclarators[i];
                if (vd.optionalInitializer == null) continue;
                Java.setEnclosingBlockStatement(vd.optionalInitializer, this);
            }
        }

        public void setDeclaringType(TypeDeclaration declaringType) {
            this.setEnclosingScope(declaringType);
        }

        public TypeDeclaration getDeclaringType() {
            return (TypeDeclaration)this.getEnclosingScope();
        }

        public boolean isStatic() {
            return (this.modifiers & 8) != 0;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(Mod.shortToString(this.modifiers)).append(' ').append(this.type).append(' ').append(this.variableDeclarators[0]);
            for (int i = 1; i < this.variableDeclarators.length; ++i) {
                sb.append(", ").append(this.variableDeclarators[i]);
            }
            return sb.toString();
        }

        public final void accept(Visitor.TypeBodyDeclarationVisitor visitor) {
            visitor.visitFieldDeclaration(this);
        }

        public final void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitFieldDeclaration(this);
        }

        public String getDocComment() {
            return this.optionalDocComment;
        }

        public boolean hasDeprecatedDocTag() {
            return this.optionalDocComment != null && this.optionalDocComment.indexOf("@deprecated") != -1;
        }
    }

    public static final class MethodDeclarator
    extends FunctionDeclarator {
        IClass.IMethod iMethod = null;

        public MethodDeclarator(Location location, String optionalDocComment, short modifiers, Type type, String name, FunctionDeclarator.FormalParameter[] formalParameters, Type[] thrownExceptions, Block optionalBody) {
            super(location, optionalDocComment, modifiers, type, name, formalParameters, thrownExceptions, optionalBody);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.name);
            sb.append('(');
            FunctionDeclarator.FormalParameter[] fps = this.formalParameters;
            for (int i = 0; i < fps.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(fps[i].toString());
            }
            sb.append(')');
            return sb.toString();
        }

        public final void accept(Visitor.TypeBodyDeclarationVisitor visitor) {
            visitor.visitMethodDeclarator(this);
        }
    }

    public static final class ConstructorDeclarator
    extends FunctionDeclarator {
        IClass.IConstructor iConstructor = null;
        public ConstructorInvocation optionalConstructorInvocation = null;
        Map syntheticParameters = new HashMap();

        public ConstructorDeclarator(Location location, String optionalDocComment, short modifiers, FunctionDeclarator.FormalParameter[] formalParameters, Type[] thrownExceptions, ConstructorInvocation optionalConstructorInvocation, Block optionalBody) {
            super(location, optionalDocComment, modifiers, new BasicType(location, 0), "<init>", formalParameters, thrownExceptions, optionalBody);
            this.optionalConstructorInvocation = optionalConstructorInvocation;
            if (optionalConstructorInvocation != null) {
                optionalConstructorInvocation.setEnclosingScope(this);
            }
        }

        public ClassDeclaration getDeclaringClass() {
            return (ClassDeclaration)this.getEnclosingScope();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.getDeclaringClass().getClassName());
            sb.append('(');
            FunctionDeclarator.FormalParameter[] fps = this.formalParameters;
            for (int i = 0; i < fps.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(fps[i].toString());
            }
            sb.append(')');
            return sb.toString();
        }

        public final void accept(Visitor.TypeBodyDeclarationVisitor visitor) {
            visitor.visitConstructorDeclarator(this);
        }
    }

    public static abstract class FunctionDeclarator
    extends AbstractTypeBodyDeclaration
    implements DocCommentable {
        private final String optionalDocComment;
        public final short modifiers;
        public final Type type;
        public final String name;
        public final FormalParameter[] formalParameters;
        public final Type[] thrownExceptions;
        public final Block optionalBody;
        IClass returnType = null;
        public Map localVariables = null;

        public FunctionDeclarator(Location location, String optionalDocComment, short modifiers, Type type, String name, FormalParameter[] formalParameters, Type[] thrownExceptions, Block optionalBody) {
            super(location, (modifiers & 8) != 0);
            int i;
            this.optionalDocComment = optionalDocComment;
            this.modifiers = modifiers;
            this.type = type;
            this.type.setEnclosingScope(this);
            this.name = name;
            this.formalParameters = formalParameters;
            for (i = 0; i < formalParameters.length; ++i) {
                formalParameters[i].type.setEnclosingScope(this);
            }
            this.thrownExceptions = thrownExceptions;
            for (i = 0; i < thrownExceptions.length; ++i) {
                thrownExceptions[i].setEnclosingScope(this);
            }
            this.optionalBody = optionalBody;
            if (optionalBody != null) {
                optionalBody.setEnclosingScope(this);
            }
        }

        public Scope getEnclosingScope() {
            return this.getDeclaringType();
        }

        public String getDocComment() {
            return this.optionalDocComment;
        }

        public boolean hasDeprecatedDocTag() {
            return this.optionalDocComment != null && this.optionalDocComment.indexOf("@deprecated") != -1;
        }

        public static final class FormalParameter
        extends Located {
            public final boolean finaL;
            public final Type type;
            public final String name;
            public LocalVariable localVariable = null;

            public FormalParameter(Location location, boolean finaL, Type type, String name) {
                super(location);
                this.finaL = finaL;
                this.type = type;
                this.name = name;
            }

            public String toString() {
                return this.type.toString() + ' ' + this.name;
            }
        }
    }

    public static final class Initializer
    extends AbstractTypeBodyDeclaration
    implements BlockStatement {
        public final Block block;

        public Initializer(Location location, boolean statiC, Block block) {
            super(location, statiC);
            this.block = block;
            this.block.setEnclosingScope(this);
        }

        public String toString() {
            return this.statiC ? "static " + this.block : this.block.toString();
        }

        public final void accept(Visitor.TypeBodyDeclarationVisitor visitor) {
            visitor.visitInitializer(this);
        }

        public final void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitInitializer(this);
        }

        public LocalVariable findLocalVariable(String name) {
            return this.block.findLocalVariable(name);
        }
    }

    public static abstract class AbstractTypeBodyDeclaration
    extends Located
    implements TypeBodyDeclaration {
        private TypeDeclaration declaringType;
        public final boolean statiC;

        protected AbstractTypeBodyDeclaration(Location location, boolean statiC) {
            super(location);
            this.statiC = statiC;
        }

        public void setDeclaringType(TypeDeclaration declaringType) {
            if (this.declaringType != null && declaringType != null) {
                throw new RuntimeException("Declaring type for type body declaration \"" + this.toString() + "\"at " + this.getLocation() + " is already set");
            }
            this.declaringType = declaringType;
        }

        public TypeDeclaration getDeclaringType() {
            return this.declaringType;
        }

        public boolean isStatic() {
            return this.statiC;
        }

        public void setEnclosingScope(Scope enclosingScope) {
            this.declaringType = (TypeDeclaration)enclosingScope;
        }

        public Scope getEnclosingScope() {
            return this.declaringType;
        }

        public abstract /* synthetic */ void accept(Visitor.TypeBodyDeclarationVisitor var1);
    }

    public static interface TypeBodyDeclaration
    extends Locatable,
    Scope {
        public void setDeclaringType(TypeDeclaration var1);

        public TypeDeclaration getDeclaringType();

        public boolean isStatic();

        public void accept(Visitor.TypeBodyDeclarationVisitor var1);
    }

    public static final class PackageMemberInterfaceDeclaration
    extends InterfaceDeclaration
    implements PackageMemberTypeDeclaration {
        public PackageMemberInterfaceDeclaration(Location location, String optionalDocComment, short modifiers, String name, Type[] extendedTypes) throws Parser.ParseException {
            super(location, optionalDocComment, modifiers, name, extendedTypes);
            if ((modifiers & 0xE) != 0) {
                this.throwParseException("Modifiers \"protected\", \"private\" and \"static\" not allowed in package member interface declaration");
            }
        }

        public void setDeclaringCompilationUnit(CompilationUnit declaringCompilationUnit) {
            this.setEnclosingScope(declaringCompilationUnit);
        }

        public CompilationUnit getDeclaringCompilationUnit() {
            return (CompilationUnit)this.getEnclosingScope();
        }

        public String getClassName() {
            String className = this.getName();
            CompilationUnit compilationUnit = (CompilationUnit)this.getEnclosingScope();
            if (compilationUnit.optionalPackageDeclaration != null) {
                className = compilationUnit.optionalPackageDeclaration.packageName + '.' + className;
            }
            return className;
        }

        public final void accept(Visitor.TypeDeclarationVisitor visitor) {
            visitor.visitPackageMemberInterfaceDeclaration(this);
        }
    }

    public static final class MemberInterfaceDeclaration
    extends InterfaceDeclaration
    implements MemberTypeDeclaration {
        public MemberInterfaceDeclaration(Location location, String optionalDocComment, short modifiers, String name, Type[] extendedTypes) {
            super(location, optionalDocComment, modifiers, name, extendedTypes);
        }

        public String getClassName() {
            NamedTypeDeclaration declaringType = (NamedTypeDeclaration)this.getEnclosingScope();
            return declaringType.getClassName() + '$' + this.getName();
        }

        public void setDeclaringType(TypeDeclaration declaringType) {
            this.setEnclosingScope(declaringType);
        }

        public TypeDeclaration getDeclaringType() {
            return (TypeDeclaration)this.getEnclosingScope();
        }

        public boolean isStatic() {
            return (this.modifiers & 8) != 0;
        }

        public final void accept(Visitor.TypeDeclarationVisitor visitor) {
            visitor.visitMemberInterfaceDeclaration(this);
        }

        public final void accept(Visitor.TypeBodyDeclarationVisitor visitor) {
            visitor.visitMemberInterfaceDeclaration(this);
        }
    }

    public static abstract class InterfaceDeclaration
    extends AbstractTypeDeclaration
    implements NamedTypeDeclaration,
    DocCommentable {
        private final String optionalDocComment;
        public String name;
        public Type[] extendedTypes;
        public final List constantDeclarations = new ArrayList();
        IClass[] interfaces = null;

        protected InterfaceDeclaration(Location location, String optionalDocComment, short modifiers, String name, Type[] extendedTypes) {
            super(location, modifiers);
            this.optionalDocComment = optionalDocComment;
            this.name = name;
            this.extendedTypes = extendedTypes;
            for (int i = 0; i < extendedTypes.length; ++i) {
                extendedTypes[i].setEnclosingScope(new EnclosingScopeOfTypeDeclaration(this));
            }
        }

        public String toString() {
            return this.name;
        }

        public void addConstantDeclaration(FieldDeclaration fd) {
            this.constantDeclarations.add(fd);
            fd.setDeclaringType(this);
            if (this.resolvedType != null) {
                this.resolvedType.clearIFieldCaches();
            }
        }

        public String getName() {
            return this.name;
        }

        public String getDocComment() {
            return this.optionalDocComment;
        }

        public boolean hasDeprecatedDocTag() {
            return this.optionalDocComment != null && this.optionalDocComment.indexOf("@deprecated") != -1;
        }
    }

    public static final class PackageMemberClassDeclaration
    extends NamedClassDeclaration
    implements PackageMemberTypeDeclaration {
        public PackageMemberClassDeclaration(Location location, String optionalDocComment, short modifiers, String name, Type optionalExtendedType, Type[] implementedTypes) throws Parser.ParseException {
            super(location, optionalDocComment, modifiers, name, optionalExtendedType, implementedTypes);
            if ((modifiers & 0xE) != 0) {
                this.throwParseException("Modifiers \"protected\", \"private\" and \"static\" not allowed in package member class declaration");
            }
        }

        public void setDeclaringCompilationUnit(CompilationUnit declaringCompilationUnit) {
            this.setEnclosingScope(declaringCompilationUnit);
        }

        public CompilationUnit getDeclaringCompilationUnit() {
            return (CompilationUnit)this.getEnclosingScope();
        }

        protected IClass getOuterIClass2() {
            return null;
        }

        public String getClassName() {
            String className = this.getName();
            CompilationUnit compilationUnit = (CompilationUnit)this.getEnclosingScope();
            if (compilationUnit.optionalPackageDeclaration != null) {
                className = compilationUnit.optionalPackageDeclaration.packageName + '.' + className;
            }
            return className;
        }

        public final void accept(Visitor.TypeDeclarationVisitor visitor) {
            visitor.visitPackageMemberClassDeclaration(this);
        }
    }

    public static final class LocalClassDeclaration
    extends NamedClassDeclaration
    implements InnerClassDeclaration {
        public LocalClassDeclaration(Location location, String optionalDocComment, short modifiers, String name, Type optionalExtendedType, Type[] implementedTypes) {
            super(location, optionalDocComment, modifiers, name, optionalExtendedType, implementedTypes);
        }

        protected IClass getOuterIClass2() {
            boolean isStaticMethod;
            Scope s = this.getEnclosingScope();
            while (!(s instanceof FunctionDeclarator)) {
                s = s.getEnclosingScope();
            }
            boolean bl = isStaticMethod = s instanceof MethodDeclarator && (((FunctionDeclarator)s).modifiers & 8) != 0;
            while (!(s instanceof TypeDeclaration)) {
                s = s.getEnclosingScope();
            }
            TypeDeclaration immediatelyEnclosingTypeDeclaration = (TypeDeclaration)s;
            return immediatelyEnclosingTypeDeclaration instanceof ClassDeclaration && !isStaticMethod ? (IClass)((Object)immediatelyEnclosingTypeDeclaration) : null;
        }

        public String getClassName() {
            Scope s = this.getEnclosingScope();
            while (!(s instanceof TypeDeclaration)) {
                s = s.getEnclosingScope();
            }
            return ((TypeDeclaration)s).getClassName() + '$' + this.name;
        }

        public final void accept(Visitor.TypeDeclarationVisitor visitor) {
            visitor.visitLocalClassDeclaration(this);
        }
    }

    public static final class MemberClassDeclaration
    extends NamedClassDeclaration
    implements MemberTypeDeclaration,
    InnerClassDeclaration {
        public MemberClassDeclaration(Location location, String optionalDocComment, short modifiers, String name, Type optionalExtendedType, Type[] implementedTypes) {
            super(location, optionalDocComment, modifiers, name, optionalExtendedType, implementedTypes);
        }

        public void setDeclaringType(TypeDeclaration declaringType) {
            this.setEnclosingScope(declaringType);
        }

        public TypeDeclaration getDeclaringType() {
            return (TypeDeclaration)this.getEnclosingScope();
        }

        public boolean isStatic() {
            return (this.modifiers & 8) != 0;
        }

        public String getClassName() {
            return this.getDeclaringType().getClassName() + '$' + this.getName();
        }

        public void accept(Visitor.TypeDeclarationVisitor visitor) {
            visitor.visitMemberClassDeclaration(this);
        }

        public void accept(Visitor.TypeBodyDeclarationVisitor visitor) {
            visitor.visitMemberClassDeclaration(this);
        }
    }

    public static final class EnclosingScopeOfTypeDeclaration
    implements Scope {
        public final TypeDeclaration typeDeclaration;

        public EnclosingScopeOfTypeDeclaration(TypeDeclaration typeDeclaration) {
            this.typeDeclaration = typeDeclaration;
        }

        public Scope getEnclosingScope() {
            return this.typeDeclaration.getEnclosingScope();
        }
    }

    public static abstract class NamedClassDeclaration
    extends ClassDeclaration
    implements NamedTypeDeclaration,
    DocCommentable {
        private final String optionalDocComment;
        public final String name;
        public final Type optionalExtendedType;
        public final Type[] implementedTypes;

        public NamedClassDeclaration(Location location, String optionalDocComment, short modifiers, String name, Type optionalExtendedType, Type[] implementedTypes) {
            super(location, modifiers);
            this.optionalDocComment = optionalDocComment;
            this.name = name;
            this.optionalExtendedType = optionalExtendedType;
            if (optionalExtendedType != null) {
                optionalExtendedType.setEnclosingScope(new EnclosingScopeOfTypeDeclaration(this));
            }
            this.implementedTypes = implementedTypes;
            for (int i = 0; i < implementedTypes.length; ++i) {
                implementedTypes[i].setEnclosingScope(new EnclosingScopeOfTypeDeclaration(this));
            }
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public String getDocComment() {
            return this.optionalDocComment;
        }

        public boolean hasDeprecatedDocTag() {
            return this.optionalDocComment != null && this.optionalDocComment.indexOf("@deprecated") != -1;
        }
    }

    public static final class AnonymousClassDeclaration
    extends ClassDeclaration
    implements InnerClassDeclaration {
        public final Type baseType;
        private String myName = null;

        public AnonymousClassDeclaration(Location location, Type baseType) {
            super(location, (short)18);
            this.baseType = baseType;
            this.baseType.setEnclosingScope(new EnclosingScopeOfTypeDeclaration(this));
        }

        public final void accept(Visitor.TypeDeclarationVisitor visitor) {
            visitor.visitAnonymousClassDeclaration(this);
        }

        public String getClassName() {
            if (this.myName == null) {
                Scope s = this.getEnclosingScope();
                while (!(s instanceof TypeDeclaration)) {
                    s = s.getEnclosingScope();
                }
                this.myName = ((TypeDeclaration)s).createAnonymousClassName();
            }
            return this.myName;
        }

        public String toString() {
            return this.getClassName();
        }
    }

    public static abstract class ClassDeclaration
    extends AbstractTypeDeclaration {
        public final List constructors = new ArrayList();
        public final List variableDeclaratorsAndInitializers = new ArrayList();
        final SortedMap syntheticFields = new TreeMap();

        public ClassDeclaration(Location location, short modifiers) {
            super(location, modifiers);
        }

        public void addConstructor(ConstructorDeclarator cd) {
            this.constructors.add(cd);
            cd.setDeclaringType(this);
        }

        public void addVariableDeclaratorOrInitializer(TypeBodyDeclaration tbd) {
            this.variableDeclaratorsAndInitializers.add(tbd);
            tbd.setDeclaringType(this);
            if (this.resolvedType != null) {
                this.resolvedType.clearIFieldCaches();
            }
        }

        public void defineSyntheticField(IClass.IField iField) throws CompileException {
            if (!(this instanceof InnerClassDeclaration)) {
                throw new RuntimeException();
            }
            IClass.IField if2 = (IClass.IField)this.syntheticFields.get(iField.getName());
            if (if2 != null) {
                if (iField.getType() != if2.getType()) {
                    throw new RuntimeException();
                }
                return;
            }
            this.syntheticFields.put(iField.getName(), iField);
        }

        ConstructorDeclarator[] getConstructors() {
            if (this.constructors.isEmpty()) {
                ConstructorDeclarator defaultConstructor = new ConstructorDeclarator(this.getLocation(), null, 1, new FunctionDeclarator.FormalParameter[0], new Type[0], null, new Block(this.getLocation()));
                defaultConstructor.setDeclaringType(this);
                return new ConstructorDeclarator[]{defaultConstructor};
            }
            return this.constructors.toArray(new ConstructorDeclarator[this.constructors.size()]);
        }
    }

    public static abstract class AbstractTypeDeclaration
    implements TypeDeclaration {
        private final Location location;
        public final short modifiers;
        public final List declaredMethods = new ArrayList();
        public final List declaredClassesAndInterfaces = new ArrayList();
        private Scope enclosingScope = null;
        IClass resolvedType = null;
        public int anonymousClassCount = 0;
        public int localClassCount = 0;

        public AbstractTypeDeclaration(Location location, short modifiers) {
            this.location = location;
            this.modifiers = modifiers;
        }

        public void setEnclosingScope(Scope enclosingScope) {
            if (this.enclosingScope != null && enclosingScope != this.enclosingScope) {
                throw new RuntimeException("Enclosing scope is already set for type declaration \"" + this.toString() + "\" at " + this.getLocation());
            }
            this.enclosingScope = enclosingScope;
        }

        public Scope getEnclosingScope() {
            return this.enclosingScope;
        }

        public void addDeclaredMethod(MethodDeclarator method) {
            this.declaredMethods.add(method);
            method.setDeclaringType(this);
        }

        public void invalidateMethodCaches() {
            if (this.resolvedType != null) {
                this.resolvedType.declaredIMethods = null;
                this.resolvedType.declaredIMethodCache = null;
            }
        }

        public void addMemberTypeDeclaration(MemberTypeDeclaration mcoid) {
            this.declaredClassesAndInterfaces.add(mcoid);
            mcoid.setDeclaringType(this);
        }

        public Collection getMemberTypeDeclarations() {
            return this.declaredClassesAndInterfaces;
        }

        public MemberTypeDeclaration getMemberTypeDeclaration(String name) {
            Iterator it = this.declaredClassesAndInterfaces.iterator();
            while (it.hasNext()) {
                MemberTypeDeclaration mtd = (MemberTypeDeclaration)it.next();
                if (!mtd.getName().equals(name)) continue;
                return mtd;
            }
            return null;
        }

        public MethodDeclarator getMethodDeclaration(String name) {
            Iterator it = this.declaredMethods.iterator();
            while (it.hasNext()) {
                MethodDeclarator md = (MethodDeclarator)it.next();
                if (!md.name.equals(name)) continue;
                return md;
            }
            return null;
        }

        public String createLocalTypeName(String localTypeName) {
            return this.getClassName() + '$' + ++this.localClassCount + '$' + localTypeName;
        }

        public String createAnonymousClassName() {
            return this.getClassName() + '$' + ++this.anonymousClassCount;
        }

        public Location getLocation() {
            return this.location;
        }

        public void throwParseException(String message) throws Parser.ParseException {
            throw new Parser.ParseException(message, this.location);
        }

        public abstract String toString();

        public abstract /* synthetic */ void accept(Visitor.TypeDeclarationVisitor var1);

        public abstract /* synthetic */ String getClassName();
    }

    static interface InnerClassDeclaration
    extends TypeDeclaration {
        public void defineSyntheticField(IClass.IField var1) throws CompileException;
    }

    public static interface NamedTypeDeclaration
    extends TypeDeclaration {
        public String getName();
    }

    public static interface MemberTypeDeclaration
    extends NamedTypeDeclaration,
    TypeBodyDeclaration {
    }

    public static interface PackageMemberTypeDeclaration
    extends NamedTypeDeclaration {
        public void setDeclaringCompilationUnit(CompilationUnit var1);

        public CompilationUnit getDeclaringCompilationUnit();
    }

    public static interface DocCommentable {
        public String getDocComment();

        public boolean hasDeprecatedDocTag();
    }

    public static interface TypeDeclaration
    extends Locatable,
    Scope {
        public MemberTypeDeclaration getMemberTypeDeclaration(String var1);

        public String getClassName();

        public String createLocalTypeName(String var1);

        public String createAnonymousClassName();

        public void accept(Visitor.TypeDeclarationVisitor var1);
    }

    public static class PackageDeclaration
    extends Located {
        public final String packageName;

        public PackageDeclaration(Location location, String packageName) {
            super(location);
            this.packageName = packageName;
        }
    }

    public static final class CompilationUnit
    implements Scope {
        public String optionalFileName;
        public PackageDeclaration optionalPackageDeclaration = null;
        public final List importDeclarations = new ArrayList();
        public final List packageMemberTypeDeclarations = new ArrayList();

        public CompilationUnit(String optionalFileName) {
            this.optionalFileName = optionalFileName;
        }

        public Scope getEnclosingScope() {
            throw new RuntimeException("A compilation unit has no enclosing scope");
        }

        public void setPackageDeclaration(PackageDeclaration packageDeclaration) {
            if (this.optionalPackageDeclaration != null) {
                throw new RuntimeException("Re-setting package declaration");
            }
            this.optionalPackageDeclaration = packageDeclaration;
        }

        public void addImportDeclaration(ImportDeclaration id) {
            this.importDeclarations.add(id);
        }

        public void addPackageMemberTypeDeclaration(PackageMemberTypeDeclaration pmtd) {
            this.packageMemberTypeDeclarations.add(pmtd);
            pmtd.setDeclaringCompilationUnit(this);
        }

        public PackageMemberTypeDeclaration[] getPackageMemberTypeDeclarations() {
            return this.packageMemberTypeDeclarations.toArray(new PackageMemberTypeDeclaration[this.packageMemberTypeDeclarations.size()]);
        }

        public PackageMemberTypeDeclaration getPackageMemberTypeDeclaration(String name) {
            Iterator it = this.packageMemberTypeDeclarations.iterator();
            while (it.hasNext()) {
                PackageMemberTypeDeclaration pmtd = (PackageMemberTypeDeclaration)it.next();
                if (!pmtd.getName().equals(name)) continue;
                return pmtd;
            }
            return null;
        }

        public static abstract class ImportDeclaration
        extends Located {
            public ImportDeclaration(Location location) {
                super(location);
            }

            public abstract void accept(Visitor.ImportVisitor var1);
        }

        public static class StaticImportOnDemandDeclaration
        extends ImportDeclaration {
            public final String[] identifiers;

            public StaticImportOnDemandDeclaration(Location location, String[] identifiers) {
                super(location);
                this.identifiers = identifiers;
            }

            public final void accept(Visitor.ImportVisitor visitor) {
                visitor.visitStaticImportOnDemandDeclaration(this);
            }
        }

        public static class SingleStaticImportDeclaration
        extends ImportDeclaration {
            public final String[] identifiers;

            public SingleStaticImportDeclaration(Location location, String[] identifiers) {
                super(location);
                this.identifiers = identifiers;
            }

            public final void accept(Visitor.ImportVisitor visitor) {
                visitor.visitSingleStaticImportDeclaration(this);
            }
        }

        public static class TypeImportOnDemandDeclaration
        extends ImportDeclaration {
            public final String[] identifiers;

            public TypeImportOnDemandDeclaration(Location location, String[] identifiers) {
                super(location);
                this.identifiers = identifiers;
            }

            public final void accept(Visitor.ImportVisitor visitor) {
                visitor.visitTypeImportOnDemandDeclaration(this);
            }

            public String toString() {
                return "import " + Java.join(this.identifiers, ".") + ".*;";
            }
        }

        public static class SingleTypeImportDeclaration
        extends ImportDeclaration {
            public final String[] identifiers;

            public SingleTypeImportDeclaration(Location location, String[] identifiers) {
                super(location);
                this.identifiers = identifiers;
            }

            public final void accept(Visitor.ImportVisitor visitor) {
                visitor.visitSingleTypeImportDeclaration(this);
            }

            public String toString() {
                return "import " + Java.join(this.identifiers, ".") + ';';
            }
        }
    }

    public static abstract class Located
    implements Locatable {
        private final Location location;

        protected Located(Location location) {
            this.location = location;
        }

        public Location getLocation() {
            return this.location;
        }

        public void throwParseException(String message) throws Parser.ParseException {
            throw new Parser.ParseException(message, this.location);
        }
    }

    public static interface Locatable {
        public Location getLocation();

        public void throwParseException(String var1) throws Parser.ParseException;
    }

    public static interface Scope {
        public Scope getEnclosingScope();
    }
}

