/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePattern;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.internal.ExchangeImpl;
import org.switchyard.internal.HandlerChain;
import org.switchyard.runtime.RuntimeMessages;
import org.switchyard.spi.Dispatcher;

class LocalDispatcher
implements Dispatcher {
    private HandlerChain _requestChain;
    private HandlerChain _replyChain;
    private ServiceReference _reference;
    private ServiceDomain _domain;

    LocalDispatcher(ServiceDomain domain, ServiceReference reference, HandlerChain requestChain, HandlerChain replyChain) {
        this._domain = domain;
        this._reference = reference;
        this._requestChain = requestChain;
        this._replyChain = replyChain;
    }

    @Override
    public void dispatch(Exchange exchange) {
        switch (exchange.getPhase()) {
            case IN: {
                this._requestChain.handle(exchange);
                break;
            }
            case OUT: {
                ExchangeHandler replyHandler = ((ExchangeImpl)exchange).getReplyHandler();
                if (replyHandler != null) {
                    this._replyChain.replace("consumer", replyHandler);
                }
                this._replyChain.handle(exchange);
                break;
            }
            default: {
                throw RuntimeMessages.MESSAGES.invalidPhaseForDispatch(exchange.getPhase().toString());
            }
        }
    }

    @Override
    public ServiceReference getServiceReference() {
        return this._reference;
    }

    @Override
    public Exchange createExchange(ExchangeHandler handler, ExchangePattern pattern) {
        ExchangeImpl exchangeImpl = new ExchangeImpl(this._domain, this, handler);
        return exchangeImpl;
    }
}

