/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.store.intern;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.ops4j.io.FileUtils;
import org.ops4j.io.StreamUtils;
import org.ops4j.store.Handle;
import org.ops4j.store.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryStore
implements Store<InputStream> {
    private static Logger LOG = LoggerFactory.getLogger(TemporaryStore.class);
    private final File m_dir;

    public TemporaryStore(File folder, boolean flushStoreage) {
        this.m_dir = folder;
        if (this.m_dir.exists() && flushStoreage) {
            FileUtils.delete(this.m_dir);
        }
        this.m_dir.mkdirs();
        LOG.debug("Storage Area is " + this.m_dir.getAbsolutePath());
    }

    @Override
    public Handle store(InputStream inp) throws IOException {
        LOG.debug("Enter store()");
        File intermediate = File.createTempFile("tinybundles_", ".tmp");
        FileOutputStream fis = null;
        fis = new FileOutputStream(intermediate);
        final String h = this.hash(inp, fis);
        fis.close();
        if (!this.getLocation(h).exists()) {
            StreamUtils.copyStream(new FileInputStream(intermediate), new FileOutputStream(this.getLocation(h)), true);
        } else {
            LOG.debug("Object for " + h + " already exists in store.");
        }
        intermediate.delete();
        Handle handle = new Handle(){

            @Override
            public String getIdentification() {
                return h;
            }
        };
        LOG.debug("Exit store(): " + h);
        return handle;
    }

    private File getLocation(String id) {
        return new File(this.m_dir, "tinybundles_" + id + ".bin");
    }

    @Override
    public InputStream load(Handle handle) throws IOException {
        return new FileInputStream(this.getLocation(handle.getIdentification()));
    }

    @Override
    public URI getLocation(Handle handle) throws IOException {
        return this.getLocation(handle.getIdentification()).toURI();
    }

    public String hash(InputStream is, OutputStream storeHere) throws IOException {
        byte[] sha1hash;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] bytes = new byte[1024];
            int numRead = 0;
            while ((numRead = is.read(bytes)) >= 0) {
                md.update(bytes, 0, numRead);
                storeHere.write(bytes, 0, numRead);
            }
            sha1hash = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return TemporaryStore.convertToHex(sha1hash);
    }

    private static String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }
}

