/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.ejb;

import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.ejb.InternalEjbDescriptor;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.util.collections.HashSetSupplier;
import org.jboss.weld.util.reflection.Reflections;

public class EjbDescriptors
implements Service,
Iterable<InternalEjbDescriptor<?>> {
    private final Map<String, InternalEjbDescriptor<?>> ejbByName = new HashMap();
    private final SetMultimap<Class<?>, String> ejbByClass = Multimaps.newSetMultimap(new HashMap(), HashSetSupplier.instance());
    public static final EjbDescriptors EMPTY = new EjbDescriptors();

    public <T> InternalEjbDescriptor<T> get(String beanName) {
        return (InternalEjbDescriptor)Reflections.cast(this.ejbByName.get(beanName));
    }

    public <T> void add(EjbDescriptor<T> ejbDescriptor) {
        InternalEjbDescriptor<T> internalEjbDescriptor = InternalEjbDescriptor.of(ejbDescriptor);
        this.ejbByName.put(ejbDescriptor.getEjbName(), internalEjbDescriptor);
        this.ejbByClass.put(ejbDescriptor.getBeanClass(), (Object)internalEjbDescriptor.getEjbName());
    }

    public boolean contains(String beanName) {
        return this.ejbByName.containsKey(beanName);
    }

    public boolean contains(Class<?> beanClass) {
        return this.ejbByClass.containsKey(beanClass);
    }

    public <T> InternalEjbDescriptor<T> getUnique(Class<T> beanClass) {
        Set ejbs = this.ejbByClass.get(beanClass);
        if (ejbs.size() > 1) {
            throw BeanLogger.LOG.tooManyEjbsForClass(beanClass, ejbs);
        }
        if (ejbs.size() == 0) {
            return null;
        }
        return this.get((String)ejbs.iterator().next());
    }

    public void addAll(Iterable<EjbDescriptor<?>> ejbDescriptors) {
        for (EjbDescriptor<?> ejbDescriptor : ejbDescriptors) {
            this.add(ejbDescriptor);
        }
    }

    public void clear() {
        this.ejbByName.clear();
    }

    @Override
    public Iterator<InternalEjbDescriptor<?>> iterator() {
        return this.ejbByName.values().iterator();
    }

    @Override
    public void cleanup() {
        this.ejbByClass.clear();
        this.ejbByName.clear();
    }
}

