/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.execution;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.model.Profile;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.transfer.TransferListener;

public class DefaultMavenExecutionRequest
implements MavenExecutionRequest {
    private RepositoryCache repositoryCache = new DefaultRepositoryCache();
    private WorkspaceReader workspaceReader;
    private ArtifactRepository localRepository;
    private File localRepositoryPath;
    private boolean offline = false;
    private boolean interactiveMode = true;
    private boolean cacheTransferError;
    private boolean cacheNotFound;
    private List<Proxy> proxies;
    private List<Server> servers;
    private List<Mirror> mirrors;
    private List<Profile> profiles;
    private List<String> pluginGroups;
    private boolean isProjectPresent = true;
    private File userSettingsFile;
    private File globalSettingsFile;
    private File userToolchainsFile;
    private File basedir;
    private List<String> goals;
    private boolean useReactor = false;
    private boolean recursive = true;
    private File pom;
    private String reactorFailureBehavior = "FAIL_FAST";
    private List<String> selectedProjects;
    private List<String> excludedProjects;
    private String resumeFrom;
    private String makeBehavior;
    private Properties systemProperties;
    private Properties userProperties;
    private Date startTime;
    private boolean showErrors = false;
    private List<String> activeProfiles;
    private List<String> inactiveProfiles;
    private TransferListener transferListener;
    private int loggingLevel = 1;
    private String globalChecksumPolicy;
    private boolean updateSnapshots = false;
    private List<ArtifactRepository> remoteRepositories;
    private List<ArtifactRepository> pluginArtifactRepositories;
    private ExecutionListener executionListener;
    private int degreeOfConcurrency = 1;
    private String builderId = "singlethreaded";
    private boolean noSnapshotUpdates;
    private boolean useSimpleLocalRepositoryManager = false;
    private ProjectBuildingRequest projectBuildingRequest;

    public static MavenExecutionRequest copy(MavenExecutionRequest original) {
        DefaultMavenExecutionRequest copy = new DefaultMavenExecutionRequest();
        copy.setLocalRepository(original.getLocalRepository());
        copy.setLocalRepositoryPath(original.getLocalRepositoryPath());
        copy.setOffline(original.isOffline());
        copy.setInteractiveMode(original.isInteractiveMode());
        copy.setCacheNotFound(original.isCacheNotFound());
        copy.setCacheTransferError(original.isCacheTransferError());
        copy.setProxies(original.getProxies());
        copy.setServers(original.getServers());
        copy.setMirrors(original.getMirrors());
        copy.setProfiles(original.getProfiles());
        copy.setPluginGroups(original.getPluginGroups());
        copy.setProjectPresent(original.isProjectPresent());
        copy.setUserSettingsFile(original.getUserSettingsFile());
        copy.setGlobalSettingsFile(original.getGlobalSettingsFile());
        copy.setUserToolchainsFile(original.getUserToolchainsFile());
        copy.setBaseDirectory(original.getBaseDirectory() != null ? new File(original.getBaseDirectory()) : null);
        copy.setGoals(original.getGoals());
        copy.setRecursive(original.isRecursive());
        copy.setPom(original.getPom());
        copy.setSystemProperties(original.getSystemProperties());
        copy.setUserProperties(original.getUserProperties());
        copy.setShowErrors(original.isShowErrors());
        copy.setActiveProfiles(original.getActiveProfiles());
        copy.setInactiveProfiles(original.getInactiveProfiles());
        copy.setTransferListener(original.getTransferListener());
        copy.setLoggingLevel(original.getLoggingLevel());
        copy.setGlobalChecksumPolicy(original.getGlobalChecksumPolicy());
        copy.setUpdateSnapshots(original.isUpdateSnapshots());
        copy.setRemoteRepositories(original.getRemoteRepositories());
        copy.setPluginArtifactRepositories(original.getPluginArtifactRepositories());
        copy.setRepositoryCache(original.getRepositoryCache());
        copy.setWorkspaceReader(original.getWorkspaceReader());
        copy.setNoSnapshotUpdates(original.isNoSnapshotUpdates());
        copy.setExecutionListener(original.getExecutionListener());
        return copy;
    }

    @Override
    public String getBaseDirectory() {
        if (this.basedir == null) {
            return null;
        }
        return this.basedir.getAbsolutePath();
    }

    @Override
    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    @Override
    public File getLocalRepositoryPath() {
        return this.localRepositoryPath;
    }

    @Override
    public List<String> getGoals() {
        if (this.goals == null) {
            this.goals = new ArrayList<String>();
        }
        return this.goals;
    }

    @Override
    public Properties getSystemProperties() {
        if (this.systemProperties == null) {
            this.systemProperties = new Properties();
        }
        return this.systemProperties;
    }

    @Override
    public Properties getUserProperties() {
        if (this.userProperties == null) {
            this.userProperties = new Properties();
        }
        return this.userProperties;
    }

    @Override
    public File getPom() {
        return this.pom;
    }

    @Override
    public String getReactorFailureBehavior() {
        return this.reactorFailureBehavior;
    }

    @Override
    public List<String> getSelectedProjects() {
        if (this.selectedProjects == null) {
            this.selectedProjects = new ArrayList<String>();
        }
        return this.selectedProjects;
    }

    @Override
    public List<String> getExcludedProjects() {
        if (this.excludedProjects == null) {
            this.excludedProjects = new ArrayList<String>();
        }
        return this.excludedProjects;
    }

    @Override
    public String getResumeFrom() {
        return this.resumeFrom;
    }

    @Override
    public String getMakeBehavior() {
        return this.makeBehavior;
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public boolean isShowErrors() {
        return this.showErrors;
    }

    @Override
    public boolean isInteractiveMode() {
        return this.interactiveMode;
    }

    @Override
    public MavenExecutionRequest setActiveProfiles(List<String> activeProfiles) {
        this.activeProfiles = activeProfiles != null ? new ArrayList<String>(activeProfiles) : null;
        return this;
    }

    @Override
    public MavenExecutionRequest setInactiveProfiles(List<String> inactiveProfiles) {
        this.inactiveProfiles = inactiveProfiles != null ? new ArrayList<String>(inactiveProfiles) : null;
        return this;
    }

    @Override
    public MavenExecutionRequest setRemoteRepositories(List<ArtifactRepository> remoteRepositories) {
        this.remoteRepositories = remoteRepositories != null ? new ArrayList<ArtifactRepository>(remoteRepositories) : null;
        return this;
    }

    @Override
    public MavenExecutionRequest setPluginArtifactRepositories(List<ArtifactRepository> pluginArtifactRepositories) {
        this.pluginArtifactRepositories = pluginArtifactRepositories != null ? new ArrayList<ArtifactRepository>(pluginArtifactRepositories) : null;
        return this;
    }

    public void setProjectBuildingConfiguration(ProjectBuildingRequest projectBuildingConfiguration) {
        this.projectBuildingRequest = projectBuildingConfiguration;
    }

    @Override
    public List<String> getActiveProfiles() {
        if (this.activeProfiles == null) {
            this.activeProfiles = new ArrayList<String>();
        }
        return this.activeProfiles;
    }

    @Override
    public List<String> getInactiveProfiles() {
        if (this.inactiveProfiles == null) {
            this.inactiveProfiles = new ArrayList<String>();
        }
        return this.inactiveProfiles;
    }

    @Override
    public TransferListener getTransferListener() {
        return this.transferListener;
    }

    @Override
    public int getLoggingLevel() {
        return this.loggingLevel;
    }

    @Override
    public boolean isOffline() {
        return this.offline;
    }

    @Override
    public boolean isUpdateSnapshots() {
        return this.updateSnapshots;
    }

    @Override
    public boolean isNoSnapshotUpdates() {
        return this.noSnapshotUpdates;
    }

    @Override
    public String getGlobalChecksumPolicy() {
        return this.globalChecksumPolicy;
    }

    @Override
    public boolean isRecursive() {
        return this.recursive;
    }

    @Override
    public MavenExecutionRequest setBaseDirectory(File basedir) {
        this.basedir = basedir;
        return this;
    }

    @Override
    public MavenExecutionRequest setStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    @Override
    public MavenExecutionRequest setShowErrors(boolean showErrors) {
        this.showErrors = showErrors;
        return this;
    }

    @Override
    public MavenExecutionRequest setGoals(List<String> goals) {
        this.goals = goals != null ? new ArrayList<String>(goals) : null;
        return this;
    }

    @Override
    public MavenExecutionRequest setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
        if (localRepository != null) {
            this.setLocalRepositoryPath(new File(localRepository.getBasedir()).getAbsoluteFile());
        }
        return this;
    }

    @Override
    public MavenExecutionRequest setLocalRepositoryPath(File localRepository) {
        this.localRepositoryPath = localRepository;
        return this;
    }

    @Override
    public MavenExecutionRequest setLocalRepositoryPath(String localRepository) {
        this.localRepositoryPath = localRepository != null ? new File(localRepository) : null;
        return this;
    }

    @Override
    public MavenExecutionRequest setSystemProperties(Properties properties) {
        if (properties != null) {
            this.systemProperties = new Properties();
            this.systemProperties.putAll((Map<?, ?>)properties);
        } else {
            this.systemProperties = null;
        }
        return this;
    }

    @Override
    public MavenExecutionRequest setUserProperties(Properties userProperties) {
        if (userProperties != null) {
            this.userProperties = new Properties();
            this.userProperties.putAll((Map<?, ?>)userProperties);
        } else {
            this.userProperties = null;
        }
        return this;
    }

    @Override
    public MavenExecutionRequest setReactorFailureBehavior(String failureBehavior) {
        this.reactorFailureBehavior = failureBehavior;
        return this;
    }

    @Override
    public MavenExecutionRequest setSelectedProjects(List<String> selectedProjects) {
        this.selectedProjects = selectedProjects != null ? new ArrayList<String>(selectedProjects) : null;
        return this;
    }

    @Override
    public MavenExecutionRequest setExcludedProjects(List<String> excludedProjects) {
        this.excludedProjects = excludedProjects != null ? new ArrayList<String>(excludedProjects) : null;
        return this;
    }

    @Override
    public MavenExecutionRequest setResumeFrom(String project) {
        this.resumeFrom = project;
        return this;
    }

    @Override
    public MavenExecutionRequest setMakeBehavior(String makeBehavior) {
        this.makeBehavior = makeBehavior;
        return this;
    }

    @Override
    public MavenExecutionRequest addActiveProfile(String profile) {
        if (!this.getActiveProfiles().contains(profile)) {
            this.getActiveProfiles().add(profile);
        }
        return this;
    }

    @Override
    public MavenExecutionRequest addInactiveProfile(String profile) {
        if (!this.getInactiveProfiles().contains(profile)) {
            this.getInactiveProfiles().add(profile);
        }
        return this;
    }

    @Override
    public MavenExecutionRequest addActiveProfiles(List<String> profiles) {
        for (String profile : profiles) {
            this.addActiveProfile(profile);
        }
        return this;
    }

    @Override
    public MavenExecutionRequest addInactiveProfiles(List<String> profiles) {
        for (String profile : profiles) {
            this.addInactiveProfile(profile);
        }
        return this;
    }

    public MavenExecutionRequest setUseReactor(boolean reactorActive) {
        this.useReactor = reactorActive;
        return this;
    }

    public boolean useReactor() {
        return this.useReactor;
    }

    public MavenExecutionRequest setPomFile(String pomFilename) {
        if (pomFilename != null) {
            this.pom = new File(pomFilename);
        }
        return this;
    }

    @Override
    public MavenExecutionRequest setPom(File pom) {
        this.pom = pom;
        return this;
    }

    @Override
    public MavenExecutionRequest setInteractiveMode(boolean interactive) {
        this.interactiveMode = interactive;
        return this;
    }

    @Override
    public MavenExecutionRequest setTransferListener(TransferListener transferListener) {
        this.transferListener = transferListener;
        return this;
    }

    @Override
    public MavenExecutionRequest setLoggingLevel(int loggingLevel) {
        this.loggingLevel = loggingLevel;
        return this;
    }

    @Override
    public MavenExecutionRequest setOffline(boolean offline) {
        this.offline = offline;
        return this;
    }

    @Override
    public MavenExecutionRequest setUpdateSnapshots(boolean updateSnapshots) {
        this.updateSnapshots = updateSnapshots;
        return this;
    }

    @Override
    public MavenExecutionRequest setNoSnapshotUpdates(boolean noSnapshotUpdates) {
        this.noSnapshotUpdates = noSnapshotUpdates;
        return this;
    }

    @Override
    public MavenExecutionRequest setGlobalChecksumPolicy(String globalChecksumPolicy) {
        this.globalChecksumPolicy = globalChecksumPolicy;
        return this;
    }

    @Override
    public List<Proxy> getProxies() {
        if (this.proxies == null) {
            this.proxies = new ArrayList<Proxy>();
        }
        return this.proxies;
    }

    @Override
    public MavenExecutionRequest setProxies(List<Proxy> proxies) {
        this.proxies = proxies != null ? new ArrayList<Proxy>(proxies) : null;
        return this;
    }

    @Override
    public MavenExecutionRequest addProxy(Proxy proxy) {
        if (proxy == null) {
            throw new IllegalArgumentException("proxy missing");
        }
        for (Proxy p : this.getProxies()) {
            if (p.getId() == null || !p.getId().equals(proxy.getId())) continue;
            return this;
        }
        this.getProxies().add(proxy);
        return this;
    }

    @Override
    public List<Server> getServers() {
        if (this.servers == null) {
            this.servers = new ArrayList<Server>();
        }
        return this.servers;
    }

    @Override
    public MavenExecutionRequest setServers(List<Server> servers) {
        this.servers = servers != null ? new ArrayList<Server>(servers) : null;
        return this;
    }

    @Override
    public MavenExecutionRequest addServer(Server server) {
        if (server == null) {
            throw new IllegalArgumentException("server missing");
        }
        for (Server p : this.getServers()) {
            if (p.getId() == null || !p.getId().equals(server.getId())) continue;
            return this;
        }
        this.getServers().add(server);
        return this;
    }

    @Override
    public List<Mirror> getMirrors() {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList<Mirror>();
        }
        return this.mirrors;
    }

    @Override
    public MavenExecutionRequest setMirrors(List<Mirror> mirrors) {
        this.mirrors = mirrors != null ? new ArrayList<Mirror>(mirrors) : null;
        return this;
    }

    @Override
    public MavenExecutionRequest addMirror(Mirror mirror) {
        if (mirror == null) {
            throw new IllegalArgumentException("mirror missing");
        }
        for (Mirror p : this.getMirrors()) {
            if (p.getId() == null || !p.getId().equals(mirror.getId())) continue;
            return this;
        }
        this.getMirrors().add(mirror);
        return this;
    }

    @Override
    public List<Profile> getProfiles() {
        if (this.profiles == null) {
            this.profiles = new ArrayList<Profile>();
        }
        return this.profiles;
    }

    @Override
    public MavenExecutionRequest setProfiles(List<Profile> profiles) {
        this.profiles = profiles != null ? new ArrayList<Profile>(profiles) : null;
        return this;
    }

    @Override
    public List<String> getPluginGroups() {
        if (this.pluginGroups == null) {
            this.pluginGroups = new ArrayList<String>();
        }
        return this.pluginGroups;
    }

    @Override
    public MavenExecutionRequest setPluginGroups(List<String> pluginGroups) {
        this.pluginGroups = pluginGroups != null ? new ArrayList<String>(pluginGroups) : null;
        return this;
    }

    @Override
    public MavenExecutionRequest addPluginGroup(String pluginGroup) {
        if (!this.getPluginGroups().contains(pluginGroup)) {
            this.getPluginGroups().add(pluginGroup);
        }
        return this;
    }

    @Override
    public MavenExecutionRequest addPluginGroups(List<String> pluginGroups) {
        for (String pluginGroup : pluginGroups) {
            this.addPluginGroup(pluginGroup);
        }
        return this;
    }

    @Override
    public MavenExecutionRequest setRecursive(boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    @Override
    public boolean isProjectPresent() {
        return this.isProjectPresent;
    }

    @Override
    public MavenExecutionRequest setProjectPresent(boolean projectPresent) {
        this.isProjectPresent = projectPresent;
        return this;
    }

    @Override
    public File getUserSettingsFile() {
        return this.userSettingsFile;
    }

    @Override
    public MavenExecutionRequest setUserSettingsFile(File userSettingsFile) {
        this.userSettingsFile = userSettingsFile;
        return this;
    }

    @Override
    public File getGlobalSettingsFile() {
        return this.globalSettingsFile;
    }

    @Override
    public MavenExecutionRequest setGlobalSettingsFile(File globalSettingsFile) {
        this.globalSettingsFile = globalSettingsFile;
        return this;
    }

    @Override
    public File getUserToolchainsFile() {
        return this.userToolchainsFile;
    }

    @Override
    public MavenExecutionRequest setUserToolchainsFile(File userToolchainsFile) {
        this.userToolchainsFile = userToolchainsFile;
        return this;
    }

    @Override
    public MavenExecutionRequest addRemoteRepository(ArtifactRepository repository) {
        for (ArtifactRepository repo : this.getRemoteRepositories()) {
            if (repo.getId() == null || !repo.getId().equals(repository.getId())) continue;
            return this;
        }
        this.getRemoteRepositories().add(repository);
        return this;
    }

    @Override
    public List<ArtifactRepository> getRemoteRepositories() {
        if (this.remoteRepositories == null) {
            this.remoteRepositories = new ArrayList<ArtifactRepository>();
        }
        return this.remoteRepositories;
    }

    @Override
    public MavenExecutionRequest addPluginArtifactRepository(ArtifactRepository repository) {
        for (ArtifactRepository repo : this.getPluginArtifactRepositories()) {
            if (repo.getId() == null || !repo.getId().equals(repository.getId())) continue;
            return this;
        }
        this.getPluginArtifactRepositories().add(repository);
        return this;
    }

    @Override
    public List<ArtifactRepository> getPluginArtifactRepositories() {
        if (this.pluginArtifactRepositories == null) {
            this.pluginArtifactRepositories = new ArrayList<ArtifactRepository>();
        }
        return this.pluginArtifactRepositories;
    }

    @Override
    public ProjectBuildingRequest getProjectBuildingRequest() {
        if (this.projectBuildingRequest == null) {
            this.projectBuildingRequest = new DefaultProjectBuildingRequest();
            this.projectBuildingRequest.setLocalRepository(this.getLocalRepository());
            this.projectBuildingRequest.setSystemProperties(this.getSystemProperties());
            this.projectBuildingRequest.setUserProperties(this.getUserProperties());
            this.projectBuildingRequest.setRemoteRepositories(this.getRemoteRepositories());
            this.projectBuildingRequest.setPluginArtifactRepositories(this.getPluginArtifactRepositories());
            this.projectBuildingRequest.setActiveProfileIds(this.getActiveProfiles());
            this.projectBuildingRequest.setInactiveProfileIds(this.getInactiveProfiles());
            this.projectBuildingRequest.setProfiles(this.getProfiles());
            this.projectBuildingRequest.setProcessPlugins(true);
            this.projectBuildingRequest.setBuildStartTime(this.getStartTime());
        }
        return this.projectBuildingRequest;
    }

    @Override
    public MavenExecutionRequest addProfile(Profile profile) {
        if (profile == null) {
            throw new IllegalArgumentException("profile missing");
        }
        for (Profile p : this.getProfiles()) {
            if (p.getId() == null || !p.getId().equals(profile.getId())) continue;
            return this;
        }
        this.getProfiles().add(profile);
        return this;
    }

    @Override
    public RepositoryCache getRepositoryCache() {
        return this.repositoryCache;
    }

    @Override
    public MavenExecutionRequest setRepositoryCache(RepositoryCache repositoryCache) {
        this.repositoryCache = repositoryCache;
        return this;
    }

    @Override
    public ExecutionListener getExecutionListener() {
        return this.executionListener;
    }

    @Override
    public MavenExecutionRequest setExecutionListener(ExecutionListener executionListener) {
        this.executionListener = executionListener;
        return this;
    }

    @Override
    public void setDegreeOfConcurrency(int degreeOfConcurrency) {
        this.degreeOfConcurrency = degreeOfConcurrency;
    }

    @Override
    public int getDegreeOfConcurrency() {
        return this.degreeOfConcurrency;
    }

    @Override
    public WorkspaceReader getWorkspaceReader() {
        return this.workspaceReader;
    }

    @Override
    public MavenExecutionRequest setWorkspaceReader(WorkspaceReader workspaceReader) {
        this.workspaceReader = workspaceReader;
        return this;
    }

    @Override
    public boolean isCacheTransferError() {
        return this.cacheTransferError;
    }

    @Override
    public MavenExecutionRequest setCacheTransferError(boolean cacheTransferError) {
        this.cacheTransferError = cacheTransferError;
        return this;
    }

    @Override
    public boolean isCacheNotFound() {
        return this.cacheNotFound;
    }

    @Override
    public MavenExecutionRequest setCacheNotFound(boolean cacheNotFound) {
        this.cacheNotFound = cacheNotFound;
        return this;
    }

    @Override
    public boolean isUseLegacyLocalRepository() {
        return this.useSimpleLocalRepositoryManager;
    }

    @Override
    public MavenExecutionRequest setUseLegacyLocalRepository(boolean useSimpleLocalRepositoryManager) {
        this.useSimpleLocalRepositoryManager = useSimpleLocalRepositoryManager;
        return this;
    }

    @Override
    public MavenExecutionRequest setBuilderId(String builderId) {
        this.builderId = builderId;
        return this;
    }

    @Override
    public String getBuilderId() {
        return this.builderId;
    }
}

