/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.config.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.runtime.manager.impl.RuntimeEngineImpl;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.event.kiebase.KieBaseEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.api.runtime.process.WorkItemHandler;
import org.switchyard.ServiceDomain;
import org.switchyard.component.common.knowledge.config.builder.KnowledgeBuilder;
import org.switchyard.component.common.knowledge.config.builder.ListenerBuilder;
import org.switchyard.component.common.knowledge.config.builder.WorkItemHandlerBuilder;
import org.switchyard.component.common.knowledge.config.items.ExtendedRegisterableItemsFactory;
import org.switchyard.component.common.knowledge.config.items.NoopExtendedRegisterableItemsFactory;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.event.EventPublisherProcessEventListener;

public class RegisterableItemsFactoryBuilder
extends KnowledgeBuilder {
    private final List<ListenerBuilder> _listenerBuilders;
    private final boolean _bpm;
    private final List<WorkItemHandlerBuilder> _workItemHandlerBuilders;

    public RegisterableItemsFactoryBuilder(ClassLoader classLoader, ServiceDomain serviceDomain, KnowledgeComponentImplementationModel implementationModel) {
        super(classLoader, serviceDomain);
        this._listenerBuilders = ListenerBuilder.builders(this.getClassLoader(), implementationModel);
        this._bpm = implementationModel != null && "bpm".equals(implementationModel.getType());
        this._workItemHandlerBuilders = this._bpm ? WorkItemHandlerBuilder.builders(this.getClassLoader(), serviceDomain, implementationModel) : Collections.emptyList();
    }

    public ExtendedRegisterableItemsFactory build() {
        return new NoopExtendedRegisterableItemsFactory(){
            private RuntimeEngine _runtime;
            private List<EventListener> _listeners = new ArrayList<EventListener>();

            private synchronized List<EventListener> listeners(RuntimeEngine runtime) {
                if (this._runtime != runtime) {
                    this._runtime = runtime;
                    this._listeners.clear();
                    KieSession runtimeEventManager = this._runtime.getKieSession();
                    for (ListenerBuilder builder : RegisterableItemsFactoryBuilder.this._listenerBuilders) {
                        EventListener listener = builder.build((KieRuntimeEventManager)runtimeEventManager);
                        if (listener == null || builder.wasAutomaticRegistration()) continue;
                        this._listeners.add(listener);
                    }
                }
                return new ArrayList<EventListener>(this._listeners);
            }

            @Override
            public List<AgendaEventListener> getAgendaEventListeners(RuntimeEngine runtime) {
                ArrayList<AgendaEventListener> list = new ArrayList<AgendaEventListener>();
                for (EventListener listener : this.listeners(runtime)) {
                    if (!(listener instanceof AgendaEventListener)) continue;
                    list.add((AgendaEventListener)listener);
                }
                return list;
            }

            @Override
            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                ArrayList<ProcessEventListener> list = new ArrayList<ProcessEventListener>();
                if (RegisterableItemsFactoryBuilder.this._bpm) {
                    list.add(new EventPublisherProcessEventListener(RegisterableItemsFactoryBuilder.this.getServiceDomain().getEventPublisher()));
                }
                for (EventListener listener : this.listeners(runtime)) {
                    if (!(listener instanceof ProcessEventListener)) continue;
                    list.add((ProcessEventListener)listener);
                }
                return list;
            }

            @Override
            public List<RuleRuntimeEventListener> getRuleRuntimeEventListeners(RuntimeEngine runtime) {
                ArrayList<RuleRuntimeEventListener> list = new ArrayList<RuleRuntimeEventListener>();
                for (EventListener listener : this.listeners(runtime)) {
                    if (!(listener instanceof RuleRuntimeEventListener)) continue;
                    list.add((RuleRuntimeEventListener)listener);
                }
                return list;
            }

            @Override
            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                LinkedHashMap<String, WorkItemHandler> map = new LinkedHashMap<String, WorkItemHandler>();
                for (WorkItemHandlerBuilder builder : RegisterableItemsFactoryBuilder.this._workItemHandlerBuilders) {
                    KieSession processRuntime = runtime.getKieSession();
                    RuntimeManager runtimeManager = null;
                    if (runtime instanceof RuntimeEngineImpl) {
                        runtimeManager = ((RuntimeEngineImpl)runtime).getManager();
                    }
                    String name = builder.getWorkItemHandlerName();
                    WorkItemHandler handler = builder.build((ProcessRuntime)processRuntime, runtimeManager);
                    map.put(name, handler);
                }
                return map;
            }

            @Override
            public List<KieBaseEventListener> getKieBaseEventListeners(RuntimeEngine runtime) {
                ArrayList<KieBaseEventListener> list = new ArrayList<KieBaseEventListener>();
                for (EventListener listener : this.listeners(runtime)) {
                    if (!(listener instanceof KieBaseEventListener)) continue;
                    list.add((KieBaseEventListener)listener);
                }
                return list;
            }
        };
    }
}

