/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.config.builder;

import java.util.ArrayList;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.drools.core.command.CommandService;
import org.drools.core.impl.EnvironmentFactory;
import org.jbpm.runtime.manager.impl.KModuleRegisterableItemsFactory;
import org.jbpm.runtime.manager.impl.SimpleRuntimeEnvironment;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorImpl;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorManager;
import org.jbpm.runtime.manager.impl.mapper.InMemoryMapper;
import org.jbpm.runtime.manager.impl.mapper.JPAMapper;
import org.jbpm.services.task.commands.TaskCommandExecutorImpl;
import org.jbpm.services.task.events.TaskEventSupport;
import org.jbpm.services.task.impl.command.CommandBasedTaskService;
import org.kie.api.KieServices;
import org.kie.api.builder.KieScanner;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilderFactory;
import org.kie.api.task.TaskService;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.runtime.conf.AuditMode;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.manager.InternalRegisterableItemsFactory;
import org.kie.internal.runtime.manager.Mapper;
import org.kie.internal.runtime.manager.TaskServiceFactory;
import org.switchyard.ServiceDomain;
import org.switchyard.common.type.reflect.FieldAccess;
import org.switchyard.component.common.knowledge.config.builder.EntityManagerFactoryBuilder;
import org.switchyard.component.common.knowledge.config.builder.KnowledgeBuilder;
import org.switchyard.component.common.knowledge.config.builder.ManifestBuilder;
import org.switchyard.component.common.knowledge.config.builder.PropertiesBuilder;
import org.switchyard.component.common.knowledge.config.builder.RegisterableItemsFactoryBuilder;
import org.switchyard.component.common.knowledge.config.builder.UserGroupCallbackBuilder;
import org.switchyard.component.common.knowledge.config.builder.patch.PatchedLocalTaskServiceFactory;
import org.switchyard.component.common.knowledge.config.builder.patch.PatchedRuntimeEnvironmentBuilder;
import org.switchyard.component.common.knowledge.config.items.CompoundRegisterableItemsFactory;
import org.switchyard.component.common.knowledge.config.items.ExtendedRegisterableItemsFactory;
import org.switchyard.component.common.knowledge.config.manifest.ContainerManifest;
import org.switchyard.component.common.knowledge.config.manifest.Manifest;
import org.switchyard.component.common.knowledge.config.manifest.RemoteManifest;
import org.switchyard.component.common.knowledge.config.manifest.ResourcesManifest;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.serial.SerializerObjectMarshallingStrategy;
import org.switchyard.component.common.knowledge.transaction.TransactionManagerLocator;
import org.switchyard.serial.FormatType;
import org.switchyard.serial.SerializerFactory;

public class RuntimeEnvironmentBuilder
extends KnowledgeBuilder {
    private final KieServices _kieServices = KieServices.Factory.get();
    private final RuntimeEnvironmentBuilderFactory _runtimeEnvironmentBuilderFactory = new PatchedRuntimeEnvironmentBuilder();
    private final boolean _persistent;
    private final EntityManagerFactoryBuilder _entityManagerFactoryBuilder;
    private final ManifestBuilder _manifestBuilder;
    private final PropertiesBuilder _propertiesBuilder;
    private final UserGroupCallbackBuilder _userGroupCallbackBuilder;
    private final RegisterableItemsFactoryBuilder _registerableItemsFactoryBuilder;

    public RuntimeEnvironmentBuilder(ClassLoader classLoader, ServiceDomain serviceDomain, KnowledgeComponentImplementationModel implementationModel) {
        super(classLoader, serviceDomain);
        this._persistent = implementationModel != null ? implementationModel.isPersistent() : false;
        this._entityManagerFactoryBuilder = new EntityManagerFactoryBuilder(serviceDomain, this._persistent);
        this._manifestBuilder = ManifestBuilder.builder(this.getClassLoader(), implementationModel);
        this._propertiesBuilder = PropertiesBuilder.builder(implementationModel);
        this._userGroupCallbackBuilder = UserGroupCallbackBuilder.builder(this.getClassLoader(), implementationModel);
        this._registerableItemsFactoryBuilder = new RegisterableItemsFactoryBuilder(this.getClassLoader(), serviceDomain, implementationModel);
    }

    public RuntimeEnvironment build() {
        org.kie.api.runtime.manager.RuntimeEnvironmentBuilder jbpmRuntimeEnvironmentBuilder;
        Manifest manifest = this._manifestBuilder.build();
        if (manifest instanceof RemoteManifest) {
            RemoteManifest remoteManifest = (RemoteManifest)manifest;
            org.kie.api.runtime.manager.RuntimeEnvironmentBuilder jbpmRuntimeEnvironmentBuilder2 = this._runtimeEnvironmentBuilderFactory.newDefaultInMemoryBuilder();
            remoteManifest.addToEnvironment(jbpmRuntimeEnvironmentBuilder2);
            return jbpmRuntimeEnvironmentBuilder2.get();
        }
        if (manifest instanceof ContainerManifest) {
            ContainerManifest containerManifest = (ContainerManifest)manifest;
            String baseName = containerManifest.getBaseName();
            ReleaseId releaseId = containerManifest.getReleaseId();
            String sessionName = containerManifest.getSessionName();
            if (releaseId != null) {
                jbpmRuntimeEnvironmentBuilder = baseName != null || sessionName != null ? this._runtimeEnvironmentBuilderFactory.newDefaultBuilder(releaseId, baseName, sessionName) : this._runtimeEnvironmentBuilderFactory.newDefaultBuilder(releaseId);
                containerManifest.addToEnvironment(jbpmRuntimeEnvironmentBuilder);
            } else {
                jbpmRuntimeEnvironmentBuilder = baseName != null || sessionName != null ? this._runtimeEnvironmentBuilderFactory.newClasspathKmoduleDefaultBuilder(baseName, sessionName) : this._runtimeEnvironmentBuilderFactory.newClasspathKmoduleDefaultBuilder();
            }
        } else {
            jbpmRuntimeEnvironmentBuilder = this._persistent ? this._runtimeEnvironmentBuilderFactory.newDefaultBuilder() : this._runtimeEnvironmentBuilderFactory.newDefaultInMemoryBuilder();
            if (manifest instanceof ResourcesManifest) {
                ResourcesManifest resourcesManifest = (ResourcesManifest)manifest;
                for (Resource resource : resourcesManifest.buildResources()) {
                    jbpmRuntimeEnvironmentBuilder.addAsset(resource, resource.getResourceType());
                }
            }
        }
        jbpmRuntimeEnvironmentBuilder.classLoader(this.getClassLoader());
        jbpmRuntimeEnvironmentBuilder.persistence(this._persistent);
        EntityManagerFactory entityManagerFactory = this._entityManagerFactoryBuilder.build();
        jbpmRuntimeEnvironmentBuilder.entityManagerFactory((Object)entityManagerFactory);
        jbpmRuntimeEnvironmentBuilder.addEnvironmentEntry("org.kie.api.persistence.jpa.EntityManagerFactory", (Object)entityManagerFactory);
        UserGroupCallback userGroupCallback = this._userGroupCallbackBuilder.build();
        jbpmRuntimeEnvironmentBuilder.userGroupCallback(userGroupCallback);
        if (this._persistent) {
            UserTransaction ut = TransactionManagerLocator.INSTANCE.getUserTransaction();
            TransactionManager tm = TransactionManagerLocator.INSTANCE.getTransactionManager();
            jbpmRuntimeEnvironmentBuilder.addEnvironmentEntry("org.kie.transaction.Transaction", (Object)ut);
            jbpmRuntimeEnvironmentBuilder.addEnvironmentEntry("org.kie.transaction.TransactionManager", (Object)tm);
        } else {
            jbpmRuntimeEnvironmentBuilder.addEnvironmentEntry("IS_JTA_TRANSACTION", (Object)Boolean.FALSE);
            TaskEventSupport taskEventSupport = new TaskEventSupport();
            TaskCommandExecutorImpl executor = new TaskCommandExecutorImpl(EnvironmentFactory.newEnvironment(), taskEventSupport);
            jbpmRuntimeEnvironmentBuilder.addEnvironmentEntry(TaskService.class.getName(), (Object)new CommandBasedTaskService((CommandService)executor, taskEventSupport));
        }
        Properties properties = this._propertiesBuilder.build();
        for (Object key : properties.keySet()) {
            String name = (String)key;
            String value = properties.getProperty(name);
            jbpmRuntimeEnvironmentBuilder.addConfiguration(name, value);
            jbpmRuntimeEnvironmentBuilder.addEnvironmentEntry(name, (Object)value);
        }
        KieScanner scanner = null;
        SimpleRuntimeEnvironment originalRE = ((PatchedRuntimeEnvironmentBuilder)jbpmRuntimeEnvironmentBuilder).getRuntimeEnvironment();
        if (originalRE != null) {
            AuditMode auditMode;
            InMemoryMapper mapper;
            RegisterableItemsFactory originalRIF = originalRE.getRegisterableItemsFactory();
            if (originalRIF instanceof InternalRegisterableItemsFactory) {
                FieldAccess kieContainerAccess;
                ExtendedRegisterableItemsFactory extendedRIF = this._registerableItemsFactoryBuilder.build();
                CompoundRegisterableItemsFactory compoundRIF = new CompoundRegisterableItemsFactory((InternalRegisterableItemsFactory)originalRIF, new RegisterableItemsFactory[]{extendedRIF});
                jbpmRuntimeEnvironmentBuilder.registerableItemsFactory((RegisterableItemsFactory)compoundRIF);
                ExtendedRegisterableItemsFactory.Env.addToEnvironment(jbpmRuntimeEnvironmentBuilder, compoundRIF);
                if (manifest instanceof ContainerManifest && originalRIF instanceof KModuleRegisterableItemsFactory && (kieContainerAccess = new FieldAccess(KModuleRegisterableItemsFactory.class, "kieContainer")).isReadable()) {
                    KieContainer kieContainer = (KieContainer)kieContainerAccess.read((Object)originalRIF);
                    ((ContainerManifest)manifest).setKieContainer(kieContainer);
                    if (((ContainerManifest)manifest).isScan()) {
                        scanner = this._kieServices.newKieScanner(kieContainer);
                        scanner.start(((ContainerManifest)manifest).getScanInterval().longValue());
                    }
                }
            }
            if (this._persistent) {
                mapper = new JPAMapper(entityManagerFactory);
                auditMode = AuditMode.JPA;
            } else {
                mapper = new InMemoryMapper();
                auditMode = AuditMode.NONE;
            }
            originalRE.setMapper((Mapper)mapper);
            Environment environmentTemplate = originalRE.getEnvironmentTemplate();
            originalRE.addToEnvironment(TaskServiceFactory.class.getName(), (Object)new PatchedLocalTaskServiceFactory((RuntimeEnvironment)originalRE));
            DeploymentDescriptor deploymentDescriptor = (DeploymentDescriptor)environmentTemplate.get("KieDeploymentDescriptor");
            if (deploymentDescriptor == null) {
                deploymentDescriptor = new DeploymentDescriptorManager().getDefaultDescriptor();
                originalRE.addToEnvironment("KieDeploymentDescriptor", (Object)deploymentDescriptor);
            }
            originalRE.addToEnvironment(manifest.getClass().getName(), (Object)manifest);
            ((DeploymentDescriptorImpl)deploymentDescriptor).setAuditMode(auditMode);
            if (scanner != null) {
                originalRE.addToEnvironment("KieScanner", scanner);
            }
        }
        RuntimeEnvironment runtimeEnvironment = jbpmRuntimeEnvironmentBuilder.get();
        Environment environment = originalRE.getEnvironmentTemplate();
        ArrayList<ObjectMarshallingStrategy> new_oms = new ArrayList<ObjectMarshallingStrategy>();
        new_oms.add(new SerializerObjectMarshallingStrategy(SerializerFactory.create((FormatType)FormatType.JSON, null, (boolean)true)));
        ObjectMarshallingStrategy[] old_oms = (ObjectMarshallingStrategy[])environment.get("org.kie.api.marshalling.ObjectMarshallingStrategies");
        if (old_oms != null) {
            for (int i = 0; i < old_oms.length; ++i) {
                if (old_oms[i] == null) continue;
                new_oms.add(old_oms[i]);
            }
        }
        originalRE.addToEnvironment("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)new_oms.toArray(new ObjectMarshallingStrategy[new_oms.size()]));
        return runtimeEnvironment;
    }
}

