/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.config.builder;

import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.switchyard.ServiceDomain;
import org.switchyard.component.common.knowledge.config.builder.KnowledgeBuilder;
import org.switchyard.component.common.knowledge.config.builder.RuntimeEnvironmentBuilder;
import org.switchyard.component.common.knowledge.config.manifest.RemoteManifest;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.runtime.KnowledgeRuntimeManagerType;
import org.switchyard.component.common.knowledge.runtime.remote.RemoteRuntimeManager;

public class RuntimeManagerBuilder
extends KnowledgeBuilder {
    private final RuntimeManagerFactory _runtimeManagerFactory;
    private final RuntimeEnvironmentBuilder _runtimeEnvironmentBuilder;

    public RuntimeManagerBuilder(ClassLoader classLoader, ServiceDomain serviceDomain, KnowledgeComponentImplementationModel implementationModel) {
        super(classLoader, serviceDomain);
        this._runtimeManagerFactory = RuntimeManagerFactory.Factory.get((ClassLoader)classLoader);
        this._runtimeEnvironmentBuilder = new RuntimeEnvironmentBuilder(this.getClassLoader(), serviceDomain, implementationModel);
    }

    public RuntimeManager build(KnowledgeRuntimeManagerType type, String identifier) {
        RemoteRuntimeManager runtimeManager;
        RuntimeEnvironment runtimeEnvironment = this._runtimeEnvironmentBuilder.build();
        RemoteManifest remoteManifest = RemoteManifest.removeFromEnvironment(runtimeEnvironment.getEnvironment());
        if (remoteManifest != null) {
            runtimeManager = new RemoteRuntimeManager(remoteManifest.buildConfiguration(), identifier);
        } else {
            switch (type) {
                case SINGLETON: {
                    runtimeManager = this._runtimeManagerFactory.newSingletonRuntimeManager(runtimeEnvironment, identifier);
                    break;
                }
                case PER_REQUEST: {
                    runtimeManager = this._runtimeManagerFactory.newPerRequestRuntimeManager(runtimeEnvironment, identifier);
                    break;
                }
                case PER_PROCESS_INSTANCE: {
                    runtimeManager = this._runtimeManagerFactory.newPerProcessInstanceRuntimeManager(runtimeEnvironment, identifier);
                    break;
                }
                default: {
                    runtimeManager = null;
                }
            }
        }
        return runtimeManager;
    }
}

