/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.ResourceFinder;

public class DefaultResourceFinder
implements ResourceFinder {
    private static final Log __log = LogFactory.getLog(DefaultResourceFinder.class);
    private File _relativeDir;
    private File _absoluteDir;

    public DefaultResourceFinder() {
        this._relativeDir = this._absoluteDir = new File("");
    }

    public DefaultResourceFinder(File relativeDir, File absoluteDir) {
        this.checkDir("relativeDir", relativeDir);
        this.checkDir("absoluteDir", absoluteDir);
        this._relativeDir = relativeDir;
        this._absoluteDir = absoluteDir;
    }

    private void checkDir(String arg, File dir) {
        if (dir == null) {
            throw new IllegalArgumentException("Argument '" + arg + "' is null");
        }
        if (!dir.exists()) {
            throw new IllegalArgumentException("Directory does not exist: " + dir);
        }
    }

    @Override
    public InputStream openResource(URI uri) throws MalformedURLException, IOException {
        InputStream r = this.openFileResource(uri = this.relativize(uri));
        if (r != null) {
            return r;
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("trying classpath resource for " + uri));
        }
        if ((r = Thread.currentThread().getContextClassLoader().getResourceAsStream(uri.getPath())) != null) {
            return r;
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("classpath resource not found " + uri));
        }
        return null;
    }

    private InputStream openFileResource(URI uri) throws MalformedURLException, IOException {
        URI absolute = this._absoluteDir.toURI();
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("openResource: uri=" + uri + " relativeDir=" + this._relativeDir + " absoluteDir=" + this._absoluteDir));
        }
        if (uri.isAbsolute() && uri.getScheme().equals("file")) {
            try {
                return uri.toURL().openStream();
            }
            catch (Exception except) {
                __log.debug((Object)("openResource: unable to open file URL " + uri + "; " + except.toString()));
                return null;
            }
        }
        URI relative = this._relativeDir.toURI().relativize(uri);
        if (relative.isAbsolute() && !relative.getScheme().equals("urn")) {
            __log.fatal((Object)("openResource: invalid scheme (should be urn:)  " + uri));
            return null;
        }
        File f = new File(absolute.getPath(), relative.getPath());
        if (f.exists()) {
            return new FileInputStream(f);
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("fileNotFound: " + f));
        }
        return null;
    }

    @Override
    public URI getBaseResourceURI() {
        return this._absoluteDir.toURI();
    }

    private URI relativize(URI u) {
        if (u.isAbsolute()) {
            return this._absoluteDir.toURI().relativize(u);
        }
        return u;
    }

    @Override
    public URI resolve(URI parent, URI child) {
        parent = this.relativize(parent);
        child = this.relativize(child);
        URI result = parent.resolve(child);
        URI result2 = this._absoluteDir.toURI().resolve(result);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("resolving URI: parent " + parent + " child " + child + " result " + result + " resultAbsolute:" + result2));
        }
        return result2;
    }
}

