/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa.hibernate;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.dao.jpa.JpaConnection;
import org.apache.ode.dao.jpa.hibernate.DataSourceConnectionProvider;
import org.apache.ode.dao.jpa.hibernate.OdeJtaPlatform;
import org.apache.ode.utils.GUID;
import org.hibernate.jpa.internal.EntityManagerImpl;

public class HibernateUtil {
    static final Log __log = LogFactory.getLog(HibernateUtil.class);
    public static final String PROP_GUID = "ode.hibernate.guid";
    private static final Map<String, TransactionManager> _txManagers = Collections.synchronizedMap(new HashMap());
    private static final Map<String, DataSource> _dataSources = Collections.synchronizedMap(new HashMap());

    public static void registerTransactionManager(String uuid, TransactionManager txm) {
        _txManagers.put(uuid, txm);
    }

    public static void registerDatasource(String uuid, DataSource ds) {
        _dataSources.put(uuid, ds);
    }

    public static TransactionManager getTransactionManager(Properties props) {
        String guid = props.getProperty(PROP_GUID);
        TransactionManager mgr = _txManagers.get(guid);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("guid is: " + guid + ", TransactionManager is: " + mgr));
        }
        return mgr;
    }

    public static Connection getConnection(Properties props) throws SQLException {
        String guid = props.getProperty(PROP_GUID);
        Connection conn = _dataSources.get(guid).getConnection();
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("guid is: " + guid + ", Connection is: " + conn));
        }
        return conn;
    }

    public static Map buildConfig(String prefix, Properties odeConfig, TransactionManager txm, DataSource ds) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("javax.persistence.provider", "org.hibernate.ejb.HibernatePersistence");
        HibernateUtil.addEntries(prefix, odeConfig, props);
        String guid = new GUID().toString();
        if (ds != null) {
            props.put("hibernate.connection.provider_class", DataSourceConnectionProvider.class.getName());
            HibernateUtil.registerDatasource(guid, ds);
        }
        if (txm != null) {
            props.put("hibernate.current_session_context_class", "jta");
            props.put("hibernate.transaction.jta.platform", OdeJtaPlatform.class.getName());
            HibernateUtil.registerTransactionManager(guid, txm);
            props.put("javax.persistence.transactionType", "JTA");
        } else {
            props.put("javax.persistence.transactionType", "RESOURCE_LOCAL");
        }
        if (ds != null || txm != null) {
            props.put(PROP_GUID, guid);
        }
        if (Boolean.valueOf(odeConfig.getProperty("db.emb.create", "true")).booleanValue()) {
            props.put("hibernate.hbm2ddl.auto", "create-drop");
            __log.debug((Object)"create-drop DDL by Hibernate automatically");
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)"========= Hibernate properties ==============");
            for (Object key : props.keySet()) {
                __log.debug((Object)("key : " + key + ", value : " + props.get(key)));
            }
            __log.debug((Object)"==============================================");
        }
        return props;
    }

    private static void addEntries(String prefix, Properties odeConfig, Map props) {
        if (odeConfig != null) {
            for (Map.Entry<Object, Object> me : odeConfig.entrySet()) {
                String key = (String)me.getKey();
                if (key.startsWith(prefix)) {
                    String jpaKey = key.substring(prefix.length() - 1);
                    String val = (String)me.getValue();
                    if (val == null || val.trim().length() == 0) {
                        props.remove(jpaKey);
                        continue;
                    }
                    props.put(jpaKey, me.getValue());
                    continue;
                }
                if (!key.startsWith("hibernate")) continue;
                props.put(key, me.getValue());
            }
        }
    }

    public static boolean isOpen(JpaConnection conn) {
        EntityManager mgr = conn.getEntityManager();
        if (mgr == null) {
            return false;
        }
        if (mgr instanceof EntityManagerImpl) {
            EntityManagerImpl mgrImpl = (EntityManagerImpl)mgr;
            return mgrImpl.isOpen();
        }
        return !conn.isClosed();
    }
}

