
    select execute_if_not_exists('create table BPEL_ACTIVITY_RECOVERY (
        ID int8 not null,
        ACTIONS varchar(255),
        ACTIVITY_ID int8,
        CHANNEL varchar(255),
        DATE_TIME timestamp,
        DETAILS text,
        INSTANCE_ID int8,
        REASON varchar(255),
        RETRIES int4,
        primary key (ID)
    )');

    select execute_if_not_exists('create table BPEL_CORRELATION_SET (
        CORRELATION_SET_ID int8 not null,
        CORRELATION_KEY varchar(255),
        NAME varchar(255),
        SCOPE_ID int8,
        primary key (CORRELATION_SET_ID)
    )');

    select execute_if_not_exists('create table BPEL_CORRELATOR (
        CORRELATOR_ID int8 not null,
        CORRELATOR_KEY varchar(255),
        PROC_ID int8,
        primary key (CORRELATOR_ID)
    )');

    select execute_if_not_exists('create table BPEL_CORSET_PROP (
        ID int8 not null,
        CORRSET_ID int8,
        PROP_KEY varchar(255),
        PROP_VALUE varchar(255),
        primary key (ID)
    )');

    select execute_if_not_exists('create table BPEL_EVENT (
        EVENT_ID int8 not null,
        DETAIL varchar(255),
        DATA oid,
        SCOPE_ID int8,
        TSTAMP timestamp,
        TYPE varchar(255),
        INSTANCE_ID int8,
        PROCESS_ID int8,
        primary key (EVENT_ID)
    )');

    select execute_if_not_exists('create table BPEL_FAULT (
        FAULT_ID int8 not null,
        ACTIVITY_ID int4,
        DATA text,
        MESSAGE text,
        LINE_NUMBER int4,
        NAME varchar(255),
        primary key (FAULT_ID)
    )');

    select execute_if_not_exists('create table BPEL_MESSAGE (
        MESSAGE_ID int8 not null,
        DATA text,
        HEADER text,
        TYPE varchar(255),
        MESSAGE_EXCHANGE_ID varchar(255),
        primary key (MESSAGE_ID)
    )');

    select execute_if_not_exists('create table BPEL_MESSAGE_EXCHANGE (
        MESSAGE_EXCHANGE_ID varchar(255) not null,
        CALLEE varchar(255),
        CHANNEL varchar(255),
        CORRELATION_ID varchar(255),
        CORRELATION_KEYS varchar(255),
        CORRELATION_STATUS varchar(255),
        CREATE_TIME timestamp,
        DIRECTION char(1),
        EPR text,
        FAULT varchar(255),
        FAULT_EXPLANATION varchar(255),
        OPERATION varchar(255),
        PARTNER_LINK_MODEL_ID int4,
        PATTERN varchar(255),
        PIPED_ID varchar(255),
        PORT_TYPE varchar(255),
        PROPAGATE_TRANS boolean,
        STATUS varchar(255),
        SUBSCRIBER_COUNT int4,
        CORR_ID int8,
        PARTNER_LINK_ID int8,
        PROCESS_ID int8,
        PROCESS_INSTANCE_ID int8,
        REQUEST_MESSAGE_ID int8,
        RESPONSE_MESSAGE_ID int8,
        primary key (MESSAGE_EXCHANGE_ID)
    )');

    select execute_if_not_exists('create table BPEL_MESSAGE_ROUTE (
        MESSAGE_ROUTE_ID int8 not null,
        CORRELATION_KEY varchar(255),
        GROUP_ID varchar(255),
        ROUTE_INDEX int4,
        PROCESS_INSTANCE_ID int8,
        ROUTE_POLICY varchar(16),
        CORR_ID int8,
        primary key (MESSAGE_ROUTE_ID)
    )');

    select execute_if_not_exists('create table BPEL_MEX_PROP (
        ID int8 not null,
        MEX_ID varchar(255),
        PROP_KEY varchar(255),
        PROP_VALUE varchar(2000),
        primary key (ID)
    )');

    select execute_if_not_exists('create table BPEL_PARTNER_LINK (
        PARTNER_LINK_ID int8 not null,
        MY_EPR text,
        MY_ROLE_NAME varchar(255),
        MY_ROLE_SERVICE_NAME varchar(255),
        MY_SESSION_ID varchar(255),
        PARTNER_EPR text,
        PARTNER_LINK_MODEL_ID int4,
        PARTNER_LINK_NAME varchar(255),
        PARTNER_ROLE_NAME varchar(255),
        PARTNER_SESSION_ID varchar(255),
        SCOPE_ID int8,
        primary key (PARTNER_LINK_ID)
    )');

    select execute_if_not_exists('create table BPEL_PROCESS (
        ID int8 not null,
        GUID varchar(255),
        PROCESS_ID varchar(255),
        PROCESS_TYPE varchar(255),
        VERSION int8,
        primary key (ID)
    )');

    select execute_if_not_exists('create table BPEL_PROCESS_INSTANCE (
        ID int8 not null,
        DATE_CREATED timestamp,
        EXECUTION_STATE oid,
        FAULT_ID int8,
        LAST_ACTIVE_TIME timestamp,
        LAST_RECOVERY_DATE timestamp,
        PREVIOUS_STATE int2,
        SEQUENCE int8,
        INSTANCE_STATE int2,
        INSTANTIATING_CORRELATOR_ID int8,
        PROCESS_ID int8,
        ROOT_SCOPE_ID int8,
        primary key (ID)
    )');

    select execute_if_not_exists('create table BPEL_SCOPE (
        SCOPE_ID int8 not null,
        MODEL_ID int4,
        SCOPE_NAME varchar(255),
        SCOPE_STATE varchar(255),
        PARENT_SCOPE_ID int8,
        PROCESS_INSTANCE_ID int8,
        primary key (SCOPE_ID)
    )');

    select execute_if_not_exists('create table BPEL_XML_DATA (
        XML_DATA_ID int8 not null,
        DATA text,
        IS_SIMPLE_TYPE boolean,
        NAME varchar(255),
        SCOPE_ID int8,
        primary key (XML_DATA_ID)
    )');

    select execute_if_not_exists('create table BPEL_XML_DATA_PROP (
        ID int8 not null,
        XML_DATA_ID int8,
        PROP_KEY varchar(255),
        PROP_VALUE varchar(255),
        primary key (ID)
    )');

    select execute_if_not_exists('create table ODE_JOB (
        jobid varchar(64) not null,
        channel varchar(255),
        correlationKeySet varchar(255),
        correlatorId varchar(255),
        detailsExt oid,
        inMem boolean,
        instanceId int8,
        mexId varchar(255),
        nodeid varchar(64),
        processId varchar(255),
        retryCount int4,
        scheduled boolean not null,
        ts int8 not null,
        transacted boolean not null,
        type varchar(255),
        primary key (jobid)
    )');

    select execute_if_not_exists('create table STORE_DU (
        NAME varchar(255) not null,
        DEPLOYDT timestamp,
        DEPLOYER varchar(255),
        DIR varchar(255),
        primary key (NAME)
    )');

    select execute_if_not_exists('create table STORE_PROCESS (
        PID varchar(255) not null,
        STATE varchar(255),
        TYPE varchar(255),
        VERSION int8,
        DU varchar(255),
        primary key (PID)
    )');

    select execute_if_not_exists('create table STORE_PROCESS_PROP (
        ID int8 not null,
        PROP_KEY varchar(255),
        PROP_VAL varchar(255),
        primary key (ID)
    )');

    select execute_if_not_exists('create table STORE_PROC_TO_PROP (
        STORE_PROCESS_PID varchar(255) not null,
        STORE_PROPERTY_ID int8 not null,
        primary key (STORE_PROCESS_PID, STORE_PROPERTY_ID)
    )');

    select execute_if_not_exists('create table STORE_VERSIONS (
        ID int8 not null,
        VERSION int8,
        primary key (ID)
    )');

    select execute_if_exists('alter table STORE_PROC_TO_PROP 
        add constraint UK_ld9y5wtckspqw9us9gfeokf6a unique (STORE_PROPERTY_ID)');

    select execute_if_exists('alter table BPEL_ACTIVITY_RECOVERY 
        add constraint FK_5iwucbr1yngxjs16sxeej3xpp 
        foreign key (INSTANCE_ID) 
        references BPEL_PROCESS_INSTANCE');

    select execute_if_exists('alter table BPEL_CORRELATION_SET 
        add constraint FK_j1vdkxghmf62wsykum7ut0mjp 
        foreign key (SCOPE_ID) 
        references BPEL_SCOPE');

    select execute_if_exists('alter table BPEL_CORRELATOR 
        add constraint FK_6sqr3hmuqssl6v7en9extt6nb 
        foreign key (PROC_ID) 
        references BPEL_PROCESS');

    select execute_if_exists('alter table BPEL_CORSET_PROP 
        add constraint FK_6vmj2n3pf8el6xupevpjpw0q5 
        foreign key (CORRSET_ID) 
        references BPEL_CORRELATION_SET');

    select execute_if_exists('alter table BPEL_EVENT 
        add constraint FK_on6qt1pmhmhq302bvn0afqrib 
        foreign key (INSTANCE_ID) 
        references BPEL_PROCESS_INSTANCE');

    select execute_if_exists('alter table BPEL_EVENT 
        add constraint FK_3i4chalwvtcsxnb3kitlk008i 
        foreign key (PROCESS_ID) 
        references BPEL_PROCESS');

    select execute_if_exists('alter table BPEL_MESSAGE 
        add constraint FK_t7okesqhwuldkv1hh6gbqf2ou 
        foreign key (MESSAGE_EXCHANGE_ID) 
        references BPEL_MESSAGE_EXCHANGE');

    select execute_if_exists('alter table BPEL_MESSAGE_EXCHANGE 
        add constraint FK_h7khyrytsirwd8wab4u46m2n8 
        foreign key (CORR_ID) 
        references BPEL_CORRELATOR');

    select execute_if_exists('alter table BPEL_MESSAGE_EXCHANGE 
        add constraint FK_uonx6oawfknxho8jrf3rfk5c 
        foreign key (PARTNER_LINK_ID) 
        references BPEL_PARTNER_LINK');

    select execute_if_exists('alter table BPEL_MESSAGE_EXCHANGE 
        add constraint FK_gb2u3yldxdoo1cwm0r4ueumks 
        foreign key (PROCESS_ID) 
        references BPEL_PROCESS');

    select execute_if_exists('alter table BPEL_MESSAGE_ROUTE 
        add constraint FK_c7spgx5vfvekg032033rpqdbk 
        foreign key (CORR_ID) 
        references BPEL_CORRELATOR');

    select execute_if_exists('alter table BPEL_MESSAGE_ROUTE 
        add constraint FK_fxmbqc9xnjklj0k4bn1e2l34x 
        foreign key (PROCESS_INSTANCE_ID) 
        references BPEL_PROCESS_INSTANCE');

    select execute_if_exists('alter table BPEL_MEX_PROP 
        add constraint FK_4hprt848lqhnc8pjdxhslqy53 
        foreign key (MEX_ID) 
        references BPEL_MESSAGE_EXCHANGE');

    select execute_if_exists('alter table BPEL_PARTNER_LINK 
        add constraint FK_n42xwpib34r1o4j3gum2o7teo 
        foreign key (SCOPE_ID) 
        references BPEL_SCOPE');

    select execute_if_exists('alter table BPEL_PROCESS_INSTANCE 
        add constraint FK_cbaftcdg3olwu6c1hb9uiysh8 
        foreign key (INSTANTIATING_CORRELATOR_ID) 
        references BPEL_CORRELATOR');

    select execute_if_exists('alter table BPEL_PROCESS_INSTANCE 
        add constraint FK_s6umxoyr597vbkk95ff9uwx8 
        foreign key (PROCESS_ID) 
        references BPEL_PROCESS');

    select execute_if_exists('alter table BPEL_SCOPE 
        add constraint FK_nuormejxj2iyfxm4yny8g2msh 
        foreign key (PROCESS_INSTANCE_ID) 
        references BPEL_PROCESS_INSTANCE');

    select execute_if_exists('alter table BPEL_XML_DATA 
        add constraint FK_g0pgad8e5x63j502w4ps9ysnh 
        foreign key (SCOPE_ID) 
        references BPEL_SCOPE');

    select execute_if_exists('alter table BPEL_XML_DATA_PROP 
        add constraint FK_5pv5xml1vgquncql9irej95k7 
        foreign key (XML_DATA_ID) 
        references BPEL_XML_DATA');

    select execute_if_exists('alter table STORE_PROCESS 
        add constraint FK_c8haf42aukvqr2udrtpyi3kdb 
        foreign key (DU) 
        references STORE_DU');

    select execute_if_exists('alter table STORE_PROC_TO_PROP 
        add constraint FK_ld9y5wtckspqw9us9gfeokf6a 
        foreign key (STORE_PROPERTY_ID) 
        references STORE_PROCESS_PROP');

    select execute_if_exists('alter table STORE_PROC_TO_PROP 
        add constraint FK_t19b3gjvbvqke3hh5mcdr2dwl 
        foreign key (STORE_PROCESS_PID) 
        references STORE_PROCESS');

    select execute_if_not_exists('create sequence bpel_sequence');