
    begin execute_if_not_exists('create table BPEL_ACTIVITY_RECOVERY (
        ID number(19,0) not null,
        ACTIONS varchar2(255 char),
        ACTIVITY_ID number(19,0),
        CHANNEL varchar2(255 char),
        DATE_TIME timestamp,
        DETAILS clob,
        INSTANCE_ID number(19,0),
        REASON varchar2(255 char),
        RETRIES number(10,0),
        primary key (ID)
    )'); end;;

    begin execute_if_not_exists('create table BPEL_CORRELATION_SET (
        CORRELATION_SET_ID number(19,0) not null,
        CORRELATION_KEY varchar2(255 char),
        NAME varchar2(255 char),
        SCOPE_ID number(19,0),
        primary key (CORRELATION_SET_ID)
    )'); end;;

    begin execute_if_not_exists('create table BPEL_CORRELATOR (
        CORRELATOR_ID number(19,0) not null,
        CORRELATOR_KEY varchar2(255 char),
        PROC_ID number(19,0),
        primary key (CORRELATOR_ID)
    )'); end;;

    begin execute_if_not_exists('create table BPEL_CORSET_PROP (
        ID number(19,0) not null,
        CORRSET_ID number(19,0),
        PROP_KEY varchar2(255 char),
        PROP_VALUE varchar2(255 char),
        primary key (ID)
    )'); end;;

    begin execute_if_not_exists('create table BPEL_EVENT (
        EVENT_ID number(19,0) not null,
        DETAIL varchar2(255 char),
        DATA blob,
        SCOPE_ID number(19,0),
        TSTAMP timestamp,
        TYPE varchar2(255 char),
        INSTANCE_ID number(19,0),
        PROCESS_ID number(19,0),
        primary key (EVENT_ID)
    )'); end;;

    begin execute_if_not_exists('create table BPEL_FAULT (
        FAULT_ID number(19,0) not null,
        ACTIVITY_ID number(10,0),
        DATA clob,
        MESSAGE clob,
        LINE_NUMBER number(10,0),
        NAME varchar2(255 char),
        primary key (FAULT_ID)
    )'); end;;

    begin execute_if_not_exists('create table BPEL_MESSAGE (
        MESSAGE_ID number(19,0) not null,
        DATA clob,
        HEADER clob,
        TYPE varchar2(255 char),
        MESSAGE_EXCHANGE_ID varchar2(255 char),
        primary key (MESSAGE_ID)
    )'); end;;

    begin execute_if_not_exists('create table BPEL_MESSAGE_EXCHANGE (
        MESSAGE_EXCHANGE_ID varchar2(255 char) not null,
        CALLEE varchar2(255 char),
        CHANNEL varchar2(255 char),
        CORRELATION_ID varchar2(255 char),
        CORRELATION_KEYS varchar2(255 char),
        CORRELATION_STATUS varchar2(255 char),
        CREATE_TIME timestamp,
        DIRECTION char(1 char),
        EPR clob,
        FAULT varchar2(255 char),
        FAULT_EXPLANATION varchar2(255 char),
        OPERATION varchar2(255 char),
        PARTNER_LINK_MODEL_ID number(10,0),
        PATTERN varchar2(255 char),
        PIPED_ID varchar2(255 char),
        PORT_TYPE varchar2(255 char),
        PROPAGATE_TRANS number(1,0),
        STATUS varchar2(255 char),
        SUBSCRIBER_COUNT number(10,0),
        CORR_ID number(19,0),
        PARTNER_LINK_ID number(19,0),
        PROCESS_ID number(19,0),
        PROCESS_INSTANCE_ID number(19,0),
        REQUEST_MESSAGE_ID number(19,0),
        RESPONSE_MESSAGE_ID number(19,0),
        primary key (MESSAGE_EXCHANGE_ID)
    )'); end;;

    begin execute_if_not_exists('create table BPEL_MESSAGE_ROUTE (
        MESSAGE_ROUTE_ID number(19,0) not null,
        CORRELATION_KEY varchar2(255 char),
        GROUP_ID varchar2(255 char),
        ROUTE_INDEX number(10,0),
        PROCESS_INSTANCE_ID number(19,0),
        ROUTE_POLICY varchar2(16 char),
        CORR_ID number(19,0),
        primary key (MESSAGE_ROUTE_ID)
    )'); end;;

    begin execute_if_not_exists('create table BPEL_MEX_PROP (
        ID number(19,0) not null,
        MEX_ID varchar2(255 char),
        PROP_KEY varchar2(255 char),
        PROP_VALUE varchar2(2000 char),
        primary key (ID)
    )'); end;;

    begin execute_if_not_exists('create table BPEL_PARTNER_LINK (
        PARTNER_LINK_ID number(19,0) not null,
        MY_EPR clob,
        MY_ROLE_NAME varchar2(255 char),
        MY_ROLE_SERVICE_NAME varchar2(255 char),
        MY_SESSION_ID varchar2(255 char),
        PARTNER_EPR clob,
        PARTNER_LINK_MODEL_ID number(10,0),
        PARTNER_LINK_NAME varchar2(255 char),
        PARTNER_ROLE_NAME varchar2(255 char),
        PARTNER_SESSION_ID varchar2(255 char),
        SCOPE_ID number(19,0),
        primary key (PARTNER_LINK_ID)
    )'); end;;

    begin execute_if_not_exists('create table BPEL_PROCESS (
        ID number(19,0) not null,
        GUID varchar2(255 char),
        PROCESS_ID varchar2(255 char),
        PROCESS_TYPE varchar2(255 char),
        VERSION number(19,0),
        primary key (ID)
    )'); end;;

    begin execute_if_not_exists('create table BPEL_PROCESS_INSTANCE (
        ID number(19,0) not null,
        DATE_CREATED timestamp,
        EXECUTION_STATE blob,
        FAULT_ID number(19,0),
        LAST_ACTIVE_TIME timestamp,
        LAST_RECOVERY_DATE timestamp,
        PREVIOUS_STATE number(5,0),
        SEQUENCE number(19,0),
        INSTANCE_STATE number(5,0),
        INSTANTIATING_CORRELATOR_ID number(19,0),
        PROCESS_ID number(19,0),
        ROOT_SCOPE_ID number(19,0),
        primary key (ID)
    )'); end;;

    begin execute_if_not_exists('create table BPEL_SCOPE (
        SCOPE_ID number(19,0) not null,
        MODEL_ID number(10,0),
        SCOPE_NAME varchar2(255 char),
        SCOPE_STATE varchar2(255 char),
        PARENT_SCOPE_ID number(19,0),
        PROCESS_INSTANCE_ID number(19,0),
        primary key (SCOPE_ID)
    )'); end;;

    begin execute_if_not_exists('create table BPEL_XML_DATA (
        XML_DATA_ID number(19,0) not null,
        DATA clob,
        IS_SIMPLE_TYPE number(1,0),
        NAME varchar2(255 char),
        SCOPE_ID number(19,0),
        primary key (XML_DATA_ID)
    )'); end;;

    begin execute_if_not_exists('create table BPEL_XML_DATA_PROP (
        ID number(19,0) not null,
        XML_DATA_ID number(19,0),
        PROP_KEY varchar2(255 char),
        PROP_VALUE varchar2(255 char),
        primary key (ID)
    )'); end;;

    begin execute_if_not_exists('create table ODE_JOB (
        jobid varchar2(64 char) not null,
        channel varchar2(255 char),
        correlationKeySet varchar2(255 char),
        correlatorId varchar2(255 char),
        detailsExt blob,
        inMem number(1,0),
        instanceId number(19,0),
        mexId varchar2(255 char),
        nodeid varchar2(64 char),
        processId varchar2(255 char),
        retryCount number(10,0),
        scheduled number(1,0) not null,
        ts number(19,0) not null,
        transacted number(1,0) not null,
        type varchar2(255 char),
        primary key (jobid)
    )'); end;;

    begin execute_if_not_exists('create table STORE_DU (
        NAME varchar2(255 char) not null,
        DEPLOYDT timestamp,
        DEPLOYER varchar2(255 char),
        DIR varchar2(255 char),
        primary key (NAME)
    )'); end;;

    begin execute_if_not_exists('create table STORE_PROCESS (
        PID varchar2(255 char) not null,
        STATE varchar2(255 char),
        TYPE varchar2(255 char),
        VERSION number(19,0),
        DU varchar2(255 char),
        primary key (PID)
    )'); end;;

    begin execute_if_not_exists('create table STORE_PROCESS_PROP (
        ID number(19,0) not null,
        PROP_KEY varchar2(255 char),
        PROP_VAL varchar2(255 char),
        primary key (ID)
    )'); end;;

    begin execute_if_not_exists('create table STORE_PROC_TO_PROP (
        STORE_PROCESS_PID varchar2(255 char) not null,
        STORE_PROPERTY_ID number(19,0) not null,
        primary key (STORE_PROCESS_PID, STORE_PROPERTY_ID)
    )'); end;;

    begin execute_if_not_exists('create table STORE_VERSIONS (
        ID number(19,0) not null,
        VERSION number(19,0),
        primary key (ID)
    )'); end;;

    begin execute_if_exists('alter table STORE_PROC_TO_PROP 
        add constraint UK_ld9y5wtckspqw9us9gfeokf6a unique (STORE_PROPERTY_ID)'); end;;

    begin execute_if_exists('alter table BPEL_ACTIVITY_RECOVERY 
        add constraint FK_5iwucbr1yngxjs16sxeej3xpp 
        foreign key (INSTANCE_ID) 
        references BPEL_PROCESS_INSTANCE'); end;;

    begin execute_if_exists('alter table BPEL_CORRELATION_SET 
        add constraint FK_j1vdkxghmf62wsykum7ut0mjp 
        foreign key (SCOPE_ID) 
        references BPEL_SCOPE'); end;;

    begin execute_if_exists('alter table BPEL_CORRELATOR 
        add constraint FK_6sqr3hmuqssl6v7en9extt6nb 
        foreign key (PROC_ID) 
        references BPEL_PROCESS'); end;;

    begin execute_if_exists('alter table BPEL_CORSET_PROP 
        add constraint FK_6vmj2n3pf8el6xupevpjpw0q5 
        foreign key (CORRSET_ID) 
        references BPEL_CORRELATION_SET'); end;;

    begin execute_if_exists('alter table BPEL_EVENT 
        add constraint FK_on6qt1pmhmhq302bvn0afqrib 
        foreign key (INSTANCE_ID) 
        references BPEL_PROCESS_INSTANCE'); end;;

    begin execute_if_exists('alter table BPEL_EVENT 
        add constraint FK_3i4chalwvtcsxnb3kitlk008i 
        foreign key (PROCESS_ID) 
        references BPEL_PROCESS'); end;;

    begin execute_if_exists('alter table BPEL_MESSAGE 
        add constraint FK_t7okesqhwuldkv1hh6gbqf2ou 
        foreign key (MESSAGE_EXCHANGE_ID) 
        references BPEL_MESSAGE_EXCHANGE'); end;;

    begin execute_if_exists('alter table BPEL_MESSAGE_EXCHANGE 
        add constraint FK_h7khyrytsirwd8wab4u46m2n8 
        foreign key (CORR_ID) 
        references BPEL_CORRELATOR'); end;;

    begin execute_if_exists('alter table BPEL_MESSAGE_EXCHANGE 
        add constraint FK_uonx6oawfknxho8jrf3rfk5c 
        foreign key (PARTNER_LINK_ID) 
        references BPEL_PARTNER_LINK'); end;;

    begin execute_if_exists('alter table BPEL_MESSAGE_EXCHANGE 
        add constraint FK_gb2u3yldxdoo1cwm0r4ueumks 
        foreign key (PROCESS_ID) 
        references BPEL_PROCESS'); end;;

    begin execute_if_exists('alter table BPEL_MESSAGE_ROUTE 
        add constraint FK_c7spgx5vfvekg032033rpqdbk 
        foreign key (CORR_ID) 
        references BPEL_CORRELATOR'); end;;

    begin execute_if_exists('alter table BPEL_MESSAGE_ROUTE 
        add constraint FK_fxmbqc9xnjklj0k4bn1e2l34x 
        foreign key (PROCESS_INSTANCE_ID) 
        references BPEL_PROCESS_INSTANCE'); end;;

    begin execute_if_exists('alter table BPEL_MEX_PROP 
        add constraint FK_4hprt848lqhnc8pjdxhslqy53 
        foreign key (MEX_ID) 
        references BPEL_MESSAGE_EXCHANGE'); end;;

    begin execute_if_exists('alter table BPEL_PARTNER_LINK 
        add constraint FK_n42xwpib34r1o4j3gum2o7teo 
        foreign key (SCOPE_ID) 
        references BPEL_SCOPE'); end;;

    begin execute_if_exists('alter table BPEL_PROCESS_INSTANCE 
        add constraint FK_cbaftcdg3olwu6c1hb9uiysh8 
        foreign key (INSTANTIATING_CORRELATOR_ID) 
        references BPEL_CORRELATOR'); end;;

    begin execute_if_exists('alter table BPEL_PROCESS_INSTANCE 
        add constraint FK_s6umxoyr597vbkk95ff9uwx8 
        foreign key (PROCESS_ID) 
        references BPEL_PROCESS'); end;;

    begin execute_if_exists('alter table BPEL_SCOPE 
        add constraint FK_nuormejxj2iyfxm4yny8g2msh 
        foreign key (PROCESS_INSTANCE_ID) 
        references BPEL_PROCESS_INSTANCE'); end;;

    begin execute_if_exists('alter table BPEL_XML_DATA 
        add constraint FK_g0pgad8e5x63j502w4ps9ysnh 
        foreign key (SCOPE_ID) 
        references BPEL_SCOPE'); end;;

    begin execute_if_exists('alter table BPEL_XML_DATA_PROP 
        add constraint FK_5pv5xml1vgquncql9irej95k7 
        foreign key (XML_DATA_ID) 
        references BPEL_XML_DATA'); end;;

    begin execute_if_exists('alter table STORE_PROCESS 
        add constraint FK_c8haf42aukvqr2udrtpyi3kdb 
        foreign key (DU) 
        references STORE_DU'); end;;

    begin execute_if_exists('alter table STORE_PROC_TO_PROP 
        add constraint FK_ld9y5wtckspqw9us9gfeokf6a 
        foreign key (STORE_PROPERTY_ID) 
        references STORE_PROCESS_PROP'); end;;

    begin execute_if_exists('alter table STORE_PROC_TO_PROP 
        add constraint FK_t19b3gjvbvqke3hh5mcdr2dwl 
        foreign key (STORE_PROCESS_PID) 
        references STORE_PROCESS'); end;;

    begin execute_if_not_exists('create sequence hibernate_sequence'); end;;

    begin execute_if_not_exists('create table BPAF_EVENT (
        EID number(19,0) not null,
        ACTIVITY_DEFINITION_ID varchar2(255 char),
        ACTIVITY_INSTANCE_ID varchar2(255 char),
        ACTIVITY_NAME varchar2(255 char),
        CURRENT_STATE varchar2(255 char),
        PREVIOUS_STATE varchar2(255 char),
        PROCESS_DEFINITION_ID varchar2(255 char),
        PROCESS_INSTANCE_ID varchar2(255 char),
        PROCESS_NAME varchar2(255 char),
        SERVER_ID varchar2(255 char),
        TIMESTAMP number(19,0),
        primary key (EID)
    )'); end;;

    begin execute_if_not_exists('create table BPAF_EVENT_DATA (
        TID number(19,0) not null,
        NAME varchar2(255 char),
        VALUE clob,
        EVENT_ID number(19,0),
        primary key (TID)
    )'); end;;

    begin execute_if_exists('alter table BPAF_EVENT_DATA 
        add constraint FK_5dx9wlbxkeho97gui4la0vjye 
        foreign key (EVENT_ID) 
        references BPAF_EVENT'); end;;