
    if object_id('BPEL_ACTIVITY_RECOVERY', 'U') is null create table BPEL_ACTIVITY_RECOVERY (
        ID bigint identity not null,
        ACTIONS varchar(255),
        ACTIVITY_ID bigint,
        CHANNEL varchar(255),
        DATE_TIME datetime2,
        DETAILS varchar(MAX),
        INSTANCE_ID bigint,
        REASON varchar(255),
        RETRIES int,
        primary key (ID)
    );

    if object_id('BPEL_CORRELATION_SET', 'U') is null create table BPEL_CORRELATION_SET (
        CORRELATION_SET_ID bigint identity not null,
        CORRELATION_KEY varchar(255),
        NAME varchar(255),
        SCOPE_ID bigint,
        primary key (CORRELATION_SET_ID)
    );

    if object_id('BPEL_CORRELATOR', 'U') is null create table BPEL_CORRELATOR (
        CORRELATOR_ID bigint identity not null,
        CORRELATOR_KEY varchar(255),
        PROC_ID bigint,
        primary key (CORRELATOR_ID)
    );

    if object_id('BPEL_CORSET_PROP', 'U') is null create table BPEL_CORSET_PROP (
        ID bigint identity not null,
        CORRSET_ID bigint,
        PROP_KEY varchar(255),
        PROP_VALUE varchar(255),
        primary key (ID)
    );

    if object_id('BPEL_EVENT', 'U') is null create table BPEL_EVENT (
        EVENT_ID bigint identity not null,
        DETAIL varchar(255),
        DATA varbinary(MAX),
        SCOPE_ID bigint,
        TSTAMP datetime2,
        TYPE varchar(255),
        INSTANCE_ID bigint,
        PROCESS_ID bigint,
        primary key (EVENT_ID)
    );

    if object_id('BPEL_FAULT', 'U') is null create table BPEL_FAULT (
        FAULT_ID bigint identity not null,
        ACTIVITY_ID int,
        DATA varchar(MAX),
        MESSAGE varchar(MAX),
        LINE_NUMBER int,
        NAME varchar(255),
        primary key (FAULT_ID)
    );

    if object_id('BPEL_MESSAGE', 'U') is null create table BPEL_MESSAGE (
        MESSAGE_ID bigint identity not null,
        DATA varchar(MAX),
        HEADER varchar(MAX),
        TYPE varchar(255),
        MESSAGE_EXCHANGE_ID varchar(255),
        primary key (MESSAGE_ID)
    );

    if object_id('BPEL_MESSAGE_EXCHANGE', 'U') is null create table BPEL_MESSAGE_EXCHANGE (
        MESSAGE_EXCHANGE_ID varchar(255) not null,
        CALLEE varchar(255),
        CHANNEL varchar(255),
        CORRELATION_ID varchar(255),
        CORRELATION_KEYS varchar(255),
        CORRELATION_STATUS varchar(255),
        CREATE_TIME datetime2,
        DIRECTION char(1),
        EPR varchar(MAX),
        FAULT varchar(255),
        FAULT_EXPLANATION varchar(255),
        OPERATION varchar(255),
        PARTNER_LINK_MODEL_ID int,
        PATTERN varchar(255),
        PIPED_ID varchar(255),
        PORT_TYPE varchar(255),
        PROPAGATE_TRANS bit,
        STATUS varchar(255),
        SUBSCRIBER_COUNT int,
        CORR_ID bigint,
        PARTNER_LINK_ID bigint,
        PROCESS_ID bigint,
        PROCESS_INSTANCE_ID bigint,
        REQUEST_MESSAGE_ID bigint,
        RESPONSE_MESSAGE_ID bigint,
        primary key (MESSAGE_EXCHANGE_ID)
    );

    if object_id('BPEL_MESSAGE_ROUTE', 'U') is null create table BPEL_MESSAGE_ROUTE (
        MESSAGE_ROUTE_ID bigint identity not null,
        CORRELATION_KEY varchar(255),
        GROUP_ID varchar(255),
        ROUTE_INDEX int,
        PROCESS_INSTANCE_ID bigint,
        ROUTE_POLICY varchar(16),
        CORR_ID bigint,
        primary key (MESSAGE_ROUTE_ID)
    );

    if object_id('BPEL_MEX_PROP', 'U') is null create table BPEL_MEX_PROP (
        ID bigint identity not null,
        MEX_ID varchar(255),
        PROP_KEY varchar(255),
        PROP_VALUE varchar(2000),
        primary key (ID)
    );

    if object_id('BPEL_PARTNER_LINK', 'U') is null create table BPEL_PARTNER_LINK (
        PARTNER_LINK_ID bigint identity not null,
        MY_EPR varchar(MAX),
        MY_ROLE_NAME varchar(255),
        MY_ROLE_SERVICE_NAME varchar(255),
        MY_SESSION_ID varchar(255),
        PARTNER_EPR varchar(MAX),
        PARTNER_LINK_MODEL_ID int,
        PARTNER_LINK_NAME varchar(255),
        PARTNER_ROLE_NAME varchar(255),
        PARTNER_SESSION_ID varchar(255),
        SCOPE_ID bigint,
        primary key (PARTNER_LINK_ID)
    );

    if object_id('BPEL_PROCESS', 'U') is null create table BPEL_PROCESS (
        ID bigint identity not null,
        GUID varchar(255),
        PROCESS_ID varchar(255),
        PROCESS_TYPE varchar(255),
        VERSION bigint,
        primary key (ID)
    );

    if object_id('BPEL_PROCESS_INSTANCE', 'U') is null create table BPEL_PROCESS_INSTANCE (
        ID bigint identity not null,
        DATE_CREATED datetime2,
        EXECUTION_STATE varbinary(MAX),
        FAULT_ID bigint,
        LAST_ACTIVE_TIME datetime2,
        LAST_RECOVERY_DATE datetime2,
        PREVIOUS_STATE smallint,
        SEQUENCE bigint,
        INSTANCE_STATE smallint,
        INSTANTIATING_CORRELATOR_ID bigint,
        PROCESS_ID bigint,
        ROOT_SCOPE_ID bigint,
        primary key (ID)
    );

    if object_id('BPEL_SCOPE', 'U') is null create table BPEL_SCOPE (
        SCOPE_ID bigint identity not null,
        MODEL_ID int,
        SCOPE_NAME varchar(255),
        SCOPE_STATE varchar(255),
        PARENT_SCOPE_ID bigint,
        PROCESS_INSTANCE_ID bigint,
        primary key (SCOPE_ID)
    );

    if object_id('BPEL_XML_DATA', 'U') is null create table BPEL_XML_DATA (
        XML_DATA_ID bigint identity not null,
        DATA varchar(MAX),
        IS_SIMPLE_TYPE bit,
        NAME varchar(255),
        SCOPE_ID bigint,
        primary key (XML_DATA_ID)
    );

    if object_id('BPEL_XML_DATA_PROP', 'U') is null create table BPEL_XML_DATA_PROP (
        ID bigint identity not null,
        XML_DATA_ID bigint,
        PROP_KEY varchar(255),
        PROP_VALUE varchar(255),
        primary key (ID)
    );

    if object_id('ODE_JOB', 'U') is null create table ODE_JOB (
        jobid varchar(64) not null,
        channel varchar(255),
        correlationKeySet varchar(255),
        correlatorId varchar(255),
        detailsExt varbinary(MAX),
        inMem bit,
        instanceId bigint,
        mexId varchar(255),
        nodeid varchar(64),
        processId varchar(255),
        retryCount int,
        scheduled bit not null,
        ts bigint not null,
        transacted bit not null,
        type varchar(255),
        primary key (jobid)
    );

    if object_id('STORE_DU', 'U') is null create table STORE_DU (
        NAME varchar(255) not null,
        DEPLOYDT datetime2,
        DEPLOYER varchar(255),
        DIR varchar(255),
        primary key (NAME)
    );

    if object_id('STORE_PROCESS', 'U') is null create table STORE_PROCESS (
        PID varchar(255) not null,
        STATE varchar(255),
        TYPE varchar(255),
        VERSION bigint,
        DU varchar(255),
        primary key (PID)
    );

    if object_id('STORE_PROCESS_PROP', 'U') is null create table STORE_PROCESS_PROP (
        ID bigint identity not null,
        PROP_KEY varchar(255),
        PROP_VAL varchar(255),
        primary key (ID)
    );

    if object_id('STORE_PROC_TO_PROP', 'U') is null create table STORE_PROC_TO_PROP (
        STORE_PROCESS_PID varchar(255) not null,
        STORE_PROPERTY_ID bigint not null,
        primary key (STORE_PROCESS_PID, STORE_PROPERTY_ID)
    );

    if object_id('STORE_VERSIONS', 'U') is null create table STORE_VERSIONS (
        ID bigint identity not null,
        VERSION bigint,
        primary key (ID)
    );

    if object_id('STORE_PROC_TO_PROP', 'U') is not null alter table STORE_PROC_TO_PROP 
        add constraint UK_ld9y5wtckspqw9us9gfeokf6a unique (STORE_PROPERTY_ID);

    if object_id('BPEL_ACTIVITY_RECOVERY', 'U') is not null alter table BPEL_ACTIVITY_RECOVERY 
        add constraint FK_5iwucbr1yngxjs16sxeej3xpp 
        foreign key (INSTANCE_ID) 
        references BPEL_PROCESS_INSTANCE;

    if object_id('BPEL_CORRELATION_SET', 'U') is not null alter table BPEL_CORRELATION_SET 
        add constraint FK_j1vdkxghmf62wsykum7ut0mjp 
        foreign key (SCOPE_ID) 
        references BPEL_SCOPE;

    if object_id('BPEL_CORRELATOR', 'U') is not null alter table BPEL_CORRELATOR 
        add constraint FK_6sqr3hmuqssl6v7en9extt6nb 
        foreign key (PROC_ID) 
        references BPEL_PROCESS;

    if object_id('BPEL_CORSET_PROP', 'U') is not null alter table BPEL_CORSET_PROP 
        add constraint FK_6vmj2n3pf8el6xupevpjpw0q5 
        foreign key (CORRSET_ID) 
        references BPEL_CORRELATION_SET;

    if object_id('BPEL_EVENT', 'U') is not null alter table BPEL_EVENT 
        add constraint FK_on6qt1pmhmhq302bvn0afqrib 
        foreign key (INSTANCE_ID) 
        references BPEL_PROCESS_INSTANCE;

    if object_id('BPEL_EVENT', 'U') is not null alter table BPEL_EVENT 
        add constraint FK_3i4chalwvtcsxnb3kitlk008i 
        foreign key (PROCESS_ID) 
        references BPEL_PROCESS;

    if object_id('BPEL_MESSAGE', 'U') is not null alter table BPEL_MESSAGE 
        add constraint FK_t7okesqhwuldkv1hh6gbqf2ou 
        foreign key (MESSAGE_EXCHANGE_ID) 
        references BPEL_MESSAGE_EXCHANGE;

    if object_id('BPEL_MESSAGE_EXCHANGE', 'U') is not null alter table BPEL_MESSAGE_EXCHANGE 
        add constraint FK_h7khyrytsirwd8wab4u46m2n8 
        foreign key (CORR_ID) 
        references BPEL_CORRELATOR;

    if object_id('BPEL_MESSAGE_EXCHANGE', 'U') is not null alter table BPEL_MESSAGE_EXCHANGE 
        add constraint FK_uonx6oawfknxho8jrf3rfk5c 
        foreign key (PARTNER_LINK_ID) 
        references BPEL_PARTNER_LINK;

    if object_id('BPEL_MESSAGE_EXCHANGE', 'U') is not null alter table BPEL_MESSAGE_EXCHANGE 
        add constraint FK_gb2u3yldxdoo1cwm0r4ueumks 
        foreign key (PROCESS_ID) 
        references BPEL_PROCESS;

    if object_id('BPEL_MESSAGE_ROUTE', 'U') is not null alter table BPEL_MESSAGE_ROUTE 
        add constraint FK_c7spgx5vfvekg032033rpqdbk 
        foreign key (CORR_ID) 
        references BPEL_CORRELATOR;

    if object_id('BPEL_MESSAGE_ROUTE', 'U') is not null alter table BPEL_MESSAGE_ROUTE 
        add constraint FK_fxmbqc9xnjklj0k4bn1e2l34x 
        foreign key (PROCESS_INSTANCE_ID) 
        references BPEL_PROCESS_INSTANCE;

    if object_id('BPEL_MEX_PROP', 'U') is not null alter table BPEL_MEX_PROP 
        add constraint FK_4hprt848lqhnc8pjdxhslqy53 
        foreign key (MEX_ID) 
        references BPEL_MESSAGE_EXCHANGE;

    if object_id('BPEL_PARTNER_LINK', 'U') is not null alter table BPEL_PARTNER_LINK 
        add constraint FK_n42xwpib34r1o4j3gum2o7teo 
        foreign key (SCOPE_ID) 
        references BPEL_SCOPE;

    if object_id('BPEL_PROCESS_INSTANCE', 'U') is not null alter table BPEL_PROCESS_INSTANCE 
        add constraint FK_cbaftcdg3olwu6c1hb9uiysh8 
        foreign key (INSTANTIATING_CORRELATOR_ID) 
        references BPEL_CORRELATOR;

    if object_id('BPEL_PROCESS_INSTANCE', 'U') is not null alter table BPEL_PROCESS_INSTANCE 
        add constraint FK_s6umxoyr597vbkk95ff9uwx8 
        foreign key (PROCESS_ID) 
        references BPEL_PROCESS;

    if object_id('BPEL_SCOPE', 'U') is not null alter table BPEL_SCOPE 
        add constraint FK_nuormejxj2iyfxm4yny8g2msh 
        foreign key (PROCESS_INSTANCE_ID) 
        references BPEL_PROCESS_INSTANCE;

    if object_id('BPEL_XML_DATA', 'U') is not null alter table BPEL_XML_DATA 
        add constraint FK_g0pgad8e5x63j502w4ps9ysnh 
        foreign key (SCOPE_ID) 
        references BPEL_SCOPE;

    if object_id('BPEL_XML_DATA_PROP', 'U') is not null alter table BPEL_XML_DATA_PROP 
        add constraint FK_5pv5xml1vgquncql9irej95k7 
        foreign key (XML_DATA_ID) 
        references BPEL_XML_DATA;

    if object_id('STORE_PROCESS', 'U') is not null alter table STORE_PROCESS 
        add constraint FK_c8haf42aukvqr2udrtpyi3kdb 
        foreign key (DU) 
        references STORE_DU;

    if object_id('STORE_PROC_TO_PROP', 'U') is not null alter table STORE_PROC_TO_PROP 
        add constraint FK_ld9y5wtckspqw9us9gfeokf6a 
        foreign key (STORE_PROPERTY_ID) 
        references STORE_PROCESS_PROP;

    if object_id('STORE_PROC_TO_PROP', 'U') is not null alter table STORE_PROC_TO_PROP 
        add constraint FK_t19b3gjvbvqke3hh5mcdr2dwl 
        foreign key (STORE_PROCESS_PID) 
        references STORE_PROCESS;

    if object_id('BPAF_EVENT', 'U') is null create table BPAF_EVENT (
        EID bigint identity not null,
        ACTIVITY_DEFINITION_ID varchar(255),
        ACTIVITY_INSTANCE_ID varchar(255),
        ACTIVITY_NAME varchar(255),
        CURRENT_STATE varchar(255),
        PREVIOUS_STATE varchar(255),
        PROCESS_DEFINITION_ID varchar(255),
        PROCESS_INSTANCE_ID varchar(255),
        PROCESS_NAME varchar(255),
        SERVER_ID varchar(255),
        TIMESTAMP bigint,
        primary key (EID)
    );

    if object_id('BPAF_EVENT_DATA', 'U') is null create table BPAF_EVENT_DATA (
        TID bigint identity not null,
        NAME varchar(255),
        VALUE varchar(MAX),
        EVENT_ID bigint,
        primary key (TID)
    );

    if object_id('BPAF_EVENT_DATA', 'U') is not null alter table BPAF_EVENT_DATA 
        add constraint FK_5dx9wlbxkeho97gui4la0vjye 
        foreign key (EVENT_ID) 
        references BPAF_EVENT;