/*
 * Decompiled with CFR 0.152.
 */
package org.jbosson.plugins.fuse;

import java.lang.reflect.Array;
import java.util.SortedSet;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbosson.plugins.fuse.ActiveMQResourceComponent;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.operation.EmsOperation;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.jmx.JMXComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveMQDestinationComponent<T extends JMXComponent<?>>
extends ActiveMQResourceComponent<T> {
    private static final String BROWSE_OPERATION = "browse";
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public OperationResult invokeOperation(String name, Configuration parameters, EmsBean emsBean) throws Exception {
        if (!BROWSE_OPERATION.equals(name)) {
            return super.invokeOperation(name, parameters, emsBean);
        }
        if (emsBean == null) {
            throw new Exception("Can not invoke operation [" + name + "], as we can't connect to the MBean - is it down?");
        }
        String selector = parameters.getSimpleValue("selector");
        int requiredParams = selector != null && selector.trim().isEmpty() ? 1 : 0;
        String returnType = new CompositeData[0].getClass().toString().substring(6);
        SortedSet operations = emsBean.getOperations();
        EmsOperation browseMessagesOp = null;
        for (EmsOperation operation : operations) {
            if (!BROWSE_OPERATION.equals(operation.getName()) || !operation.getReturnType().equals(returnType) || operation.getParameters().size() != requiredParams) continue;
            browseMessagesOp = operation;
            break;
        }
        if (browseMessagesOp == null) {
            throw new Exception("Missing operation CompositeData[] browse(" + (requiredParams == 1 ? "String" : "") + ")");
        }
        Object opResult = requiredParams == 1 ? browseMessagesOp.invoke(new Object[]{selector}) : browseMessagesOp.invoke(new Object[0]);
        PropertyList messageList = new PropertyList("messageList");
        int nMsgs = Array.getLength(opResult);
        for (int i = 0; i < nMsgs; ++i) {
            PropertyMap msgMap = new PropertyMap("message");
            CompositeData compositeData = (CompositeData)Array.get(opResult, i);
            for (String key : compositeData.getCompositeType().keySet()) {
                Object value = compositeData.get(key);
                if (value != null && value instanceof TabularData) continue;
                if (value != null && value.getClass().isArray()) {
                    StringBuilder builder = new StringBuilder("[");
                    int size = Array.getLength(value);
                    for (int index = 0; index < size; ++index) {
                        builder.append(Array.get(value, index));
                        if (index >= size - 1) continue;
                        builder.append(", ");
                    }
                    builder.append(']');
                    msgMap.put((Property)new PropertySimple(key, (Object)builder.toString()));
                    continue;
                }
                msgMap.put((Property)new PropertySimple(key, (Object)(value != null ? value.toString() : null)));
            }
            messageList.add((Property)msgMap);
        }
        OperationResult result = new OperationResult();
        result.getComplexResults().put((Property)messageList);
        return result;
    }
}

