/*
 * Decompiled with CFR 0.152.
 */
package org.jbosson.plugins.fuse;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ManualAddFacet;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.util.Base64;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.BaseServerComponent;
import org.rhq.modules.plugins.jbossas7.JBossProductType;
import org.rhq.modules.plugins.jbossas7.ManagedASComponent;
import org.rhq.modules.plugins.jbossas7.StandaloneASComponent;
import org.rhq.modules.plugins.jbossas7.helper.ServerPluginConfiguration;
import org.rhq.modules.plugins.jbossas7.jmx.ApplicationMBeansDiscoveryComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FuseJBossAS7MBeansDiscoveryComponent
extends ApplicationMBeansDiscoveryComponent
implements ManualAddFacet<BaseComponent<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(FuseJBossAS7MBeansDiscoveryComponent.class);
    private static final String HOSTNAME = "hostname";
    private static final String PORT = "port";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String CLIENT_JAR_LOCATION = "clientJarLocation";
    private static final String PROTOCOL = "protocol";
    private static final int STANDALONE_REMOTING_PORT_OFFSET = 9;
    private static final int DOMAIN_REMOTING_PORT_DEFAULT = 4447;
    private static final String MANAGED_SERVER_PORT_OFFSET_PROPERTY_NAME = "socket-binding-port-offset";
    private static final int HTTP_PORT_DEFAULT = 8080;
    private ThreadLocal<ResourceDiscoveryContext<BaseComponent<?>>> context = new ThreadLocal();

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<BaseComponent<?>> context) throws Exception {
        this.context.set(context);
        return super.discoverResources(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getCredentialsForManagedAS() {
        File rhqUserFile;
        block16: {
            ResourceDiscoveryContext<BaseComponent<?>> discoveryContext = this.context.get();
            BaseServerComponent serverComponent = ((BaseComponent)discoveryContext.getParentResourceComponent()).getServerComponent();
            ServerPluginConfiguration serverConfig = serverComponent.getServerPluginConfiguration();
            File homeDir = serverConfig.getHomeDir();
            rhqUserFile = new File(homeDir, "domain/configuration/rhq-user.properties");
            if (rhqUserFile.isFile()) {
                FileInputStream inputStream = null;
                try {
                    inputStream = new FileInputStream(rhqUserFile);
                    Properties userProperties = new Properties();
                    userProperties.load(inputStream);
                    if (userProperties.size() != 1) {
                        LOG.warn("File {} MUST contain a single entry of the form username=<BASE64 encoded utf-8-password>", (Object)rhqUserFile);
                        break block16;
                    }
                    Map.Entry<Object, Object> entry = userProperties.entrySet().iterator().next();
                    String[] stringArray = new String[]{entry.getKey().toString(), new String(Base64.decode((String)entry.getValue().toString()), "UTF-8")};
                    return stringArray;
                }
                catch (IOException e) {
                    LOG.warn("Error reading rhq-user.properties file, resource " + discoveryContext.getResourceType().getName() + " must be manually imported for parent resource " + discoveryContext.getParentResourceContext().getResourceDetails(), (Throwable)e);
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        LOG.debug("Management user not configured in {}, trying default user rhqadmin", (Object)rhqUserFile);
        return super.getCredentialsForManagedAS();
    }

    public DiscoveredResourceDetails discoverResource(Configuration configuration, ResourceDiscoveryContext<BaseComponent<?>> resourceDiscoveryContext) throws InvalidPluginConfigurationException {
        BaseComponent parentComponent = (BaseComponent)resourceDiscoveryContext.getParentResourceComponent();
        BaseServerComponent serverComponent = parentComponent.getServerComponent();
        ServerPluginConfiguration serverPluginConfiguration = serverComponent.getServerPluginConfiguration();
        JBossProductType productType = serverPluginConfiguration.getProductType();
        if (configuration.getSimpleValue(HOSTNAME) == null) {
            configuration.setSimpleValue(HOSTNAME, serverPluginConfiguration.getHostname());
        }
        if (configuration.getSimpleValue(PORT) == null) {
            int port;
            if (parentComponent instanceof ManagedASComponent) {
                Configuration managedASConfig;
                ManagedASComponent managedASComponent = (ManagedASComponent)parentComponent;
                try {
                    managedASConfig = managedASComponent.loadResourceConfiguration();
                }
                catch (Exception e) {
                    throw new InvalidPluginConfigurationException("Error adding resource: " + e.getMessage(), (Throwable)e);
                }
                PropertySimple offsetProp = managedASConfig.getSimple(MANAGED_SERVER_PORT_OFFSET_PROPERTY_NAME);
                if (offsetProp == null) {
                    throw new InvalidPluginConfigurationException("Could not find Managed Server socket binding offset, skipping discovery");
                }
                port = productType != JBossProductType.WILDFLY8 ? 4447 : 8080;
                port += offsetProp.getIntegerValue().intValue();
            } else if (parentComponent instanceof StandaloneASComponent) {
                port = serverPluginConfiguration.getPort();
                if (productType != JBossProductType.WILDFLY8) {
                    port += 9;
                }
                configuration.setSimpleValue(USERNAME, serverPluginConfiguration.getUser());
                configuration.setSimpleValue(PASSWORD, serverPluginConfiguration.getPassword());
            } else {
                throw new InvalidPluginConfigurationException(parentComponent + " is not a supported parent component");
            }
            configuration.setSimpleValue(PORT, String.valueOf(port));
        }
        String clientJarPath = "bin" + File.separator + "client" + File.separator + "jboss-client.jar";
        File clientJarFile = new File(serverPluginConfiguration.getHomeDir(), clientJarPath);
        if (!clientJarFile.isFile()) {
            throw new InvalidPluginConfigurationException(clientJarFile + " does not exist.");
        }
        configuration.setSimpleValue(CLIENT_JAR_LOCATION, clientJarFile.getAbsolutePath());
        configuration.setSimpleValue(PROTOCOL, productType == JBossProductType.WILDFLY8 ? "http-remoting-jmx" : "remoting-jmx");
        if (ApplicationMBeansDiscoveryComponent.loadEmsConnection((Configuration)configuration, (File)resourceDiscoveryContext.getParentResourceContext().getTemporaryDirectory()) == null) {
            throw new InvalidPluginConfigurationException("Unable to connect to management service, enable agent debug logging for more details");
        }
        return new DiscoveredResourceDetails(resourceDiscoveryContext.getResourceType(), this.getNewResourceKey(configuration), this.getNewResourceName(configuration), this.getNewResourceVersion(configuration), this.getNewResourceDescription(configuration), configuration, null);
    }
}

