/*
 * Decompiled with CFR 0.152.
 */
package org.jbosson.plugins.fuse;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbosson.plugins.fuse.FuseMBeanDiscoveryComponent;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.util.ObjectNameQueryUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveMQDiscoveryComponent<T extends JMXComponent<?>>
extends FuseMBeanDiscoveryComponent<T> {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String PROPERTY_OBJECT_NAME1 = "objectName1";
    protected ResourceDiscoveryContext<T> discoveryContext;

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<T> context) {
        this.discoveryContext = context;
        return super.discoverResources(context);
    }

    public Set<DiscoveredResourceDetails> performDiscovery(Configuration pluginConfiguration, JMXComponent parentResourceComponent, ResourceType resourceType, boolean skipUnknownProps) {
        String objectNameQueryTemplateOrig = pluginConfiguration.getSimple("objectName").getStringValue();
        Set<DiscoveredResourceDetails> detailsSet = this.performDiscovery(pluginConfiguration, parentResourceComponent, resourceType, skipUnknownProps, objectNameQueryTemplateOrig);
        if (detailsSet.isEmpty()) {
            objectNameQueryTemplateOrig = pluginConfiguration.getSimple(PROPERTY_OBJECT_NAME1).getStringValue();
            detailsSet = this.performDiscovery(pluginConfiguration, parentResourceComponent, resourceType, skipUnknownProps, objectNameQueryTemplateOrig);
        }
        return detailsSet;
    }

    protected Set<DiscoveredResourceDetails> performDiscovery(Configuration pluginConfiguration, JMXComponent parentResourceComponent, ResourceType resourceType, boolean skipUnknownProps, String objectNameQueryTemplateOrig) {
        String[] templates;
        this.log.debug((Object)("Discovering MBean resources with object name query template: " + objectNameQueryTemplateOrig));
        EmsConnection connection = parentResourceComponent.getEmsConnection();
        if (connection == null) {
            throw new NullPointerException("The parent resource component [" + parentResourceComponent + "] returned a null connection - cannot discover MBeans without a connection");
        }
        HashSet<DiscoveredResourceDetails> services = new HashSet<DiscoveredResourceDetails>();
        for (String objectNameQueryTemplate : templates = objectNameQueryTemplateOrig.split("\\|")) {
            ObjectNameQueryUtility queryUtility = new ObjectNameQueryUtility(objectNameQueryTemplate, this.discoveryContext != null ? this.discoveryContext.getParentResourceContext().getPluginConfiguration() : null);
            List beans = connection.queryBeans(queryUtility.getTranslatedQuery());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Found [" + beans.size() + "] mbeans for query [" + queryUtility.getTranslatedQuery() + "]."));
            }
            for (EmsBean bean : beans) {
                if (!queryUtility.setMatchedKeyValues(bean.getBeanName().getKeyProperties()) || skipUnknownProps && queryUtility.isContainsExtraKeyProperties(bean.getBeanName().getKeyProperties().keySet())) continue;
                String resourceKey = bean.getBeanName().getCanonicalName();
                String nameTemplate = pluginConfiguration.getSimple("nameTemplate") != null ? pluginConfiguration.getSimple("nameTemplate").getStringValue() : null;
                String descriptionTemplate = pluginConfiguration.getSimple("descriptionTemplate") != null ? pluginConfiguration.getSimple("descriptionTemplate").getStringValue() : null;
                String name = resourceKey;
                if (nameTemplate != null) {
                    name = queryUtility.formatMessage(nameTemplate);
                }
                String description = null;
                if (descriptionTemplate != null) {
                    description = queryUtility.formatMessage(descriptionTemplate);
                }
                DiscoveredResourceDetails service = new DiscoveredResourceDetails(resourceType, resourceKey, name, "", description, null, null);
                Configuration config = service.getPluginConfiguration();
                config.put((Property)new PropertySimple("objectName", (Object)bean.getBeanName().toString()));
                Map mappedVariableValues = queryUtility.getVariableValues();
                for (String key : mappedVariableValues.keySet()) {
                    config.put((Property)new PropertySimple(key, mappedVariableValues.get(key)));
                }
                services.add(service);
                queryUtility.resetVariables();
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("[" + services.size() + "] services have been added"));
        }
        return services;
    }
}

