/*
 * Decompiled with CFR 0.152.
 */
package org.jbosson.plugins.fuse;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbosson.plugins.fuse.FuseServerDiscoveryComponent;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.ClassLoaderFacet;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.system.ProcessInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FabricContainerDiscoveryComponent
extends FuseServerDiscoveryComponent
implements ClassLoaderFacet {
    public static final Log log = LogFactory.getLog(FabricContainerDiscoveryComponent.class);
    private static final String KARAF_BASE_PROPERTY = "karaf.base";
    private static final String KARAF_HOME_PROPERTY = "karaf.home";
    private static final String CHILD_PREFIX = "Child ";
    private static final String DEFAULT_KARAF_NAME = "root";
    static final String KARAF_NAME_PROPERTY = "karaf.name";
    static final String ZOOKEEPER_URL_PROPERTY = "zookeeper.url";
    static final String ZOOKEEPER_PASSWORD_PROPERTY = "zookeeper.password";
    private static final String ETC_SYSTEM_PROPERTIES = "etc/system.properties";
    private static final String FUSE_ESB_ENTERPRISE_PRODUCT = "Fuse ESB Enterprise";
    private static final String FUSE_MQ_ENTERPRISE_PRODUCT = "Fuse MQ Enterprise";
    private static final String FUSE_MANAGEMENT_CONSOLE_PRODUCT = "Fuse Management Console";
    private static final String GENERIC_FABRIC_CONTAINER = "Fabric Container";
    private static final String CONTAINER_TYPE_PROPERTY = "container.type";

    protected boolean populateResourceProperties(ResourceDiscoveryContext context, DiscoveredResourceDetails details) {
        File fuseFmcScript;
        File fuseMqScript;
        if (!super.populateResourceProperties(context, details)) {
            return false;
        }
        Configuration pluginConfiguration = details.getPluginConfiguration();
        String karafHomePath = pluginConfiguration.getSimpleValue(KARAF_HOME_PROPERTY);
        String karafBasePath = pluginConfiguration.getSimpleValue(KARAF_BASE_PROPERTY);
        String resourceTypeName = details.getResourceType().getName();
        if (!karafHomePath.equals(karafBasePath)) {
            details.setResourceName(details.getResourceName().replace(resourceTypeName, CHILD_PREFIX + resourceTypeName));
            details.setResourceDescription(details.getResourceDescription().replace(resourceTypeName, CHILD_PREFIX + resourceTypeName));
        }
        File karafHome = new File(karafHomePath);
        File karafBase = new File(karafBasePath);
        Properties serverProperties = this.getServerProperties(karafBase);
        String karafName = serverProperties.getProperty(KARAF_NAME_PROPERTY);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found " + details.getResourceType().getName() + " with container name: " + karafName));
        }
        pluginConfiguration.setSimpleValue(KARAF_NAME_PROPERTY, karafName);
        File fuseEsbScript = this.findVersionFile(karafHome, Pattern.compile("bin/fuseesb(.bat)?$"));
        String productName = fuseEsbScript != null ? FUSE_ESB_ENTERPRISE_PRODUCT : ((fuseMqScript = this.findVersionFile(karafHome, Pattern.compile("bin/fusemq(.bat)?$"))) != null ? FUSE_MQ_ENTERPRISE_PRODUCT : ((fuseFmcScript = this.findVersionFile(karafHome, Pattern.compile("bin/fmc(.bat)?$"))) != null ? FUSE_MANAGEMENT_CONSOLE_PRODUCT : GENERIC_FABRIC_CONTAINER));
        pluginConfiguration.setSimpleValue(CONTAINER_TYPE_PROPERTY, productName);
        String oldResourceKey = details.getResourceKey();
        details.setResourceKey(oldResourceKey.replace(resourceTypeName, productName));
        details.setResourceName(details.getResourceName().replace(oldResourceKey, details.getResourceKey()));
        details.setResourceName(details.getResourceName().replace(resourceTypeName, productName + " [" + karafName + "]"));
        details.setResourceDescription(details.getResourceDescription().replace(resourceTypeName, productName));
        String zkProperty = pluginConfiguration.getSimpleValue(ZOOKEEPER_URL_PROPERTY);
        if (zkProperty == null) {
            String[] zookeeperUrlPassword = this.getZookeeperUrlPassword(karafHome, karafBase);
            pluginConfiguration.setSimpleValue(ZOOKEEPER_URL_PROPERTY, zookeeperUrlPassword[0]);
            pluginConfiguration.setSimpleValue(ZOOKEEPER_PASSWORD_PROPERTY, zookeeperUrlPassword[1]);
        }
        return true;
    }

    private Properties getServerProperties(File karafBase) {
        Properties serverProperties = new Properties();
        serverProperties.setProperty(KARAF_NAME_PROPERTY, DEFAULT_KARAF_NAME);
        File systemPropertiesFile = new File(karafBase, ETC_SYSTEM_PROPERTIES);
        this.loadPropertiesFile(systemPropertiesFile, serverProperties);
        return serverProperties;
    }

    private String[] getZookeeperUrlPassword(File karafHome, File karafBase) {
        Properties serverProperties = this.getServerProperties(karafBase);
        String zookeeperUrl = serverProperties.getProperty(ZOOKEEPER_URL_PROPERTY);
        String zookeeperPassword = serverProperties.getProperty(ZOOKEEPER_PASSWORD_PROPERTY);
        if (zookeeperUrl == null) {
            if (!karafHome.equals(karafBase)) {
                String[] zookeeperUrlPassword = this.getChildZooKeeperUrlPassword(karafBase.getAbsolutePath(), serverProperties.getProperty(KARAF_NAME_PROPERTY));
                zookeeperUrl = zookeeperUrlPassword[0];
                zookeeperPassword = zookeeperUrlPassword[1];
            } else {
                log.warn((Object)"Looking for zookeeper.url in data/cache/**/zookeeper.config");
                File zookeperConfig = this.findVersionFile(new File(karafBase, "data/cache"), Pattern.compile("config/org/fusesource/fabric/zookeeper.config"));
                if (zookeperConfig != null) {
                    log.debug((Object)("Found zookeeper.config at " + zookeperConfig));
                    Properties zkConfigProps = new Properties();
                    this.loadPropertiesFile(zookeperConfig, zkConfigProps);
                    zookeeperUrl = zkConfigProps.getProperty(ZOOKEEPER_URL_PROPERTY);
                    zookeeperPassword = zkConfigProps.getProperty(ZOOKEEPER_PASSWORD_PROPERTY);
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Found %s in file %s under directory %s", ZOOKEEPER_URL_PROPERTY, ETC_SYSTEM_PROPERTIES, karafBase));
            log.debug((Object)String.format("Found %s in file %s under directory %s", ZOOKEEPER_PASSWORD_PROPERTY, ETC_SYSTEM_PROPERTIES, karafBase));
        }
        if (zookeeperUrl != null) {
            zookeeperUrl = zookeeperUrl.replaceAll("\"", "");
        }
        if (zookeeperPassword != null) {
            zookeeperPassword = zookeeperPassword.replaceAll("\"", "");
        }
        return new String[]{zookeeperUrl, zookeeperPassword};
    }

    protected Configuration getConfigWithJmxServiceUrl(ResourceDiscoveryContext context, ProcessInfo process) {
        try {
            Configuration pluginConfiguration = context.getDefaultPluginConfiguration();
            String basePath = this.getSystemPropertyValue(process, KARAF_BASE_PROPERTY);
            File karafBase = new File(basePath);
            Properties serverProps = this.getServerProperties(karafBase);
            this.loadPropertiesFile(new File(basePath, "etc/org.apache.karaf.management.cfg"), serverProps);
            String serviceUrl = serverProps.getProperty("serviceUrl");
            if (serviceUrl != null) {
                Pattern propPattern = Pattern.compile("\\$\\{[^\\{\\}]+\\}");
                Matcher matcher = propPattern.matcher(serviceUrl);
                while (matcher.find()) {
                    String property = matcher.group();
                    String value = serverProps.getProperty(property.substring(2, property.length() - 1));
                    if (value == null) {
                        throw new InvalidPluginConfigurationException("Missing value for property " + property + " in serviceUrl");
                    }
                    serviceUrl = serviceUrl.replace(property, value);
                }
                pluginConfiguration.setSimpleValue("connectorAddress", serviceUrl);
            } else {
                log.warn((Object)"Unable to read JMX URL from etc/org.apache.karaf.management.cfg");
            }
            String adminRole = serverProps.getProperty("jmxRole");
            if (adminRole == null && (adminRole = serverProps.getProperty("karaf.admin.role")) == null) {
                log.debug((Object)"Using default admin role [admin]");
                adminRole = "admin";
            }
            Properties usersProperties = new Properties();
            this.loadPropertiesFile(new File(basePath, "etc/users.properties"), usersProperties);
            for (Map.Entry<Object, Object> entry : usersProperties.entrySet()) {
                String value = (String)entry.getValue();
                if (!value.contains(adminRole)) continue;
                pluginConfiguration.setSimpleValue("principal", (String)entry.getKey());
                pluginConfiguration.setSimpleValue("credentials", value.substring(0, value.indexOf(44)));
                break;
            }
            String[] zookeeperUrlPassword = this.getZookeeperUrlPassword(new File(this.getSystemPropertyValue(process, KARAF_HOME_PROPERTY)), karafBase);
            pluginConfiguration.setSimpleValue(ZOOKEEPER_URL_PROPERTY, zookeeperUrlPassword[0]);
            pluginConfiguration.setSimpleValue(ZOOKEEPER_PASSWORD_PROPERTY, zookeeperUrlPassword[1]);
            if (zookeeperUrlPassword[0] != null) {
                log.warn((Object)"Container uses Fabric Zookeeper registry, using default JMX user");
                pluginConfiguration.setSimpleValue("principal", "admin");
                pluginConfiguration.setSimpleValue("credentials", "admin");
            }
            return pluginConfiguration;
        }
        catch (Exception e) {
            log.warn((Object)("Error getting JMX properties from Fabric container: [" + e.getMessage() + "], using default connection properties"), (Throwable)e);
            return super.getConfigWithJmxServiceUrl(context, process);
        }
    }

    private String[] getChildZooKeeperUrlPassword(String basePath, String karafName) {
        File karafBase = new File(basePath);
        Properties instanceProps = new Properties();
        File propertiesFile = new File(karafBase.getParent(), "instance.properties");
        this.loadPropertiesFile(propertiesFile, instanceProps);
        String zooKeeperUrl = null;
        String zooKeeperPassword = null;
        for (Map.Entry<Object, Object> entry : instanceProps.entrySet()) {
            int end;
            if (!karafName.equals(entry.getValue())) continue;
            String key = (String)entry.getKey();
            String instanceOpts = instanceProps.getProperty(key.replace("name", "opts"));
            if (instanceOpts.contains(ZOOKEEPER_URL_PROPERTY)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found zookeeper.url in " + propertiesFile));
                }
                end = (zooKeeperUrl = instanceOpts.substring(instanceOpts.indexOf(ZOOKEEPER_URL_PROPERTY) + ZOOKEEPER_URL_PROPERTY.length() + 2)).indexOf(32) != -1 ? zooKeeperUrl.indexOf(32) - 1 : zooKeeperUrl.length();
                zooKeeperUrl = zooKeeperUrl.substring(0, end);
            }
            if (!instanceOpts.contains(ZOOKEEPER_PASSWORD_PROPERTY)) break;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found zookeeper.password in " + propertiesFile));
            }
            end = (zooKeeperPassword = instanceOpts.substring(instanceOpts.indexOf(ZOOKEEPER_PASSWORD_PROPERTY) + ZOOKEEPER_PASSWORD_PROPERTY.length() + 2)).indexOf(32) != -1 ? zooKeeperPassword.indexOf(32) - 1 : zooKeeperPassword.length();
            zooKeeperPassword = zooKeeperPassword.substring(0, end);
            break;
        }
        return new String[]{zooKeeperUrl, zooKeeperPassword};
    }

    protected void initLogEventSourcesConfigProp(File homeDir, Configuration pluginConfiguration, ProcessInfo process) {
        String karafHome = pluginConfiguration.getSimpleValue(KARAF_HOME_PROPERTY);
        String karafBase = pluginConfiguration.getSimpleValue(KARAF_BASE_PROPERTY);
        String logFile = "{karaf.base}/data/log/karaf.log";
        if (karafHome.equals(karafBase)) {
            String productType = pluginConfiguration.getSimpleValue(CONTAINER_TYPE_PROPERTY);
            if (FUSE_ESB_ENTERPRISE_PRODUCT.equals(productType)) {
                logFile = "{karaf.base}/data/log/fuseesb.log";
            } else if (FUSE_MQ_ENTERPRISE_PRODUCT.equals(productType)) {
                logFile = "{karaf.base}/data/log/fusemq.log";
            }
        }
        pluginConfiguration.setSimpleValue("logFile", logFile);
        super.initLogEventSourcesConfigProp(homeDir, pluginConfiguration, process);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPropertiesFile(File propertiesFile, Properties properties) {
        if (propertiesFile.exists()) {
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(propertiesFile);
                properties.load(stream);
            }
            catch (IOException e) {
                String message = "Error reading " + propertiesFile;
                log.warn((Object)message, (Throwable)e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {}
                }
            }
        } else {
            log.warn((Object)("File " + propertiesFile.getAbsolutePath() + " does not exist"));
        }
    }

    public List<URL> getAdditionalClasspathUrls(ResourceDiscoveryContext context, DiscoveredResourceDetails details) throws Exception {
        String karafHomePath = details.getPluginConfiguration().getSimpleValue(KARAF_HOME_PROPERTY);
        File zooKeeperLib = this.findVersionFile(new File(karafHomePath + "/system"), Pattern.compile("fabric-linkedin-zookeeper-.*\\.jar"));
        if (zooKeeperLib == null) {
            throw new InvalidPluginConfigurationException("Missing ZooKeeper library fabric-linkedin-zookeeper*.jar in " + karafHomePath + "/system");
        }
        return Arrays.asList(zooKeeperLib.toURI().toURL());
    }
}

