/*
 * Decompiled with CFR 0.152.
 */
package org.jbosson.plugins.fuse.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.FS;
import org.jbosson.plugins.fuse.JBossFuseContainerTraits;
import org.jbosson.plugins.fuse.JBossFuseProfileGroupManager;
import org.jbosson.plugins.fuse.utils.DataStore;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;

public class GitDataStoreImpl
implements DataStore {
    private static final Log LOG = LogFactory.getLog(GitDataStoreImpl.class);
    private static final String UTF_8 = "UTF-8";
    private static final String MQ_SERVER_BROKER_PROPERTIES = "fabric/profiles/%s.profile/org.fusesource.mq.fabric.server-broker.properties";
    private static final String MQ_TEMPLATE_PROPERTIES = "fabric/profiles/%s.profile/org.fusesource.mq.fabric.template.properties";
    private static final String AGENT_PROPERTIES = "fabric/profiles/%s.profile/io.fabric8.agent.properties";
    private static final String ATTRIBUTES_PROPERTIES = "fabric/profiles/%s.profile/io.fabric8.profile.attributes.properties";
    private static final String AGENT_MVEL_PROPERTIES = "fabric/profiles/%s.profile/io.fabric8.agent.properties.mvel";
    private static final String ATTRIBUTE_PREFIX = "attribute.";
    private Repository repository;
    private final RevTree masterTree;
    private final RevTree versionTree;

    public GitDataStoreImpl(File gitRepo, String containerVersion) throws InvalidPluginConfigurationException {
        try {
            FileRepositoryBuilder builder = new FileRepositoryBuilder();
            RepositoryCache.FileKey key = RepositoryCache.FileKey.lenient((File)gitRepo, (FS)FS.DETECTED);
            this.repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setFS(FS.DETECTED)).setGitDir(key.getFile())).setMustExist(true)).build();
            this.masterTree = this.getRevTree("master");
            this.versionTree = this.getRevTree(containerVersion);
        }
        catch (IOException e) {
            throw new InvalidPluginConfigurationException(String.format("Error opening Fabric Git Repo at [%s]: %s", gitRepo, e.getMessage()), (Throwable)e);
        }
    }

    public void close() throws Exception {
        if (this.repository != null) {
            this.repository.close();
        }
    }

    public void getFabricMetadata(String profileName, JBossFuseContainerTraits traits) throws InvalidPluginConfigurationException {
        if (!JBossFuseProfileGroupManager.ENSEMBLE_PROFILE_PATTERN.matcher(profileName).matches()) {
            String brokerClusterName = null;
            try {
                String profilePathName = GitDataStoreImpl.gitPathName(profileName);
                Properties brokerProperties = this.findProfileProperties(this.versionTree, new PropertiesAcceptor(){

                    public boolean accept(Properties properties) {
                        return properties.containsKey("group");
                    }
                }, profilePathName, MQ_SERVER_BROKER_PROPERTIES, MQ_TEMPLATE_PROPERTIES);
                if (brokerProperties != null) {
                    LOG.debug((Object)("Broker properties found in profile " + profileName));
                    brokerClusterName = brokerProperties.getProperty("group");
                    LOG.debug((Object)("Found Broker Cluster " + brokerClusterName));
                } else {
                    LOG.debug((Object)("Broker properties NOT found in profile " + profileName));
                }
            }
            catch (IOException e) {
                throw new InvalidPluginConfigurationException("Error looking up MQ broker properties: " + e.getMessage(), (Throwable)e);
            }
            if (brokerClusterName != null) {
                traits.addCluster(brokerClusterName);
            }
        }
        try {
            String[] parents;
            String parentList = this.getParents(profileName);
            if (parentList != null && traits.setParentProfiles(profileName, parents = parentList.split(" "))) {
                for (String parent : parents) {
                    if (traits.hasChildProfile(parent)) continue;
                    this.getFabricMetadata(parent, traits);
                }
            }
        }
        catch (IOException e) {
            throw new InvalidPluginConfigurationException("Error getting Parent profiles for " + profileName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    protected String getParents(String profileName) throws IOException {
        String profilePathName = GitDataStoreImpl.gitPathName(profileName);
        RevTree tree = JBossFuseProfileGroupManager.ENSEMBLE_PROFILE_PATTERN.matcher(profileName).matches() ? this.masterTree : this.versionTree;
        Properties properties = this.findProfileProperties(tree, new PropertiesAcceptor(){

            public boolean accept(Properties properties) {
                return properties.containsKey("parents") || properties.containsKey("attribute.parents");
            }
        }, profilePathName, AGENT_PROPERTIES, ATTRIBUTES_PROPERTIES, AGENT_MVEL_PROPERTIES);
        String parents = null;
        if (properties != null && (parents = properties.getProperty("parents")) == null) {
            parents = properties.getProperty("attribute.parents");
        }
        return parents;
    }

    protected static String gitPathName(String profileName) {
        return profileName.replaceAll("-", "/");
    }

    protected static String gitPath(String pathFormat, String profilePathName) {
        return String.format(pathFormat, profilePathName);
    }

    protected Properties findProfileProperties(RevTree tree, PropertiesAcceptor acceptor, String profile, String ... paths) throws IOException {
        for (String path : paths) {
            Properties properties = this.getPropertiesFile(tree, GitDataStoreImpl.gitPath(path, profile));
            if (properties == null || !acceptor.accept(properties)) continue;
            return properties;
        }
        return null;
    }

    protected Properties getPropertiesFile(RevTree tree, String pathFilter) throws IOException {
        TreeWalk treeWalk = TreeWalk.forPath((Repository)this.repository, (String)pathFilter, (RevTree)tree);
        if (treeWalk == null) {
            return null;
        }
        ObjectId objectId = treeWalk.getObjectId(0);
        ObjectLoader loader = this.repository.open((AnyObjectId)objectId);
        Properties properties = new Properties();
        properties.load(new InputStreamReader((InputStream)new ByteArrayInputStream(loader.getBytes()), Charset.forName(UTF_8)));
        return properties;
    }

    protected RevTree getRevTree(String branch) throws IOException {
        Ref ref = this.repository.getRef("refs/heads/" + branch);
        if (ref == null) {
            throw new InvalidPluginConfigurationException("Missing Git branch " + branch);
        }
        ObjectId lastCommitId = ref.getObjectId();
        RevWalk revWalk = new RevWalk(this.repository);
        RevCommit commit = revWalk.parseCommit((AnyObjectId)lastCommitId);
        return commit.getTree();
    }

    private static interface PropertiesAcceptor {
        public boolean accept(Properties var1);
    }
}

