/*
 * Decompiled with CFR 0.152.
 */
package org.jbosson.plugins.fuse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.criteria.MeasurementDataTraitCriteria;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.criteria.ResourceGroupDefinitionCriteria;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.group.GroupDefinition;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerLocal;
import org.rhq.enterprise.server.plugin.pc.ScheduledJobInvocationContext;
import org.rhq.enterprise.server.plugin.pc.ServerPluginComponent;
import org.rhq.enterprise.server.plugin.pc.ServerPluginContext;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.group.definition.GroupDefinitionManagerLocal;
import org.rhq.enterprise.server.resource.group.definition.exception.GroupDefinitionAlreadyExistsException;
import org.rhq.enterprise.server.resource.group.definition.exception.GroupDefinitionCreateException;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FabricProfileGroupsComponent
implements ServerPluginComponent {
    private final Log log = LogFactory.getLog(FabricProfileGroupsComponent.class);
    private static final String CONTAINER_VERSION_TRAIT = "container.version";
    private static final String FABRIC_REGISTRIES_PROPERTY = "fabricRegistries";
    private static final String RHQ_USER_PROPERTY = "rhq.user";
    private static final String RHQ_PASSWORD_PROPERTY = "rhq.password";
    private static final String RECALCULATION_INTERVAL_PROPERTY = "groups.recalculationInterval";
    private static final String PROFILES_PROFILE_GROUPS = "profiles.profileGroups";
    private static final String PROFILES_PARENT_GROUPS = "profiles.parentGroups";
    private static final String REGISTRY_PROPERTIES_MAP = "registryProperties";
    private static final String FABRIC_CONTAINER_TYPE = "Fabric Container";
    private static final String JBOSS_FUSE_CONTAINER_TYPE = "JBoss Fuse Container";
    private static final String DEFAULT_REGISTRY_URL = "*";
    private static final String ZOOKEEPER_URL_PROPERTY = "zookeeper.url";
    private static final String PROFILES_TRAIT = "profiles";
    private static final String PARENT_PROFILES_TRAIT = "parentProfiles";
    private static final String MQ_CLUSTERS_TRAIT = "mqClusters";
    private static final String DEFAULT_PROFILE_INCLUDES = ".*";
    private static final String DEFAULT_PROFILE_EXCLUDES = "fabric-ensemble.* default karaf mq-base";
    private static final String PROFILES_EXCLUDE = "profiles.exclude";
    private static final String PROFILES_INCLUDE = "profiles.include";
    private static final String DEFAULT_ENABLE_PROFILE_GROUPS = "true";
    private static final String DEFAULT_DISABLE_PARENT_PROFILES = "false";
    private ServerPluginContext context;
    private String userName;
    private String userPassword;
    private final Map<String, PropertyMap> registryPropertiesMap = new HashMap<String, PropertyMap>();
    private long recalculationInterval;

    public void initialize(ServerPluginContext context) throws Exception {
        this.context = context;
        Configuration pluginConfiguration = context.getPluginConfiguration();
        this.userName = pluginConfiguration.getSimpleValue(RHQ_USER_PROPERTY);
        if (this.userName == null) {
            throw new IllegalArgumentException("Fabric profile groups server plugin is misconfigured - User Name property is not set");
        }
        this.userPassword = pluginConfiguration.getSimpleValue(RHQ_PASSWORD_PROPERTY);
        if (this.userPassword == null) {
            throw new IllegalArgumentException("Fabric profile groups server plugin is misconfigured - User Password property is not set");
        }
        String recalculationIntervalStr = pluginConfiguration.getSimpleValue(RECALCULATION_INTERVAL_PROPERTY);
        if (recalculationIntervalStr == null) {
            throw new IllegalArgumentException("Fabric profile groups server plugin is misconfigured - Recalculation Interval property is not set");
        }
        this.recalculationInterval = Long.parseLong(recalculationIntervalStr);
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        Subject subject = subjectManager.login(this.userName, this.userPassword);
        subjectManager.logout(subject);
        this.parseFabricRegistries();
        this.log.info((Object)"The Fabric profile groups server plugin has been initialized!!!");
    }

    public void start() {
        this.log.info((Object)"The Fabric profile groups server plugin has started!!!");
    }

    public void stop() {
        this.log.info((Object)"The Fabric profile groups server plugin has stopped!!!");
    }

    public void shutdown() {
        this.registryPropertiesMap.clear();
        this.log.info((Object)"The Fabric profile groups server plugin has been shut down!!!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createProfileGroups(ScheduledJobInvocationContext invocation) throws Exception {
        this.log.info((Object)"The Fabric profile groups server plugin scheduled job [createProfileGroups] has triggered!!!");
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        Subject subject = subjectManager.login(this.userName, this.userPassword);
        try {
            ArrayList containers = new ArrayList();
            ResourceCriteria criteria = new ResourceCriteria();
            criteria.addFilterResourceTypeName(FABRIC_CONTAINER_TYPE);
            criteria.addFilterResourceCategories(new ResourceCategory[]{ResourceCategory.SERVER});
            criteria.addFilterParentResourceCategory(ResourceCategory.PLATFORM);
            criteria.fetchPluginConfiguration(true);
            ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
            PageList fabricContainers = resourceManager.findResourcesByCriteria(subject, criteria);
            containers.addAll(fabricContainers);
            criteria.addFilterResourceTypeName(JBOSS_FUSE_CONTAINER_TYPE);
            PageList jbossFuseContainers = resourceManager.findResourcesByCriteria(subject, criteria);
            containers.addAll(jbossFuseContainers);
            HashSet<FabricProfileInfo> profiles = new HashSet<FabricProfileInfo>();
            HashSet<MQClusterInfo> mqClusters = new HashSet<MQClusterInfo>();
            if (!containers.isEmpty()) {
                MeasurementDataManagerLocal dataManager = LookupUtil.getMeasurementDataManager();
                for (Resource container : containers) {
                    if (this.getZooKeeperUrl(container) == null) continue;
                    this.getContainerMetadata(container, subject, dataManager, profiles, mqClusters);
                }
                GroupDefinitionManagerLocal groupDefinitionManager = LookupUtil.getGroupDefinitionManager();
                for (FabricProfileInfo profile : profiles) {
                    this.processContainerProfile(profile, subject, groupDefinitionManager);
                }
                for (MQClusterInfo mqCluster : mqClusters) {
                    this.processMqCluster(mqCluster, subject, groupDefinitionManager);
                }
            }
            this.log.info((Object)String.format("Found %s Fabric Containers, %s Profiles, and %s MQ Clusters", containers.size(), profiles.size(), mqClusters.size()));
        }
        finally {
            subjectManager.logout(subject);
        }
    }

    private void getContainerMetadata(Resource container, Subject subject, MeasurementDataManagerLocal dataManager, Set<FabricProfileInfo> profiles, Set<MQClusterInfo> mqClusters) {
        String zooKeeperUrl = this.getZooKeeperUrl(container);
        PropertyMap registryProperties = this.getRegistryProperties(zooKeeperUrl);
        boolean allowProfileGroups = this.getProfileGroups(registryProperties);
        boolean allowParentGroups = this.getParentProfiles(registryProperties);
        Pattern excludePattern = this.getProfilesExcludePattern(registryProperties);
        Pattern includePattern = this.getProfilesIncludePattern(registryProperties);
        if (allowProfileGroups) {
            MeasurementDataTraitCriteria traitCriteria = new MeasurementDataTraitCriteria();
            traitCriteria.addFilterResourceId(Integer.valueOf(container.getId()));
            traitCriteria.fetchSchedule(true);
            PageList containerTraits = dataManager.findTraitsByCriteria(subject, traitCriteria);
            if (!containerTraits.isEmpty()) {
                String profilesValue = null;
                String parentProfilesValue = null;
                String mqClusterValue = null;
                String containerVersion = null;
                for (MeasurementDataTrait trait : containerTraits) {
                    String traitName = trait.getSchedule().getDefinition().getName();
                    if (PROFILES_TRAIT.equals(traitName)) {
                        profilesValue = trait.getValue();
                        continue;
                    }
                    if (PARENT_PROFILES_TRAIT.equals(traitName)) {
                        parentProfilesValue = trait.getValue();
                        continue;
                    }
                    if (MQ_CLUSTERS_TRAIT.equals(traitName)) {
                        mqClusterValue = trait.getValue();
                        continue;
                    }
                    if (!CONTAINER_VERSION_TRAIT.equals(traitName)) continue;
                    containerVersion = trait.getValue();
                }
                Map<String, String[]> parentProfilesMap = null;
                if (allowParentGroups && parentProfilesValue != null && !parentProfilesValue.isEmpty()) {
                    parentProfilesMap = this.getParentProfiles(parentProfilesValue);
                }
                if (profilesValue != null && !profilesValue.isEmpty()) {
                    String[] profileNames;
                    for (String profileName : profileNames = profilesValue.split(",")) {
                        if (!this.profileGroupAllowed(profileName, includePattern, excludePattern)) continue;
                        profiles.add(new FabricProfileInfo(container.getResourceType().getName(), container.getResourceType().getPlugin(), profileName, containerVersion, false, zooKeeperUrl));
                        if (!allowParentGroups || parentProfilesMap == null) continue;
                        this.processParentProfiles(container, profileName, containerVersion, parentProfilesMap, excludePattern, includePattern, profiles);
                    }
                }
                if (mqClusterValue != null && !mqClusterValue.isEmpty()) {
                    String[] clusters;
                    for (String cluster : clusters = mqClusterValue.split(",")) {
                        mqClusters.add(new MQClusterInfo(container.getResourceType().getName(), container.getResourceType().getPlugin(), cluster, zooKeeperUrl));
                    }
                }
            }
        }
    }

    private String getZooKeeperUrl(Resource container) {
        return container.getPluginConfiguration().getSimpleValue(ZOOKEEPER_URL_PROPERTY);
    }

    private PropertyMap getRegistryProperties(String zookeeperUrl) {
        PropertyMap registryProperties = this.registryPropertiesMap.get(zookeeperUrl);
        if (registryProperties == null) {
            registryProperties = this.registryPropertiesMap.get(DEFAULT_REGISTRY_URL);
        }
        return registryProperties;
    }

    private void processParentProfiles(Resource container, String profileName, String containerVersion, Map<String, String[]> parentProfilesMap, Pattern excludePattern, Pattern includePattern, Set<FabricProfileInfo> profiles) {
        String[] parentProfiles = parentProfilesMap.get(profileName);
        if (parentProfiles != null) {
            for (String parent : parentProfiles) {
                if (!this.profileGroupAllowed(parent, includePattern, excludePattern)) continue;
                profiles.add(new FabricProfileInfo(container.getResourceType().getName(), container.getResourceType().getPlugin(), parent, containerVersion, true, this.getZooKeeperUrl(container)));
                this.processParentProfiles(container, parent, containerVersion, parentProfilesMap, excludePattern, includePattern, profiles);
            }
        }
    }

    private boolean profileGroupAllowed(String profile, Pattern includePattern, Pattern excludePattern) {
        String profileName = profile.substring(1, profile.indexOf(123));
        return includePattern.matcher(profileName).matches() && !excludePattern.matcher(profileName).matches();
    }

    private Pattern getProfilesIncludePattern(PropertyMap registryProperties) {
        return Pattern.compile("(" + registryProperties.getSimpleValue(PROFILES_INCLUDE, DEFAULT_PROFILE_INCLUDES).replace(" ", ")|(") + ")");
    }

    private Pattern getProfilesExcludePattern(PropertyMap registryProperties) {
        return Pattern.compile("(" + registryProperties.getSimpleValue(PROFILES_EXCLUDE, DEFAULT_PROFILE_EXCLUDES).replace(" ", ")|(") + ")");
    }

    private boolean getParentProfiles(PropertyMap registryProperties) {
        return Boolean.parseBoolean(registryProperties.getSimpleValue(PROFILES_PARENT_GROUPS, DEFAULT_DISABLE_PARENT_PROFILES));
    }

    private boolean getProfileGroups(PropertyMap registryProperties) {
        return Boolean.parseBoolean(registryProperties.getSimpleValue(PROFILES_PROFILE_GROUPS, DEFAULT_ENABLE_PROFILE_GROUPS));
    }

    private void processContainerProfile(FabricProfileInfo profileInfo, Subject subject, GroupDefinitionManagerLocal groupDefinitionManager) throws GroupDefinitionCreateException, GroupDefinitionAlreadyExistsException {
        String allGrandchildrenServicesGroupName;
        String allServicesGroupName;
        String grandchildServiceGroupName;
        String serviceGroupName;
        String containerGroupName;
        String plugin = profileInfo.plugin;
        String containerType = profileInfo.containerType;
        String profile = profileInfo.profileName;
        String containerVersion = profileInfo.containerVersion;
        String profileName = profile.substring(1, profile.indexOf("{"));
        String profileGroupPrefix = String.format("Fabric %s %s:%s (%s)", profileInfo.isParent ? "Parent Profile" : "Profile", profileName, containerVersion, profileInfo.zookeeperUrl);
        Map<String, GroupDefinition> groupDefinitionMap = this.getProfileGroupDefinitions(subject, groupDefinitionManager, profileGroupPrefix);
        String traitName = profileInfo.isParent ? PARENT_PROFILES_TRAIT : PROFILES_TRAIT;
        String platformGroupName = profileGroupPrefix + " Platform";
        if (!groupDefinitionMap.containsKey(platformGroupName)) {
            this.createGroupDefinition(subject, groupDefinitionManager, platformGroupName, "Platforms for Profile " + profileName + ":" + containerVersion, "resource.child.type.plugin = " + plugin + "\n" + "resource.child.type.name = " + containerType + "\n" + "resource.child.pluginConfiguration[" + ZOOKEEPER_URL_PROPERTY + "] = " + profileInfo.zookeeperUrl + "\n" + "resource.child.trait[" + traitName + "].contains = " + profile + "\n" + "resource.type.plugin = Platforms\n" + "groupby resource.type.name");
        }
        if (!groupDefinitionMap.containsKey(containerGroupName = profileGroupPrefix + " Containers")) {
            this.createGroupDefinition(subject, groupDefinitionManager, containerGroupName, "Containers for Profile " + profileName + ":" + containerVersion, "resource.type.plugin = " + plugin + "\n" + "resource.type.name = " + containerType + "\n" + "resource.pluginConfiguration[" + ZOOKEEPER_URL_PROPERTY + "] = " + profileInfo.zookeeperUrl + "\n" + "resource.trait[" + traitName + "].contains = " + profile + "\n");
        }
        if (!groupDefinitionMap.containsKey(serviceGroupName = profileGroupPrefix + " Child Service")) {
            this.createGroupDefinition(subject, groupDefinitionManager, serviceGroupName, "Child Service for Profile " + profileName + ":" + containerVersion, "resource.type.category = service\nresource.parent.type.plugin = " + plugin + "\n" + "resource.parent.type.name = " + containerType + "\n" + "resource.parent.pluginConfiguration[" + ZOOKEEPER_URL_PROPERTY + "] = " + profileInfo.zookeeperUrl + "\n" + "resource.parent.trait[" + traitName + "].contains = " + profile + "\n" + "groupby resource.type.plugin\n" + "groupby resource.type.name");
        }
        if (!groupDefinitionMap.containsKey(grandchildServiceGroupName = profileGroupPrefix + " Grandchild Service")) {
            this.createGroupDefinition(subject, groupDefinitionManager, grandchildServiceGroupName, "Grandchild Service for Profile " + profileName + ":" + containerVersion, "resource.type.category = service\nresource.grandparent.type.plugin = " + plugin + "\n" + "resource.grandparent.type.name = " + containerType + "\n" + "resource.grandparent.pluginConfiguration[" + ZOOKEEPER_URL_PROPERTY + "] = " + profileInfo.zookeeperUrl + "\n" + "resource.grandparent.trait[" + traitName + "].contains = " + profile + "\n" + "groupby resource.type.plugin\n" + "groupby resource.type.name");
        }
        if (!groupDefinitionMap.containsKey(allServicesGroupName = profileGroupPrefix + " Children Services")) {
            this.createGroupDefinition(subject, groupDefinitionManager, allServicesGroupName, "Children Services for Profile " + profileName + ":" + containerVersion, "resource.type.category = service\nresource.parent.type.plugin = " + plugin + "\n" + "resource.parent.type.name = " + containerType + "\n" + "resource.parent.pluginConfiguration[" + ZOOKEEPER_URL_PROPERTY + "] = " + profileInfo.zookeeperUrl + "\n" + "resource.parent.trait[" + traitName + "].contains = " + profile + "\n" + "groupby resource.type.plugin");
        }
        if (!groupDefinitionMap.containsKey(allGrandchildrenServicesGroupName = profileGroupPrefix + " Grandchildren Services")) {
            this.createGroupDefinition(subject, groupDefinitionManager, allGrandchildrenServicesGroupName, "Grandchildren Services for Profile " + profileName + ":" + containerVersion, "resource.type.category = service\nresource.grandparent.type.plugin = " + plugin + "\n" + "resource.grandparent.type.name = " + containerType + "\n" + "resource.grandparent.pluginConfiguration[" + ZOOKEEPER_URL_PROPERTY + "] = " + profileInfo.zookeeperUrl + "\n" + "resource.grandparent.trait[" + traitName + "].contains = " + profile + "\n" + "groupby resource.type.plugin");
        }
    }

    private void processMqCluster(MQClusterInfo clusterInfo, Subject subject, GroupDefinitionManagerLocal groupDefinitionManager) throws GroupDefinitionCreateException, GroupDefinitionAlreadyExistsException {
        String allGrandchildrenServicesGroupName;
        String allServicesGroupName;
        String topicServiceGroupName;
        String queueServiceGroupName;
        String grandchildServiceGroupName;
        String serviceGroupName;
        String plugin = clusterInfo.plugin;
        String containerType = clusterInfo.containerType;
        String clusterName = clusterInfo.name.substring(1, clusterInfo.name.length() - 1);
        String clusterGroupPrefix = String.format("Fuse MQ Cluster %s (%s)", clusterName, clusterInfo.zookeeperUrl);
        Map<String, GroupDefinition> groupDefinitionMap = this.getProfileGroupDefinitions(subject, groupDefinitionManager, clusterGroupPrefix);
        if (!groupDefinitionMap.containsKey(serviceGroupName = clusterGroupPrefix + " Child Service")) {
            this.createGroupDefinition(subject, groupDefinitionManager, serviceGroupName, "Child Service for Fuse MQ Cluster " + clusterName, "resource.type.plugin = ActiveMQ\nresource.parent.type.plugin = " + plugin + "\n" + "resource.parent.type.name = " + containerType + "\n" + "resource.parent.pluginConfiguration[" + ZOOKEEPER_URL_PROPERTY + "] = " + clusterInfo.zookeeperUrl + "\n" + "resource.parent.trait[" + MQ_CLUSTERS_TRAIT + "].contains = " + clusterInfo.name + "\n" + "groupby resource.type.name");
        }
        if (!groupDefinitionMap.containsKey(grandchildServiceGroupName = clusterGroupPrefix + " Grandchild Service")) {
            this.createGroupDefinition(subject, groupDefinitionManager, grandchildServiceGroupName, "Grandchild Service for Fuse MQ Cluster " + clusterName, "resource.type.plugin = ActiveMQ\nresource.grandparent.type.plugin = " + plugin + "\n" + "resource.grandparent.type.name = " + containerType + "\n" + "resource.grandparent.pluginConfiguration[" + ZOOKEEPER_URL_PROPERTY + "] = " + clusterInfo.zookeeperUrl + "\n" + "resource.grandparent.trait[" + MQ_CLUSTERS_TRAIT + "].contains = " + clusterInfo.name + "\n" + "groupby resource.type.name");
        }
        if (!groupDefinitionMap.containsKey(queueServiceGroupName = clusterGroupPrefix + " Grandchild Service")) {
            this.createGroupDefinition(subject, groupDefinitionManager, queueServiceGroupName, "Destination Service for Fuse MQ Cluster " + clusterName, "resource.type.plugin = ActiveMQ\nresource.type.name = Queue\nresource.grandparent.type.plugin = " + plugin + "\n" + "resource.grandparent.type.name = " + containerType + "\n" + "resource.grandparent.pluginConfiguration[" + ZOOKEEPER_URL_PROPERTY + "] = " + clusterInfo.zookeeperUrl + "\n" + "resource.grandparent.trait[" + MQ_CLUSTERS_TRAIT + "].contains = " + clusterInfo.name + "\n" + "groupby resource.type.name" + "groupby resource.name");
        }
        if (!groupDefinitionMap.containsKey(topicServiceGroupName = clusterGroupPrefix + " Grandchild Service")) {
            this.createGroupDefinition(subject, groupDefinitionManager, topicServiceGroupName, "Destination Service for Fuse MQ Cluster " + clusterName, "resource.type.plugin = ActiveMQ\nresource.type.name = Topic\nresource.grandparent.type.plugin = " + plugin + "\n" + "resource.grandparent.type.name = " + containerType + "\n" + "resource.grandparent.pluginConfiguration[" + ZOOKEEPER_URL_PROPERTY + "] = " + clusterInfo.zookeeperUrl + "\n" + "resource.grandparent.trait[" + MQ_CLUSTERS_TRAIT + "].contains = " + clusterInfo.name + "\n" + "groupby resource.type.name" + "groupby resource.name");
        }
        if (!groupDefinitionMap.containsKey(allServicesGroupName = clusterGroupPrefix + " Children Services")) {
            this.createGroupDefinition(subject, groupDefinitionManager, allServicesGroupName, "Children Services for Fuse MQ Cluster " + clusterName, "resource.type.plugin = ActiveMQ\nresource.parent.type.plugin = " + plugin + "\n" + "resource.parent.type.name = " + containerType + "\n" + "resource.parent.pluginConfiguration[" + ZOOKEEPER_URL_PROPERTY + "] = " + clusterInfo.zookeeperUrl + "\n" + "resource.parent.trait[" + MQ_CLUSTERS_TRAIT + "].contains = " + clusterInfo.name + "\n");
        }
        if (!groupDefinitionMap.containsKey(allGrandchildrenServicesGroupName = clusterGroupPrefix + " Grandchildren Services")) {
            this.createGroupDefinition(subject, groupDefinitionManager, allGrandchildrenServicesGroupName, "Grandchildren Services for Fuse MQ Cluster " + clusterName, "resource.type.plugin = ActiveMQ\nresource.grandparent.type.plugin = " + plugin + "\n" + "resource.grandparent.type.name = " + containerType + "\n" + "resource.grandparent.pluginConfiguration[" + ZOOKEEPER_URL_PROPERTY + "] = " + clusterInfo.zookeeperUrl + "\n" + "resource.grandparent.trait[" + MQ_CLUSTERS_TRAIT + "].contains = " + clusterInfo.name + "\n");
        }
    }

    private void createGroupDefinition(Subject subject, GroupDefinitionManagerLocal groupDefinitionManager, String platformGroupName, String description, String expression) throws GroupDefinitionAlreadyExistsException, GroupDefinitionCreateException {
        GroupDefinition platformGroup = new GroupDefinition();
        platformGroup.setName(platformGroupName);
        description = "Auto-generated, " + description;
        if (description.length() > 100) {
            description = description.substring(0, 97) + "...";
        }
        platformGroup.setDescription(description);
        platformGroup.setRecalculationInterval(Long.valueOf(TimeUnit.MINUTES.toMillis(this.recalculationInterval)));
        platformGroup.setExpression(expression);
        groupDefinitionManager.createGroupDefinition(subject, platformGroup);
    }

    private Map<String, GroupDefinition> getProfileGroupDefinitions(Subject subject, GroupDefinitionManagerLocal groupDefinitionManager, String profileGroupPrefix) {
        ResourceGroupDefinitionCriteria criteria = new ResourceGroupDefinitionCriteria();
        criteria.addFilterName(profileGroupPrefix);
        PageList groupDefinitions = groupDefinitionManager.findGroupDefinitionsByCriteria(subject, criteria);
        HashMap<String, GroupDefinition> groupDefinitionMap = new HashMap<String, GroupDefinition>();
        for (GroupDefinition definition : groupDefinitions) {
            groupDefinitionMap.put(definition.getName(), definition);
        }
        return groupDefinitionMap;
    }

    private void parseFabricRegistries() throws Exception {
        PropertyList propertyList = this.context.getPluginConfiguration().getList(FABRIC_REGISTRIES_PROPERTY);
        for (Property property : propertyList.getList()) {
            PropertyMap registryMap = (PropertyMap)property;
            PropertySimple zookeeperUrl = registryMap.getSimple(ZOOKEEPER_URL_PROPERTY);
            if (zookeeperUrl == null || zookeeperUrl.getStringValue() == null || zookeeperUrl.getStringValue().isEmpty()) {
                throw new IllegalArgumentException("Property Registry URL MUST have a non-empty value");
            }
            this.registryPropertiesMap.put(zookeeperUrl.getStringValue(), registryMap);
        }
        if (!this.registryPropertiesMap.containsKey(DEFAULT_REGISTRY_URL)) {
            PropertyMap defaults = new PropertyMap(REGISTRY_PROPERTIES_MAP);
            defaults.put((Property)new PropertySimple(ZOOKEEPER_URL_PROPERTY, (Object)DEFAULT_REGISTRY_URL));
            defaults.put((Property)new PropertySimple(PROFILES_PROFILE_GROUPS, (Object)DEFAULT_ENABLE_PROFILE_GROUPS));
            defaults.put((Property)new PropertySimple(PROFILES_PARENT_GROUPS, (Object)DEFAULT_DISABLE_PARENT_PROFILES));
            propertyList.add((Property)defaults);
            this.registryPropertiesMap.put(DEFAULT_REGISTRY_URL, defaults);
            this.log.warn((Object)("No default property with Registry URL * specified, using defaults: " + defaults));
        }
    }

    private Map<String, String[]> getParentProfiles(String parentProfilesValue) {
        HashMap<String, String[]> parentMap = new HashMap<String, String[]>();
        for (String parentList : parentProfilesValue.split(",")) {
            String[] profileParents = parentList.split(":");
            parentMap.put(profileParents[0], Arrays.copyOfRange(profileParents, 1, profileParents.length));
        }
        return Collections.unmodifiableMap(parentMap);
    }

    private class MQClusterInfo {
        final String containerType;
        final String plugin;
        final String name;
        final String zookeeperUrl;

        public MQClusterInfo(String containerType, String plugin, String cluster, String zookeeperUrl) {
            this.containerType = containerType;
            this.plugin = plugin;
            this.name = cluster;
            this.zookeeperUrl = zookeeperUrl;
        }
    }

    private class FabricProfileInfo {
        final String containerType;
        final String plugin;
        final String profileName;
        final String containerVersion;
        final boolean isParent;
        final String zookeeperUrl;

        public FabricProfileInfo(String containerType, String plugin, String profileName, String containerVersion, boolean isParent, String zookeeperUrl) {
            this.containerType = containerType;
            this.plugin = plugin;
            this.profileName = profileName;
            this.containerVersion = containerVersion;
            this.isParent = isParent;
            this.zookeeperUrl = zookeeperUrl;
        }

        public int hashCode() {
            return (this.containerType + this.profileName + this.containerVersion).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof FabricProfileInfo) {
                FabricProfileInfo info = (FabricProfileInfo)obj;
                return this.containerType.equals(info.containerType) && this.profileName.equals(info.profileName) && this.containerVersion.equals(info.containerVersion);
            }
            return false;
        }
    }
}

