/*
 * Decompiled with CFR 0.152.
 */
package org.jbosson.plugins.fuse.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.jbosson.plugins.fuse.utils.FabricRegistry;
import org.linkedin.util.clock.Timespan;
import org.linkedin.zookeeper.client.ZKClient;

public class LinkedInFabricRegistryImpl
implements FabricRegistry {
    private static final Log LOG = LogFactory.getLog(LinkedInFabricRegistryImpl.class);
    private final String url;
    private final long timeout;
    private final String password;
    private final String containerName;
    private ZKClient client;
    private boolean connected;

    public static boolean isSupported() {
        try {
            Class.forName("org.linkedin.zookeeper.client.ZKClient");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public LinkedInFabricRegistryImpl(String zooKeeperUrl, String zooKeeperPassword, long timeout, String containerName) {
        this.url = zooKeeperUrl;
        this.timeout = timeout;
        this.password = zooKeeperPassword;
        this.containerName = containerName;
    }

    public void connect() throws Exception {
        Timespan fabricTimeout = Timespan.seconds((long)this.timeout);
        this.client = new ZKClient(this.url, fabricTimeout, new Watcher(){

            public void process(WatchedEvent watchedEvent) {
                if (LinkedInFabricRegistryImpl.this.connected && watchedEvent.getState().equals((Object)Watcher.Event.KeeperState.Disconnected)) {
                    LOG.warn((Object)"Disconnected from Fabric Registry");
                }
            }
        });
        try {
            this.client.start();
            if (!this.client.isConnected()) {
                Thread.sleep(fabricTimeout.getDurationInMilliseconds());
                if (!this.client.isConnected()) {
                    throw new IllegalAccessException("Unable to connect to Fabric Registry in " + fabricTimeout.getDurationInSeconds() + " seconds");
                }
            }
            if (this.password != null) {
                this.client.addAuthInfo("digest", ("fabric:" + this.password).getBytes("UTF-8"));
            }
            this.connected = true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
    }

    public void disconnect() throws Exception {
        if (this.client != null) {
            this.connected = false;
            try {
                this.client.destroy();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public String getContainerVersion() throws Exception {
        return this.client.getStringData(String.format("/fabric/configs/containers/%s", this.containerName));
    }

    public String[] getContainerProfiles(String containerVersion) throws Exception {
        return this.client.getStringData(String.format("/fabric/configs/versions/%s/containers/%s", containerVersion, this.containerName)).split(" ");
    }

    public Object getClient() {
        return this.client;
    }
}

