/*
 * Decompiled with CFR 0.152.
 */
package org.jbosson.plugins.fuse;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbosson.plugins.fuse.FuseServerComponent;
import org.jbosson.plugins.fuse.JBossFuseContainerDiscoveryComponent;
import org.jbosson.plugins.fuse.JBossFuseProfileGroupManager;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.EmsBeanName;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.availability.AvailabilityContext;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.pluginapi.util.ProcessExecutionUtility;
import org.rhq.core.pluginapi.util.StartScriptConfiguration;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.SystemInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossFuseContainerComponent<T extends ResourceComponent<?>>
extends FuseServerComponent<T>
implements MeasurementFacet,
OperationFacet {
    private static final Log LOG = LogFactory.getLog(JBossFuseContainerComponent.class);
    private static final String SEPARATOR = "\n-----------------------\n";
    private static final int RETRIES = 60;
    private static final int TIMEOUT_INTERVAL = 1000;
    private JBossFuseProfileGroupManager profileGroupManager;
    private StartScriptConfiguration startScriptConfig;
    private Configuration pluginConfiguration;

    public void start(ResourceContext context) throws Exception {
        super.start(context);
        this.pluginConfiguration = context.getPluginConfiguration();
        this.profileGroupManager = new JBossFuseProfileGroupManager(context);
        this.startScriptConfig = new StartScriptConfiguration(context.getPluginConfiguration());
    }

    public void stop() {
        this.profileGroupManager = null;
        this.startScriptConfig = null;
        super.stop();
    }

    public void getValues(MeasurementReport measurementReport, Set<MeasurementScheduleRequest> measurementScheduleRequests) throws Exception {
        this.profileGroupManager.getValues(measurementReport, measurementScheduleRequests);
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        if (name.equals("start")) {
            return this.startServer();
        }
        if (name.equals("restart")) {
            return this.restartServer();
        }
        if (name.equals("stop")) {
            return this.stopServer();
        }
        throw new UnsupportedOperationException(name);
    }

    protected OperationResult startServer() {
        File startScriptFile;
        OperationResult operationResult = new OperationResult();
        if (this.isManuallyAddedServer(operationResult, "Starting")) {
            return operationResult;
        }
        List<String> errors = this.validateStartScriptPluginConfigProps();
        if (!errors.isEmpty()) {
            this.setErrorMessage(operationResult, errors);
            return operationResult;
        }
        String startScriptPrefix = this.startScriptConfig.getStartScriptPrefix();
        ProcessExecution processExecution = ProcessExecutionUtility.createProcessExecution((String)startScriptPrefix, (File)(startScriptFile = this.getStartScriptFile()));
        ArrayList<String> arguments = processExecution.getArguments();
        if (arguments == null) {
            arguments = new ArrayList<String>();
            processExecution.setArguments(arguments);
        }
        List startScriptArgs = this.startScriptConfig.getStartScriptArgs();
        for (String startScriptArg : startScriptArgs) {
            startScriptArg = this.replacePropertyPatterns(startScriptArg);
            arguments.add(startScriptArg);
        }
        Map startScriptEnv = this.startScriptConfig.getStartScriptEnv();
        for (String envVarName : startScriptEnv.keySet()) {
            String envVarValue = (String)startScriptEnv.get(envVarName);
            envVarValue = this.replacePropertyPatterns(envVarValue);
            startScriptEnv.put(envVarName, envVarValue);
        }
        processExecution.setEnvironmentVariables(startScriptEnv);
        processExecution.setWorkingDirectory(startScriptFile.getParent());
        processExecution.setCaptureOutput(true);
        processExecution.setWaitForCompletion(15000L);
        processExecution.setKillOnTimeout(false);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("About to execute the following process: [" + processExecution + "]"));
        }
        SystemInfo systemInfo = this.context.getSystemInformation();
        ProcessExecutionResults results = systemInfo.executeProcess(processExecution);
        this.logExecutionResults(results);
        if (results.getError() != null) {
            operationResult.setErrorMessage(results.getError().getMessage());
        } else if (results.getExitCode() == null || results.getExitCode() != 0) {
            operationResult.setErrorMessage("Start failed with error code " + results.getExitCode() + ":\n" + results.getCapturedOutput());
        } else {
            boolean up = this.waitForServerToStart();
            if (up) {
                operationResult.setSimpleResult("Success");
            } else {
                operationResult.setErrorMessage("Was not able to start the server");
            }
        }
        this.context.getAvailabilityContext().requestAvailabilityCheck();
        return operationResult;
    }

    protected OperationResult restartServer() throws Exception {
        OperationResult operationResult = new OperationResult();
        if (this.isManuallyAddedServer(operationResult, "Restarting")) {
            return operationResult;
        }
        operationResult = this.stopServer();
        if (operationResult.getErrorMessage() != null) {
            operationResult.setErrorMessage("Restart failed while attempting to shut down: " + operationResult.getErrorMessage());
            return operationResult;
        }
        return this.startServer();
    }

    private OperationResult stopServer() {
        OperationResult operationResult = new OperationResult();
        if (this.isManuallyAddedServer(operationResult, "Stopping")) {
            return operationResult;
        }
        List<String> errors = this.validateStartScriptPluginConfigProps();
        if (!errors.isEmpty()) {
            OperationResult result = new OperationResult();
            this.setErrorMessage(result, errors);
            return result;
        }
        String karafBinPath = this.pluginConfiguration.getSimpleValue("karaf.base") + File.separator + "bin";
        ProcessExecution processExecution = ProcessExecutionUtility.createProcessExecution((File)new File(karafBinPath, JBossFuseContainerDiscoveryComponent.OS_IS_WINDOWS ? "stop.bat" : "stop"));
        processExecution.setWorkingDirectory(karafBinPath);
        processExecution.setCaptureOutput(true);
        processExecution.setWaitForCompletion(15000L);
        processExecution.setKillOnTimeout(false);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("About to execute the following process: [" + processExecution + "]"));
        }
        SystemInfo systemInfo = this.context.getSystemInformation();
        ProcessExecutionResults results = systemInfo.executeProcess(processExecution);
        this.logExecutionResults(results);
        if (results.getError() != null) {
            operationResult.setErrorMessage(results.getError().getMessage());
        } else if (results.getExitCode() == null || results.getExitCode() != 0) {
            operationResult.setErrorMessage("Stop failed with error code: " + results.getExitCode() + ":\n" + results.getCapturedOutput());
        } else {
            boolean down = this.waitForServerToStop();
            if (down) {
                operationResult.setSimpleResult("Success");
            } else {
                operationResult.setErrorMessage("Was not able to stop the server");
            }
        }
        this.context.getAvailabilityContext().requestAvailabilityCheck();
        return operationResult;
    }

    private boolean isManuallyAddedServer(OperationResult operationResult, String operation) {
        if (this.pluginConfiguration.get("manuallyAdded") != null) {
            operationResult.setErrorMessage(operation + " is not enabled for manually added servers");
            return true;
        }
        return false;
    }

    private void setErrorMessage(OperationResult operationResult, List<String> errors) {
        StringBuilder buffer = new StringBuilder("This Resource's connection properties contain errors: ");
        int errorsSize = errors.size();
        for (int i = 0; i < errorsSize; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            String error = errors.get(i);
            buffer.append('[').append(error).append(']');
        }
        operationResult.setErrorMessage(buffer.toString());
    }

    private List<String> validateStartScriptPluginConfigProps() {
        ArrayList<String> errors = new ArrayList<String>();
        File startScriptFile = this.getStartScriptFile();
        if (!startScriptFile.exists()) {
            errors.add("Start script '" + startScriptFile + "' does not exist.");
        } else if (!startScriptFile.isFile()) {
            errors.add("Start script '" + startScriptFile + "' is not a regular file.");
        } else {
            if (!startScriptFile.canRead()) {
                errors.add("Start script '" + startScriptFile + "' is not readable.");
            }
            if (!startScriptFile.canExecute()) {
                errors.add("Start script '" + startScriptFile + "' is not executable.");
            }
        }
        Map startScriptEnv = this.startScriptConfig.getStartScriptEnv();
        if (startScriptEnv.isEmpty()) {
            errors.add("No start script environment variables are set. At a minimum, PATH should be set (on UNIX, it should contain at least /bin and /usr/bin). It is recommended that JAVA_HOME also be set, otherwise the PATH will be used to find java.");
        }
        return errors;
    }

    private File getStartScriptFile() {
        File startScriptFile = this.startScriptConfig.getStartScript();
        File homeDir = new File(this.pluginConfiguration.getSimpleValue("karaf.base"));
        if (startScriptFile != null) {
            if (!startScriptFile.isAbsolute()) {
                startScriptFile = new File(homeDir, startScriptFile.getPath());
            }
        } else {
            String startScriptFileName = JBossFuseContainerDiscoveryComponent.OS_IS_WINDOWS ? "start.bat" : "start";
            File binDir = new File(homeDir, "bin");
            startScriptFile = new File(binDir, startScriptFileName);
        }
        return startScriptFile;
    }

    private boolean waitForServerToStart() {
        boolean up = false;
        for (int count = 0; !up && count < 60; ++count) {
            block6: {
                try {
                    SortedSet emsBeans;
                    AvailabilityContext availabilityContext = this.getResourceContext().getAvailabilityContext();
                    availabilityContext.requestAvailabilityCheck();
                    if (availabilityContext.getLastReportedAvailability() != AvailabilityType.UP || (emsBeans = this.getEmsConnection().getBeans()) == null || emsBeans.isEmpty()) break block6;
                    for (EmsBean bean : emsBeans) {
                        EmsBeanName beanName = bean.getBeanName();
                        if (!"osgi.core".equals(beanName.getDomain()) || !"framework".equals(beanName.getKeyProperty("type"))) continue;
                        up = true;
                        break;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (up) continue;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return up;
    }

    private boolean waitForServerToStop() {
        boolean down = false;
        for (int count = 0; !down && count < 60; ++count) {
            try {
                AvailabilityContext availabilityContext = this.getResourceContext().getAvailabilityContext();
                availabilityContext.requestAvailabilityCheck();
                if (availabilityContext.getLastReportedAvailability() == AvailabilityType.DOWN) {
                    down = true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (down) continue;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return down;
    }

    private void logExecutionResults(ProcessExecutionResults results) {
        LOG.info((Object)("Exit code from process execution: " + results.getExitCode()));
        LOG.info((Object)("Output from process execution: \n-----------------------\n" + results.getCapturedOutput() + SEPARATOR));
    }

    private String replacePropertyPatterns(String value) {
        Pattern pattern = Pattern.compile("(%([^%]*)%)");
        Matcher matcher = pattern.matcher(value);
        Configuration pluginConfig = this.context.getPluginConfiguration();
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String propName = matcher.group(2);
            PropertySimple prop = pluginConfig.getSimple(propName);
            String propValue = prop != null && prop.getStringValue() != null ? prop.getStringValue() : "";
            String propPattern = matcher.group(1);
            String replacement = prop != null ? propValue : propPattern;
            matcher.appendReplacement(buffer, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }
}

