/*
 * Decompiled with CFR 0.152.
 */
package org.jbosson.plugins.fuse;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FabricContainerTraits {
    private String containerVersion;
    private final Set<String> profiles = new HashSet<String>();
    private final Map<String, List<String>> parentProfileMap = new HashMap<String, List<String>>();
    private final Set<String> clusters = new HashSet<String>();

    FabricContainerTraits() {
    }

    public String getContainerVersion() {
        return this.containerVersion;
    }

    public void setContainerVersion(String containerVersion) {
        this.containerVersion = containerVersion;
    }

    public void setProfiles(String[] profileNames) {
        for (String profileName : profileNames) {
            this.profiles.add("[" + profileName + "{" + this.containerVersion + "}]");
        }
    }

    public boolean setParentProfiles(String child, String[] parents) {
        boolean newChild = false;
        if (!this.parentProfileMap.containsKey(child)) {
            this.parentProfileMap.put(child, Arrays.asList(parents));
            newChild = true;
        }
        return newChild;
    }

    public void addCluster(String clusterName) {
        this.clusters.add("[" + clusterName + "]");
    }

    public String getProfileTrait() {
        return this.getValue(this.profiles);
    }

    public String getParentProfilesTrait() {
        HashSet<String> parentValues = new HashSet<String>();
        for (Map.Entry<String, List<String>> entry : this.parentProfileMap.entrySet()) {
            StringBuilder value = new StringBuilder();
            value.append("[");
            value.append(entry.getKey());
            value.append("{");
            value.append(this.containerVersion);
            value.append("}]");
            for (String parent : entry.getValue()) {
                value.append(":");
                value.append("[");
                value.append(parent);
                value.append("{");
                value.append(this.containerVersion);
                value.append("}]");
            }
            parentValues.add(value.toString());
        }
        return this.getValue(parentValues);
    }

    public String getClustersTrait() {
        return this.getValue(this.clusters);
    }

    private String getValue(Set<String> valueSet) {
        StringBuffer value = new StringBuffer();
        int total = valueSet.size();
        int i = 0;
        for (String profile : valueSet) {
            value.append(profile);
            if (++i >= total) continue;
            value.append(",");
        }
        return value.toString();
    }

    public boolean hasChildProfile(String child) {
        return this.parentProfileMap.containsKey(child);
    }
}

