/*
 * Decompiled with CFR 0.152.
 */
package org.jbosson.plugins.fuse;

import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.jbosson.plugins.fuse.FabricContainerTraits;
import org.linkedin.util.clock.Timespan;
import org.linkedin.zookeeper.client.ZKClient;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FabricProfileGroupManager
implements MeasurementFacet,
Watcher {
    private static final String PARENTS_PROPERTY = "parents";
    private Log log = LogFactory.getLog(FabricProfileGroupManager.class);
    private static final String PROFILES_TRAIT = "profiles";
    private static final String PARENT_PROFILES_TRAIT = "parentProfiles";
    private static final String MQ_CLUSTERS_TRAIT = "mqClusters";
    private static final String CONTAINER_VERSION_TRAIT = "container.version";
    private static final String ZOOKEEPER_TIMEOUT = "zookeeper.timeout";
    private final ResourceContext context;

    public FabricProfileGroupManager(ResourceContext context) {
        this.context = context;
    }

    public void getValues(MeasurementReport measurementReport, Set<MeasurementScheduleRequest> measurementScheduleRequests) throws Exception {
        String resourceKey = this.context.getResourceKey();
        Configuration pluginConfiguration = this.context.getPluginConfiguration();
        String zookeeperUrl = pluginConfiguration.getSimpleValue("zookeeper.url");
        String zookeeperPassword = pluginConfiguration.getSimpleValue("zookeeper.password");
        if (zookeeperUrl != null) {
            this.log.debug((Object)("Processing Fabric Groups for Server " + resourceKey));
            Timespan fabricTimeout = Timespan.seconds((long)Long.valueOf(pluginConfiguration.getSimpleValue(ZOOKEEPER_TIMEOUT)));
            ZKClient client = new ZKClient(zookeeperUrl, fabricTimeout, (Watcher)this);
            try {
                client.start();
                if (!client.isConnected()) {
                    Thread.sleep(fabricTimeout.getDurationInMilliseconds());
                    if (!client.isConnected()) {
                        throw new IllegalAccessException("Unable to connect to Fabric Registry in " + fabricTimeout.getDurationInSeconds() + " seconds");
                    }
                }
                if (zookeeperPassword != null) {
                    client.addAuthInfo("digest", ("fabric:" + zookeeperPassword).getBytes("UTF-8"));
                }
                String containerName = pluginConfiguration.getSimpleValue("karaf.name");
                String containerVersion = client.getStringData("/fabric/configs/containers/" + containerName);
                String[] profiles = client.getStringData("/fabric/configs/versions/" + containerVersion + "/containers/" + containerName).split(" ");
                FabricContainerTraits traits = new FabricContainerTraits();
                traits.setContainerVersion(containerVersion);
                traits.setProfiles(profiles);
                for (String profile : profiles) {
                    this.log.debug((Object)("Processing Server profile " + profile + ":" + containerVersion));
                    try {
                        this.getFabricMetadata(profile, containerVersion, client, traits);
                    }
                    catch (Exception e) {
                        throw new InvalidPluginConfigurationException("Error processing Server Profile " + profile + ":" + containerVersion + ": " + e.getMessage(), (Throwable)e);
                    }
                }
                for (MeasurementScheduleRequest request : measurementScheduleRequests) {
                    String metricName = request.getName();
                    if (metricName.equals(PROFILES_TRAIT)) {
                        measurementReport.addData(new MeasurementDataTrait(request, traits.getProfileTrait()));
                        continue;
                    }
                    if (metricName.equals(PARENT_PROFILES_TRAIT)) {
                        measurementReport.addData(new MeasurementDataTrait(request, traits.getParentProfilesTrait()));
                        continue;
                    }
                    if (metricName.equals(MQ_CLUSTERS_TRAIT)) {
                        measurementReport.addData(new MeasurementDataTrait(request, traits.getClustersTrait()));
                        continue;
                    }
                    if (metricName.equals(CONTAINER_VERSION_TRAIT)) {
                        measurementReport.addData(new MeasurementDataTrait(request, traits.getContainerVersion()));
                        continue;
                    }
                    throw new InvalidPluginConfigurationException(String.format("Unknown metric %s for resource %s", metricName, resourceKey));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (KeeperException e) {
                throw new InvalidPluginConfigurationException("Error getting Server info from Fabric Registry: " + e.getMessage());
            }
            catch (InvalidPluginConfigurationException e) {
                throw e;
            }
            catch (Exception ex) {
                throw new InvalidPluginConfigurationException("Error processing Profiles for [" + this.context.getResourceKey() + "]: " + ex.getMessage(), (Throwable)ex);
            }
            finally {
                try {
                    client.destroy();
                }
                catch (Throwable t) {}
            }
        } else {
            this.log.debug((Object)("Plugin property zookeeper.url is not set for [" + this.context.getResourceKey() + "], no Fabric data to collect"));
        }
    }

    protected void getFabricMetadata(String profileName, String containerVersion, ZKClient client, FabricContainerTraits traits) throws InvalidPluginConfigurationException {
        String brokerClusterName = null;
        try {
            String brokerPropertiesPath = "/fabric/configs/versions/" + containerVersion + "/profiles/" + profileName + "/org.fusesource.mq.fabric.server-" + profileName + ".properties";
            boolean brokerFound = null == client.exists(brokerPropertiesPath) ? null != client.exists(brokerPropertiesPath = "/fabric/configs/versions/" + containerVersion + "/profiles/" + profileName + "/org.fusesource.mq.fabric.server-broker.properties") : true;
            if (brokerFound) {
                this.log.debug((Object)("Broker properties found in profile " + profileName));
                Properties brokerProperties = new Properties();
                String propertiesData = client.getStringData(brokerPropertiesPath);
                brokerProperties.load(new StringReader(propertiesData));
                brokerClusterName = brokerProperties.getProperty("group");
                this.log.debug((Object)("Found Broker Cluster " + brokerClusterName));
            } else {
                this.log.debug((Object)("Broker properties NOT found in profile " + profileName));
            }
        }
        catch (InterruptedException e) {
            throw new InvalidPluginConfigurationException("Error looking up MQ broker properties: " + e.getMessage(), (Throwable)e);
        }
        catch (KeeperException e) {
            throw new InvalidPluginConfigurationException("Error looking up MQ broker properties: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new InvalidPluginConfigurationException("Error looking up MQ broker properties: " + e.getMessage(), (Throwable)e);
        }
        if (brokerClusterName != null) {
            traits.addCluster(brokerClusterName);
        }
        try {
            String[] parents;
            String parentList = this.getParents(profileName, containerVersion, client);
            if (parentList != null && traits.setParentProfiles(profileName, parents = parentList.split(" "))) {
                for (String parent : parents) {
                    if (traits.hasChildProfile(parent)) continue;
                    this.getFabricMetadata(parent, containerVersion, client, traits);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (KeeperException e) {
            throw new InvalidPluginConfigurationException("Error getting Parent profiles for " + profileName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private String getParents(String profileName, String containerVersion, ZKClient client) throws InterruptedException, KeeperException {
        String key;
        String profilePath = "/fabric/configs/versions/" + containerVersion + "/profiles/" + profileName;
        String value = null;
        if (null != client.exists(profilePath)) {
            value = client.getStringData(profilePath);
        } else {
            String ensemblePath = "/fabric/configs/ensemble/profiles/" + profileName;
            if (null != client.exists(ensemblePath)) {
                value = client.getStringData(ensemblePath);
            }
        }
        Properties props = new Properties();
        if (value != null) {
            try {
                props.load(new StringReader(value));
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        if (props.size() == 1 && !(key = props.stringPropertyNames().iterator().next()).equals(PARENTS_PROPERTY)) {
            String val = props.getProperty(key);
            props.remove(key);
            props.setProperty(PARENTS_PROPERTY, val.isEmpty() ? key : key + " " + val);
        }
        return props.getProperty(PARENTS_PROPERTY);
    }

    public void process(WatchedEvent watchedEvent) {
        if (watchedEvent.getState().equals((Object)Watcher.Event.KeeperState.Disconnected)) {
            this.log.warn((Object)"Disconnected from Fabric Registry");
        }
    }
}

