/*
 * Decompiled with CFR 0.152.
 */
package org.jbosson.plugins.fuse;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbosson.plugins.fuse.FuseServerDiscoveryComponent;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.ClassLoaderFacet;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.pluginapi.util.CommandLineOption;
import org.rhq.core.pluginapi.util.JavaCommandLine;
import org.rhq.core.pluginapi.util.ServerStartScriptDiscoveryUtility;
import org.rhq.core.pluginapi.util.StartScriptConfiguration;
import org.rhq.core.system.ProcessInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossFuseContainerDiscoveryComponent
extends FuseServerDiscoveryComponent
implements ClassLoaderFacet {
    private static final Log log = LogFactory.getLog(JBossFuseContainerDiscoveryComponent.class);
    public static final boolean OS_IS_WINDOWS = File.separatorChar == '\\';
    public static final String KARAF_BASE_PROPERTY = "karaf.base";
    public static final String KARAF_HOME_PROPERTY = "karaf.home";
    public static final String KARAF_NAME_PROPERTY = "karaf.name";
    public static final String ZOOKEEPER_URL_PROPERTY = "zookeeper.url";
    public static final String ZOOKEEPER_PASSWORD_PROPERTY = "zookeeper.password";
    public static final String GIT_REPO_PROPERTY = "git.root";
    private static final String CHILD_PREFIX = "Child ";
    private static final String DEFAULT_KARAF_NAME = "root";
    private static final String ETC_SYSTEM_PROPERTIES = "etc/system.properties";
    private static final String JBOSS_FUSE_PRODUCT = "JBoss Fuse";
    private static final String JBOSS_A_MQ_PRODUCT = "JBoss A-MQ";
    private static final String JBOSS_FUSE_CONTAINER = "JBoss Fuse Container";
    private static final String CONTAINER_TYPE_PROPERTY = "container.type";
    private static final String GIT_REPO_HOME = "data/git";
    private static final Set<String> START_SCRIPT_ENV_VAR_NAMES = new LinkedHashSet<String>();
    private static final Set<CommandLineOption> START_SCRIPT_OPTION_EXCLUDES;

    protected boolean populateResourceProperties(ResourceDiscoveryContext context, DiscoveredResourceDetails details) {
        File gitIndex;
        File fuseMqScript;
        if (!super.populateResourceProperties(context, details)) {
            return false;
        }
        Configuration pluginConfiguration = details.getPluginConfiguration();
        String karafHomePath = pluginConfiguration.getSimpleValue(KARAF_HOME_PROPERTY);
        String karafBasePath = pluginConfiguration.getSimpleValue(KARAF_BASE_PROPERTY);
        String resourceTypeName = details.getResourceType().getName();
        if (!karafHomePath.equals(karafBasePath)) {
            details.setResourceName(details.getResourceName().replace(resourceTypeName, CHILD_PREFIX + resourceTypeName));
            details.setResourceDescription(details.getResourceDescription().replace(resourceTypeName, CHILD_PREFIX + resourceTypeName));
        }
        File karafHome = new File(karafHomePath);
        File karafBase = new File(karafBasePath);
        Properties serverProperties = this.getServerProperties(karafBase);
        String karafName = serverProperties.getProperty(KARAF_NAME_PROPERTY);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found " + details.getResourceType().getName() + " with container name: " + karafName));
        }
        pluginConfiguration.setSimpleValue(KARAF_NAME_PROPERTY, karafName);
        String productName = null;
        String resourceVersion = null;
        File fuseEsbScript = this.findVersionFile(karafHome, Pattern.compile("bin/fuse(.bat)?$"));
        if (fuseEsbScript != null) {
            productName = JBOSS_FUSE_PRODUCT;
            pluginConfiguration.setSimpleValue("versionFile", "system/org/jboss/fuse/jboss-fuse/(6\\.[0-9\\.\\-(redhat)]+)");
            resourceVersion = this.getResourceVersion(pluginConfiguration, karafHome);
        }
        if ((fuseEsbScript == null || resourceVersion == null) && (fuseMqScript = this.findVersionFile(karafHome, Pattern.compile("bin/amq(.bat)?$"))) != null) {
            productName = JBOSS_A_MQ_PRODUCT;
            pluginConfiguration.setSimpleValue("versionFile", "system/org/jboss/amq/mq-fabric/(6\\.[0-9\\.\\-(redhat)]+)");
            resourceVersion = this.getResourceVersion(pluginConfiguration, karafHome);
        }
        if (resourceVersion == null) {
            resourceVersion = details.getResourceVersion();
            productName = JBOSS_FUSE_CONTAINER;
        }
        pluginConfiguration.setSimpleValue(CONTAINER_TYPE_PROPERTY, productName);
        String oldResourceKey = details.getResourceKey();
        details.setResourceKey(oldResourceKey.replace(resourceTypeName, productName));
        details.setResourceName(details.getResourceName().replace(oldResourceKey, details.getResourceKey()));
        details.setResourceName(details.getResourceName().replace(resourceTypeName, productName + " [" + karafName + "]"));
        details.setResourceDescription(details.getResourceDescription().replace(resourceTypeName, productName));
        details.setResourceVersion(resourceVersion);
        String zkProperty = pluginConfiguration.getSimpleValue(ZOOKEEPER_URL_PROPERTY);
        if (zkProperty == null) {
            String[] zookeeperUrlPassword = this.getZookeeperUrlPassword(karafHome, karafBase);
            pluginConfiguration.setSimpleValue(ZOOKEEPER_URL_PROPERTY, zookeeperUrlPassword[0]);
            pluginConfiguration.setSimpleValue(ZOOKEEPER_PASSWORD_PROPERTY, zookeeperUrlPassword[1]);
        }
        if ((gitIndex = this.findVersionFile(new File(karafBase, GIT_REPO_HOME), Pattern.compile("\\.git/index$"))) != null) {
            pluginConfiguration.setSimpleValue(GIT_REPO_PROPERTY, gitIndex.getAbsoluteFile().getParentFile().getParent());
        }
        if (pluginConfiguration.getSimple("manuallyAdded") == null) {
            JavaCommandLine commandLine = new JavaCommandLine(details.getProcessInfo().getCommandLine(), true, EnumSet.of(JavaCommandLine.OptionValueDelimiter.WHITESPACE, JavaCommandLine.OptionValueDelimiter.EQUALS_SIGN), EnumSet.of(JavaCommandLine.OptionValueDelimiter.WHITESPACE, JavaCommandLine.OptionValueDelimiter.EQUALS_SIGN));
            this.setStartScriptPluginConfigProps(details.getProcessInfo(), commandLine, pluginConfiguration, context.getSystemInformation().getThisProcess());
        }
        return true;
    }

    private Properties getServerProperties(File karafBase) {
        Properties serverProperties = new Properties();
        serverProperties.setProperty(KARAF_NAME_PROPERTY, DEFAULT_KARAF_NAME);
        File systemPropertiesFile = new File(karafBase, ETC_SYSTEM_PROPERTIES);
        this.loadPropertiesFile(systemPropertiesFile, serverProperties);
        return serverProperties;
    }

    private String[] getZookeeperUrlPassword(File karafHome, File karafBase) {
        Properties serverProperties = this.getServerProperties(karafBase);
        String zookeeperUrl = serverProperties.getProperty(ZOOKEEPER_URL_PROPERTY);
        String zookeeperPassword = serverProperties.getProperty(ZOOKEEPER_PASSWORD_PROPERTY);
        if (zookeeperUrl == null) {
            if (!karafHome.equals(karafBase)) {
                String[] zookeeperUrlPassword = this.getChildZooKeeperUrlPassword(karafBase.getAbsolutePath(), serverProperties.getProperty(KARAF_NAME_PROPERTY));
                zookeeperUrl = zookeeperUrlPassword[0];
                zookeeperPassword = zookeeperUrlPassword[1];
            } else {
                log.warn((Object)"Looking for zookeeper.url in data/cache/**/zookeeper.config");
                File zookeperConfig = this.findVersionFile(new File(karafBase, "data/cache"), Pattern.compile("config/((org/fusesource/fabric)|(io/fabric8))/zookeeper.config"));
                if (zookeperConfig != null) {
                    log.debug((Object)("Found zookeeper.config at " + zookeperConfig));
                    Properties zkConfigProps = new Properties();
                    this.loadPropertiesFile(zookeperConfig, zkConfigProps);
                    zookeeperUrl = zkConfigProps.getProperty(ZOOKEEPER_URL_PROPERTY);
                    zookeeperPassword = zkConfigProps.getProperty(ZOOKEEPER_PASSWORD_PROPERTY);
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Found %s in file %s under directory %s", ZOOKEEPER_URL_PROPERTY, ETC_SYSTEM_PROPERTIES, karafBase));
            log.debug((Object)String.format("Found %s in file %s under directory %s", ZOOKEEPER_PASSWORD_PROPERTY, ETC_SYSTEM_PROPERTIES, karafBase));
        }
        if (zookeeperUrl != null) {
            zookeeperUrl = zookeeperUrl.replaceAll("\"", "");
        }
        if (zookeeperPassword != null) {
            zookeeperPassword = zookeeperPassword.replaceAll("\"", "");
        }
        return new String[]{zookeeperUrl, zookeeperPassword};
    }

    protected Configuration getConfigWithJmxServiceUrl(ResourceDiscoveryContext context, ProcessInfo process) {
        try {
            Configuration pluginConfiguration = context.getDefaultPluginConfiguration();
            String basePath = this.getSystemPropertyValue(process, KARAF_BASE_PROPERTY);
            File karafBase = new File(basePath);
            Properties serverProps = this.getServerProperties(karafBase);
            this.loadPropertiesFile(new File(basePath, "etc/org.apache.karaf.management.cfg"), serverProps);
            String serviceUrl = serverProps.getProperty("serviceUrl");
            if (serviceUrl != null) {
                Pattern propPattern = Pattern.compile("\\$\\{[^\\{\\}]+\\}");
                Matcher matcher = propPattern.matcher(serviceUrl);
                while (matcher.find()) {
                    String property = matcher.group();
                    String value = serverProps.getProperty(property.substring(2, property.length() - 1));
                    if (value == null) {
                        throw new InvalidPluginConfigurationException("Missing value for property " + property + " in serviceUrl");
                    }
                    serviceUrl = serviceUrl.replace(property, value);
                }
                pluginConfiguration.setSimpleValue("connectorAddress", serviceUrl);
            } else {
                log.warn((Object)"Unable to read JMX URL from etc/org.apache.karaf.management.cfg");
            }
            String adminRole = serverProps.getProperty("jmxRole");
            if (adminRole == null && (adminRole = serverProps.getProperty("karaf.admin.role")) == null) {
                log.debug((Object)"Using default admin role [admin]");
                adminRole = "admin";
            }
            Properties usersProperties = new Properties();
            this.loadPropertiesFile(new File(basePath, "etc/users.properties"), usersProperties);
            for (Map.Entry<Object, Object> entry : usersProperties.entrySet()) {
                String value = (String)entry.getValue();
                if (!value.contains(adminRole)) continue;
                pluginConfiguration.setSimpleValue("principal", (String)entry.getKey());
                pluginConfiguration.setSimpleValue("credentials", value.substring(0, value.indexOf(44)));
                break;
            }
            String[] zookeeperUrlPassword = this.getZookeeperUrlPassword(new File(this.getSystemPropertyValue(process, KARAF_HOME_PROPERTY)), karafBase);
            pluginConfiguration.setSimpleValue(ZOOKEEPER_URL_PROPERTY, zookeeperUrlPassword[0]);
            pluginConfiguration.setSimpleValue(ZOOKEEPER_PASSWORD_PROPERTY, zookeeperUrlPassword[1]);
            if (zookeeperUrlPassword[0] != null) {
                log.warn((Object)"Container uses Fabric Zookeeper registry, using default JMX user");
                pluginConfiguration.setSimpleValue("principal", "admin");
                pluginConfiguration.setSimpleValue("credentials", "admin");
            }
            return pluginConfiguration;
        }
        catch (Exception e) {
            log.warn((Object)("Error getting JMX properties from Fabric container: [" + e.getMessage() + "], using default connection properties"), (Throwable)e);
            return super.getConfigWithJmxServiceUrl(context, process);
        }
    }

    private String[] getChildZooKeeperUrlPassword(String basePath, String karafName) {
        File karafBase = new File(basePath);
        Properties instanceProps = new Properties();
        File propertiesFile = new File(karafBase.getParent(), "instance.properties");
        this.loadPropertiesFile(propertiesFile, instanceProps);
        String zooKeeperUrl = null;
        String zooKeeperPassword = null;
        for (Map.Entry<Object, Object> entry : instanceProps.entrySet()) {
            int end;
            if (!karafName.equals(entry.getValue())) continue;
            String key = (String)entry.getKey();
            String instanceOpts = instanceProps.getProperty(key.replace("name", "opts"));
            if (instanceOpts.contains(ZOOKEEPER_URL_PROPERTY)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found zookeeper.url in " + propertiesFile));
                }
                end = (zooKeeperUrl = instanceOpts.substring(instanceOpts.indexOf(ZOOKEEPER_URL_PROPERTY) + ZOOKEEPER_URL_PROPERTY.length() + 2)).indexOf(32) != -1 ? zooKeeperUrl.indexOf(32) - 1 : zooKeeperUrl.length();
                zooKeeperUrl = zooKeeperUrl.substring(0, end);
            }
            if (!instanceOpts.contains(ZOOKEEPER_PASSWORD_PROPERTY)) break;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found zookeeper.password in " + propertiesFile));
            }
            end = (zooKeeperPassword = instanceOpts.substring(instanceOpts.indexOf(ZOOKEEPER_PASSWORD_PROPERTY) + ZOOKEEPER_PASSWORD_PROPERTY.length() + 2)).indexOf(32) != -1 ? zooKeeperPassword.indexOf(32) - 1 : zooKeeperPassword.length();
            zooKeeperPassword = zooKeeperPassword.substring(0, end);
            break;
        }
        return new String[]{zooKeeperUrl, zooKeeperPassword};
    }

    protected void initLogEventSourcesConfigProp(File homeDir, Configuration pluginConfiguration, ProcessInfo process) {
        String karafHome = pluginConfiguration.getSimpleValue(KARAF_HOME_PROPERTY);
        String karafBase = pluginConfiguration.getSimpleValue(KARAF_BASE_PROPERTY);
        String logFile = "{karaf.base}/data/log/karaf.log";
        if (karafHome.equals(karafBase)) {
            String productType = pluginConfiguration.getSimpleValue(CONTAINER_TYPE_PROPERTY);
            if (JBOSS_FUSE_PRODUCT.equals(productType)) {
                logFile = "{karaf.base}/data/log/fuse.log";
            } else if (JBOSS_A_MQ_PRODUCT.equals(productType)) {
                logFile = "{karaf.base}/data/log/amq.log";
            }
        }
        pluginConfiguration.setSimpleValue("logFile", logFile);
        super.initLogEventSourcesConfigProp(homeDir, pluginConfiguration, process);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPropertiesFile(File propertiesFile, Properties properties) {
        if (propertiesFile.exists()) {
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(propertiesFile);
                properties.load(stream);
            }
            catch (IOException e) {
                String message = "Error reading " + propertiesFile;
                log.warn((Object)message, (Throwable)e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {}
                }
            }
        } else {
            log.warn((Object)("File " + propertiesFile.getAbsolutePath() + " does not exist"));
        }
    }

    public List<URL> getAdditionalClasspathUrls(ResourceDiscoveryContext context, DiscoveredResourceDetails details) throws Exception {
        ArrayList<URL> classpath = new ArrayList<URL>();
        String karafHomePath = details.getPluginConfiguration().getSimpleValue(KARAF_HOME_PROPERTY);
        File systemDir = new File(karafHomePath, "system");
        File zooKeeperLib = this.findVersionFile(systemDir, Pattern.compile("fabric-linkedin-zookeeper-.*\\.jar"));
        if (zooKeeperLib == null) {
            log.debug((Object)("Missing ZooKeeper library fabric-linkedin-zookeeper*.jar in " + karafHomePath + "/system"));
            zooKeeperLib = this.findVersionFile(systemDir, Pattern.compile("fabric-zookeeper-1.*\\.jar"));
            if (zooKeeperLib == null) {
                throw new InvalidPluginConfigurationException("Missing ZooKeeper libraries fabric-linkedin-zookeeper-*.jar and fabric-zookeeper-*.jar in " + karafHomePath + "/system");
            }
            File guavaLib = this.findVersionFile(systemDir, Pattern.compile("guava-14.*\\.jar"));
            if (guavaLib == null) {
                throw new InvalidPluginConfigurationException("Missing Google Guava library guava-14*.jar in " + karafHomePath + "/system");
            }
            classpath.add(guavaLib.toURI().toURL());
        }
        classpath.add(zooKeeperLib.toURI().toURL());
        File jGitLib = this.findVersionFile(systemDir, Pattern.compile("fabric-git-1.*\\.jar"));
        if (jGitLib != null) {
            classpath.add(jGitLib.toURI().toURL());
        } else {
            File gitRepo;
            String gitRepoPath = details.getPluginConfiguration().getSimpleValue(GIT_REPO_PROPERTY);
            File file = gitRepo = gitRepoPath != null ? new File(gitRepoPath) : null;
            if (gitRepo != null && gitRepo.exists() && gitRepo.isDirectory()) {
                throw new InvalidPluginConfigurationException("Missing JGit library org.eclipse.jgit-*.jar in " + karafHomePath + "/system");
            }
        }
        return classpath;
    }

    private void setStartScriptPluginConfigProps(ProcessInfo process, JavaCommandLine commandLine, Configuration pluginConfig, ProcessInfo agentProcess) {
        File homeDir;
        File startScriptAbsolute;
        StartScriptConfiguration startScriptConfig = new StartScriptConfiguration(pluginConfig);
        ProcessInfo parentProcess = process.getParentProcess();
        File startScript = ServerStartScriptDiscoveryUtility.getStartScript((ProcessInfo)parentProcess);
        if (startScript == null) {
            String startScriptFileName = OS_IS_WINDOWS ? "start.bat" : "start";
            startScript = new File("bin", startScriptFileName);
        }
        if (!(startScript.exists() || startScript.isAbsolute() || (startScriptAbsolute = new File(homeDir = new File(pluginConfig.getSimpleValue(KARAF_BASE_PROPERTY)), startScript.getPath())).exists())) {
            log.warn((Object)("Failed to find start script file for JBoss Fuse server with command line [" + commandLine + "] - defaulting 'startScripFile' plugin config prop to [" + startScript + "]."));
        }
        startScriptConfig.setStartScript(startScript);
        String startScriptPrefix = ServerStartScriptDiscoveryUtility.getStartScriptPrefix((ProcessInfo)process, (ProcessInfo)agentProcess);
        startScriptConfig.setStartScriptPrefix(startScriptPrefix);
        Map startScriptEnv = ServerStartScriptDiscoveryUtility.getStartScriptEnv((ProcessInfo)process, (ProcessInfo)parentProcess, START_SCRIPT_ENV_VAR_NAMES);
        startScriptConfig.setStartScriptEnv(startScriptEnv);
        List startScriptArgs = ServerStartScriptDiscoveryUtility.getStartScriptArgs((ProcessInfo)parentProcess, (List)commandLine.getClassArguments(), START_SCRIPT_OPTION_EXCLUDES);
        startScriptConfig.setStartScriptArgs(startScriptArgs);
    }

    static {
        START_SCRIPT_ENV_VAR_NAMES.addAll(Arrays.asList("JAVA", "JAVA_DEBUG_OPTS", "JAVA_HOME", "JAVA_MAX_MEM", "JAVA_MAX_PERM_MEM", "JAVA_MIN_MEM", "JAVA_OPTS", "JAVA_PERM_MEM", "KARAF_BASE", "KARAF_DATA", "KARAF_DEBUG", "KARAF_ETC", "KARAF_HOME", "MAX_FD"));
        if (OS_IS_WINDOWS) {
            START_SCRIPT_ENV_VAR_NAMES.add("ECHO");
            START_SCRIPT_ENV_VAR_NAMES.add("KARAF_TITLE");
            START_SCRIPT_ENV_VAR_NAMES.add("PAUSE");
            START_SCRIPT_ENV_VAR_NAMES.add("SHIFT");
        }
        START_SCRIPT_OPTION_EXCLUDES = new HashSet<CommandLineOption>();
        START_SCRIPT_OPTION_EXCLUDES.add(new CommandLineOption("Dcom.sun.management.jmxremote", null));
        START_SCRIPT_OPTION_EXCLUDES.add(new CommandLineOption("Djava.endorsed.dirs", null));
        START_SCRIPT_OPTION_EXCLUDES.add(new CommandLineOption("Djava.ext.dirs", null));
        START_SCRIPT_OPTION_EXCLUDES.add(new CommandLineOption("Dkaraf.instances", null));
        START_SCRIPT_OPTION_EXCLUDES.add(new CommandLineOption("Dkaraf.home", null));
        START_SCRIPT_OPTION_EXCLUDES.add(new CommandLineOption("Dkaraf.base", null));
        START_SCRIPT_OPTION_EXCLUDES.add(new CommandLineOption("Dkaraf.data", null));
        START_SCRIPT_OPTION_EXCLUDES.add(new CommandLineOption("Dkaraf.etc", null));
        START_SCRIPT_OPTION_EXCLUDES.add(new CommandLineOption("Djava.io.tmpdir", null));
        START_SCRIPT_OPTION_EXCLUDES.add(new CommandLineOption("Djava.util.logging.config.file", null));
        START_SCRIPT_OPTION_EXCLUDES.add(new CommandLineOption("Dkaraf.startLocalConsole", null));
        START_SCRIPT_OPTION_EXCLUDES.add(new CommandLineOption("Dkaraf.startRemoteShell", null));
        START_SCRIPT_OPTION_EXCLUDES.add(new CommandLineOption("classpath", null));
    }
}

