/*
 * Decompiled with CFR 0.152.
 */
package org.jbosson.plugins.fuse.utils;

import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.KeeperException;
import org.jbosson.plugins.fuse.JBossFuseContainerTraits;
import org.jbosson.plugins.fuse.JBossFuseProfileGroupManager;
import org.jbosson.plugins.fuse.utils.DataStore;
import org.linkedin.zookeeper.client.IZKClient;

public class ZooKeeperDataStoreImpl
implements DataStore {
    private static final Log LOG = LogFactory.getLog(ZooKeeperDataStoreImpl.class);
    private final IZKClient client;
    private final String containerVersion;

    public ZooKeeperDataStoreImpl(Object client, String containerVersion) {
        this.client = (IZKClient)client;
        this.containerVersion = containerVersion;
    }

    public void getFabricMetadata(String profileName, JBossFuseContainerTraits traits) throws Exception {
        if (!JBossFuseProfileGroupManager.ENSEMBLE_PROFILE_PATTERN.matcher(profileName).matches()) {
            String brokerClusterName = null;
            try {
                String brokerPropertiesPath = "/fabric/configs/versions/" + this.containerVersion + "/profiles/" + profileName + "/org.fusesource.mq.fabric.server-" + profileName + ".properties";
                boolean brokerFound = null == this.client.exists(brokerPropertiesPath) ? null != this.client.exists(brokerPropertiesPath = "/fabric/configs/versions/" + this.containerVersion + "/profiles/" + profileName + "/org.fusesource.mq.fabric.server-broker.properties") : true;
                if (brokerFound) {
                    LOG.debug((Object)("Broker properties found in profile " + profileName));
                    Properties brokerProperties = new Properties();
                    String propertiesData = this.client.getStringData(brokerPropertiesPath);
                    brokerProperties.load(new StringReader(propertiesData));
                    brokerClusterName = brokerProperties.getProperty("group");
                    LOG.debug((Object)("Found Broker Cluster " + brokerClusterName));
                } else {
                    LOG.debug((Object)("Broker properties NOT found in profile " + profileName));
                }
            }
            catch (InterruptedException e) {
                throw new IllegalArgumentException("Error looking up MQ broker properties: " + e.getMessage(), e);
            }
            catch (KeeperException e) {
                throw new IllegalArgumentException("Error looking up MQ broker properties: " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error looking up MQ broker properties: " + e.getMessage(), e);
            }
            if (brokerClusterName != null) {
                traits.addCluster(brokerClusterName);
            }
        }
        try {
            String[] parents;
            String parentList = this.getParents(profileName);
            if (parentList != null && traits.setParentProfiles(profileName, parents = parentList.split(" "))) {
                for (String parent : parents) {
                    if (traits.hasChildProfile(parent)) continue;
                    this.getFabricMetadata(parent, traits);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (KeeperException e) {
            throw new IllegalArgumentException("Error getting Parent profiles for " + profileName + ": " + e.getMessage(), e);
        }
    }

    public void close() throws Exception {
    }

    private String getParents(String profileName) throws InterruptedException, KeeperException {
        String key;
        String value = null;
        if (JBossFuseProfileGroupManager.ENSEMBLE_PROFILE_PATTERN.matcher(profileName).matches()) {
            String ensemblePath = "/fabric/configs/ensemble/profiles/" + profileName;
            if (null != this.client.exists(ensemblePath)) {
                value = this.client.getStringData(ensemblePath);
            }
        } else {
            String profilePath = "/fabric/configs/versions/" + this.containerVersion + "/profiles/" + profileName;
            if (null != this.client.exists(profilePath)) {
                value = this.client.getStringData(profilePath);
            }
        }
        Properties props = new Properties();
        if (value != null) {
            try {
                props.load(new StringReader(value));
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        if (props.size() == 1 && !(key = props.stringPropertyNames().iterator().next()).equals("parents")) {
            String val = props.getProperty(key);
            props.remove(key);
            props.setProperty("parents", val.isEmpty() ? key : key + " " + val);
        }
        return props.getProperty("parents");
    }
}

