/*
 * Decompiled with CFR 0.152.
 */
package org.jbosson.plugins.fuse.utils;

import io.fabric8.utils.PasswordEncoder;
import io.fabric8.zookeeper.curator.DynamicEnsembleProvider;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.RetryPolicy;
import org.apache.curator.ensemble.EnsembleProvider;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.jbosson.plugins.fuse.utils.FabricRegistry;

public class CuratorFabricRegistryImpl
implements FabricRegistry {
    private static final Log LOG = LogFactory.getLog(CuratorFabricRegistryImpl.class);
    private static final int BASE_SLEEP_TIME_MS = 5000;
    private static final int MAX_RETRIES = 3;
    private static final String UTF_8_CHARSET_NAME = "UTF-8";
    private final String url;
    private final String password;
    private final long timeout;
    private final String containerName;
    private boolean connected;
    private CuratorFramework framework;

    public static boolean isSupported() {
        try {
            Class.forName("org.apache.curator.framework.CuratorFramework");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public CuratorFabricRegistryImpl(String zookeeperUrl, String zookeeperPassword, long timeoutSeconds, String containerName) {
        this.url = zookeeperUrl;
        this.password = zookeeperPassword.startsWith("ZKENC=") ? PasswordEncoder.decode((String)zookeeperPassword) : zookeeperPassword;
        this.timeout = timeoutSeconds;
        this.containerName = containerName;
    }

    public void connect() throws Exception {
        DynamicEnsembleProvider ensembleProvider = new DynamicEnsembleProvider();
        ensembleProvider.update(this.url);
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().ensembleProvider((EnsembleProvider)ensembleProvider).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(5000, 3)).connectionTimeoutMs((int)TimeUnit.SECONDS.toMillis(this.timeout));
        if (this.password != null) {
            builder = builder.authorization("digest", ("fabric:" + this.password).getBytes(UTF_8_CHARSET_NAME));
        }
        this.framework = builder.build();
        this.framework.getConnectionStateListenable().addListener((Object)new ConnectionStateListener(){

            public void stateChanged(CuratorFramework curatorFramework, ConnectionState connectionState) {
                if (CuratorFabricRegistryImpl.this.connected && (connectionState == ConnectionState.SUSPENDED || connectionState == ConnectionState.LOST)) {
                    LOG.warn((Object)("Connection state changed to " + connectionState));
                }
            }
        });
        this.framework.start();
        this.connected = true;
    }

    public void disconnect() throws Exception {
        this.connected = false;
        if (this.framework != null) {
            this.framework.close();
        }
    }

    public String getContainerVersion() throws Exception {
        String path = String.format("/fabric/configs/containers/%s", this.containerName);
        return new String((byte[])this.framework.getData().forPath(path), UTF_8_CHARSET_NAME);
    }

    public String[] getContainerProfiles(String containerVersion) throws Exception {
        String path = String.format("/fabric/configs/versions/%s/containers/%s", containerVersion, this.containerName);
        return new String((byte[])this.framework.getData().forPath(path), UTF_8_CHARSET_NAME).split(" ");
    }
}

