/*
 * Copyright 2013 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version
 * 2.0 (the "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied.  See the License for the specific language governing
 * permissions and limitations under the License.
 */
package org.jbosson.plugins.fuse.utils;

import org.jbosson.plugins.fuse.JBossFuseContainerTraits;

/**
 * Utility interface for Fabric DataStores
 * @author dbokde
 */
public interface DataStore {

    /**
     * Get Fabric meta data for a given profile, and version.
     * @param profileName name of profile to get metadata.
     * @param traits Container Traits to store collected meta data results.
     * @throws Exception on error.
     */
    void getFabricMetadata(String profileName, JBossFuseContainerTraits traits) throws Exception;

    /**
     * Close any resources used.
     */
    void close() throws Exception;

}
