/*
 * Decompiled with CFR 0.152.
 */
package org.jbosson.plugins.fuse;

import java.io.File;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbosson.plugins.fuse.JBossFuseContainerTraits;
import org.jbosson.plugins.fuse.utils.CuratorFabricRegistryImpl;
import org.jbosson.plugins.fuse.utils.DataStore;
import org.jbosson.plugins.fuse.utils.FabricRegistry;
import org.jbosson.plugins.fuse.utils.GitDataStoreImpl;
import org.jbosson.plugins.fuse.utils.LinkedInFabricRegistryImpl;
import org.jbosson.plugins.fuse.utils.ZooKeeperDataStoreImpl;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossFuseProfileGroupManager
implements MeasurementFacet {
    public static final String PARENTS_PROPERTY = "parents";
    private static final Log LOG = LogFactory.getLog(JBossFuseProfileGroupManager.class);
    private static final String PROFILES_TRAIT = "profiles";
    private static final String PARENT_PROFILES_TRAIT = "parentProfiles";
    private static final String MQ_CLUSTERS_TRAIT = "mqClusters";
    private static final String CONTAINER_VERSION_TRAIT = "container.version";
    private static final String ZOOKEEPER_TIMEOUT = "zookeeper.timeout";
    public static final Pattern ENSEMBLE_PROFILE_PATTERN = Pattern.compile("fabric-ensemble-[0-9]+|fabric-ensemble-[0-9]+-[0-9]+");
    public static final String MQ_GROUP_PROPERTY = "group";
    public static final String CONTAINER_VERSION_PATH_FORMAT = "/fabric/configs/containers/%s";
    public static final String CONTAINER_PROFILES_PATH_FORMAT = "/fabric/configs/versions/%s/containers/%s";
    public static final String FABRIC_REGISTRY_CLUSTERS_JON = "/fabric/registry/clusters/jon";
    public static final String ZK_CLUSTER_JSON_TEMPLATE = "{\"id\":\"jon\", \"services\":[\"%s\"] }";
    public static final String JBOSS_IDENTITY_DIR = "jboss.identity.dir";
    public static final String FAILOVER_LIST_DAT = "failover-list.dat";
    private final ResourceContext context;

    public JBossFuseProfileGroupManager(ResourceContext context) {
        this.context = context;
    }

    public void getValues(MeasurementReport measurementReport, Set<MeasurementScheduleRequest> measurementScheduleRequests) throws Exception {
        String resourceKey = this.context.getResourceKey();
        Configuration pluginConfiguration = this.context.getPluginConfiguration();
        String zookeeperUrl = pluginConfiguration.getSimpleValue("zookeeper.url");
        if (zookeeperUrl != null) {
            FabricRegistry registry;
            String containerName = pluginConfiguration.getSimpleValue("karaf.name");
            String zookeeperPassword = pluginConfiguration.getSimpleValue("zookeeper.password");
            LOG.debug((Object)("Processing Fabric Groups for Server " + resourceKey));
            Long timeoutSeconds = Long.valueOf(pluginConfiguration.getSimpleValue(ZOOKEEPER_TIMEOUT));
            DataStore dataStore = null;
            if (LinkedInFabricRegistryImpl.isSupported()) {
                registry = new LinkedInFabricRegistryImpl(zookeeperUrl, zookeeperPassword, timeoutSeconds, containerName);
            } else if (CuratorFabricRegistryImpl.isSupported()) {
                registry = new CuratorFabricRegistryImpl(zookeeperUrl, zookeeperPassword, timeoutSeconds, containerName);
            } else {
                throw new IllegalStateException("Neither LinkedIn ZooKeeper nor Apache Curator library was found");
            }
            try {
                registry.connect();
                String containerVersion = registry.getContainerVersion();
                String[] profiles = registry.getContainerProfiles(containerVersion);
                JBossFuseContainerTraits traits = new JBossFuseContainerTraits();
                traits.setContainerVersion(containerVersion);
                traits.setProfiles(profiles);
                String karafBasePath = pluginConfiguration.getSimpleValue("karaf.base");
                String gitRepoPath = pluginConfiguration.getSimpleValue("git.root");
                File gitRepo = gitRepoPath != null ? new File(gitRepoPath) : null;
                dataStore = gitRepo != null && gitRepo.exists() && gitRepo.isDirectory() ? new GitDataStoreImpl(gitRepo, containerVersion) : new ZooKeeperDataStoreImpl(((LinkedInFabricRegistryImpl)registry).getClient(), containerVersion);
                String zkClusterLocation = FABRIC_REGISTRY_CLUSTERS_JON;
                if (registry.getTextNode(zkClusterLocation) == null) {
                    Properties props = System.getProperties();
                    String configFilePath = "" + props.getProperty(JBOSS_IDENTITY_DIR);
                    File configFile = new File(configFilePath + props.getProperty("file.separator") + FAILOVER_LIST_DAT);
                    String jsonEntry = String.format(ZK_CLUSTER_JSON_TEMPLATE, "http(s)://" + FileUtils.readFileToString((File)configFile, (String)"UTF-8") + " /rest");
                    LOG.info((Object)("Adding rest API endpoint to zk registry: " + jsonEntry));
                    registry.writeTextNode(zkClusterLocation, jsonEntry);
                }
                for (String profile : profiles) {
                    LOG.debug((Object)("Processing Server profile " + profile + ":" + containerVersion));
                    try {
                        dataStore.getFabricMetadata(profile, traits);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Error processing Server Profile " + profile + ":" + containerVersion + ": " + e.getMessage(), e);
                    }
                }
                for (MeasurementScheduleRequest request : measurementScheduleRequests) {
                    String metricName = request.getName();
                    if (metricName.equals(PROFILES_TRAIT)) {
                        measurementReport.addData(new MeasurementDataTrait(request, traits.getProfileTrait()));
                        continue;
                    }
                    if (metricName.equals(PARENT_PROFILES_TRAIT)) {
                        measurementReport.addData(new MeasurementDataTrait(request, traits.getParentProfilesTrait()));
                        continue;
                    }
                    if (metricName.equals(MQ_CLUSTERS_TRAIT)) {
                        measurementReport.addData(new MeasurementDataTrait(request, traits.getClustersTrait()));
                        continue;
                    }
                    if (metricName.equals(CONTAINER_VERSION_TRAIT)) {
                        measurementReport.addData(new MeasurementDataTrait(request, traits.getContainerVersion()));
                        continue;
                    }
                    throw new IllegalArgumentException(String.format("Unknown metric %s for resource %s", metricName, resourceKey));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Error processing Profile metadata for [" + this.context.getResourceKey() + "]: " + ex.getMessage(), ex);
            }
            finally {
                if (dataStore != null) {
                    try {
                        dataStore.close();
                    }
                    catch (Throwable e) {}
                }
                try {
                    registry.disconnect();
                }
                catch (Throwable e) {}
            }
        } else {
            LOG.debug((Object)("Plugin property zookeeper.url is not set for [" + this.context.getResourceKey() + "], no Fabric data to collect"));
        }
    }
}

