/*
 * Copyright 2013 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version
 * 2.0 (the "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied.  See the License for the specific language governing
 * permissions and limitations under the License.
 */
package org.jbosson.plugins.fuse;

import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;

import java.util.Set;

/**
 * Create and Updates Resource Groups corresponding to Profiles for Fabric containers.
 *
 * @author dbokde
 */
public class FabricContainerComponent<T extends ResourceComponent<?>> extends FuseServerComponent<T> implements MeasurementFacet {

    private FabricProfileGroupManager profileGroupManager;

    @Override
    public void start(ResourceContext context) throws Exception {

        // let super do its thing!
        super.start(context);

        // create a Profile group manager
        this.profileGroupManager = new FabricProfileGroupManager(context);
    }

    @Override
    public void stop() {

        profileGroupManager = null;
        super.stop();
    }

    public void getValues(MeasurementReport measurementReport,
                          Set<MeasurementScheduleRequest> measurementScheduleRequests) throws Exception {
        // get Fabric metadata as traits to be used in fabric-groups-plugin for creating DynaGroups
        this.profileGroupManager.getValues(measurementReport, measurementScheduleRequests);
    }
}
