/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.command;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import org.apache.activeio.command.ClassLoading;
import org.apache.activeio.command.DefaultWireFormat;

public class ClassLoadingAwareObjectInputStream
extends ObjectInputStream {
    private static final ClassLoader myClassLoader = DefaultWireFormat.class.getClassLoader();

    public ClassLoadingAwareObjectInputStream(InputStream in) throws IOException {
        super(in);
    }

    protected Class resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return this.loadClass(classDesc.getName(), classLoader);
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class[] interfaceClasses = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceClasses[i] = this.loadClass(interfaces[i], classLoader);
        }
        try {
            return Proxy.getProxyClass(interfaceClasses[0].getClassLoader(), interfaceClasses);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }

    protected Class loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            return ClassLoading.loadClass(className, classLoader);
        }
        catch (ClassNotFoundException e) {
            return ClassLoading.loadClass(className, myClassLoader);
        }
    }
}

